/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.Toolkit;
import rene.dialogs.ExampleCanvas;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.ChoiceAction;
import rene.gui.CloseDialog;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.IntField;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;

public class FontEditor
extends CloseDialog {
    String FontTag;
    TextField FontName;
    IntField FontSize;
    IntField FontSpacing;
    Choice Fonts;
    Choice Mode;
    Canvas Example;
    String E = Global.name("fonteditor.sample");
    Checkbox Smooth;

    public FontEditor(Frame frame, String string, String string2, int n) {
        super(frame, Global.name("fonteditor.title"), true);
        this.FontTag = string;
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(0, 2));
        myPanel.add(new MyLabel(Global.name("fonteditor.name")));
        this.FontName = new TextFieldAction(this, "FontName");
        myPanel.add(this.FontName);
        this.FontName.setText(Global.getParameter(string + ".name", string2));
        myPanel.add(new MyLabel(Global.name("fonteditor.available")));
        this.Fonts = new ChoiceAction(this, "Fonts");
        myPanel.add(this.Fonts);
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.Fonts.add(stringArray[i]);
            }
        } else {
            this.Fonts.add("Dialog");
            this.Fonts.add("SansSerif");
            this.Fonts.add("Serif");
            this.Fonts.add("Monospaced");
            this.Fonts.add("DialogInput");
        }
        this.Fonts.add("Courier");
        this.Fonts.add("TimesRoman");
        this.Fonts.add("Helvetica");
        this.Fonts.select(this.FontName.getText());
        myPanel.add(new MyLabel(Global.name("fonteditor.mode")));
        this.Mode = new ChoiceAction(this, "Mode");
        myPanel.add(this.Mode);
        this.Mode.add(Global.name("fonteditor.plain"));
        this.Mode.add(Global.name("fonteditor.bold"));
        this.Mode.add(Global.name("fonteditor.italic"));
        String string3 = Global.getParameter(string + ".mode", "plain");
        if (string3.startsWith("bold")) {
            this.Mode.select(1);
        } else if (string3.startsWith("italic")) {
            this.Mode.select(2);
        } else {
            this.Mode.select(0);
        }
        myPanel.add(new MyLabel(Global.name("fonteditor.size")));
        this.FontSize = new IntField((DoActionListener)this, "FontSize", Global.getParameter(string + ".size", n));
        myPanel.add(this.FontSize);
        myPanel.add(new MyLabel(Global.name("fonteditor.spacing")));
        this.FontSpacing = new IntField((DoActionListener)this, "FontSpacing", Global.getParameter(string + ".spacing", 0));
        myPanel.add(this.FontSpacing);
        myPanel.add(new MyLabel(Global.name("fonteditor.antialias")));
        this.Smooth = new CheckboxAction(this, "", "Smooth");
        myPanel.add(this.Smooth);
        this.Smooth.setState(Global.getParameter("font.smooth", true));
        this.add("North", new Panel3D(myPanel));
        this.Example = new ExampleCanvas(this);
        this.add("Center", new Panel3D(this.Example));
        MyPanel myPanel2 = new MyPanel();
        myPanel2.add(new ButtonAction(this, Global.name("OK"), "OK"));
        myPanel2.add(new ButtonAction(this, Global.name("close"), "Close"));
        this.add("South", new Panel3D(myPanel2));
        this.pack();
    }

    public void doAction(String string) {
        if ("OK".equals(string)) {
            Global.setParameter(this.FontTag + ".name", this.FontName.getText());
            String string2 = "plain";
            if (this.mode() == 1) {
                string2 = "bold";
            } else if (this.mode() == 2) {
                string2 = "Italic";
            }
            Global.setParameter(this.FontTag + ".mode", string2);
            Global.setParameter(this.FontTag + ".size", this.FontSize.value(3, 50));
            Global.setParameter(this.FontTag + ".spacing", this.FontSpacing.value(-10, 10));
            Global.setParameter("font.smooth", this.Smooth.getState());
            this.doclose();
        } else {
            super.doAction(string);
        }
        this.Example.repaint();
    }

    public void itemAction(String string, boolean bl) {
        this.FontName.setText(this.Fonts.getSelectedItem());
        this.Example.repaint();
    }

    int mode() {
        if (this.Mode.getSelectedItem().equals(Global.name("fonteditor.bold"))) {
            return 1;
        }
        if (this.Mode.getSelectedItem().equals(Global.name("fonteditor.italic"))) {
            return 2;
        }
        return 0;
    }

    public void example(Graphics graphics, int n, int n2) {
        Font font = new Font(this.FontName.getText(), this.mode(), this.FontSize.value(3, 50));
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = this.FontSpacing.value(-10, 10);
        for (int i = 1; i <= 4; ++i) {
            graphics.drawString(this.E, 5, 5 + n3 + i * n3 + fontMetrics.getLeading() + fontMetrics.getAscent() + i * fontMetrics.getHeight());
        }
    }
}

