/**
 * @file svnxx/detail/doxygen.hpp
 * @copyright
 * ====================================================================
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 * ====================================================================
 * @endcopyright
 */

#ifdef DOXYGEN

namespace apache {
namespace subversion {
namespace svnxx {
namespace detail {

/**
 * @defgroup svnxx_detail SVN++ Implementation Details
 * @brief The C++ API's Private Parts
 *
 * The C++ API's Private Parts
 * ===========================
 *
 * Anything declared or defined in the namespace
 * @c apache::subversion::svnxx::detail is an implementation detail
 * of the SVN++ public API. User code @b should @b not use anything
 * from this namespace, except as far as it's referenced from the
 * public parts of the API.
 */

} // namespace detail
} // namespace svnxx
} // namespace subversion
} // namespace apache

#endif // DOXYGEN
