#ifndef INCLUDED_SSHCRON_
#define INCLUDED_SSHCRON_

#include <memory>

#include <bobcat/fork>
#include <bobcat/localclientsocket>

#include "../udsreq/udsreq.h"

namespace FBB
{
    class IFdStream;
    class OFdStream;
}

class Options;

class SSHCron: public FBB::Fork, private UDSReq
{
    Options &d_options;
    FBB::LocalClientSocket d_client;
    std::string d_passphrase;
    std::unique_ptr<FBB::IFdStream> d_in;
    std::unique_ptr<FBB::OFdStream> d_out;

    public:
        SSHCron();
        ~SSHCron() override;

        void run();

    private:
        void childProcess()     override;
        void parentProcess()    override;

        void askPassphrase();
        std::ostream &basename() const; // options.msg() inserts basename :
        void toCron();                  // commands to the child, e.g., --list
        void daemon();                  // run the daemon in the background
        void foreground();
        void getPassphrase();
        std::ostream &idmsg() const;    // imsg inserts "'basename' : "
        void list();
        void reload();
        void terminate();
};
        
#endif


