# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `pp` gem.
# Please instead update this file by running `bin/tapioca gem pp`.


class Array
  include ::Enumerable

  # source://pp//lib/pp.rb#412
  def pretty_print(q); end

  # source://pp//lib/pp.rb#420
  def pretty_print_cycle(q); end
end

class Data
  # source://pp//lib/pp.rb#495
  def pretty_print(q); end

  # source://pp//lib/pp.rb#523
  def pretty_print_cycle(q); end
end

class File::Stat
  include ::Comparable

  # source://pp//lib/pp.rb#557
  def pretty_print(q); end
end

class Hash
  include ::Enumerable

  # source://pp//lib/pp.rb#426
  def pretty_print(q); end

  # source://pp//lib/pp.rb#430
  def pretty_print_cycle(q); end
end

module Kernel
  # Returns a pretty printed object as a string.
  #
  # See the PP module for more information.
  #
  # source://pp//lib/pp.rb#724
  def pretty_inspect; end

  private

  # prints arguments in pretty form.
  #
  # +#pp+ returns argument(s).
  #
  # source://pp//lib/pp.rb#731
  def pp(*objs); end

  class << self
    # prints arguments in pretty form.
    #
    # +#pp+ returns argument(s).
    #
    # source://pp//lib/pp.rb#731
    def pp(*objs); end
  end
end

class MatchData
  # source://pp//lib/pp.rb#640
  def pretty_print(q); end
end

# A pretty-printer for Ruby objects.
#
#
# == What PP Does
#
# Standard output by #p returns this:
#   #<PP:0x81fedf0 @genspace=#<Proc:0x81feda0>, @group_queue=#<PrettyPrint::GroupQueue:0x81fed3c @queue=[[#<PrettyPrint::Group:0x81fed78 @breakables=[], @depth=0, @break=false>], []]>, @buffer=[], @newline="\n", @group_stack=[#<PrettyPrint::Group:0x81fed78 @breakables=[], @depth=0, @break=false>], @buffer_width=0, @indent=0, @maxwidth=79, @output_width=2, @output=#<IO:0x8114ee4>>
#
# Pretty-printed output returns this:
#   #<PP:0x81fedf0
#    @buffer=[],
#    @buffer_width=0,
#    @genspace=#<Proc:0x81feda0>,
#    @group_queue=
#     #<PrettyPrint::GroupQueue:0x81fed3c
#      @queue=
#       [[#<PrettyPrint::Group:0x81fed78 @break=false, @breakables=[], @depth=0>],
#        []]>,
#    @group_stack=
#     [#<PrettyPrint::Group:0x81fed78 @break=false, @breakables=[], @depth=0>],
#    @indent=0,
#    @maxwidth=79,
#    @newline="\n",
#    @output=#<IO:0x8114ee4>,
#    @output_width=2>
#
#
# == Usage
#
#   pp(obj)             #=> obj
#   pp obj              #=> obj
#   pp(obj1, obj2, ...) #=> [obj1, obj2, ...]
#   pp()                #=> nil
#
# Output <tt>obj(s)</tt> to <tt>$></tt> in pretty printed format.
#
# It returns <tt>obj(s)</tt>.
#
#
# == Output Customization
#
# To define a customized pretty printing function for your classes,
# redefine method <code>#pretty_print(pp)</code> in the class.
# Note that <code>require 'pp'</code> is needed before redefining <code>#pretty_print(pp)</code>.
#
# <code>#pretty_print</code> takes the +pp+ argument, which is an instance of the PP class.
# The method uses #text, #breakable, #nest, #group and #pp to print the
# object.
#
#
# == Pretty-Print JSON
#
# To pretty-print JSON refer to JSON#pretty_generate.
#
#
# == Author
# Tanaka Akira <akr@fsij.org>
class PP < ::PrettyPrint
  include ::PP::PPMethods

  class << self
    # :stopdoc:
    #
    # source://pp//lib/pp.rb#116
    def mcall(obj, mod, meth, *args, &block); end

    # Outputs +obj+ to +out+ in pretty printed format of
    # +width+ columns in width.
    #
    # If +out+ is omitted, <code>$></code> is assumed.
    # If +width+ is omitted, the width of +out+ is assumed (see
    # width_for).
    #
    # PP.pp returns +out+.
    #
    # source://pp//lib/pp.rb#96
    def pp(obj, out = T.unsafe(nil), width = T.unsafe(nil)); end

    # Returns the sharing detection flag as a boolean value.
    # It is false by default.
    #
    # source://pp//lib/pp.rb#125
    def sharing_detection; end

    # Returns the sharing detection flag as a boolean value.
    # It is false by default.
    #
    # source://pp//lib/pp.rb#129
    def sharing_detection=(b); end

    # Outputs +obj+ to +out+ like PP.pp but with no indent and
    # newline.
    #
    # PP.singleline_pp returns +out+.
    #
    # source://pp//lib/pp.rb#108
    def singleline_pp(obj, out = T.unsafe(nil)); end

    # Returns the usable width for +out+.
    # As the width of +out+:
    # 1. If +out+ is assigned to a tty device, its width is used.
    # 2. Otherwise, or it could not get the value, the +COLUMN+
    #    environment variable is assumed to be set to the width.
    # 3. If +COLUMN+ is not set to a non-zero number, 80 is assumed.
    #
    # And finally, returns the above width value - 1.
    # * This -1 is for Windows command prompt, which moves the cursor to
    #   the next line if it reaches the last column.
    #
    # source://pp//lib/pp.rb#79
    def width_for(out); end
  end
end

module PP::ObjectMixin
  # A default pretty printing method for general objects.
  # It calls #pretty_print_instance_variables to list instance variables.
  #
  # If +self+ has a customized (redefined) #inspect method,
  # the result of self.inspect is used but it obviously has no
  # line break hints.
  #
  # This module provides predefined #pretty_print methods for some of
  # the most commonly used built-in classes for convenience.
  #
  # source://pp//lib/pp.rb#362
  def pretty_print(q); end

  # A default pretty printing method for general objects that are
  # detected as part of a cycle.
  #
  # source://pp//lib/pp.rb#379
  def pretty_print_cycle(q); end

  # Is #inspect implementation using #pretty_print.
  # If you implement #pretty_print, it can be used as follows.
  #
  #   alias inspect pretty_print_inspect
  #
  # However, doing this requires that every class that #inspect is called on
  # implement #pretty_print, or a RuntimeError will be raised.
  #
  # source://pp//lib/pp.rb#402
  def pretty_print_inspect; end

  # Returns a sorted array of instance variable names.
  #
  # This method should return an array of names of instance variables as symbols or strings as:
  # +[:@a, :@b]+.
  #
  # source://pp//lib/pp.rb#390
  def pretty_print_instance_variables; end
end

# Module that defines helper methods for pretty_print.
module PP::PPMethods
  # Check whether the object_id +id+ is in the current buffer of objects
  # to be pretty printed. Used to break cycles in chains of objects to be
  # pretty printed.
  #
  # source://pp//lib/pp.rb#161
  def check_inspect_key(id); end

  # A convenience method which is same as follows:
  #
  #   text ','
  #   breakable
  #
  # source://pp//lib/pp.rb#238
  def comma_breakable; end

  # Yields to a block
  # and preserves the previous set of objects being printed.
  #
  # source://pp//lib/pp.rb#147
  def guard_inspect_key; end

  # A convenience method, like object_group, but also reformats the Object's
  # object_id.
  #
  # source://pp//lib/pp.rb#228
  def object_address_group(obj, &block); end

  # A convenience method which is same as follows:
  #
  #   group(1, '#<' + obj.class.name, '>') { ... }
  #
  # source://pp//lib/pp.rb#222
  def object_group(obj, &block); end

  # Removes an object from the set of objects being pretty printed.
  #
  # source://pp//lib/pp.rb#173
  def pop_inspect_key(id); end

  # Adds +obj+ to the pretty printing buffer
  # using Object#pretty_print or Object#pretty_print_cycle.
  #
  # Object#pretty_print_cycle is used when +obj+ is already
  # printed, a.k.a the object reference chain has a cycle.
  #
  # source://pp//lib/pp.rb#200
  def pp(obj); end

  # A pretty print for a Hash
  #
  # source://pp//lib/pp.rb#302
  def pp_hash(obj); end

  # A pretty print for a pair of Hash
  #
  # source://pp//lib/pp.rb#314
  def pp_hash_pair(k, v); end

  # A present standard failsafe for pretty printing any given Object
  #
  # source://pp//lib/pp.rb#286
  def pp_object(obj); end

  # Adds the object_id +id+ to the set of objects being pretty printed, so
  # as to not repeat objects.
  #
  # source://pp//lib/pp.rb#168
  def push_inspect_key(id); end

  # Adds a separated list.
  # The list is separated by comma with breakable space, by default.
  #
  # #seplist iterates the +list+ using +iter_method+.
  # It yields each object to the block given for #seplist.
  # The procedure +separator_proc+ is called between each yields.
  #
  # If the iteration is zero times, +separator_proc+ is not called at all.
  #
  # If +separator_proc+ is nil or not given,
  # +lambda { comma_breakable }+ is used.
  # If +iter_method+ is not given, :each is used.
  #
  # For example, following 3 code fragments has similar effect.
  #
  #   q.seplist([1,2,3]) {|v| xxx v }
  #
  #   q.seplist([1,2,3], lambda { q.comma_breakable }, :each) {|v| xxx v }
  #
  #   xxx 1
  #   q.comma_breakable
  #   xxx 2
  #   q.comma_breakable
  #   xxx 3
  #
  # source://pp//lib/pp.rb#267
  def seplist(list, sep = T.unsafe(nil), iter_method = T.unsafe(nil)); end

  private

  # source://pp//lib/pp.rb#177
  def guard_inspect(object); end
end

# source://pp//lib/pp.rb#280
PP::PPMethods::EMPTY_KWHASH = T.let(T.unsafe(nil), Hash)

class PP::SingleLine < ::PrettyPrint::SingleLine
  include ::PP::PPMethods
end

# The version string
#
# source://pp//lib/pp.rb#67
PP::VERSION = T.let(T.unsafe(nil), String)

class Range
  include ::Enumerable

  # source://pp//lib/pp.rb#529
  def pretty_print(q); end
end

class RubyVM::AbstractSyntaxTree::Node
  # source://pp//lib/pp.rb#679
  def pretty_print(q); end

  # source://pp//lib/pp.rb#666
  def pretty_print_children(q, names = T.unsafe(nil)); end
end

class Set
  include ::Enumerable

  # source://pp//lib/pp.rb#443
  def pretty_print(pp); end

  # source://pp//lib/pp.rb#451
  def pretty_print_cycle(pp); end
end

class Set::CoreSet < ::Set; end

class String
  include ::Comparable

  # source://pp//lib/pp.rb#541
  def pretty_print(q); end
end

class Struct
  include ::Enumerable

  # source://pp//lib/pp.rb#468
  def pretty_print(q); end

  # source://pp//lib/pp.rb#482
  def pretty_print_cycle(q); end
end
