#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;

use lib 'lib';
use RestfulDB::DBSettings qw(get_database_settings);

binmode( STDOUT, "utf8" );

my %cgi_params;

eval {
    # Should croak:
    print STDERR "test1:\n";
    &get_database_settings( \%cgi_params, \%ENV, {} );
};
if( $@ ) {
    print STDERR $@;
}

eval {
    # Should croak:
    my %env = %ENV;
    $env{REQUEST_URI} = "/~saulius/test/dbase/tbl";
    print STDERR "test2:\n";
    &get_database_settings( \%cgi_params, \%env, { db_dir => ".",
                                                   level => 4 } );
};
if( $@ ) {
    print STDERR $@;
}
