
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <AppBlend_Approx.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_AppBlend(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("AppBlend"));
py::object klass;

//Python trampoline classes
    class Py_AppBlend_Approx : public AppBlend_Approx{
    public:
        using AppBlend_Approx::AppBlend_Approx;


        // public pure virtual
        Standard_Boolean IsDone() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,IsDone,) };
        void Surface(TColgp_Array2OfPnt & TPoles,TColStd_Array2OfReal & TWeights,TColStd_Array1OfReal & TUKnots,TColStd_Array1OfReal & TVKnots,TColStd_Array1OfInteger & TUMults,TColStd_Array1OfInteger & TVMults) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Surface,TPoles,TWeights,TUKnots,TVKnots,TUMults,TVMults) };
        Standard_Integer UDegree() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,UDegree,) };
        Standard_Integer VDegree() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,VDegree,) };
         const TColgp_Array2OfPnt & SurfPoles() const  override { using return_type =  const TColgp_Array2OfPnt &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfPoles,) };
         const TColStd_Array2OfReal & SurfWeights() const  override { using return_type =  const TColStd_Array2OfReal &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfWeights,) };
         const TColStd_Array1OfReal & SurfUKnots() const  override { using return_type =  const TColStd_Array1OfReal &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfUKnots,) };
         const TColStd_Array1OfReal & SurfVKnots() const  override { using return_type =  const TColStd_Array1OfReal &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfVKnots,) };
         const TColStd_Array1OfInteger & SurfUMults() const  override { using return_type =  const TColStd_Array1OfInteger &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfUMults,) };
         const TColStd_Array1OfInteger & SurfVMults() const  override { using return_type =  const TColStd_Array1OfInteger &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfVMults,) };
        Standard_Integer NbCurves2d() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,NbCurves2d,) };
        void Curve2d( const Standard_Integer Index,TColgp_Array1OfPnt2d & TPoles,TColStd_Array1OfReal & TKnots,TColStd_Array1OfInteger & TMults) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curve2d,Index,TPoles,TKnots,TMults) };
        Standard_Integer Curves2dDegree() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curves2dDegree,) };
         const TColgp_Array1OfPnt2d & Curve2dPoles( const Standard_Integer Index) const  override { using return_type =  const TColgp_Array1OfPnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curve2dPoles,Index) };
         const TColStd_Array1OfReal & Curves2dKnots() const  override { using return_type =  const TColStd_Array1OfReal &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curves2dKnots,) };
         const TColStd_Array1OfInteger & Curves2dMults() const  override { using return_type =  const TColStd_Array1OfInteger &;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curves2dMults,) };
        Standard_Real TolCurveOnSurf( const Standard_Integer Index) const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,TolCurveOnSurf,Index) };
        void SurfShape(Standard_Integer & UDegree,Standard_Integer & VDegree,Standard_Integer & NbUPoles,Standard_Integer & NbVPoles,Standard_Integer & NbUKnots,Standard_Integer & NbVKnots) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,SurfShape,UDegree,VDegree,NbUPoles,NbVPoles,NbUKnots,NbVKnots) };
        void Curves2dShape(Standard_Integer & Degree,Standard_Integer & NbPoles,Standard_Integer & NbKnots) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,Curves2dShape,Degree,NbPoles,NbKnots) };
        void TolReached(Standard_Real & Tol3d,Standard_Real & Tol2d) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,AppBlend_Approx,TolReached,Tol3d,Tol2d) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class AppBlend_Approx from ./opencascade/AppBlend_Approx.hxx
    klass = m.attr("AppBlend_Approx");


    // nested enums

    static_cast<py::class_<AppBlend_Approx , shared_ptr<AppBlend_Approx> ,Py_AppBlend_Approx >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("IsDone",
             (Standard_Boolean (AppBlend_Approx::*)() const) static_cast<Standard_Boolean (AppBlend_Approx::*)() const>(&AppBlend_Approx::IsDone),
             R"#()#" 
          )
        .def("Surface",
             (void (AppBlend_Approx::*)( TColgp_Array2OfPnt & ,  TColStd_Array2OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfInteger &  ) const) static_cast<void (AppBlend_Approx::*)( TColgp_Array2OfPnt & ,  TColStd_Array2OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger & ,  TColStd_Array1OfInteger &  ) const>(&AppBlend_Approx::Surface),
             R"#()#"  , py::arg("TPoles"),  py::arg("TWeights"),  py::arg("TUKnots"),  py::arg("TVKnots"),  py::arg("TUMults"),  py::arg("TVMults")
          )
        .def("UDegree",
             (Standard_Integer (AppBlend_Approx::*)() const) static_cast<Standard_Integer (AppBlend_Approx::*)() const>(&AppBlend_Approx::UDegree),
             R"#()#" 
          )
        .def("VDegree",
             (Standard_Integer (AppBlend_Approx::*)() const) static_cast<Standard_Integer (AppBlend_Approx::*)() const>(&AppBlend_Approx::VDegree),
             R"#()#" 
          )
        .def("SurfPoles",
             ( const TColgp_Array2OfPnt & (AppBlend_Approx::*)() const) static_cast< const TColgp_Array2OfPnt & (AppBlend_Approx::*)() const>(&AppBlend_Approx::SurfPoles),
             R"#()#" 
          )
        .def("SurfWeights",
             ( const TColStd_Array2OfReal & (AppBlend_Approx::*)() const) static_cast< const TColStd_Array2OfReal & (AppBlend_Approx::*)() const>(&AppBlend_Approx::SurfWeights),
             R"#()#" 
          )
        .def("SurfUKnots",
             ( const TColStd_Array1OfReal & (AppBlend_Approx::*)() const) static_cast< const TColStd_Array1OfReal & (AppBlend_Approx::*)() const>(&AppBlend_Approx::SurfUKnots),
             R"#()#" 
          )
        .def("SurfVKnots",
             ( const TColStd_Array1OfReal & (AppBlend_Approx::*)() const) static_cast< const TColStd_Array1OfReal & (AppBlend_Approx::*)() const>(&AppBlend_Approx::SurfVKnots),
             R"#()#" 
          )
        .def("SurfUMults",
             ( const TColStd_Array1OfInteger & (AppBlend_Approx::*)() const) static_cast< const TColStd_Array1OfInteger & (AppBlend_Approx::*)() const>(&AppBlend_Approx::SurfUMults),
             R"#()#" 
          )
        .def("SurfVMults",
             ( const TColStd_Array1OfInteger & (AppBlend_Approx::*)() const) static_cast< const TColStd_Array1OfInteger & (AppBlend_Approx::*)() const>(&AppBlend_Approx::SurfVMults),
             R"#()#" 
          )
        .def("NbCurves2d",
             (Standard_Integer (AppBlend_Approx::*)() const) static_cast<Standard_Integer (AppBlend_Approx::*)() const>(&AppBlend_Approx::NbCurves2d),
             R"#()#" 
          )
        .def("Curve2d",
             (void (AppBlend_Approx::*)(  const Standard_Integer ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger &  ) const) static_cast<void (AppBlend_Approx::*)(  const Standard_Integer ,  TColgp_Array1OfPnt2d & ,  TColStd_Array1OfReal & ,  TColStd_Array1OfInteger &  ) const>(&AppBlend_Approx::Curve2d),
             R"#()#"  , py::arg("Index"),  py::arg("TPoles"),  py::arg("TKnots"),  py::arg("TMults")
          )
        .def("Curves2dDegree",
             (Standard_Integer (AppBlend_Approx::*)() const) static_cast<Standard_Integer (AppBlend_Approx::*)() const>(&AppBlend_Approx::Curves2dDegree),
             R"#()#" 
          )
        .def("Curve2dPoles",
             ( const TColgp_Array1OfPnt2d & (AppBlend_Approx::*)(  const Standard_Integer  ) const) static_cast< const TColgp_Array1OfPnt2d & (AppBlend_Approx::*)(  const Standard_Integer  ) const>(&AppBlend_Approx::Curve2dPoles),
             R"#()#"  , py::arg("Index")
          )
        .def("Curves2dKnots",
             ( const TColStd_Array1OfReal & (AppBlend_Approx::*)() const) static_cast< const TColStd_Array1OfReal & (AppBlend_Approx::*)() const>(&AppBlend_Approx::Curves2dKnots),
             R"#()#" 
          )
        .def("Curves2dMults",
             ( const TColStd_Array1OfInteger & (AppBlend_Approx::*)() const) static_cast< const TColStd_Array1OfInteger & (AppBlend_Approx::*)() const>(&AppBlend_Approx::Curves2dMults),
             R"#()#" 
          )
        .def("TolCurveOnSurf",
             (Standard_Real (AppBlend_Approx::*)(  const Standard_Integer  ) const) static_cast<Standard_Real (AppBlend_Approx::*)(  const Standard_Integer  ) const>(&AppBlend_Approx::TolCurveOnSurf),
             R"#()#"  , py::arg("Index")
          )
    // methods using call by reference i.s.o. return
        .def("SurfShape",
             []( AppBlend_Approx &self   ){
                 Standard_Integer  UDegree;
                Standard_Integer  VDegree;
                Standard_Integer  NbUPoles;
                Standard_Integer  NbVPoles;
                Standard_Integer  NbUKnots;
                Standard_Integer  NbVKnots;

                 self.SurfShape(UDegree,VDegree,NbUPoles,NbVPoles,NbUKnots,NbVKnots);
                 
                 return std::make_tuple(UDegree,VDegree,NbUPoles,NbVPoles,NbUKnots,NbVKnots); },
             R"#()#" 
          )
        .def("Curves2dShape",
             []( AppBlend_Approx &self   ){
                 Standard_Integer  Degree;
                Standard_Integer  NbPoles;
                Standard_Integer  NbKnots;

                 self.Curves2dShape(Degree,NbPoles,NbKnots);
                 
                 return std::make_tuple(Degree,NbPoles,NbKnots); },
             R"#()#" 
          )
        .def("TolReached",
             []( AppBlend_Approx &self   ){
                 Standard_Real  Tol3d;
                Standard_Real  Tol2d;

                 self.TolReached(Tol3d,Tol2d);
                 
                 return std::make_tuple(Tol3d,Tol2d); },
             R"#()#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/AppBlend_Approx.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
