/* Copyright (c) 2001-2025, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.dicom;

/**
 * <p>Standard DICOM Hot Metal Blue color palette.</p>
 *
 * @author	dclunie
 */
public class ColorPaletteHotMetalBlue extends ColorPalette {
	private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ColorPaletteHotMetalBlue.java,v 1.14 2025/01/29 10:58:06 dclunie Exp $";
	
	protected static String sopInstanceUIDStatic = "1.2.840.10008.1.5.3";
	protected static String contentLabelStatic = "HOT_METAL_BLUE";
	protected static String contentDescriptionStatic = "Hot Metal Blue";
	protected static String contentCreatorNameStatic = "PixelMed^Publishing";
	protected static String referenceEncodedInstanceURLStatic = "ftp://medical.nema.org/Medical/Dicom/Palettes/hotmetalblue.dcm";
	
	protected static String[] alternateContentDescriptionStatic = { "Hot Metal Blue", "Heisses Metallblau" };
	protected static String[] alternateContentLanguageCodeValueStatic = { "fr", "de" };
	protected static String[] alternateContentLanguageCodeMeaningStatic = { "French", "German" };
	
	protected static byte[] redStaticArray = {
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)3,
		(byte)6,
		(byte)9,
		(byte)12,
		(byte)15,
		(byte)18,
		(byte)21,
		(byte)24,
		(byte)26,
		(byte)29,
		(byte)32,
		(byte)35,
		(byte)38,
		(byte)41,
		(byte)44,
		(byte)47,
		(byte)50,
		(byte)52,
		(byte)55,
		(byte)57,
		(byte)59,
		(byte)62,
		(byte)64,
		(byte)66,
		(byte)69,
		(byte)71,
		(byte)74,
		(byte)76,
		(byte)78,
		(byte)81,
		(byte)83,
		(byte)85,
		(byte)88,
		(byte)90,
		(byte)93,
		(byte)96,
		(byte)99,
		(byte)102,
		(byte)105,
		(byte)108,
		(byte)111,
		(byte)114,
		(byte)116,
		(byte)119,
		(byte)122,
		(byte)125,
		(byte)128,
		(byte)131,
		(byte)134,
		(byte)137,
		(byte)140,
		(byte)143,
		(byte)146,
		(byte)149,
		(byte)152,
		(byte)155,
		(byte)158,
		(byte)161,
		(byte)164,
		(byte)166,
		(byte)169,
		(byte)172,
		(byte)175,
		(byte)178,
		(byte)181,
		(byte)184,
		(byte)187,
		(byte)190,
		(byte)194,
		(byte)198,
		(byte)201,
		(byte)205,
		(byte)209,
		(byte)213,
		(byte)217,
		(byte)221,
		(byte)224,
		(byte)228,
		(byte)232,
		(byte)236,
		(byte)240,
		(byte)244,
		(byte)247,
		(byte)251,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255,
		(byte)255
	};
	
	protected static byte[] greenStaticArray = {
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)2,
		(byte)4,
		(byte)6,
		(byte)8,
		(byte)9,
		(byte)11,
		(byte)13,
		(byte)15,
		(byte)17,
		(byte)19,
		(byte)21,
		(byte)23,
		(byte)24,
		(byte)26,
		(byte)28,
		(byte)30,
		(byte)32,
		(byte)34,
		(byte)36,
		(byte)38,
		(byte)40,
		(byte)41,
		(byte)43,
		(byte)45,
		(byte)47,
		(byte)49,
		(byte)51,
		(byte)53,
		(byte)55,
		(byte)56,
		(byte)58,
		(byte)60,
		(byte)62,
		(byte)64,
		(byte)66,
		(byte)68,
		(byte)70,
		(byte)72,
		(byte)73,
		(byte)75,
		(byte)77,
		(byte)79,
		(byte)81,
		(byte)83,
		(byte)85,
		(byte)87,
		(byte)88,
		(byte)90,
		(byte)92,
		(byte)94,
		(byte)96,
		(byte)98,
		(byte)100,
		(byte)102,
		(byte)104,
		(byte)105,
		(byte)107,
		(byte)109,
		(byte)111,
		(byte)113,
		(byte)115,
		(byte)117,
		(byte)119,
		(byte)120,
		(byte)122,
		(byte)124,
		(byte)126,
		(byte)128,
		(byte)130,
		(byte)132,
		(byte)134,
		(byte)136,
		(byte)137,
		(byte)139,
		(byte)141,
		(byte)143,
		(byte)145,
		(byte)147,
		(byte)149,
		(byte)151,
		(byte)152,
		(byte)154,
		(byte)156,
		(byte)158,
		(byte)160,
		(byte)162,
		(byte)164,
		(byte)166,
		(byte)168,
		(byte)169,
		(byte)171,
		(byte)173,
		(byte)175,
		(byte)177,
		(byte)179,
		(byte)181,
		(byte)183,
		(byte)184,
		(byte)186,
		(byte)188,
		(byte)190,
		(byte)192,
		(byte)194,
		(byte)196,
		(byte)198,
		(byte)200,
		(byte)201,
		(byte)203,
		(byte)205,
		(byte)207,
		(byte)209,
		(byte)211,
		(byte)213,
		(byte)215,
		(byte)216,
		(byte)218,
		(byte)220,
		(byte)222,
		(byte)224,
		(byte)226,
		(byte)228,
		(byte)229,
		(byte)231,
		(byte)233,
		(byte)235,
		(byte)237,
		(byte)239,
		(byte)240,
		(byte)242,
		(byte)244,
		(byte)246,
		(byte)248,
		(byte)250,
		(byte)251,
		(byte)253,
		(byte)255
	};

	protected static byte[] blueStaticArray = {
		(byte)0,
		(byte)2,
		(byte)4,
		(byte)6,
		(byte)8,
		(byte)10,
		(byte)12,
		(byte)14,
		(byte)16,
		(byte)17,
		(byte)19,
		(byte)21,
		(byte)23,
		(byte)25,
		(byte)27,
		(byte)29,
		(byte)31,
		(byte)33,
		(byte)35,
		(byte)37,
		(byte)39,
		(byte)41,
		(byte)43,
		(byte)45,
		(byte)47,
		(byte)49,
		(byte)51,
		(byte)53,
		(byte)55,
		(byte)57,
		(byte)59,
		(byte)61,
		(byte)63,
		(byte)65,
		(byte)67,
		(byte)69,
		(byte)71,
		(byte)73,
		(byte)75,
		(byte)77,
		(byte)79,
		(byte)81,
		(byte)83,
		(byte)84,
		(byte)86,
		(byte)88,
		(byte)90,
		(byte)92,
		(byte)94,
		(byte)96,
		(byte)98,
		(byte)100,
		(byte)102,
		(byte)104,
		(byte)106,
		(byte)108,
		(byte)110,
		(byte)112,
		(byte)114,
		(byte)116,
		(byte)117,
		(byte)119,
		(byte)121,
		(byte)123,
		(byte)125,
		(byte)127,
		(byte)129,
		(byte)131,
		(byte)133,
		(byte)135,
		(byte)137,
		(byte)139,
		(byte)141,
		(byte)143,
		(byte)145,
		(byte)147,
		(byte)149,
		(byte)151,
		(byte)153,
		(byte)155,
		(byte)157,
		(byte)159,
		(byte)161,
		(byte)163,
		(byte)165,
		(byte)167,
		(byte)169,
		(byte)171,
		(byte)173,
		(byte)175,
		(byte)177,
		(byte)179,
		(byte)181,
		(byte)183,
		(byte)184,
		(byte)186,
		(byte)188,
		(byte)190,
		(byte)192,
		(byte)194,
		(byte)196,
		(byte)198,
		(byte)200,
		(byte)197,
		(byte)194,
		(byte)191,
		(byte)188,
		(byte)185,
		(byte)182,
		(byte)179,
		(byte)176,
		(byte)174,
		(byte)171,
		(byte)168,
		(byte)165,
		(byte)162,
		(byte)159,
		(byte)156,
		(byte)153,
		(byte)150,
		(byte)144,
		(byte)138,
		(byte)132,
		(byte)126,
		(byte)121,
		(byte)115,
		(byte)109,
		(byte)103,
		(byte)97,
		(byte)91,
		(byte)85,
		(byte)79,
		(byte)74,
		(byte)68,
		(byte)62,
		(byte)56,
		(byte)50,
		(byte)47,
		(byte)44,
		(byte)41,
		(byte)38,
		(byte)35,
		(byte)32,
		(byte)29,
		(byte)26,
		(byte)24,
		(byte)21,
		(byte)18,
		(byte)15,
		(byte)12,
		(byte)9,
		(byte)6,
		(byte)3,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)0,
		(byte)3,
		(byte)6,
		(byte)9,
		(byte)12,
		(byte)15,
		(byte)18,
		(byte)21,
		(byte)24,
		(byte)26,
		(byte)29,
		(byte)32,
		(byte)35,
		(byte)38,
		(byte)41,
		(byte)44,
		(byte)47,
		(byte)50,
		(byte)53,
		(byte)56,
		(byte)59,
		(byte)62,
		(byte)65,
		(byte)68,
		(byte)71,
		(byte)74,
		(byte)76,
		(byte)79,
		(byte)82,
		(byte)85,
		(byte)88,
		(byte)91,
		(byte)94,
		(byte)97,
		(byte)100,
		(byte)103,
		(byte)106,
		(byte)109,
		(byte)112,
		(byte)115,
		(byte)118,
		(byte)121,
		(byte)124,
		(byte)126,
		(byte)129,
		(byte)132,
		(byte)135,
		(byte)138,
		(byte)141,
		(byte)144,
		(byte)147,
		(byte)150,
		(byte)153,
		(byte)156,
		(byte)159,
		(byte)162,
		(byte)165,
		(byte)168,
		(byte)171,
		(byte)174,
		(byte)176,
		(byte)179,
		(byte)182,
		(byte)185,
		(byte)188,
		(byte)191,
		(byte)194,
		(byte)197,
		(byte)200,
		(byte)203,
		(byte)206,
		(byte)210,
		(byte)213,
		(byte)216,
		(byte)219,
		(byte)223,
		(byte)226,
		(byte)229,
		(byte)232,
		(byte)236,
		(byte)239,
		(byte)242,
		(byte)245,
		(byte)249,
		(byte)252,
		(byte)255
	};

	public ColorPaletteHotMetalBlue() {
		red = redStaticArray;
		green = greenStaticArray;
		blue = blueStaticArray;
		sopInstanceUID= sopInstanceUIDStatic;
		contentLabel = contentLabelStatic;
		contentDescription = contentDescriptionStatic;
		contentCreatorName = contentCreatorNameStatic;
		referenceEncodedInstanceURL = referenceEncodedInstanceURLStatic;
		alternateContentDescription = alternateContentDescriptionStatic;
		alternateContentLanguageCodeValue = alternateContentLanguageCodeValueStatic;
		alternateContentLanguageCodeMeaning = alternateContentLanguageCodeMeaningStatic;
	}

	/**
	 * <p>Create a DICOM color palette storage instance from the palette characteristics.</p>
	 *
	 * @param	arg one or two arguments, the name of the DICOM file to write, and optionally the name of a file containing the ICC profile to include
	 */
	public static void main(String arg[]) {

		try {
			new ColorPaletteHotMetalBlue().createDICOMInstance(arg[0],(arg.length > 1 ? arg[1] : null),"OURAETITLE");
		}
		catch (Exception e) {
			System.err.println(e);
			e.printStackTrace(System.err);	// no need to use SLF4J since command line utility/test
			System.exit(0);
		}
	}
}
