/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "perfetto/trace_processor/trace_processor.h"

#include <cstddef>
#include <cstdint>
#include <memory>
#include <utility>

#include "perfetto/base/status.h"
#include "perfetto/trace_processor/basic_types.h"
#include "perfetto/trace_processor/trace_processor_storage.h"
#include "src/trace_processor/trace_processor_impl.h"

namespace perfetto::trace_processor {

TraceProcessor::MetatraceConfig::MetatraceConfig() = default;

// static
std::unique_ptr<TraceProcessor> TraceProcessor::CreateInstance(
    const Config& config) {
  return std::unique_ptr<TraceProcessor>(new TraceProcessorImpl(config));
}

TraceProcessor::~TraceProcessor() = default;

base::Status TraceProcessor::Parse(std::unique_ptr<uint8_t[]> buf,
                                   size_t size) {
  return TraceProcessorStorage::Parse(std::move(buf), size);
}

}  // namespace perfetto::trace_processor
