/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Autogenerated by the ProtoZero C compiler plugin.
// Invoked by tools/gen_c_protos
// DO NOT EDIT.
#ifndef INCLUDE_PERFETTO_PUBLIC_PROTOS_TRACE_ANDROID_ANDROID_TRACK_EVENT_PZC_H_
#define INCLUDE_PERFETTO_PUBLIC_PROTOS_TRACE_ANDROID_ANDROID_TRACK_EVENT_PZC_H_

#include <stdbool.h>
#include <stdint.h>

#include "perfetto/public/pb_macros.h"
#include "perfetto/public/protos/trace/track_event/track_event.pzc.h"

PERFETTO_PB_MSG_DECL(perfetto_protos_AndroidSurfaceFlingerWorkload_Summary);
PERFETTO_PB_MSG_DECL(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Stats);
PERFETTO_PB_MSG_DECL(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings);
PERFETTO_PB_MSG_DECL(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Hwc);
PERFETTO_PB_MSG_DECL(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Re);
PERFETTO_PB_MSG_DECL(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_SfCpu);
PERFETTO_PB_MSG_DECL(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Skia);

PERFETTO_PB_ENUM(perfetto_protos_ReceiverType){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UNKNOWN) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_RUNTIME) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_MANIFEST) = 2,
};

PERFETTO_PB_ENUM(perfetto_protos_ProcessStartType){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_START_TYPE_UNKNOWN) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_START_TYPE_WARM) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_START_TYPE_HOT) = 2,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_START_TYPE_COLD) = 3,
};

PERFETTO_PB_ENUM(perfetto_protos_PackageStoppedState){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PACKAGE_STATE_UNKNOWN) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PACKAGE_STATE_NORMAL) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PACKAGE_STATE_STOPPED) = 2,
};

PERFETTO_PB_ENUM(perfetto_protos_BroadcastDeliveryGroupPolicy){
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_BROADCAST_DELIVERY_GROUP_POLICY_ALL) = 0,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_BROADCAST_DELIVERY_GROUP_POLICY_MOST_RECENT) = 1,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_BROADCAST_DELIVERY_GROUP_POLICY_MERGED) = 2,
};

PERFETTO_PB_ENUM(perfetto_protos_ProcessStateEnum){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_UNSPECIFIED) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_UNKNOWN_TO_PROTO) =
        998,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_UNKNOWN) = 999,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_PERSISTENT) = 1000,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_PERSISTENT_UI) = 1001,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_TOP) = 1002,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_BOUND_TOP) = 1020,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_FOREGROUND_SERVICE) =
        1003,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_STATE_BOUND_FOREGROUND_SERVICE) = 1004,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_IMPORTANT_FOREGROUND) =
        1005,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_IMPORTANT_BACKGROUND) =
        1006,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_TRANSIENT_BACKGROUND) =
        1007,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_BACKUP) = 1008,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_SERVICE) = 1009,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_RECEIVER) = 1010,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_TOP_SLEEPING) = 1011,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_HEAVY_WEIGHT) = 1012,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_HOME) = 1013,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_LAST_ACTIVITY) = 1014,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_CACHED_ACTIVITY) =
        1015,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_STATE_CACHED_ACTIVITY_CLIENT) = 1016,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_CACHED_RECENT) = 1017,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_CACHED_EMPTY) = 1018,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_STATE_NONEXISTENT) = 1019,
};

PERFETTO_PB_ENUM(perfetto_protos_ProcessCapabilityEnum){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_CAPABILITY_UNKNOWN) = 0,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_CAPABILITY_FOREGROUND_LOCATION) = 1,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_CAPABILITY_FOREGROUND_CAMERA) = 2,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_CAPABILITY_FOREGROUND_MICROPHONE) = 3,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_CAPABILITY_POWER_RESTRICTED_NETWORK) = 4,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_CAPABILITY_BFSL) = 5,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_CAPABILITY_USER_RESTRICTED_NETWORK) = 6,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_CAPABILITY_FOREGROUND_AUDIO_CONTROL) = 7,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_PROCESS_CAPABILITY_CPU_TIME) = 8,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_PROCESS_CAPABILITY_IMPLICIT_CPU_TIME) = 9,
};

PERFETTO_PB_ENUM(perfetto_protos_AppExitReasonCode){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_UNKNOWN) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_EXIT_SELF) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_SIGNALED) = 2,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_LOW_MEMORY) = 3,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_CRASH) = 4,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_CRASH_NATIVE) = 5,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_ANR) = 6,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_INITIALIZATION_FAILURE) = 7,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_PERMISSION_CHANGE) = 8,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_EXCESSIVE_RESOURCE_USAGE) = 9,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_USER_REQUESTED) = 10,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_USER_STOPPED) = 11,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_DEPENDENCY_DIED) = 12,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_OTHER) = 13,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_FREEZER) = 14,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_PACKAGE_STATE_CHANGE) = 15,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_REASON_PACKAGE_UPDATED) = 16,
};

PERFETTO_PB_ENUM(perfetto_protos_AppExitSubReasonCode){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_UNKNOWN) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_WAIT_FOR_DEBUGGER) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_TOO_MANY_CACHED) = 2,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_TOO_MANY_EMPTY) = 3,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_TRIM_EMPTY) = 4,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_LARGE_CACHED) = 5,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_MEMORY_PRESSURE) = 6,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_EXCESSIVE_CPU) = 7,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_SYSTEM_UPDATE_DONE) = 8,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_KILL_ALL_FG) = 9,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_KILL_ALL_BG_EXCEPT) = 10,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_KILL_UID) = 11,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_KILL_PID) = 12,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_INVALID_START) = 13,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_INVALID_STATE) = 14,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_IMPERCEPTIBLE) = 15,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_REMOVE_LRU) = 16,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_ISOLATED_NOT_NEEDED) = 17,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_CACHED_IDLE_FORCED_APP_STANDBY) = 18,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_FREEZER_BINDER_IOCTL) = 19,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_FREEZER_BINDER_TRANSACTION) = 20,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_FORCE_STOP) = 21,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_REMOVE_TASK) = 22,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_STOP_APP) = 23,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_KILL_BACKGROUND) = 24,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_PACKAGE_UPDATE) = 25,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_UNDELIVERED_BROADCAST) =
        26,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_SDK_SANDBOX_DIED) = 27,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_SDK_SANDBOX_NOT_NEEDED) =
        28,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_EXCESSIVE_BINDER_OBJECTS) =
        29,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_OOM_KILL) = 30,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_FREEZER_BINDER_ASYNC_FULL) = 31,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_EXCESSIVE_OUTGOING_BROADCASTS_WHILE_CACHED) =
        32,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_SUBREASON_ANR_TYPE_APP_TRIGGERED) =
        33,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_BIND_APPLICATION) = 34,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_BROADCAST_OF_INTENT) = 35,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_CONTENT_PROVIDER_NOT_RESPONDING) =
        36,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_EXECUTING_SERVICE) = 37,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_FOREGROUND_SHORT_SERVICE_TIMEOUT) =
        39,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_INPUT_DISPATCHING_TIMEOUT) = 41,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_INPUT_DISPATCHING_TIMEOUT_NO_FOCUSED_WINDOW) =
        42,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_JOB_SERVICE_START) = 45,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_ANR_TYPE_START_FOREGROUND_SERVICE) = 47,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_SUBREASON_EXCESSIVE_ENQUEUED_BROADCASTS_COUNT) = 49,
};

PERFETTO_PB_ENUM(perfetto_protos_Importance){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_FOREGROUND) = 100,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_FOREGROUND_SERVICE) = 125,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_TOP_SLEEPING_PRE_28) =
        150,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_VISIBLE) = 200,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_PERCEPTIBLE_PRE_26) = 130,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_PERCEPTIBLE) = 230,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_CANT_SAVE_STATE_PRE_26) =
        170,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_SERVICE) = 300,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_TOP_SLEEPING) = 325,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_CANT_SAVE_STATE) = 350,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_CACHED) = 400,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_BACKGROUND) = 400,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_EMPTY) = 500,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_IMPORTANCE_GONE) = 1000,
};

PERFETTO_PB_ENUM(perfetto_protos_BroadcastType){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_NONE) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_BACKGROUND) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_FOREGROUND) = 2,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_ALARM) = 4,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_INTERACTIVE) = 8,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_ORDERED) = 16,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_PRIORITIZED) = 32,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_RESULT_TO) = 64,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_BROADCAST_TYPE_DEFERRABLE_UNTIL_ACTIVE) = 128,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_PUSH_MESSAGE) = 256,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_BROADCAST_TYPE_PUSH_MESSAGE_OVER_QUOTA) = 512,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_STICKY) = 1024,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_BROADCAST_TYPE_INITIAL_STICKY) =
        2048,
};

PERFETTO_PB_ENUM(perfetto_protos_HostingTypeId){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_UNKNOWN) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_ACTIVITY) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_ADDED_APPLICATION) = 2,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_BACKUP) = 3,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_BROADCAST) = 4,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_CONTENT_PROVIDER) = 5,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_LINK_FAIL) = 6,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_ON_HOLD) = 7,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_NEXT_ACTIVITY) = 8,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_NEXT_TOP_ACTIVITY) = 9,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_RESTART) = 10,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_SERVICE) = 11,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_SYSTEM) = 12,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_TOP_ACTIVITY) = 13,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_HOSTING_TYPE_EMPTY) = 14,
};

PERFETTO_PB_ENUM(perfetto_protos_UnfreezeReason){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_NONE) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_ACTIVITY) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_FINISH_RECEIVER) = 2,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_START_RECEIVER) = 3,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_BIND_SERVICE) = 4,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_UNBIND_SERVICE) = 5,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_START_SERVICE) = 6,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_GET_PROVIDER) = 7,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_REMOVE_PROVIDER) = 8,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_UI_VISIBILITY) = 9,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_ALLOWLIST) = 10,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_PROCESS_BEGIN) = 11,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_PROCESS_END) = 12,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_TRIM_MEMORY) = 13,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_PING) = 15,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_FILE_LOCKS) = 16,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_FILE_LOCK_CHECK_FAILURE) = 17,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_BINDER_TXNS) = 18,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_FEATURE_FLAGS) = 19,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_SHORT_FGS_TIMEOUT) = 20,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_SYSTEM_INIT) = 21,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_BACKUP) = 22,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_SHELL) = 23,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_REMOVE_TASK) = 24,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_UID_IDLE) = 25,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_STOP_SERVICE) = 26,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_EXECUTING_SERVICE) = 27,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_RESTRICTION_CHANGE) = 28,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_COMPONENT_DISABLED) = 29,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_OOM_ADJ_FOLLOW_UP) = 30,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_UFR_OOM_ADJ_RECONFIGURATION) = 31,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_UFR_OOM_ADJ_REASON_SERVICE_BINDER_CALL) = 32,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_UFR_OOM_ADJ_REASON_BATCH_UPDATE_REQUEST) = 33,
};

PERFETTO_PB_ENUM(perfetto_protos_TriggerType){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_TRIGGER_TYPE_UNKNOWN) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_TRIGGER_TYPE_ALARM) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_TRIGGER_TYPE_PUSH_MESSAGE) = 2,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_TRIGGER_TYPE_PUSH_MESSAGE_OVER_QUOTA) = 3,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_TRIGGER_TYPE_JOB) = 4,
};

PERFETTO_PB_ENUM(perfetto_protos_OomChangeReasonEnum){
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_UNKNOWN_TO_PROTO) =
        -1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_NONE) = 0,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_ACTIVITY) = 1,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_FINISH_RECEIVER) = 2,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_START_RECEIVER) = 3,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_BIND_SERVICE) = 4,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_UNBIND_SERVICE) = 5,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_START_SERVICE) = 6,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_GET_PROVIDER) = 7,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_REMOVE_PROVIDER) = 8,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_UI_VISIBILITY) = 9,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_ALLOWLIST) = 10,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_PROCESS_BEGIN) = 11,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_PROCESS_END) = 12,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_SHORT_FGS_TIMEOUT) =
        13,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_SYSTEM_INIT) = 14,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_BACKUP) = 15,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_SHELL) = 16,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_REMOVE_TASK) = 17,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_UID_IDLE) = 18,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_STOP_SERVICE) = 19,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_EXECUTING_SERVICE) =
        20,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_RESTRICTION_CHANGE) =
        21,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_COMPONENT_DISABLED) =
        22,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_FOLLOW_UP) = 23,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_RECONFIGURATION) = 24,
    PERFETTO_PB_ENUM_ENTRY(perfetto_protos_OOM_ADJ_REASON_SERVICE_BINDER_CALL) =
        25,
    PERFETTO_PB_ENUM_ENTRY(
        perfetto_protos_OOM_ADJ_REASON_BATCH_UPDATE_REQUEST) = 26,
};

PERFETTO_PB_ENUM_IN_MSG(perfetto_protos_AndroidSurfaceFlingerWorkload, Source){
    PERFETTO_PB_ENUM_IN_MSG_ENTRY(perfetto_protos_AndroidSurfaceFlingerWorkload,
                                  UNKNOWN) = 0,
    PERFETTO_PB_ENUM_IN_MSG_ENTRY(perfetto_protos_AndroidSurfaceFlingerWorkload,
                                  FRAME_SIGNAL) = 1,
};

PERFETTO_PB_MSG(perfetto_protos_AndroidProcessStateChangedEvent);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int32_t,
                  uid,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int32_t,
                  pid,
                  2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  enum perfetto_protos_ProcessStateEnum,
                  prev_proc_state,
                  3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  enum perfetto_protos_ProcessStateEnum,
                  cur_proc_state,
                  4);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int32_t,
                  prev_capability_flags,
                  5);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int32_t,
                  cur_capability_flags,
                  6);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int32_t,
                  prev_oom_score,
                  7);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int32_t,
                  cur_oom_score,
                  8);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  enum perfetto_protos_OomChangeReasonEnum,
                  reason,
                  9);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int64_t,
                  seq_id,
                  10);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int32_t,
                  cpu_time_reasons,
                  11);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStateChangedEvent,
                  VARINT,
                  int32_t,
                  implicit_cpu_time_reasons,
                  12);

PERFETTO_PB_MSG(perfetto_protos_AndroidBinderDiedEvent);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBinderDiedEvent,
                  VARINT,
                  int32_t,
                  uid,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBinderDiedEvent,
                  VARINT,
                  int32_t,
                  pid,
                  2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBinderDiedEvent,
                  STRING,
                  const char*,
                  process_name,
                  3);

PERFETTO_PB_MSG(perfetto_protos_AndroidProcessDiedEvent);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessDiedEvent,
                  VARINT,
                  int32_t,
                  uid,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessDiedEvent,
                  VARINT,
                  int32_t,
                  pid,
                  2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessDiedEvent,
                  STRING,
                  const char*,
                  process_name,
                  3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessDiedEvent,
                  VARINT,
                  enum perfetto_protos_AppExitReasonCode,
                  reason,
                  4);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessDiedEvent,
                  VARINT,
                  enum perfetto_protos_AppExitSubReasonCode,
                  sub_reason,
                  5);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessDiedEvent,
                  VARINT,
                  enum perfetto_protos_Importance,
                  importance,
                  6);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessDiedEvent,
                  VARINT,
                  int32_t,
                  rss_kb,
                  7);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessDiedEvent,
                  VARINT,
                  int32_t,
                  has_foreground_services,
                  8);

PERFETTO_PB_MSG(perfetto_protos_AndroidProcessStartEvent);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStartEvent,
                  VARINT,
                  int32_t,
                  uid,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStartEvent,
                  VARINT,
                  int32_t,
                  pid,
                  2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStartEvent,
                  STRING,
                  const char*,
                  process_name,
                  3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStartEvent,
                  VARINT,
                  int64_t,
                  bind_application_delay_ms,
                  4);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStartEvent,
                  VARINT,
                  int64_t,
                  process_start_delay_ms,
                  5);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStartEvent,
                  STRING,
                  const char*,
                  hosting_name,
                  6);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStartEvent,
                  VARINT,
                  enum perfetto_protos_HostingTypeId,
                  hosting_type,
                  7);
PERFETTO_PB_FIELD(perfetto_protos_AndroidProcessStartEvent,
                  VARINT,
                  enum perfetto_protos_TriggerType,
                  trigger_type,
                  8);

PERFETTO_PB_MSG(perfetto_protos_AndroidFreezerEvent);
PERFETTO_PB_FIELD(perfetto_protos_AndroidFreezerEvent, VARINT, int32_t, uid, 1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidFreezerEvent, VARINT, int32_t, pid, 2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidFreezerEvent,
                  VARINT,
                  int64_t,
                  unfrozen_dur_ms,
                  3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidFreezerEvent,
                  VARINT,
                  int64_t,
                  frozen_dur_ms,
                  4);
PERFETTO_PB_FIELD(perfetto_protos_AndroidFreezerEvent,
                  VARINT,
                  enum perfetto_protos_UnfreezeReason,
                  unfreeze_reason,
                  5);

PERFETTO_PB_MSG(perfetto_protos_AndroidBroadcastEvent);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int32_t,
                  receiver_uid,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int32_t,
                  receiver_pid,
                  2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int32_t,
                  sender_uid,
                  3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int32_t,
                  sender_pid,
                  4);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  STRING,
                  const char*,
                  action_name,
                  5);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  enum perfetto_protos_ReceiverType,
                  receiver_type,
                  6);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  enum perfetto_protos_ProcessStartType,
                  proc_start_type,
                  7);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int64_t,
                  dispatch_delay_ms,
                  8);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int64_t,
                  receive_delay_ms,
                  9);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int64_t,
                  finish_delay_ms,
                  10);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  enum perfetto_protos_PackageStoppedState,
                  package_stopped_state,
                  11);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int32_t,
                  broadcast_type,
                  12);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  enum perfetto_protos_BroadcastDeliveryGroupPolicy,
                  delivery_group_policy,
                  13);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int32_t,
                  intent_flags,
                  14);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  int32_t,
                  filter_priority,
                  15);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  enum perfetto_protos_ProcessStateEnum,
                  sender_process_state,
                  16);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  enum perfetto_protos_ProcessStateEnum,
                  receiver_process_state,
                  17);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBroadcastEvent,
                  VARINT,
                  uint32_t,
                  first_launch,
                  18);

PERFETTO_PB_MSG(perfetto_protos_AndroidSurfaceFlingerWorkload);
PERFETTO_PB_FIELD(perfetto_protos_AndroidSurfaceFlingerWorkload,
                  VARINT,
                  enum perfetto_protos_AndroidSurfaceFlingerWorkload_Source,
                  source,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidSurfaceFlingerWorkload,
                  STRING,
                  const char*,
                  output_name,
                  2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidSurfaceFlingerWorkload,
                  VARINT,
                  int64_t,
                  vsync_id,
                  3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidSurfaceFlingerWorkload,
                  MSG,
                  perfetto_protos_AndroidSurfaceFlingerWorkload_Summary,
                  summary,
                  4);

PERFETTO_PB_MSG(perfetto_protos_AndroidSurfaceFlingerWorkload_Summary);
PERFETTO_PB_FIELD(perfetto_protos_AndroidSurfaceFlingerWorkload_Summary,
                  MSG,
                  perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings,
                  timings,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidSurfaceFlingerWorkload_Summary,
                  MSG,
                  perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Stats,
                  stats,
                  2);

PERFETTO_PB_MSG(perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Stats);
PERFETTO_PB_FIELD(perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Stats,
                  VARINT,
                  int32_t,
                  gpu_composited_layers,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Stats,
                  VARINT,
                  int32_t,
                  dpu_composited_layers,
                  2);

PERFETTO_PB_MSG(perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings,
    MSG,
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_SfCpu,
    sf_cpu,
    1);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings,
    MSG,
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Hwc,
    hwc,
    2);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings,
    MSG,
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Re,
    re,
    3);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings,
    MSG,
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Skia,
    skia,
    4);

PERFETTO_PB_MSG(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Skia);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Skia,
    VARINT,
    int64_t,
    flush_nanos,
    1);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Skia,
    VARINT,
    int64_t,
    submit_nanos,
    2);

PERFETTO_PB_MSG(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Re);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Re,
    VARINT,
    int64_t,
    draw_layers_nanos,
    1);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Re,
    VARINT,
    int64_t,
    gpu_completion_nanos,
    2);

PERFETTO_PB_MSG(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Hwc);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Hwc,
    VARINT,
    int64_t,
    present_nanos,
    1);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Hwc,
    VARINT,
    int64_t,
    validate_nanos,
    2);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_Hwc,
    VARINT,
    int64_t,
    present_or_validate_nanos,
    3);

PERFETTO_PB_MSG(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_SfCpu);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_SfCpu,
    VARINT,
    int64_t,
    frame_signal_nanos,
    1);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_SfCpu,
    VARINT,
    int64_t,
    commit_nanos,
    2);
PERFETTO_PB_FIELD(
    perfetto_protos_AndroidSurfaceFlingerWorkload_Summary_Timings_SfCpu,
    VARINT,
    int64_t,
    composite_nanos,
    3);

PERFETTO_PB_MSG(perfetto_protos_AndroidBitmap);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBitmap, VARINT, int64_t, size, 1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBitmap, VARINT, int32_t, width, 2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBitmap, VARINT, int32_t, height, 3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBitmap, VARINT, int32_t, density, 4);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBitmap, VARINT, int32_t, config, 5);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBitmap,
                  VARINT,
                  int32_t,
                  mutable_pixels,
                  6);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBitmap,
                  VARINT,
                  int32_t,
                  pixel_storage_type,
                  7);
PERFETTO_PB_FIELD(perfetto_protos_AndroidBitmap, VARINT, int64_t, id, 8);

PERFETTO_PB_MSG(perfetto_protos_AndroidJobSchedulerJob);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  job_id,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  source_uid,
                  2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  proxy_uid,
                  3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  state,
                  4);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  standby_bucket,
                  5);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  requested_priority,
                  6);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  effective_priority,
                  7);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  num_previous_attempts,
                  8);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int64_t,
                  deadline_ms,
                  9);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int64_t,
                  delay_ms,
                  10);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int64_t,
                  job_start_latency_ms,
                  11);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  num_uncompleted_work_items,
                  12);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  proc_state,
                  13);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int64_t,
                  periodic_job_interval_ms,
                  14);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int64_t,
                  periodic_job_flex_interval_ms,
                  15);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  num_reschedules_due_to_abandonment,
                  16);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  back_off_policy_type,
                  17);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  internal_stop_reason,
                  18);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int32_t,
                  public_stop_reason,
                  19);
PERFETTO_PB_FIELD(perfetto_protos_AndroidJobSchedulerJob,
                  VARINT,
                  int64_t,
                  job_state_flags,
                  20);

PERFETTO_PB_MSG(perfetto_protos_AndroidMessageQueue);
PERFETTO_PB_FIELD(perfetto_protos_AndroidMessageQueue,
                  STRING,
                  const char*,
                  sending_thread_name,
                  1);
PERFETTO_PB_FIELD(perfetto_protos_AndroidMessageQueue,
                  STRING,
                  const char*,
                  receiving_thread_name,
                  2);
PERFETTO_PB_FIELD(perfetto_protos_AndroidMessageQueue,
                  VARINT,
                  int32_t,
                  message_code,
                  3);
PERFETTO_PB_FIELD(perfetto_protos_AndroidMessageQueue,
                  VARINT,
                  uint64_t,
                  message_delay_ms,
                  4);

PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            STRING,
                            const char*,
                            binder_service_name,
                            2001);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            STRING,
                            const char*,
                            binder_interface_name,
                            2002);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            STRING,
                            const char*,
                            apex_name,
                            2003);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidMessageQueue,
                            message_queue,
                            2004);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidBitmap,
                            bitmap,
                            2005);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidJobSchedulerJob,
                            job_scheduler_job,
                            2006);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidSurfaceFlingerWorkload,
                            surfaceflinger_workload,
                            2007);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidBroadcastEvent,
                            broadcast_event,
                            2008);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidFreezerEvent,
                            freezer_event,
                            2009);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidProcessStartEvent,
                            process_start_event,
                            2010);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidProcessDiedEvent,
                            process_died_event,
                            2011);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidProcessStateChangedEvent,
                            process_state_changed_event,
                            2012);
PERFETTO_PB_EXTENSION_FIELD(perfetto_protos_AndroidTrackEvent,
                            perfetto_protos_TrackEvent,
                            MSG,
                            perfetto_protos_AndroidBinderDiedEvent,
                            binder_died_event,
                            2013);
#endif  // INCLUDE_PERFETTO_PUBLIC_PROTOS_TRACE_ANDROID_ANDROID_TRACK_EVENT_PZC_H_
