/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QString>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes


namespace MsXpS
{
namespace MassXpert
{


class MonomerSpec
{
  public:
  void setName(const QString &);
  const QString &getName() const;

  void setCode(const QString &);
  const QString &getCode() const;

  void setRaster(const QString &);
  const QString &getRaster() const;

  void setVector(const QString &);
  const QString &getVector() const;

  void setNameSound(const QString &);
  const QString &getNameSound() const;

  void setCodeSound(const QString &);
  const QString &getCodeSound() const;

  static bool parseFile(const QString &file_path,
                        std::vector<MonomerSpec> &monomer_specs);

  protected:
  QString m_name      = QString();
  QString m_code      = QString();
  QString m_raster    = QString();
  QString m_vector    = QString();
  QString m_nameSound = QString();
  QString m_codeSound = QString();
};


} // namespace MassXpert
} // namespace MsXpS
