.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbRefreshKeyboardMapping __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbRefreshKeyboardMapping \- Update the keyboard description that is internal to the X
library
.SH SYNOPSIS
.HP
.B Status XkbRefreshKeyboardMapping
.BI "(\^XkbMapNotifyEvent *" "event" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I event
event initiating remapping
.SH DESCRIPTION
.LP
.I XkbRefreshKeyboardMapping
is the Xkb equivalent of the core
.I XRefreshKeyboardMapping
function. It requests that the X server send the current key mapping information to
this client. A client usually invokes
.I XkbRefreshKeyboardMapping
after receiving an XkbMapNotify event.
.I XkbRefreshKeyboardMapping
returns Success if it succeeds and BadMatch if the event is not an Xkb event.

The XkbMapNotify event can be generated when some client calls
.I XkbSetMap, XkbChangeMap, XkbGetKeyboardByName,
or any of the standard X library functions that change the keyboard mapping or modifier
mapping.
.SH "RETURN VALUES"
.TP 15
Success
The
.I XkbRefreshKeyboardMapping
function returns Success when the request that the X server send the current key mapping information to
this client is successful.
.SH DIAGNOSTICS
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has correct
type and range, but is otherwise invalid
.SH "SEE ALSO"
.BR XkbChangeMap (__libmansuffix__),
.BR XkbGetKeyboardByName (__libmansuffix__),
.BR XkbSetMap (__libmansuffix__),
.BR XRefreshKeyboardMapping (__libmansuffix__)
