#pragma once
/*
 *  $Id: dwt.h 28972 2025-12-10 18:40:27Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_DWT_H__
#define __GWY_DWT_H__

#include <glib.h>
#include <libgwyddion/line.h>
#include <libgwyddion/field.h>

G_BEGIN_DECLS

typedef enum {
    GWY_DWT_HAAR,
    GWY_DWT_DAUB4,
    GWY_DWT_DAUB6,
    GWY_DWT_DAUB8,
    GWY_DWT_DAUB12,
    GWY_DWT_DAUB20
} GwyDWTType;

typedef enum {
    GWY_DWT_DENOISE_UNIVERSAL,
    GWY_DWT_DENOISE_SCALE_ADAPTIVE,
    GWY_DWT_DENOISE_SPACE_ADAPTIVE
} GwyDWTDenoiseType;

const GwyEnum* gwy_dwt_type_get_enum        (void)                            G_GNUC_CONST;
const GwyEnum* gwy_dwt_denoise_type_get_enum(void)                            G_GNUC_CONST;
GwyLine*       gwy_dwt_set_coefficients     (GwyLine *dline,
                                             GwyDWTType type);
void           gwy_line_dwt                 (GwyLine *dline,
                                             GwyLine *wt_coefs,
                                             GwyTransformDirection direction,
                                             gint minsize);
void           gwy_field_xdwt               (GwyField *field,
                                             GwyLine *wt_coefs,
                                             GwyTransformDirection direction,
                                             gint minsize);
void           gwy_field_ydwt               (GwyField *field,
                                             GwyLine *wt_coefs,
                                             GwyTransformDirection direction,
                                             gint minsize);
void           gwy_field_dwt                (GwyField *field,
                                             GwyLine *wt_coefs,
                                             GwyTransformDirection direction,
                                             gint minsize);
void           gwy_field_dwt_mark_anisotropy(GwyField *field,
                                             GwyField *mask,
                                             GwyLine *wt_coefs,
                                             gdouble ratio,
                                             gint lowlimit);
void           gwy_NIELD_dwt_mark_anisotropy(GwyField *field,
                                             GwyNield *mask,
                                             GwyLine *wt_coefs,
                                             gdouble ratio,
                                             gint lowlimit);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
