// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/storagetransfer/v1/transfer.proto

package storagetransferpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request passed to GetGoogleServiceAccount.
type GetGoogleServiceAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud project that the Google service
	// account is associated with.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *GetGoogleServiceAccountRequest) Reset() {
	*x = GetGoogleServiceAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGoogleServiceAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGoogleServiceAccountRequest) ProtoMessage() {}

func (x *GetGoogleServiceAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGoogleServiceAccountRequest.ProtoReflect.Descriptor instead.
func (*GetGoogleServiceAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{0}
}

func (x *GetGoogleServiceAccountRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Request passed to CreateTransferJob.
type CreateTransferJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The job to create.
	TransferJob *TransferJob `protobuf:"bytes,1,opt,name=transfer_job,json=transferJob,proto3" json:"transfer_job,omitempty"`
}

func (x *CreateTransferJobRequest) Reset() {
	*x = CreateTransferJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTransferJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTransferJobRequest) ProtoMessage() {}

func (x *CreateTransferJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTransferJobRequest.ProtoReflect.Descriptor instead.
func (*CreateTransferJobRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{1}
}

func (x *CreateTransferJobRequest) GetTransferJob() *TransferJob {
	if x != nil {
		return x.TransferJob
	}
	return nil
}

// Request passed to UpdateTransferJob.
type UpdateTransferJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of job to update.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Required. The ID of the Google Cloud project that owns the
	// job.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The job to update. `transferJob` is expected to specify one or
	// more of five fields:
	// [description][google.storagetransfer.v1.TransferJob.description],
	// [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
	// [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
	// [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
	// [status][google.storagetransfer.v1.TransferJob.status].  An
	// `UpdateTransferJobRequest` that specifies other fields are rejected with
	// the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a
	// job status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
	// `storagetransfer.jobs.delete` permission.
	TransferJob *TransferJob `protobuf:"bytes,3,opt,name=transfer_job,json=transferJob,proto3" json:"transfer_job,omitempty"`
	// The field mask of the fields in `transferJob` that are to be updated in
	// this request.  Fields in `transferJob` that can be updated are:
	// [description][google.storagetransfer.v1.TransferJob.description],
	// [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
	// [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
	// [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
	// [status][google.storagetransfer.v1.TransferJob.status].  To update the
	// `transfer_spec` of the job, a complete transfer specification must be
	// provided. An incomplete specification missing any required fields is
	// rejected with the error
	// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
	UpdateTransferJobFieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_transfer_job_field_mask,json=updateTransferJobFieldMask,proto3" json:"update_transfer_job_field_mask,omitempty"`
}

func (x *UpdateTransferJobRequest) Reset() {
	*x = UpdateTransferJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTransferJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTransferJobRequest) ProtoMessage() {}

func (x *UpdateTransferJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTransferJobRequest.ProtoReflect.Descriptor instead.
func (*UpdateTransferJobRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateTransferJobRequest) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *UpdateTransferJobRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateTransferJobRequest) GetTransferJob() *TransferJob {
	if x != nil {
		return x.TransferJob
	}
	return nil
}

func (x *UpdateTransferJobRequest) GetUpdateTransferJobFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateTransferJobFieldMask
	}
	return nil
}

// Request passed to GetTransferJob.
type GetTransferJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The job to get.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Required. The ID of the Google Cloud project that owns the
	// job.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *GetTransferJobRequest) Reset() {
	*x = GetTransferJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTransferJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTransferJobRequest) ProtoMessage() {}

func (x *GetTransferJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTransferJobRequest.ProtoReflect.Descriptor instead.
func (*GetTransferJobRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{3}
}

func (x *GetTransferJobRequest) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *GetTransferJobRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Request passed to DeleteTransferJob.
type DeleteTransferJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The job to delete.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Required. The ID of the Google Cloud project that owns the
	// job.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DeleteTransferJobRequest) Reset() {
	*x = DeleteTransferJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTransferJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTransferJobRequest) ProtoMessage() {}

func (x *DeleteTransferJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTransferJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteTransferJobRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteTransferJobRequest) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *DeleteTransferJobRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// `projectId`, `jobNames`, and `jobStatuses` are query parameters that can
// be specified when listing transfer jobs.
type ListTransferJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of query parameters specified as JSON text in the form of:
	// `{"projectId":"my_project_id",
	//
	//	"jobNames":["jobid1","jobid2",...],
	//	"jobStatuses":["status1","status2",...]}`
	//
	// Since `jobNames` and `jobStatuses` support multiple values, their values
	// must be specified with array notation. `projectId` is required.
	// `jobNames` and `jobStatuses` are optional.  The valid values for
	// `jobStatuses` are case-insensitive:
	// [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
	// [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The list page size. The max allowed value is 256.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The list page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTransferJobsRequest) Reset() {
	*x = ListTransferJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferJobsRequest) ProtoMessage() {}

func (x *ListTransferJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferJobsRequest.ProtoReflect.Descriptor instead.
func (*ListTransferJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{5}
}

func (x *ListTransferJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTransferJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTransferJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response from ListTransferJobs.
type ListTransferJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of transfer jobs.
	TransferJobs []*TransferJob `protobuf:"bytes,1,rep,name=transfer_jobs,json=transferJobs,proto3" json:"transfer_jobs,omitempty"`
	// The list next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTransferJobsResponse) Reset() {
	*x = ListTransferJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTransferJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTransferJobsResponse) ProtoMessage() {}

func (x *ListTransferJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTransferJobsResponse.ProtoReflect.Descriptor instead.
func (*ListTransferJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{6}
}

func (x *ListTransferJobsResponse) GetTransferJobs() []*TransferJob {
	if x != nil {
		return x.TransferJobs
	}
	return nil
}

func (x *ListTransferJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request passed to PauseTransferOperation.
type PauseTransferOperationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the transfer operation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *PauseTransferOperationRequest) Reset() {
	*x = PauseTransferOperationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PauseTransferOperationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseTransferOperationRequest) ProtoMessage() {}

func (x *PauseTransferOperationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseTransferOperationRequest.ProtoReflect.Descriptor instead.
func (*PauseTransferOperationRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{7}
}

func (x *PauseTransferOperationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed to ResumeTransferOperation.
type ResumeTransferOperationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the transfer operation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResumeTransferOperationRequest) Reset() {
	*x = ResumeTransferOperationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResumeTransferOperationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeTransferOperationRequest) ProtoMessage() {}

func (x *ResumeTransferOperationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeTransferOperationRequest.ProtoReflect.Descriptor instead.
func (*ResumeTransferOperationRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{8}
}

func (x *ResumeTransferOperationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed to RunTransferJob.
type RunTransferJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the transfer job.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Required. The ID of the Google Cloud project that owns the transfer
	// job.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *RunTransferJobRequest) Reset() {
	*x = RunTransferJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunTransferJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunTransferJobRequest) ProtoMessage() {}

func (x *RunTransferJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunTransferJobRequest.ProtoReflect.Descriptor instead.
func (*RunTransferJobRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{9}
}

func (x *RunTransferJobRequest) GetJobName() string {
	if x != nil {
		return x.JobName
	}
	return ""
}

func (x *RunTransferJobRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Specifies the request passed to CreateAgentPool.
type CreateAgentPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud project that owns the
	// agent pool.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The agent pool to create.
	AgentPool *AgentPool `protobuf:"bytes,2,opt,name=agent_pool,json=agentPool,proto3" json:"agent_pool,omitempty"`
	// Required. The ID of the agent pool to create.
	//
	// The `agent_pool_id` must meet the following requirements:
	//
	// *   Length of 128 characters or less.
	// *   Not start with the string `goog`.
	// *   Start with a lowercase ASCII character, followed by:
	//   - Zero or more: lowercase Latin alphabet characters, numerals,
	//     hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
	//   - One or more numerals or lowercase ASCII characters.
	//
	// As expressed by the regular expression:
	// `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
	AgentPoolId string `protobuf:"bytes,3,opt,name=agent_pool_id,json=agentPoolId,proto3" json:"agent_pool_id,omitempty"`
}

func (x *CreateAgentPoolRequest) Reset() {
	*x = CreateAgentPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAgentPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAgentPoolRequest) ProtoMessage() {}

func (x *CreateAgentPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAgentPoolRequest.ProtoReflect.Descriptor instead.
func (*CreateAgentPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{10}
}

func (x *CreateAgentPoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateAgentPoolRequest) GetAgentPool() *AgentPool {
	if x != nil {
		return x.AgentPool
	}
	return nil
}

func (x *CreateAgentPoolRequest) GetAgentPoolId() string {
	if x != nil {
		return x.AgentPoolId
	}
	return ""
}

// Specifies the request passed to UpdateAgentPool.
type UpdateAgentPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent pool to update. `agent_pool` is expected to specify
	// following fields:
	//
	// *  [name][google.storagetransfer.v1.AgentPool.name]
	//
	// *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
	//
	// *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
	// An `UpdateAgentPoolRequest` with any other fields is rejected
	// with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
	AgentPool *AgentPool `protobuf:"bytes,1,opt,name=agent_pool,json=agentPool,proto3" json:"agent_pool,omitempty"`
	// The [field mask]
	// (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
	// of the fields in `agentPool` to update in this request.
	// The following `agentPool` fields can be updated:
	//
	// *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
	//
	// *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAgentPoolRequest) Reset() {
	*x = UpdateAgentPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAgentPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAgentPoolRequest) ProtoMessage() {}

func (x *UpdateAgentPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAgentPoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateAgentPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateAgentPoolRequest) GetAgentPool() *AgentPool {
	if x != nil {
		return x.AgentPool
	}
	return nil
}

func (x *UpdateAgentPoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Specifies the request passed to GetAgentPool.
type GetAgentPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the agent pool to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAgentPoolRequest) Reset() {
	*x = GetAgentPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAgentPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAgentPoolRequest) ProtoMessage() {}

func (x *GetAgentPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAgentPoolRequest.ProtoReflect.Descriptor instead.
func (*GetAgentPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{12}
}

func (x *GetAgentPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Specifies the request passed to DeleteAgentPool.
type DeleteAgentPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the agent pool to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAgentPoolRequest) Reset() {
	*x = DeleteAgentPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAgentPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAgentPoolRequest) ProtoMessage() {}

func (x *DeleteAgentPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAgentPoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteAgentPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteAgentPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request passed to ListAgentPools.
type ListAgentPoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Google Cloud project that owns the job.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// An optional list of query parameters specified as JSON text in the
	// form of:
	//
	// `{"agentPoolNames":["agentpool1","agentpool2",...]}`
	//
	// Since `agentPoolNames` support multiple values, its values must be
	// specified with array notation. When the filter is either empty or not
	// provided, the list returns all agent pools for the project.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The list page size. The max allowed value is `256`.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAgentPoolsRequest) Reset() {
	*x = ListAgentPoolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAgentPoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAgentPoolsRequest) ProtoMessage() {}

func (x *ListAgentPoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAgentPoolsRequest.ProtoReflect.Descriptor instead.
func (*ListAgentPoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{14}
}

func (x *ListAgentPoolsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListAgentPoolsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAgentPoolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAgentPoolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response from ListAgentPools.
type ListAgentPoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of agent pools.
	AgentPools []*AgentPool `protobuf:"bytes,1,rep,name=agent_pools,json=agentPools,proto3" json:"agent_pools,omitempty"`
	// The list next page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAgentPoolsResponse) Reset() {
	*x = ListAgentPoolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAgentPoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAgentPoolsResponse) ProtoMessage() {}

func (x *ListAgentPoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAgentPoolsResponse.ProtoReflect.Descriptor instead.
func (*ListAgentPoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_proto_rawDescGZIP(), []int{15}
}

func (x *ListAgentPoolsResponse) GetAgentPools() []*AgentPool {
	if x != nil {
		return x.AgentPools
	}
	return nil
}

func (x *ListAgentPoolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_storagetransfer_v1_transfer_proto protoreflect.FileDescriptor

var file_google_storagetransfer_v1_transfer_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x44, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x6a, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f,
	0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f,
	0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x4a, 0x6f, 0x62, 0x22, 0x8e, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1e, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x4e, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a,
	0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x12, 0x5e, 0x0a, 0x1e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x1a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a,
	0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x22, 0x5e, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a,
	0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x22, 0x72, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6a,
	0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f,
	0x62, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x38, 0x0a, 0x1d, 0x50, 0x61, 0x75, 0x73, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x39, 0x0a, 0x1e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5b, 0x0a, 0x15,
	0x52, 0x75, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6a, 0x6f,
	0x62, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0xaf, 0x01, 0x0a, 0x16, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x0a, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x12, 0x27, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x22, 0x9f, 0x01, 0x0a, 0x16,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x2e, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x31, 0x0a,
	0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x8f, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a,
	0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x91, 0x13, 0x0a,
	0x16, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb5, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12,
	0x98, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a,
	0x6f, 0x62, 0x22, 0x26, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x3a, 0x0c, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x22, 0x10, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x9b, 0x01, 0x0a, 0x11, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x22, 0x29, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x23, 0x3a, 0x01, 0x2a, 0x32, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6a,
	0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0x92, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x4a, 0x6f, 0x62, 0x22, 0x26, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0x95, 0x01,
	0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f,
	0x62, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a,
	0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x18, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x12, 0x12, 0x10, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x9d, 0x01, 0x0a, 0x16, 0x50, 0x61, 0x75, 0x73, 0x65, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x75,
	0x73, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x3a, 0x01, 0x2a, 0x22, 0x26, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a,
	0x70, 0x61, 0x75, 0x73, 0x65, 0x12, 0xa0, 0x01, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x75, 0x6d, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01, 0x2a, 0x22,
	0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x12, 0xbd, 0x01, 0x0a, 0x0e, 0x52, 0x75, 0x6e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x27, 0x3a, 0x01, 0x2a, 0x22, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73,
	0x2f, 0x2a, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x12, 0x88, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x26, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x20, 0x2a, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x2f,
	0x2a, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x22, 0x60, 0xda, 0x41, 0x23, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x3a, 0x0a,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x3d, 0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x12, 0xc6, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x22,
	0x5a, 0xda, 0x41, 0x16, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x3a, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x32, 0x2d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x97, 0x01, 0x0a, 0x0c,
	0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x22, 0x31, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb2, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda,
	0x41, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x3d, 0x2a, 0x7d, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x8f, 0x01, 0x0a, 0x0f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x31, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x2a, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x52, 0xca, 0x41,
	0x1e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xef, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_storagetransfer_v1_transfer_proto_rawDescOnce sync.Once
	file_google_storagetransfer_v1_transfer_proto_rawDescData = file_google_storagetransfer_v1_transfer_proto_rawDesc
)

func file_google_storagetransfer_v1_transfer_proto_rawDescGZIP() []byte {
	file_google_storagetransfer_v1_transfer_proto_rawDescOnce.Do(func() {
		file_google_storagetransfer_v1_transfer_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storagetransfer_v1_transfer_proto_rawDescData)
	})
	return file_google_storagetransfer_v1_transfer_proto_rawDescData
}

var file_google_storagetransfer_v1_transfer_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_storagetransfer_v1_transfer_proto_goTypes = []interface{}{
	(*GetGoogleServiceAccountRequest)(nil), // 0: google.storagetransfer.v1.GetGoogleServiceAccountRequest
	(*CreateTransferJobRequest)(nil),       // 1: google.storagetransfer.v1.CreateTransferJobRequest
	(*UpdateTransferJobRequest)(nil),       // 2: google.storagetransfer.v1.UpdateTransferJobRequest
	(*GetTransferJobRequest)(nil),          // 3: google.storagetransfer.v1.GetTransferJobRequest
	(*DeleteTransferJobRequest)(nil),       // 4: google.storagetransfer.v1.DeleteTransferJobRequest
	(*ListTransferJobsRequest)(nil),        // 5: google.storagetransfer.v1.ListTransferJobsRequest
	(*ListTransferJobsResponse)(nil),       // 6: google.storagetransfer.v1.ListTransferJobsResponse
	(*PauseTransferOperationRequest)(nil),  // 7: google.storagetransfer.v1.PauseTransferOperationRequest
	(*ResumeTransferOperationRequest)(nil), // 8: google.storagetransfer.v1.ResumeTransferOperationRequest
	(*RunTransferJobRequest)(nil),          // 9: google.storagetransfer.v1.RunTransferJobRequest
	(*CreateAgentPoolRequest)(nil),         // 10: google.storagetransfer.v1.CreateAgentPoolRequest
	(*UpdateAgentPoolRequest)(nil),         // 11: google.storagetransfer.v1.UpdateAgentPoolRequest
	(*GetAgentPoolRequest)(nil),            // 12: google.storagetransfer.v1.GetAgentPoolRequest
	(*DeleteAgentPoolRequest)(nil),         // 13: google.storagetransfer.v1.DeleteAgentPoolRequest
	(*ListAgentPoolsRequest)(nil),          // 14: google.storagetransfer.v1.ListAgentPoolsRequest
	(*ListAgentPoolsResponse)(nil),         // 15: google.storagetransfer.v1.ListAgentPoolsResponse
	(*TransferJob)(nil),                    // 16: google.storagetransfer.v1.TransferJob
	(*fieldmaskpb.FieldMask)(nil),          // 17: google.protobuf.FieldMask
	(*AgentPool)(nil),                      // 18: google.storagetransfer.v1.AgentPool
	(*GoogleServiceAccount)(nil),           // 19: google.storagetransfer.v1.GoogleServiceAccount
	(*emptypb.Empty)(nil),                  // 20: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),        // 21: google.longrunning.Operation
}
var file_google_storagetransfer_v1_transfer_proto_depIdxs = []int32{
	16, // 0: google.storagetransfer.v1.CreateTransferJobRequest.transfer_job:type_name -> google.storagetransfer.v1.TransferJob
	16, // 1: google.storagetransfer.v1.UpdateTransferJobRequest.transfer_job:type_name -> google.storagetransfer.v1.TransferJob
	17, // 2: google.storagetransfer.v1.UpdateTransferJobRequest.update_transfer_job_field_mask:type_name -> google.protobuf.FieldMask
	16, // 3: google.storagetransfer.v1.ListTransferJobsResponse.transfer_jobs:type_name -> google.storagetransfer.v1.TransferJob
	18, // 4: google.storagetransfer.v1.CreateAgentPoolRequest.agent_pool:type_name -> google.storagetransfer.v1.AgentPool
	18, // 5: google.storagetransfer.v1.UpdateAgentPoolRequest.agent_pool:type_name -> google.storagetransfer.v1.AgentPool
	17, // 6: google.storagetransfer.v1.UpdateAgentPoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	18, // 7: google.storagetransfer.v1.ListAgentPoolsResponse.agent_pools:type_name -> google.storagetransfer.v1.AgentPool
	0,  // 8: google.storagetransfer.v1.StorageTransferService.GetGoogleServiceAccount:input_type -> google.storagetransfer.v1.GetGoogleServiceAccountRequest
	1,  // 9: google.storagetransfer.v1.StorageTransferService.CreateTransferJob:input_type -> google.storagetransfer.v1.CreateTransferJobRequest
	2,  // 10: google.storagetransfer.v1.StorageTransferService.UpdateTransferJob:input_type -> google.storagetransfer.v1.UpdateTransferJobRequest
	3,  // 11: google.storagetransfer.v1.StorageTransferService.GetTransferJob:input_type -> google.storagetransfer.v1.GetTransferJobRequest
	5,  // 12: google.storagetransfer.v1.StorageTransferService.ListTransferJobs:input_type -> google.storagetransfer.v1.ListTransferJobsRequest
	7,  // 13: google.storagetransfer.v1.StorageTransferService.PauseTransferOperation:input_type -> google.storagetransfer.v1.PauseTransferOperationRequest
	8,  // 14: google.storagetransfer.v1.StorageTransferService.ResumeTransferOperation:input_type -> google.storagetransfer.v1.ResumeTransferOperationRequest
	9,  // 15: google.storagetransfer.v1.StorageTransferService.RunTransferJob:input_type -> google.storagetransfer.v1.RunTransferJobRequest
	4,  // 16: google.storagetransfer.v1.StorageTransferService.DeleteTransferJob:input_type -> google.storagetransfer.v1.DeleteTransferJobRequest
	10, // 17: google.storagetransfer.v1.StorageTransferService.CreateAgentPool:input_type -> google.storagetransfer.v1.CreateAgentPoolRequest
	11, // 18: google.storagetransfer.v1.StorageTransferService.UpdateAgentPool:input_type -> google.storagetransfer.v1.UpdateAgentPoolRequest
	12, // 19: google.storagetransfer.v1.StorageTransferService.GetAgentPool:input_type -> google.storagetransfer.v1.GetAgentPoolRequest
	14, // 20: google.storagetransfer.v1.StorageTransferService.ListAgentPools:input_type -> google.storagetransfer.v1.ListAgentPoolsRequest
	13, // 21: google.storagetransfer.v1.StorageTransferService.DeleteAgentPool:input_type -> google.storagetransfer.v1.DeleteAgentPoolRequest
	19, // 22: google.storagetransfer.v1.StorageTransferService.GetGoogleServiceAccount:output_type -> google.storagetransfer.v1.GoogleServiceAccount
	16, // 23: google.storagetransfer.v1.StorageTransferService.CreateTransferJob:output_type -> google.storagetransfer.v1.TransferJob
	16, // 24: google.storagetransfer.v1.StorageTransferService.UpdateTransferJob:output_type -> google.storagetransfer.v1.TransferJob
	16, // 25: google.storagetransfer.v1.StorageTransferService.GetTransferJob:output_type -> google.storagetransfer.v1.TransferJob
	6,  // 26: google.storagetransfer.v1.StorageTransferService.ListTransferJobs:output_type -> google.storagetransfer.v1.ListTransferJobsResponse
	20, // 27: google.storagetransfer.v1.StorageTransferService.PauseTransferOperation:output_type -> google.protobuf.Empty
	20, // 28: google.storagetransfer.v1.StorageTransferService.ResumeTransferOperation:output_type -> google.protobuf.Empty
	21, // 29: google.storagetransfer.v1.StorageTransferService.RunTransferJob:output_type -> google.longrunning.Operation
	20, // 30: google.storagetransfer.v1.StorageTransferService.DeleteTransferJob:output_type -> google.protobuf.Empty
	18, // 31: google.storagetransfer.v1.StorageTransferService.CreateAgentPool:output_type -> google.storagetransfer.v1.AgentPool
	18, // 32: google.storagetransfer.v1.StorageTransferService.UpdateAgentPool:output_type -> google.storagetransfer.v1.AgentPool
	18, // 33: google.storagetransfer.v1.StorageTransferService.GetAgentPool:output_type -> google.storagetransfer.v1.AgentPool
	15, // 34: google.storagetransfer.v1.StorageTransferService.ListAgentPools:output_type -> google.storagetransfer.v1.ListAgentPoolsResponse
	20, // 35: google.storagetransfer.v1.StorageTransferService.DeleteAgentPool:output_type -> google.protobuf.Empty
	22, // [22:36] is the sub-list for method output_type
	8,  // [8:22] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_storagetransfer_v1_transfer_proto_init() }
func file_google_storagetransfer_v1_transfer_proto_init() {
	if File_google_storagetransfer_v1_transfer_proto != nil {
		return
	}
	file_google_storagetransfer_v1_transfer_types_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_storagetransfer_v1_transfer_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGoogleServiceAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTransferJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTransferJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTransferJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTransferJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTransferJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PauseTransferOperationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResumeTransferOperationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunTransferJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAgentPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAgentPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAgentPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAgentPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAgentPoolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAgentPoolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storagetransfer_v1_transfer_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_storagetransfer_v1_transfer_proto_goTypes,
		DependencyIndexes: file_google_storagetransfer_v1_transfer_proto_depIdxs,
		MessageInfos:      file_google_storagetransfer_v1_transfer_proto_msgTypes,
	}.Build()
	File_google_storagetransfer_v1_transfer_proto = out.File
	file_google_storagetransfer_v1_transfer_proto_rawDesc = nil
	file_google_storagetransfer_v1_transfer_proto_goTypes = nil
	file_google_storagetransfer_v1_transfer_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StorageTransferServiceClient is the client API for StorageTransferService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StorageTransferServiceClient interface {
	// Returns the Google service account that is used by Storage Transfer
	// Service to access buckets in the project where transfers
	// run or in other projects. Each Google service account is associated
	// with one Google Cloud project. Users
	// should add this service account to the Google Cloud Storage bucket
	// ACLs to grant access to Storage Transfer Service. This service
	// account is created and owned by Storage Transfer Service and can
	// only be used by Storage Transfer Service.
	GetGoogleServiceAccount(ctx context.Context, in *GetGoogleServiceAccountRequest, opts ...grpc.CallOption) (*GoogleServiceAccount, error)
	// Creates a transfer job that runs periodically.
	CreateTransferJob(ctx context.Context, in *CreateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Updates a transfer job. Updating a job's transfer spec does not affect
	// transfer operations that are running already.
	//
	// **Note:** The job's [status][google.storagetransfer.v1.TransferJob.status]
	// field can be modified using this RPC (for example, to set a job's status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED],
	// [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], or
	// [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED]).
	UpdateTransferJob(ctx context.Context, in *UpdateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Gets a transfer job.
	GetTransferJob(ctx context.Context, in *GetTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Lists transfer jobs.
	ListTransferJobs(ctx context.Context, in *ListTransferJobsRequest, opts ...grpc.CallOption) (*ListTransferJobsResponse, error)
	// Pauses a transfer operation.
	PauseTransferOperation(ctx context.Context, in *PauseTransferOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Resumes a transfer operation that is paused.
	ResumeTransferOperation(ctx context.Context, in *ResumeTransferOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts a new operation for the specified transfer job.
	// A `TransferJob` has a maximum of one active `TransferOperation`. If this
	// method is called while a `TransferOperation` is active, an error is
	// returned.
	RunTransferJob(ctx context.Context, in *RunTransferJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a transfer job. Deleting a transfer job sets its status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
	DeleteTransferJob(ctx context.Context, in *DeleteTransferJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates an agent pool resource.
	CreateAgentPool(ctx context.Context, in *CreateAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error)
	// Updates an existing agent pool resource.
	UpdateAgentPool(ctx context.Context, in *UpdateAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error)
	// Gets an agent pool.
	GetAgentPool(ctx context.Context, in *GetAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error)
	// Lists agent pools.
	ListAgentPools(ctx context.Context, in *ListAgentPoolsRequest, opts ...grpc.CallOption) (*ListAgentPoolsResponse, error)
	// Deletes an agent pool.
	DeleteAgentPool(ctx context.Context, in *DeleteAgentPoolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type storageTransferServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageTransferServiceClient(cc grpc.ClientConnInterface) StorageTransferServiceClient {
	return &storageTransferServiceClient{cc}
}

func (c *storageTransferServiceClient) GetGoogleServiceAccount(ctx context.Context, in *GetGoogleServiceAccountRequest, opts ...grpc.CallOption) (*GoogleServiceAccount, error) {
	out := new(GoogleServiceAccount)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/GetGoogleServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) CreateTransferJob(ctx context.Context, in *CreateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/CreateTransferJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) UpdateTransferJob(ctx context.Context, in *UpdateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/UpdateTransferJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) GetTransferJob(ctx context.Context, in *GetTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/GetTransferJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) ListTransferJobs(ctx context.Context, in *ListTransferJobsRequest, opts ...grpc.CallOption) (*ListTransferJobsResponse, error) {
	out := new(ListTransferJobsResponse)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/ListTransferJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) PauseTransferOperation(ctx context.Context, in *PauseTransferOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/PauseTransferOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) ResumeTransferOperation(ctx context.Context, in *ResumeTransferOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/ResumeTransferOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) RunTransferJob(ctx context.Context, in *RunTransferJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/RunTransferJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) DeleteTransferJob(ctx context.Context, in *DeleteTransferJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/DeleteTransferJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) CreateAgentPool(ctx context.Context, in *CreateAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error) {
	out := new(AgentPool)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/CreateAgentPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) UpdateAgentPool(ctx context.Context, in *UpdateAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error) {
	out := new(AgentPool)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/UpdateAgentPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) GetAgentPool(ctx context.Context, in *GetAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error) {
	out := new(AgentPool)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/GetAgentPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) ListAgentPools(ctx context.Context, in *ListAgentPoolsRequest, opts ...grpc.CallOption) (*ListAgentPoolsResponse, error) {
	out := new(ListAgentPoolsResponse)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/ListAgentPools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) DeleteAgentPool(ctx context.Context, in *DeleteAgentPoolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.storagetransfer.v1.StorageTransferService/DeleteAgentPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageTransferServiceServer is the server API for StorageTransferService service.
type StorageTransferServiceServer interface {
	// Returns the Google service account that is used by Storage Transfer
	// Service to access buckets in the project where transfers
	// run or in other projects. Each Google service account is associated
	// with one Google Cloud project. Users
	// should add this service account to the Google Cloud Storage bucket
	// ACLs to grant access to Storage Transfer Service. This service
	// account is created and owned by Storage Transfer Service and can
	// only be used by Storage Transfer Service.
	GetGoogleServiceAccount(context.Context, *GetGoogleServiceAccountRequest) (*GoogleServiceAccount, error)
	// Creates a transfer job that runs periodically.
	CreateTransferJob(context.Context, *CreateTransferJobRequest) (*TransferJob, error)
	// Updates a transfer job. Updating a job's transfer spec does not affect
	// transfer operations that are running already.
	//
	// **Note:** The job's [status][google.storagetransfer.v1.TransferJob.status]
	// field can be modified using this RPC (for example, to set a job's status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED],
	// [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], or
	// [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED]).
	UpdateTransferJob(context.Context, *UpdateTransferJobRequest) (*TransferJob, error)
	// Gets a transfer job.
	GetTransferJob(context.Context, *GetTransferJobRequest) (*TransferJob, error)
	// Lists transfer jobs.
	ListTransferJobs(context.Context, *ListTransferJobsRequest) (*ListTransferJobsResponse, error)
	// Pauses a transfer operation.
	PauseTransferOperation(context.Context, *PauseTransferOperationRequest) (*emptypb.Empty, error)
	// Resumes a transfer operation that is paused.
	ResumeTransferOperation(context.Context, *ResumeTransferOperationRequest) (*emptypb.Empty, error)
	// Starts a new operation for the specified transfer job.
	// A `TransferJob` has a maximum of one active `TransferOperation`. If this
	// method is called while a `TransferOperation` is active, an error is
	// returned.
	RunTransferJob(context.Context, *RunTransferJobRequest) (*longrunningpb.Operation, error)
	// Deletes a transfer job. Deleting a transfer job sets its status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
	DeleteTransferJob(context.Context, *DeleteTransferJobRequest) (*emptypb.Empty, error)
	// Creates an agent pool resource.
	CreateAgentPool(context.Context, *CreateAgentPoolRequest) (*AgentPool, error)
	// Updates an existing agent pool resource.
	UpdateAgentPool(context.Context, *UpdateAgentPoolRequest) (*AgentPool, error)
	// Gets an agent pool.
	GetAgentPool(context.Context, *GetAgentPoolRequest) (*AgentPool, error)
	// Lists agent pools.
	ListAgentPools(context.Context, *ListAgentPoolsRequest) (*ListAgentPoolsResponse, error)
	// Deletes an agent pool.
	DeleteAgentPool(context.Context, *DeleteAgentPoolRequest) (*emptypb.Empty, error)
}

// UnimplementedStorageTransferServiceServer can be embedded to have forward compatible implementations.
type UnimplementedStorageTransferServiceServer struct {
}

func (*UnimplementedStorageTransferServiceServer) GetGoogleServiceAccount(context.Context, *GetGoogleServiceAccountRequest) (*GoogleServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGoogleServiceAccount not implemented")
}
func (*UnimplementedStorageTransferServiceServer) CreateTransferJob(context.Context, *CreateTransferJobRequest) (*TransferJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTransferJob not implemented")
}
func (*UnimplementedStorageTransferServiceServer) UpdateTransferJob(context.Context, *UpdateTransferJobRequest) (*TransferJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTransferJob not implemented")
}
func (*UnimplementedStorageTransferServiceServer) GetTransferJob(context.Context, *GetTransferJobRequest) (*TransferJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransferJob not implemented")
}
func (*UnimplementedStorageTransferServiceServer) ListTransferJobs(context.Context, *ListTransferJobsRequest) (*ListTransferJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferJobs not implemented")
}
func (*UnimplementedStorageTransferServiceServer) PauseTransferOperation(context.Context, *PauseTransferOperationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseTransferOperation not implemented")
}
func (*UnimplementedStorageTransferServiceServer) ResumeTransferOperation(context.Context, *ResumeTransferOperationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeTransferOperation not implemented")
}
func (*UnimplementedStorageTransferServiceServer) RunTransferJob(context.Context, *RunTransferJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunTransferJob not implemented")
}
func (*UnimplementedStorageTransferServiceServer) DeleteTransferJob(context.Context, *DeleteTransferJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTransferJob not implemented")
}
func (*UnimplementedStorageTransferServiceServer) CreateAgentPool(context.Context, *CreateAgentPoolRequest) (*AgentPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAgentPool not implemented")
}
func (*UnimplementedStorageTransferServiceServer) UpdateAgentPool(context.Context, *UpdateAgentPoolRequest) (*AgentPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAgentPool not implemented")
}
func (*UnimplementedStorageTransferServiceServer) GetAgentPool(context.Context, *GetAgentPoolRequest) (*AgentPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgentPool not implemented")
}
func (*UnimplementedStorageTransferServiceServer) ListAgentPools(context.Context, *ListAgentPoolsRequest) (*ListAgentPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAgentPools not implemented")
}
func (*UnimplementedStorageTransferServiceServer) DeleteAgentPool(context.Context, *DeleteAgentPoolRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAgentPool not implemented")
}

func RegisterStorageTransferServiceServer(s *grpc.Server, srv StorageTransferServiceServer) {
	s.RegisterService(&_StorageTransferService_serviceDesc, srv)
}

func _StorageTransferService_GetGoogleServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).GetGoogleServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/GetGoogleServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).GetGoogleServiceAccount(ctx, req.(*GetGoogleServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_CreateTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).CreateTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/CreateTransferJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).CreateTransferJob(ctx, req.(*CreateTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_UpdateTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).UpdateTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/UpdateTransferJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).UpdateTransferJob(ctx, req.(*UpdateTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_GetTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).GetTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/GetTransferJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).GetTransferJob(ctx, req.(*GetTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_ListTransferJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).ListTransferJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/ListTransferJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).ListTransferJobs(ctx, req.(*ListTransferJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_PauseTransferOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseTransferOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).PauseTransferOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/PauseTransferOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).PauseTransferOperation(ctx, req.(*PauseTransferOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_ResumeTransferOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeTransferOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).ResumeTransferOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/ResumeTransferOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).ResumeTransferOperation(ctx, req.(*ResumeTransferOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_RunTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).RunTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/RunTransferJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).RunTransferJob(ctx, req.(*RunTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_DeleteTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).DeleteTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/DeleteTransferJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).DeleteTransferJob(ctx, req.(*DeleteTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_CreateAgentPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAgentPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).CreateAgentPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/CreateAgentPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).CreateAgentPool(ctx, req.(*CreateAgentPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_UpdateAgentPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAgentPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).UpdateAgentPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/UpdateAgentPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).UpdateAgentPool(ctx, req.(*UpdateAgentPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_GetAgentPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAgentPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).GetAgentPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/GetAgentPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).GetAgentPool(ctx, req.(*GetAgentPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_ListAgentPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAgentPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).ListAgentPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/ListAgentPools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).ListAgentPools(ctx, req.(*ListAgentPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_DeleteAgentPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).DeleteAgentPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storagetransfer.v1.StorageTransferService/DeleteAgentPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).DeleteAgentPool(ctx, req.(*DeleteAgentPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _StorageTransferService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.storagetransfer.v1.StorageTransferService",
	HandlerType: (*StorageTransferServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGoogleServiceAccount",
			Handler:    _StorageTransferService_GetGoogleServiceAccount_Handler,
		},
		{
			MethodName: "CreateTransferJob",
			Handler:    _StorageTransferService_CreateTransferJob_Handler,
		},
		{
			MethodName: "UpdateTransferJob",
			Handler:    _StorageTransferService_UpdateTransferJob_Handler,
		},
		{
			MethodName: "GetTransferJob",
			Handler:    _StorageTransferService_GetTransferJob_Handler,
		},
		{
			MethodName: "ListTransferJobs",
			Handler:    _StorageTransferService_ListTransferJobs_Handler,
		},
		{
			MethodName: "PauseTransferOperation",
			Handler:    _StorageTransferService_PauseTransferOperation_Handler,
		},
		{
			MethodName: "ResumeTransferOperation",
			Handler:    _StorageTransferService_ResumeTransferOperation_Handler,
		},
		{
			MethodName: "RunTransferJob",
			Handler:    _StorageTransferService_RunTransferJob_Handler,
		},
		{
			MethodName: "DeleteTransferJob",
			Handler:    _StorageTransferService_DeleteTransferJob_Handler,
		},
		{
			MethodName: "CreateAgentPool",
			Handler:    _StorageTransferService_CreateAgentPool_Handler,
		},
		{
			MethodName: "UpdateAgentPool",
			Handler:    _StorageTransferService_UpdateAgentPool_Handler,
		},
		{
			MethodName: "GetAgentPool",
			Handler:    _StorageTransferService_GetAgentPool_Handler,
		},
		{
			MethodName: "ListAgentPools",
			Handler:    _StorageTransferService_ListAgentPools_Handler,
		},
		{
			MethodName: "DeleteAgentPool",
			Handler:    _StorageTransferService_DeleteAgentPool_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/storagetransfer/v1/transfer.proto",
}
