//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armtrafficmanager.ClientFactory type.
type ServerFactory struct {
	EndpointsServer             EndpointsServer
	GeographicHierarchiesServer GeographicHierarchiesServer
	HeatMapServer               HeatMapServer
	ProfilesServer              ProfilesServer
	UserMetricsKeysServer       UserMetricsKeysServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armtrafficmanager.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armtrafficmanager.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                           *ServerFactory
	trMu                          sync.Mutex
	trEndpointsServer             *EndpointsServerTransport
	trGeographicHierarchiesServer *GeographicHierarchiesServerTransport
	trHeatMapServer               *HeatMapServerTransport
	trProfilesServer              *ProfilesServerTransport
	trUserMetricsKeysServer       *UserMetricsKeysServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "EndpointsClient":
		initServer(s, &s.trEndpointsServer, func() *EndpointsServerTransport { return NewEndpointsServerTransport(&s.srv.EndpointsServer) })
		resp, err = s.trEndpointsServer.Do(req)
	case "GeographicHierarchiesClient":
		initServer(s, &s.trGeographicHierarchiesServer, func() *GeographicHierarchiesServerTransport {
			return NewGeographicHierarchiesServerTransport(&s.srv.GeographicHierarchiesServer)
		})
		resp, err = s.trGeographicHierarchiesServer.Do(req)
	case "HeatMapClient":
		initServer(s, &s.trHeatMapServer, func() *HeatMapServerTransport { return NewHeatMapServerTransport(&s.srv.HeatMapServer) })
		resp, err = s.trHeatMapServer.Do(req)
	case "ProfilesClient":
		initServer(s, &s.trProfilesServer, func() *ProfilesServerTransport { return NewProfilesServerTransport(&s.srv.ProfilesServer) })
		resp, err = s.trProfilesServer.Do(req)
	case "UserMetricsKeysClient":
		initServer(s, &s.trUserMetricsKeysServer, func() *UserMetricsKeysServerTransport {
			return NewUserMetricsKeysServerTransport(&s.srv.UserMetricsKeysServer)
		})
		resp, err = s.trUserMetricsKeysServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
