//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/testbase/armtestbase"
	"net/http"
	"net/url"
	"regexp"
)

// CustomerEventsServer is a fake server for instances of the armtestbase.CustomerEventsClient type.
type CustomerEventsServer struct {
	// BeginCreate is the fake for method CustomerEventsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, testBaseAccountName string, customerEventName string, parameters armtestbase.CustomerEventResource, options *armtestbase.CustomerEventsClientBeginCreateOptions) (resp azfake.PollerResponder[armtestbase.CustomerEventsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CustomerEventsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, testBaseAccountName string, customerEventName string, options *armtestbase.CustomerEventsClientBeginDeleteOptions) (resp azfake.PollerResponder[armtestbase.CustomerEventsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CustomerEventsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, testBaseAccountName string, customerEventName string, options *armtestbase.CustomerEventsClientGetOptions) (resp azfake.Responder[armtestbase.CustomerEventsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByTestBaseAccountPager is the fake for method CustomerEventsClient.NewListByTestBaseAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTestBaseAccountPager func(resourceGroupName string, testBaseAccountName string, options *armtestbase.CustomerEventsClientListByTestBaseAccountOptions) (resp azfake.PagerResponder[armtestbase.CustomerEventsClientListByTestBaseAccountResponse])
}

// NewCustomerEventsServerTransport creates a new instance of CustomerEventsServerTransport with the provided implementation.
// The returned CustomerEventsServerTransport instance is connected to an instance of armtestbase.CustomerEventsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCustomerEventsServerTransport(srv *CustomerEventsServer) *CustomerEventsServerTransport {
	return &CustomerEventsServerTransport{
		srv:                           srv,
		beginCreate:                   newTracker[azfake.PollerResponder[armtestbase.CustomerEventsClientCreateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armtestbase.CustomerEventsClientDeleteResponse]](),
		newListByTestBaseAccountPager: newTracker[azfake.PagerResponder[armtestbase.CustomerEventsClientListByTestBaseAccountResponse]](),
	}
}

// CustomerEventsServerTransport connects instances of armtestbase.CustomerEventsClient to instances of CustomerEventsServer.
// Don't use this type directly, use NewCustomerEventsServerTransport instead.
type CustomerEventsServerTransport struct {
	srv                           *CustomerEventsServer
	beginCreate                   *tracker[azfake.PollerResponder[armtestbase.CustomerEventsClientCreateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armtestbase.CustomerEventsClientDeleteResponse]]
	newListByTestBaseAccountPager *tracker[azfake.PagerResponder[armtestbase.CustomerEventsClientListByTestBaseAccountResponse]]
}

// Do implements the policy.Transporter interface for CustomerEventsServerTransport.
func (c *CustomerEventsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CustomerEventsClient.BeginCreate":
		resp, err = c.dispatchBeginCreate(req)
	case "CustomerEventsClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CustomerEventsClient.Get":
		resp, err = c.dispatchGet(req)
	case "CustomerEventsClient.NewListByTestBaseAccountPager":
		resp, err = c.dispatchNewListByTestBaseAccountPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CustomerEventsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := c.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customerEvents/(?P<customerEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armtestbase.CustomerEventResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		customerEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customerEventName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreate(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, customerEventNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		c.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		c.beginCreate.remove(req)
	}

	return resp, nil
}

func (c *CustomerEventsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customerEvents/(?P<customerEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		customerEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customerEventName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, customerEventNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CustomerEventsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customerEvents/(?P<customerEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
	if err != nil {
		return nil, err
	}
	customerEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customerEventName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, customerEventNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomerEventResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CustomerEventsServerTransport) dispatchNewListByTestBaseAccountPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByTestBaseAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTestBaseAccountPager not implemented")}
	}
	newListByTestBaseAccountPager := c.newListByTestBaseAccountPager.get(req)
	if newListByTestBaseAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customerEvents`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByTestBaseAccountPager(resourceGroupNameParam, testBaseAccountNameParam, nil)
		newListByTestBaseAccountPager = &resp
		c.newListByTestBaseAccountPager.add(req, newListByTestBaseAccountPager)
		server.PagerResponderInjectNextLinks(newListByTestBaseAccountPager, req, func(page *armtestbase.CustomerEventsClientListByTestBaseAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTestBaseAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByTestBaseAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTestBaseAccountPager) {
		c.newListByTestBaseAccountPager.remove(req)
	}
	return resp, nil
}
