//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armscvmm.ClientFactory type.
type ServerFactory struct {
	AvailabilitySetsServer        AvailabilitySetsServer
	CloudsServer                  CloudsServer
	InventoryItemsServer          InventoryItemsServer
	OperationsServer              OperationsServer
	VirtualMachineTemplatesServer VirtualMachineTemplatesServer
	VirtualMachinesServer         VirtualMachinesServer
	VirtualNetworksServer         VirtualNetworksServer
	VmmServersServer              VmmServersServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armscvmm.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armscvmm.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                             *ServerFactory
	trMu                            sync.Mutex
	trAvailabilitySetsServer        *AvailabilitySetsServerTransport
	trCloudsServer                  *CloudsServerTransport
	trInventoryItemsServer          *InventoryItemsServerTransport
	trOperationsServer              *OperationsServerTransport
	trVirtualMachineTemplatesServer *VirtualMachineTemplatesServerTransport
	trVirtualMachinesServer         *VirtualMachinesServerTransport
	trVirtualNetworksServer         *VirtualNetworksServerTransport
	trVmmServersServer              *VmmServersServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AvailabilitySetsClient":
		initServer(s, &s.trAvailabilitySetsServer, func() *AvailabilitySetsServerTransport {
			return NewAvailabilitySetsServerTransport(&s.srv.AvailabilitySetsServer)
		})
		resp, err = s.trAvailabilitySetsServer.Do(req)
	case "CloudsClient":
		initServer(s, &s.trCloudsServer, func() *CloudsServerTransport { return NewCloudsServerTransport(&s.srv.CloudsServer) })
		resp, err = s.trCloudsServer.Do(req)
	case "InventoryItemsClient":
		initServer(s, &s.trInventoryItemsServer, func() *InventoryItemsServerTransport {
			return NewInventoryItemsServerTransport(&s.srv.InventoryItemsServer)
		})
		resp, err = s.trInventoryItemsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "VirtualMachineTemplatesClient":
		initServer(s, &s.trVirtualMachineTemplatesServer, func() *VirtualMachineTemplatesServerTransport {
			return NewVirtualMachineTemplatesServerTransport(&s.srv.VirtualMachineTemplatesServer)
		})
		resp, err = s.trVirtualMachineTemplatesServer.Do(req)
	case "VirtualMachinesClient":
		initServer(s, &s.trVirtualMachinesServer, func() *VirtualMachinesServerTransport {
			return NewVirtualMachinesServerTransport(&s.srv.VirtualMachinesServer)
		})
		resp, err = s.trVirtualMachinesServer.Do(req)
	case "VirtualNetworksClient":
		initServer(s, &s.trVirtualNetworksServer, func() *VirtualNetworksServerTransport {
			return NewVirtualNetworksServerTransport(&s.srv.VirtualNetworksServer)
		})
		resp, err = s.trVirtualNetworksServer.Do(req)
	case "VmmServersClient":
		initServer(s, &s.trVmmServersServer, func() *VmmServersServerTransport { return NewVmmServersServerTransport(&s.srv.VmmServersServer) })
		resp, err = s.trVmmServersServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
