//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentstacks

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// Client contains the methods for the DeploymentStacks group.
// Don't use this type directly, use NewClient() instead.
type Client struct {
	internal       *arm.Client
	subscriptionID string
}

// NewClient creates a new instance of Client with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*Client, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &Client{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdateAtManagementGroup - Creates or updates a Deployment Stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - Management Group.
//   - deploymentStackName - Name of the deployment stack.
//   - deploymentStack - Deployment Stack supplied to the operation.
//   - options - ClientBeginCreateOrUpdateAtManagementGroupOptions contains the optional parameters for the Client.BeginCreateOrUpdateAtManagementGroup
//     method.
func (client *Client) BeginCreateOrUpdateAtManagementGroup(ctx context.Context, managementGroupID string, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtManagementGroupOptions) (*runtime.Poller[ClientCreateOrUpdateAtManagementGroupResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateAtManagementGroup(ctx, managementGroupID, deploymentStackName, deploymentStack, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientCreateOrUpdateAtManagementGroupResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientCreateOrUpdateAtManagementGroupResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateAtManagementGroup - Creates or updates a Deployment Stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
func (client *Client) createOrUpdateAtManagementGroup(ctx context.Context, managementGroupID string, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtManagementGroupOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginCreateOrUpdateAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtManagementGroupCreateRequest(ctx, managementGroupID, deploymentStackName, deploymentStack, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateAtManagementGroupCreateRequest creates the CreateOrUpdateAtManagementGroup request.
func (client *Client) createOrUpdateAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, deploymentStack); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateOrUpdateAtResourceGroup - Creates or updates a Deployment Stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - deploymentStackName - Name of the deployment stack.
//   - deploymentStack - Deployment Stack supplied to the operation.
//   - options - ClientBeginCreateOrUpdateAtResourceGroupOptions contains the optional parameters for the Client.BeginCreateOrUpdateAtResourceGroup
//     method.
func (client *Client) BeginCreateOrUpdateAtResourceGroup(ctx context.Context, resourceGroupName string, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtResourceGroupOptions) (*runtime.Poller[ClientCreateOrUpdateAtResourceGroupResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateAtResourceGroup(ctx, resourceGroupName, deploymentStackName, deploymentStack, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientCreateOrUpdateAtResourceGroupResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientCreateOrUpdateAtResourceGroupResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateAtResourceGroup - Creates or updates a Deployment Stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
func (client *Client) createOrUpdateAtResourceGroup(ctx context.Context, resourceGroupName string, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtResourceGroupOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginCreateOrUpdateAtResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtResourceGroupCreateRequest(ctx, resourceGroupName, deploymentStackName, deploymentStack, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateAtResourceGroupCreateRequest creates the CreateOrUpdateAtResourceGroup request.
func (client *Client) createOrUpdateAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, deploymentStack); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateOrUpdateAtSubscription - Creates or updates a Deployment Stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - deploymentStackName - Name of the deployment stack.
//   - deploymentStack - Deployment Stack supplied to the operation.
//   - options - ClientBeginCreateOrUpdateAtSubscriptionOptions contains the optional parameters for the Client.BeginCreateOrUpdateAtSubscription
//     method.
func (client *Client) BeginCreateOrUpdateAtSubscription(ctx context.Context, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtSubscriptionOptions) (*runtime.Poller[ClientCreateOrUpdateAtSubscriptionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateAtSubscription(ctx, deploymentStackName, deploymentStack, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientCreateOrUpdateAtSubscriptionResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientCreateOrUpdateAtSubscriptionResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateAtSubscription - Creates or updates a Deployment Stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
func (client *Client) createOrUpdateAtSubscription(ctx context.Context, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtSubscriptionOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginCreateOrUpdateAtSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtSubscriptionCreateRequest(ctx, deploymentStackName, deploymentStack, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateAtSubscriptionCreateRequest creates the CreateOrUpdateAtSubscription request.
func (client *Client) createOrUpdateAtSubscriptionCreateRequest(ctx context.Context, deploymentStackName string, deploymentStack DeploymentStack, options *ClientBeginCreateOrUpdateAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, deploymentStack); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDeleteAtManagementGroup - Deletes a Deployment Stack by name. When operation completes, status code 200 returned without
// content.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - Management Group.
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientBeginDeleteAtManagementGroupOptions contains the optional parameters for the Client.BeginDeleteAtManagementGroup
//     method.
func (client *Client) BeginDeleteAtManagementGroup(ctx context.Context, managementGroupID string, deploymentStackName string, options *ClientBeginDeleteAtManagementGroupOptions) (*runtime.Poller[ClientDeleteAtManagementGroupResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteAtManagementGroup(ctx, managementGroupID, deploymentStackName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientDeleteAtManagementGroupResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientDeleteAtManagementGroupResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteAtManagementGroup - Deletes a Deployment Stack by name. When operation completes, status code 200 returned without
// content.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
func (client *Client) deleteAtManagementGroup(ctx context.Context, managementGroupID string, deploymentStackName string, options *ClientBeginDeleteAtManagementGroupOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginDeleteAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtManagementGroupCreateRequest(ctx, managementGroupID, deploymentStackName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteAtManagementGroupCreateRequest creates the DeleteAtManagementGroup request.
func (client *Client) deleteAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, deploymentStackName string, options *ClientBeginDeleteAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.UnmanageActionResources != nil {
		reqQP.Set("unmanageAction.Resources", string(*options.UnmanageActionResources))
	}
	if options != nil && options.UnmanageActionResourceGroups != nil {
		reqQP.Set("unmanageAction.ResourceGroups", string(*options.UnmanageActionResourceGroups))
	}
	if options != nil && options.UnmanageActionManagementGroups != nil {
		reqQP.Set("unmanageAction.ManagementGroups", string(*options.UnmanageActionManagementGroups))
	}
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteAtResourceGroup - Deletes a Deployment Stack by name. When operation completes, status code 200 returned without
// content.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientBeginDeleteAtResourceGroupOptions contains the optional parameters for the Client.BeginDeleteAtResourceGroup
//     method.
func (client *Client) BeginDeleteAtResourceGroup(ctx context.Context, resourceGroupName string, deploymentStackName string, options *ClientBeginDeleteAtResourceGroupOptions) (*runtime.Poller[ClientDeleteAtResourceGroupResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteAtResourceGroup(ctx, resourceGroupName, deploymentStackName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientDeleteAtResourceGroupResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientDeleteAtResourceGroupResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteAtResourceGroup - Deletes a Deployment Stack by name. When operation completes, status code 200 returned without
// content.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
func (client *Client) deleteAtResourceGroup(ctx context.Context, resourceGroupName string, deploymentStackName string, options *ClientBeginDeleteAtResourceGroupOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginDeleteAtResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtResourceGroupCreateRequest(ctx, resourceGroupName, deploymentStackName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteAtResourceGroupCreateRequest creates the DeleteAtResourceGroup request.
func (client *Client) deleteAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, deploymentStackName string, options *ClientBeginDeleteAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.UnmanageActionResources != nil {
		reqQP.Set("unmanageAction.Resources", string(*options.UnmanageActionResources))
	}
	if options != nil && options.UnmanageActionResourceGroups != nil {
		reqQP.Set("unmanageAction.ResourceGroups", string(*options.UnmanageActionResourceGroups))
	}
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteAtSubscription - Deletes a Deployment Stack by name. When operation completes, status code 200 returned without
// content.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientBeginDeleteAtSubscriptionOptions contains the optional parameters for the Client.BeginDeleteAtSubscription
//     method.
func (client *Client) BeginDeleteAtSubscription(ctx context.Context, deploymentStackName string, options *ClientBeginDeleteAtSubscriptionOptions) (*runtime.Poller[ClientDeleteAtSubscriptionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteAtSubscription(ctx, deploymentStackName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ClientDeleteAtSubscriptionResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ClientDeleteAtSubscriptionResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteAtSubscription - Deletes a Deployment Stack by name. When operation completes, status code 200 returned without content.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
func (client *Client) deleteAtSubscription(ctx context.Context, deploymentStackName string, options *ClientBeginDeleteAtSubscriptionOptions) (*http.Response, error) {
	var err error
	const operationName = "Client.BeginDeleteAtSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtSubscriptionCreateRequest(ctx, deploymentStackName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteAtSubscriptionCreateRequest creates the DeleteAtSubscription request.
func (client *Client) deleteAtSubscriptionCreateRequest(ctx context.Context, deploymentStackName string, options *ClientBeginDeleteAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.UnmanageActionResources != nil {
		reqQP.Set("unmanageAction.Resources", string(*options.UnmanageActionResources))
	}
	if options != nil && options.UnmanageActionResourceGroups != nil {
		reqQP.Set("unmanageAction.ResourceGroups", string(*options.UnmanageActionResourceGroups))
	}
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// ExportTemplateAtManagementGroup - Exports the template used to create the deployment stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - Management Group.
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientExportTemplateAtManagementGroupOptions contains the optional parameters for the Client.ExportTemplateAtManagementGroup
//     method.
func (client *Client) ExportTemplateAtManagementGroup(ctx context.Context, managementGroupID string, deploymentStackName string, options *ClientExportTemplateAtManagementGroupOptions) (ClientExportTemplateAtManagementGroupResponse, error) {
	var err error
	const operationName = "Client.ExportTemplateAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.exportTemplateAtManagementGroupCreateRequest(ctx, managementGroupID, deploymentStackName, options)
	if err != nil {
		return ClientExportTemplateAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientExportTemplateAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientExportTemplateAtManagementGroupResponse{}, err
	}
	resp, err := client.exportTemplateAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// exportTemplateAtManagementGroupCreateRequest creates the ExportTemplateAtManagementGroup request.
func (client *Client) exportTemplateAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, deploymentStackName string, options *ClientExportTemplateAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// exportTemplateAtManagementGroupHandleResponse handles the ExportTemplateAtManagementGroup response.
func (client *Client) exportTemplateAtManagementGroupHandleResponse(resp *http.Response) (ClientExportTemplateAtManagementGroupResponse, error) {
	result := ClientExportTemplateAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStackTemplateDefinition); err != nil {
		return ClientExportTemplateAtManagementGroupResponse{}, err
	}
	return result, nil
}

// ExportTemplateAtResourceGroup - Exports the template used to create the deployment stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientExportTemplateAtResourceGroupOptions contains the optional parameters for the Client.ExportTemplateAtResourceGroup
//     method.
func (client *Client) ExportTemplateAtResourceGroup(ctx context.Context, resourceGroupName string, deploymentStackName string, options *ClientExportTemplateAtResourceGroupOptions) (ClientExportTemplateAtResourceGroupResponse, error) {
	var err error
	const operationName = "Client.ExportTemplateAtResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.exportTemplateAtResourceGroupCreateRequest(ctx, resourceGroupName, deploymentStackName, options)
	if err != nil {
		return ClientExportTemplateAtResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientExportTemplateAtResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientExportTemplateAtResourceGroupResponse{}, err
	}
	resp, err := client.exportTemplateAtResourceGroupHandleResponse(httpResp)
	return resp, err
}

// exportTemplateAtResourceGroupCreateRequest creates the ExportTemplateAtResourceGroup request.
func (client *Client) exportTemplateAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, deploymentStackName string, options *ClientExportTemplateAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// exportTemplateAtResourceGroupHandleResponse handles the ExportTemplateAtResourceGroup response.
func (client *Client) exportTemplateAtResourceGroupHandleResponse(resp *http.Response) (ClientExportTemplateAtResourceGroupResponse, error) {
	result := ClientExportTemplateAtResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStackTemplateDefinition); err != nil {
		return ClientExportTemplateAtResourceGroupResponse{}, err
	}
	return result, nil
}

// ExportTemplateAtSubscription - Exports the template used to create the deployment stack.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientExportTemplateAtSubscriptionOptions contains the optional parameters for the Client.ExportTemplateAtSubscription
//     method.
func (client *Client) ExportTemplateAtSubscription(ctx context.Context, deploymentStackName string, options *ClientExportTemplateAtSubscriptionOptions) (ClientExportTemplateAtSubscriptionResponse, error) {
	var err error
	const operationName = "Client.ExportTemplateAtSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.exportTemplateAtSubscriptionCreateRequest(ctx, deploymentStackName, options)
	if err != nil {
		return ClientExportTemplateAtSubscriptionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientExportTemplateAtSubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientExportTemplateAtSubscriptionResponse{}, err
	}
	resp, err := client.exportTemplateAtSubscriptionHandleResponse(httpResp)
	return resp, err
}

// exportTemplateAtSubscriptionCreateRequest creates the ExportTemplateAtSubscription request.
func (client *Client) exportTemplateAtSubscriptionCreateRequest(ctx context.Context, deploymentStackName string, options *ClientExportTemplateAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// exportTemplateAtSubscriptionHandleResponse handles the ExportTemplateAtSubscription response.
func (client *Client) exportTemplateAtSubscriptionHandleResponse(resp *http.Response) (ClientExportTemplateAtSubscriptionResponse, error) {
	result := ClientExportTemplateAtSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStackTemplateDefinition); err != nil {
		return ClientExportTemplateAtSubscriptionResponse{}, err
	}
	return result, nil
}

// GetAtManagementGroup - Gets a Deployment Stack with a given name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - Management Group.
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientGetAtManagementGroupOptions contains the optional parameters for the Client.GetAtManagementGroup method.
func (client *Client) GetAtManagementGroup(ctx context.Context, managementGroupID string, deploymentStackName string, options *ClientGetAtManagementGroupOptions) (ClientGetAtManagementGroupResponse, error) {
	var err error
	const operationName = "Client.GetAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtManagementGroupCreateRequest(ctx, managementGroupID, deploymentStackName, options)
	if err != nil {
		return ClientGetAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientGetAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientGetAtManagementGroupResponse{}, err
	}
	resp, err := client.getAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// getAtManagementGroupCreateRequest creates the GetAtManagementGroup request.
func (client *Client) getAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, deploymentStackName string, options *ClientGetAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtManagementGroupHandleResponse handles the GetAtManagementGroup response.
func (client *Client) getAtManagementGroupHandleResponse(resp *http.Response) (ClientGetAtManagementGroupResponse, error) {
	result := ClientGetAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStack); err != nil {
		return ClientGetAtManagementGroupResponse{}, err
	}
	return result, nil
}

// GetAtResourceGroup - Gets a Deployment Stack with a given name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientGetAtResourceGroupOptions contains the optional parameters for the Client.GetAtResourceGroup method.
func (client *Client) GetAtResourceGroup(ctx context.Context, resourceGroupName string, deploymentStackName string, options *ClientGetAtResourceGroupOptions) (ClientGetAtResourceGroupResponse, error) {
	var err error
	const operationName = "Client.GetAtResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtResourceGroupCreateRequest(ctx, resourceGroupName, deploymentStackName, options)
	if err != nil {
		return ClientGetAtResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientGetAtResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientGetAtResourceGroupResponse{}, err
	}
	resp, err := client.getAtResourceGroupHandleResponse(httpResp)
	return resp, err
}

// getAtResourceGroupCreateRequest creates the GetAtResourceGroup request.
func (client *Client) getAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, deploymentStackName string, options *ClientGetAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtResourceGroupHandleResponse handles the GetAtResourceGroup response.
func (client *Client) getAtResourceGroupHandleResponse(resp *http.Response) (ClientGetAtResourceGroupResponse, error) {
	result := ClientGetAtResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStack); err != nil {
		return ClientGetAtResourceGroupResponse{}, err
	}
	return result, nil
}

// GetAtSubscription - Gets a Deployment Stack with a given name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - deploymentStackName - Name of the deployment stack.
//   - options - ClientGetAtSubscriptionOptions contains the optional parameters for the Client.GetAtSubscription method.
func (client *Client) GetAtSubscription(ctx context.Context, deploymentStackName string, options *ClientGetAtSubscriptionOptions) (ClientGetAtSubscriptionResponse, error) {
	var err error
	const operationName = "Client.GetAtSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtSubscriptionCreateRequest(ctx, deploymentStackName, options)
	if err != nil {
		return ClientGetAtSubscriptionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ClientGetAtSubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ClientGetAtSubscriptionResponse{}, err
	}
	resp, err := client.getAtSubscriptionHandleResponse(httpResp)
	return resp, err
}

// getAtSubscriptionCreateRequest creates the GetAtSubscription request.
func (client *Client) getAtSubscriptionCreateRequest(ctx context.Context, deploymentStackName string, options *ClientGetAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if deploymentStackName == "" {
		return nil, errors.New("parameter deploymentStackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deploymentStackName}", url.PathEscape(deploymentStackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtSubscriptionHandleResponse handles the GetAtSubscription response.
func (client *Client) getAtSubscriptionHandleResponse(resp *http.Response) (ClientGetAtSubscriptionResponse, error) {
	result := ClientGetAtSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStack); err != nil {
		return ClientGetAtSubscriptionResponse{}, err
	}
	return result, nil
}

// NewListAtManagementGroupPager - Lists all the Deployment Stacks within the specified management group.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - Management Group.
//   - options - ClientListAtManagementGroupOptions contains the optional parameters for the Client.NewListAtManagementGroupPager
//     method.
func (client *Client) NewListAtManagementGroupPager(managementGroupID string, options *ClientListAtManagementGroupOptions) *runtime.Pager[ClientListAtManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ClientListAtManagementGroupResponse]{
		More: func(page ClientListAtManagementGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ClientListAtManagementGroupResponse) (ClientListAtManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "Client.NewListAtManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAtManagementGroupCreateRequest(ctx, managementGroupID, options)
			}, nil)
			if err != nil {
				return ClientListAtManagementGroupResponse{}, err
			}
			return client.listAtManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAtManagementGroupCreateRequest creates the ListAtManagementGroup request.
func (client *Client) listAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, options *ClientListAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtManagementGroupHandleResponse handles the ListAtManagementGroup response.
func (client *Client) listAtManagementGroupHandleResponse(resp *http.Response) (ClientListAtManagementGroupResponse, error) {
	result := ClientListAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStackListResult); err != nil {
		return ClientListAtManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListAtResourceGroupPager - Lists all the Deployment Stacks within the specified resource group.
//
// Generated from API version 2022-08-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ClientListAtResourceGroupOptions contains the optional parameters for the Client.NewListAtResourceGroupPager
//     method.
func (client *Client) NewListAtResourceGroupPager(resourceGroupName string, options *ClientListAtResourceGroupOptions) *runtime.Pager[ClientListAtResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ClientListAtResourceGroupResponse]{
		More: func(page ClientListAtResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ClientListAtResourceGroupResponse) (ClientListAtResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "Client.NewListAtResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAtResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return ClientListAtResourceGroupResponse{}, err
			}
			return client.listAtResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAtResourceGroupCreateRequest creates the ListAtResourceGroup request.
func (client *Client) listAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ClientListAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtResourceGroupHandleResponse handles the ListAtResourceGroup response.
func (client *Client) listAtResourceGroupHandleResponse(resp *http.Response) (ClientListAtResourceGroupResponse, error) {
	result := ClientListAtResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStackListResult); err != nil {
		return ClientListAtResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListAtSubscriptionPager - Lists all the Deployment Stacks within the specified subscription.
//
// Generated from API version 2022-08-01-preview
//   - options - ClientListAtSubscriptionOptions contains the optional parameters for the Client.NewListAtSubscriptionPager method.
func (client *Client) NewListAtSubscriptionPager(options *ClientListAtSubscriptionOptions) *runtime.Pager[ClientListAtSubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ClientListAtSubscriptionResponse]{
		More: func(page ClientListAtSubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ClientListAtSubscriptionResponse) (ClientListAtSubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "Client.NewListAtSubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAtSubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ClientListAtSubscriptionResponse{}, err
			}
			return client.listAtSubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAtSubscriptionCreateRequest creates the ListAtSubscription request.
func (client *Client) listAtSubscriptionCreateRequest(ctx context.Context, options *ClientListAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtSubscriptionHandleResponse handles the ListAtSubscription response.
func (client *Client) listAtSubscriptionHandleResponse(resp *http.Response) (ClientListAtSubscriptionResponse, error) {
	result := ClientListAtSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentStackListResult); err != nil {
		return ClientListAtSubscriptionResponse{}, err
	}
	return result, nil
}
