//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetwork

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AADAuthenticationParameters.
func (a AADAuthenticationParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadAudience", a.AADAudience)
	populate(objectMap, "aadIssuer", a.AADIssuer)
	populate(objectMap, "aadTenant", a.AADTenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADAuthenticationParameters.
func (a *AADAuthenticationParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadAudience":
			err = unpopulate(val, "AADAudience", &a.AADAudience)
			delete(rawMsg, key)
		case "aadIssuer":
			err = unpopulate(val, "AADIssuer", &a.AADIssuer)
			delete(rawMsg, key)
		case "aadTenant":
			err = unpopulate(val, "AADTenant", &a.AADTenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Action.
func (a Action) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Action.
func (a *Action) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveBaseSecurityAdminRule.
func (a ActiveBaseSecurityAdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "commitTime", a.CommitTime)
	populate(objectMap, "configurationDescription", a.ConfigurationDescription)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = a.Kind
	populate(objectMap, "region", a.Region)
	populate(objectMap, "ruleCollectionAppliesToGroups", a.RuleCollectionAppliesToGroups)
	populate(objectMap, "ruleCollectionDescription", a.RuleCollectionDescription)
	populate(objectMap, "ruleGroups", a.RuleGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveBaseSecurityAdminRule.
func (a *ActiveBaseSecurityAdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitTime":
			err = unpopulateDateTimeRFC3339(val, "CommitTime", &a.CommitTime)
			delete(rawMsg, key)
		case "configurationDescription":
			err = unpopulate(val, "ConfigurationDescription", &a.ConfigurationDescription)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &a.Region)
			delete(rawMsg, key)
		case "ruleCollectionAppliesToGroups":
			err = unpopulate(val, "RuleCollectionAppliesToGroups", &a.RuleCollectionAppliesToGroups)
			delete(rawMsg, key)
		case "ruleCollectionDescription":
			err = unpopulate(val, "RuleCollectionDescription", &a.RuleCollectionDescription)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &a.RuleGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveConfigurationParameter.
func (a ActiveConfigurationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", a.Regions)
	populate(objectMap, "skipToken", a.SkipToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveConfigurationParameter.
func (a *ActiveConfigurationParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &a.Regions)
			delete(rawMsg, key)
		case "skipToken":
			err = unpopulate(val, "SkipToken", &a.SkipToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveConnectivityConfiguration.
func (a ActiveConnectivityConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "commitTime", a.CommitTime)
	populate(objectMap, "configurationGroups", a.ConfigurationGroups)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "region", a.Region)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveConnectivityConfiguration.
func (a *ActiveConnectivityConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitTime":
			err = unpopulateDateTimeRFC3339(val, "CommitTime", &a.CommitTime)
			delete(rawMsg, key)
		case "configurationGroups":
			err = unpopulate(val, "ConfigurationGroups", &a.ConfigurationGroups)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &a.Region)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveConnectivityConfigurationsListResult.
func (a ActiveConnectivityConfigurationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipToken", a.SkipToken)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveConnectivityConfigurationsListResult.
func (a *ActiveConnectivityConfigurationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipToken":
			err = unpopulate(val, "SkipToken", &a.SkipToken)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveDefaultSecurityAdminRule.
func (a ActiveDefaultSecurityAdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "commitTime", a.CommitTime)
	populate(objectMap, "configurationDescription", a.ConfigurationDescription)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = EffectiveAdminRuleKindDefault
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "region", a.Region)
	populate(objectMap, "ruleCollectionAppliesToGroups", a.RuleCollectionAppliesToGroups)
	populate(objectMap, "ruleCollectionDescription", a.RuleCollectionDescription)
	populate(objectMap, "ruleGroups", a.RuleGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveDefaultSecurityAdminRule.
func (a *ActiveDefaultSecurityAdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitTime":
			err = unpopulateDateTimeRFC3339(val, "CommitTime", &a.CommitTime)
			delete(rawMsg, key)
		case "configurationDescription":
			err = unpopulate(val, "ConfigurationDescription", &a.ConfigurationDescription)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &a.Region)
			delete(rawMsg, key)
		case "ruleCollectionAppliesToGroups":
			err = unpopulate(val, "RuleCollectionAppliesToGroups", &a.RuleCollectionAppliesToGroups)
			delete(rawMsg, key)
		case "ruleCollectionDescription":
			err = unpopulate(val, "RuleCollectionDescription", &a.RuleCollectionDescription)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &a.RuleGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveSecurityAdminRule.
func (a ActiveSecurityAdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "commitTime", a.CommitTime)
	populate(objectMap, "configurationDescription", a.ConfigurationDescription)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = EffectiveAdminRuleKindCustom
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "region", a.Region)
	populate(objectMap, "ruleCollectionAppliesToGroups", a.RuleCollectionAppliesToGroups)
	populate(objectMap, "ruleCollectionDescription", a.RuleCollectionDescription)
	populate(objectMap, "ruleGroups", a.RuleGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveSecurityAdminRule.
func (a *ActiveSecurityAdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitTime":
			err = unpopulateDateTimeRFC3339(val, "CommitTime", &a.CommitTime)
			delete(rawMsg, key)
		case "configurationDescription":
			err = unpopulate(val, "ConfigurationDescription", &a.ConfigurationDescription)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &a.Region)
			delete(rawMsg, key)
		case "ruleCollectionAppliesToGroups":
			err = unpopulate(val, "RuleCollectionAppliesToGroups", &a.RuleCollectionAppliesToGroups)
			delete(rawMsg, key)
		case "ruleCollectionDescription":
			err = unpopulate(val, "RuleCollectionDescription", &a.RuleCollectionDescription)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &a.RuleGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveSecurityAdminRulesListResult.
func (a ActiveSecurityAdminRulesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipToken", a.SkipToken)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveSecurityAdminRulesListResult.
func (a *ActiveSecurityAdminRulesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipToken":
			err = unpopulate(val, "SkipToken", &a.SkipToken)
			delete(rawMsg, key)
		case "value":
			a.Value, err = unmarshalActiveBaseSecurityAdminRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressPrefixItem.
func (a AddressPrefixItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", a.AddressPrefix)
	populate(objectMap, "addressPrefixType", a.AddressPrefixType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressPrefixItem.
func (a *AddressPrefixItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &a.AddressPrefix)
			delete(rawMsg, key)
		case "addressPrefixType":
			err = unpopulate(val, "AddressPrefixType", &a.AddressPrefixType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressSpace.
func (a AddressSpace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefixes", a.AddressPrefixes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressSpace.
func (a *AddressSpace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefixes":
			err = unpopulate(val, "AddressPrefixes", &a.AddressPrefixes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminPropertiesFormat.
func (a AdminPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", a.Access)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "destinationPortRanges", a.DestinationPortRanges)
	populate(objectMap, "destinations", a.Destinations)
	populate(objectMap, "direction", a.Direction)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceGuid", a.ResourceGUID)
	populate(objectMap, "sourcePortRanges", a.SourcePortRanges)
	populate(objectMap, "sources", a.Sources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminPropertiesFormat.
func (a *AdminPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &a.Access)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "destinationPortRanges":
			err = unpopulate(val, "DestinationPortRanges", &a.DestinationPortRanges)
			delete(rawMsg, key)
		case "destinations":
			err = unpopulate(val, "Destinations", &a.Destinations)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &a.Direction)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &a.ResourceGUID)
			delete(rawMsg, key)
		case "sourcePortRanges":
			err = unpopulate(val, "SourcePortRanges", &a.SourcePortRanges)
			delete(rawMsg, key)
		case "sources":
			err = unpopulate(val, "Sources", &a.Sources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminRule.
func (a AdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = AdminRuleKindCustom
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminRule.
func (a *AdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminRuleCollection.
func (a AdminRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminRuleCollection.
func (a *AdminRuleCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminRuleCollectionListResult.
func (a AdminRuleCollectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminRuleCollectionListResult.
func (a *AdminRuleCollectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminRuleCollectionPropertiesFormat.
func (a AdminRuleCollectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliesToGroups", a.AppliesToGroups)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceGuid", a.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminRuleCollectionPropertiesFormat.
func (a *AdminRuleCollectionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliesToGroups":
			err = unpopulate(val, "AppliesToGroups", &a.AppliesToGroups)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &a.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminRuleListResult.
func (a AdminRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminRuleListResult.
func (a *AdminRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			a.Value, err = unmarshalBaseAdminRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGateway.
func (a ApplicationGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "zones", a.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGateway.
func (a *ApplicationGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &a.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayAuthenticationCertificate.
func (a ApplicationGatewayAuthenticationCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayAuthenticationCertificate.
func (a *ApplicationGatewayAuthenticationCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayAuthenticationCertificatePropertiesFormat.
func (a ApplicationGatewayAuthenticationCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", a.Data)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayAuthenticationCertificatePropertiesFormat.
func (a *ApplicationGatewayAuthenticationCertificatePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &a.Data)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayAutoscaleConfiguration.
func (a ApplicationGatewayAutoscaleConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxCapacity", a.MaxCapacity)
	populate(objectMap, "minCapacity", a.MinCapacity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayAutoscaleConfiguration.
func (a *ApplicationGatewayAutoscaleConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxCapacity":
			err = unpopulate(val, "MaxCapacity", &a.MaxCapacity)
			delete(rawMsg, key)
		case "minCapacity":
			err = unpopulate(val, "MinCapacity", &a.MinCapacity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayAvailableSSLOptions.
func (a ApplicationGatewayAvailableSSLOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayAvailableSSLOptions.
func (a *ApplicationGatewayAvailableSSLOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayAvailableSSLOptionsPropertiesFormat.
func (a ApplicationGatewayAvailableSSLOptionsPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableCipherSuites", a.AvailableCipherSuites)
	populate(objectMap, "availableProtocols", a.AvailableProtocols)
	populate(objectMap, "defaultPolicy", a.DefaultPolicy)
	populate(objectMap, "predefinedPolicies", a.PredefinedPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayAvailableSSLOptionsPropertiesFormat.
func (a *ApplicationGatewayAvailableSSLOptionsPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableCipherSuites":
			err = unpopulate(val, "AvailableCipherSuites", &a.AvailableCipherSuites)
			delete(rawMsg, key)
		case "availableProtocols":
			err = unpopulate(val, "AvailableProtocols", &a.AvailableProtocols)
			delete(rawMsg, key)
		case "defaultPolicy":
			err = unpopulate(val, "DefaultPolicy", &a.DefaultPolicy)
			delete(rawMsg, key)
		case "predefinedPolicies":
			err = unpopulate(val, "PredefinedPolicies", &a.PredefinedPolicies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayAvailableSSLPredefinedPolicies.
func (a ApplicationGatewayAvailableSSLPredefinedPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayAvailableSSLPredefinedPolicies.
func (a *ApplicationGatewayAvailableSSLPredefinedPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayAvailableWafRuleSetsResult.
func (a ApplicationGatewayAvailableWafRuleSetsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayAvailableWafRuleSetsResult.
func (a *ApplicationGatewayAvailableWafRuleSetsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendAddress.
func (a ApplicationGatewayBackendAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdn", a.Fqdn)
	populate(objectMap, "ipAddress", a.IPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendAddress.
func (a *ApplicationGatewayBackendAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdn":
			err = unpopulate(val, "Fqdn", &a.Fqdn)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &a.IPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendAddressPool.
func (a ApplicationGatewayBackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendAddressPool.
func (a *ApplicationGatewayBackendAddressPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendAddressPoolPropertiesFormat.
func (a ApplicationGatewayBackendAddressPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddresses", a.BackendAddresses)
	populate(objectMap, "backendIPConfigurations", a.BackendIPConfigurations)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendAddressPoolPropertiesFormat.
func (a *ApplicationGatewayBackendAddressPoolPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddresses":
			err = unpopulate(val, "BackendAddresses", &a.BackendAddresses)
			delete(rawMsg, key)
		case "backendIPConfigurations":
			err = unpopulate(val, "BackendIPConfigurations", &a.BackendIPConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendHTTPSettings.
func (a ApplicationGatewayBackendHTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendHTTPSettings.
func (a *ApplicationGatewayBackendHTTPSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendHTTPSettingsPropertiesFormat.
func (a ApplicationGatewayBackendHTTPSettingsPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affinityCookieName", a.AffinityCookieName)
	populate(objectMap, "authenticationCertificates", a.AuthenticationCertificates)
	populate(objectMap, "connectionDraining", a.ConnectionDraining)
	populate(objectMap, "cookieBasedAffinity", a.CookieBasedAffinity)
	populate(objectMap, "hostName", a.HostName)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "pickHostNameFromBackendAddress", a.PickHostNameFromBackendAddress)
	populate(objectMap, "port", a.Port)
	populate(objectMap, "probe", a.Probe)
	populate(objectMap, "probeEnabled", a.ProbeEnabled)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "requestTimeout", a.RequestTimeout)
	populate(objectMap, "trustedRootCertificates", a.TrustedRootCertificates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendHTTPSettingsPropertiesFormat.
func (a *ApplicationGatewayBackendHTTPSettingsPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affinityCookieName":
			err = unpopulate(val, "AffinityCookieName", &a.AffinityCookieName)
			delete(rawMsg, key)
		case "authenticationCertificates":
			err = unpopulate(val, "AuthenticationCertificates", &a.AuthenticationCertificates)
			delete(rawMsg, key)
		case "connectionDraining":
			err = unpopulate(val, "ConnectionDraining", &a.ConnectionDraining)
			delete(rawMsg, key)
		case "cookieBasedAffinity":
			err = unpopulate(val, "CookieBasedAffinity", &a.CookieBasedAffinity)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &a.HostName)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &a.Path)
			delete(rawMsg, key)
		case "pickHostNameFromBackendAddress":
			err = unpopulate(val, "PickHostNameFromBackendAddress", &a.PickHostNameFromBackendAddress)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "probe":
			err = unpopulate(val, "Probe", &a.Probe)
			delete(rawMsg, key)
		case "probeEnabled":
			err = unpopulate(val, "ProbeEnabled", &a.ProbeEnabled)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "requestTimeout":
			err = unpopulate(val, "RequestTimeout", &a.RequestTimeout)
			delete(rawMsg, key)
		case "trustedRootCertificates":
			err = unpopulate(val, "TrustedRootCertificates", &a.TrustedRootCertificates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendHealth.
func (a ApplicationGatewayBackendHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPools", a.BackendAddressPools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendHealth.
func (a *ApplicationGatewayBackendHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPools":
			err = unpopulate(val, "BackendAddressPools", &a.BackendAddressPools)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendHealthHTTPSettings.
func (a ApplicationGatewayBackendHealthHTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendHttpSettings", a.BackendHTTPSettings)
	populate(objectMap, "servers", a.Servers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendHealthHTTPSettings.
func (a *ApplicationGatewayBackendHealthHTTPSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendHttpSettings":
			err = unpopulate(val, "BackendHTTPSettings", &a.BackendHTTPSettings)
			delete(rawMsg, key)
		case "servers":
			err = unpopulate(val, "Servers", &a.Servers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendHealthOnDemand.
func (a ApplicationGatewayBackendHealthOnDemand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", a.BackendAddressPool)
	populate(objectMap, "backendHealthHttpSettings", a.BackendHealthHTTPSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendHealthOnDemand.
func (a *ApplicationGatewayBackendHealthOnDemand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &a.BackendAddressPool)
			delete(rawMsg, key)
		case "backendHealthHttpSettings":
			err = unpopulate(val, "BackendHealthHTTPSettings", &a.BackendHealthHTTPSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendHealthPool.
func (a ApplicationGatewayBackendHealthPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", a.BackendAddressPool)
	populate(objectMap, "backendHttpSettingsCollection", a.BackendHTTPSettingsCollection)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendHealthPool.
func (a *ApplicationGatewayBackendHealthPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &a.BackendAddressPool)
			delete(rawMsg, key)
		case "backendHttpSettingsCollection":
			err = unpopulate(val, "BackendHTTPSettingsCollection", &a.BackendHTTPSettingsCollection)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendHealthServer.
func (a ApplicationGatewayBackendHealthServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", a.Address)
	populate(objectMap, "health", a.Health)
	populate(objectMap, "healthProbeLog", a.HealthProbeLog)
	populate(objectMap, "ipConfiguration", a.IPConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendHealthServer.
func (a *ApplicationGatewayBackendHealthServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &a.Address)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &a.Health)
			delete(rawMsg, key)
		case "healthProbeLog":
			err = unpopulate(val, "HealthProbeLog", &a.HealthProbeLog)
			delete(rawMsg, key)
		case "ipConfiguration":
			err = unpopulate(val, "IPConfiguration", &a.IPConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendSettings.
func (a ApplicationGatewayBackendSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendSettings.
func (a *ApplicationGatewayBackendSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendSettingsPropertiesFormat.
func (a ApplicationGatewayBackendSettingsPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostName", a.HostName)
	populate(objectMap, "pickHostNameFromBackendAddress", a.PickHostNameFromBackendAddress)
	populate(objectMap, "port", a.Port)
	populate(objectMap, "probe", a.Probe)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "timeout", a.Timeout)
	populate(objectMap, "trustedRootCertificates", a.TrustedRootCertificates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendSettingsPropertiesFormat.
func (a *ApplicationGatewayBackendSettingsPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostName":
			err = unpopulate(val, "HostName", &a.HostName)
			delete(rawMsg, key)
		case "pickHostNameFromBackendAddress":
			err = unpopulate(val, "PickHostNameFromBackendAddress", &a.PickHostNameFromBackendAddress)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "probe":
			err = unpopulate(val, "Probe", &a.Probe)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &a.Timeout)
			delete(rawMsg, key)
		case "trustedRootCertificates":
			err = unpopulate(val, "TrustedRootCertificates", &a.TrustedRootCertificates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayClientAuthConfiguration.
func (a ApplicationGatewayClientAuthConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "verifyClientCertIssuerDN", a.VerifyClientCertIssuerDN)
	populate(objectMap, "verifyClientRevocation", a.VerifyClientRevocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayClientAuthConfiguration.
func (a *ApplicationGatewayClientAuthConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "verifyClientCertIssuerDN":
			err = unpopulate(val, "VerifyClientCertIssuerDN", &a.VerifyClientCertIssuerDN)
			delete(rawMsg, key)
		case "verifyClientRevocation":
			err = unpopulate(val, "VerifyClientRevocation", &a.VerifyClientRevocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayConnectionDraining.
func (a ApplicationGatewayConnectionDraining) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "drainTimeoutInSec", a.DrainTimeoutInSec)
	populate(objectMap, "enabled", a.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayConnectionDraining.
func (a *ApplicationGatewayConnectionDraining) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "drainTimeoutInSec":
			err = unpopulate(val, "DrainTimeoutInSec", &a.DrainTimeoutInSec)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayCustomError.
func (a ApplicationGatewayCustomError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customErrorPageUrl", a.CustomErrorPageURL)
	populate(objectMap, "statusCode", a.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayCustomError.
func (a *ApplicationGatewayCustomError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customErrorPageUrl":
			err = unpopulate(val, "CustomErrorPageURL", &a.CustomErrorPageURL)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &a.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFirewallDisabledRuleGroup.
func (a ApplicationGatewayFirewallDisabledRuleGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleGroupName", a.RuleGroupName)
	populate(objectMap, "rules", a.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFirewallDisabledRuleGroup.
func (a *ApplicationGatewayFirewallDisabledRuleGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleGroupName":
			err = unpopulate(val, "RuleGroupName", &a.RuleGroupName)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &a.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFirewallExclusion.
func (a ApplicationGatewayFirewallExclusion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchVariable", a.MatchVariable)
	populate(objectMap, "selector", a.Selector)
	populate(objectMap, "selectorMatchOperator", a.SelectorMatchOperator)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFirewallExclusion.
func (a *ApplicationGatewayFirewallExclusion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchVariable":
			err = unpopulate(val, "MatchVariable", &a.MatchVariable)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &a.Selector)
			delete(rawMsg, key)
		case "selectorMatchOperator":
			err = unpopulate(val, "SelectorMatchOperator", &a.SelectorMatchOperator)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFirewallManifestRuleSet.
func (a ApplicationGatewayFirewallManifestRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleGroups", a.RuleGroups)
	populate(objectMap, "ruleSetType", a.RuleSetType)
	populate(objectMap, "ruleSetVersion", a.RuleSetVersion)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "tiers", a.Tiers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFirewallManifestRuleSet.
func (a *ApplicationGatewayFirewallManifestRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &a.RuleGroups)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &a.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &a.RuleSetVersion)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "tiers":
			err = unpopulate(val, "Tiers", &a.Tiers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFirewallRule.
func (a ApplicationGatewayFirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", a.Action)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "ruleId", a.RuleID)
	populate(objectMap, "ruleIdString", a.RuleIDString)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFirewallRule.
func (a *ApplicationGatewayFirewallRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &a.Action)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &a.RuleID)
			delete(rawMsg, key)
		case "ruleIdString":
			err = unpopulate(val, "RuleIDString", &a.RuleIDString)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFirewallRuleGroup.
func (a ApplicationGatewayFirewallRuleGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "ruleGroupName", a.RuleGroupName)
	populate(objectMap, "rules", a.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFirewallRuleGroup.
func (a *ApplicationGatewayFirewallRuleGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "ruleGroupName":
			err = unpopulate(val, "RuleGroupName", &a.RuleGroupName)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &a.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFirewallRuleSet.
func (a ApplicationGatewayFirewallRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFirewallRuleSet.
func (a *ApplicationGatewayFirewallRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFirewallRuleSetPropertiesFormat.
func (a ApplicationGatewayFirewallRuleSetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "ruleGroups", a.RuleGroups)
	populate(objectMap, "ruleSetType", a.RuleSetType)
	populate(objectMap, "ruleSetVersion", a.RuleSetVersion)
	populate(objectMap, "tiers", a.Tiers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFirewallRuleSetPropertiesFormat.
func (a *ApplicationGatewayFirewallRuleSetPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &a.RuleGroups)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &a.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &a.RuleSetVersion)
			delete(rawMsg, key)
		case "tiers":
			err = unpopulate(val, "Tiers", &a.Tiers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFrontendIPConfiguration.
func (a ApplicationGatewayFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFrontendIPConfiguration.
func (a *ApplicationGatewayFrontendIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFrontendIPConfigurationPropertiesFormat.
func (a ApplicationGatewayFrontendIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAddress", a.PrivateIPAddress)
	populate(objectMap, "privateIPAllocationMethod", a.PrivateIPAllocationMethod)
	populate(objectMap, "privateLinkConfiguration", a.PrivateLinkConfiguration)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "publicIPAddress", a.PublicIPAddress)
	populate(objectMap, "subnet", a.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFrontendIPConfigurationPropertiesFormat.
func (a *ApplicationGatewayFrontendIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &a.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &a.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "privateLinkConfiguration":
			err = unpopulate(val, "PrivateLinkConfiguration", &a.PrivateLinkConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &a.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &a.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFrontendPort.
func (a ApplicationGatewayFrontendPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFrontendPort.
func (a *ApplicationGatewayFrontendPort) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayFrontendPortPropertiesFormat.
func (a ApplicationGatewayFrontendPortPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", a.Port)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayFrontendPortPropertiesFormat.
func (a *ApplicationGatewayFrontendPortPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayGlobalConfiguration.
func (a ApplicationGatewayGlobalConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableRequestBuffering", a.EnableRequestBuffering)
	populate(objectMap, "enableResponseBuffering", a.EnableResponseBuffering)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayGlobalConfiguration.
func (a *ApplicationGatewayGlobalConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableRequestBuffering":
			err = unpopulate(val, "EnableRequestBuffering", &a.EnableRequestBuffering)
			delete(rawMsg, key)
		case "enableResponseBuffering":
			err = unpopulate(val, "EnableResponseBuffering", &a.EnableResponseBuffering)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayHTTPListener.
func (a ApplicationGatewayHTTPListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayHTTPListener.
func (a *ApplicationGatewayHTTPListener) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayHTTPListenerPropertiesFormat.
func (a ApplicationGatewayHTTPListenerPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customErrorConfigurations", a.CustomErrorConfigurations)
	populate(objectMap, "firewallPolicy", a.FirewallPolicy)
	populate(objectMap, "frontendIPConfiguration", a.FrontendIPConfiguration)
	populate(objectMap, "frontendPort", a.FrontendPort)
	populate(objectMap, "hostName", a.HostName)
	populate(objectMap, "hostNames", a.HostNames)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "requireServerNameIndication", a.RequireServerNameIndication)
	populate(objectMap, "sslCertificate", a.SSLCertificate)
	populate(objectMap, "sslProfile", a.SSLProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayHTTPListenerPropertiesFormat.
func (a *ApplicationGatewayHTTPListenerPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customErrorConfigurations":
			err = unpopulate(val, "CustomErrorConfigurations", &a.CustomErrorConfigurations)
			delete(rawMsg, key)
		case "firewallPolicy":
			err = unpopulate(val, "FirewallPolicy", &a.FirewallPolicy)
			delete(rawMsg, key)
		case "frontendIPConfiguration":
			err = unpopulate(val, "FrontendIPConfiguration", &a.FrontendIPConfiguration)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &a.FrontendPort)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &a.HostName)
			delete(rawMsg, key)
		case "hostNames":
			err = unpopulate(val, "HostNames", &a.HostNames)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "requireServerNameIndication":
			err = unpopulate(val, "RequireServerNameIndication", &a.RequireServerNameIndication)
			delete(rawMsg, key)
		case "sslCertificate":
			err = unpopulate(val, "SSLCertificate", &a.SSLCertificate)
			delete(rawMsg, key)
		case "sslProfile":
			err = unpopulate(val, "SSLProfile", &a.SSLProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayHeaderConfiguration.
func (a ApplicationGatewayHeaderConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "headerName", a.HeaderName)
	populate(objectMap, "headerValue", a.HeaderValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayHeaderConfiguration.
func (a *ApplicationGatewayHeaderConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headerName":
			err = unpopulate(val, "HeaderName", &a.HeaderName)
			delete(rawMsg, key)
		case "headerValue":
			err = unpopulate(val, "HeaderValue", &a.HeaderValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayIPConfiguration.
func (a ApplicationGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayIPConfiguration.
func (a *ApplicationGatewayIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayIPConfigurationPropertiesFormat.
func (a ApplicationGatewayIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "subnet", a.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayIPConfigurationPropertiesFormat.
func (a *ApplicationGatewayIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &a.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayListResult.
func (a ApplicationGatewayListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayListResult.
func (a *ApplicationGatewayListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayListener.
func (a ApplicationGatewayListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayListener.
func (a *ApplicationGatewayListener) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayListenerPropertiesFormat.
func (a ApplicationGatewayListenerPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "frontendIPConfiguration", a.FrontendIPConfiguration)
	populate(objectMap, "frontendPort", a.FrontendPort)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "sslCertificate", a.SSLCertificate)
	populate(objectMap, "sslProfile", a.SSLProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayListenerPropertiesFormat.
func (a *ApplicationGatewayListenerPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frontendIPConfiguration":
			err = unpopulate(val, "FrontendIPConfiguration", &a.FrontendIPConfiguration)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &a.FrontendPort)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "sslCertificate":
			err = unpopulate(val, "SSLCertificate", &a.SSLCertificate)
			delete(rawMsg, key)
		case "sslProfile":
			err = unpopulate(val, "SSLProfile", &a.SSLProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayLoadDistributionPolicy.
func (a ApplicationGatewayLoadDistributionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayLoadDistributionPolicy.
func (a *ApplicationGatewayLoadDistributionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayLoadDistributionPolicyPropertiesFormat.
func (a ApplicationGatewayLoadDistributionPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "loadDistributionAlgorithm", a.LoadDistributionAlgorithm)
	populate(objectMap, "loadDistributionTargets", a.LoadDistributionTargets)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayLoadDistributionPolicyPropertiesFormat.
func (a *ApplicationGatewayLoadDistributionPolicyPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "loadDistributionAlgorithm":
			err = unpopulate(val, "LoadDistributionAlgorithm", &a.LoadDistributionAlgorithm)
			delete(rawMsg, key)
		case "loadDistributionTargets":
			err = unpopulate(val, "LoadDistributionTargets", &a.LoadDistributionTargets)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayLoadDistributionTarget.
func (a ApplicationGatewayLoadDistributionTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayLoadDistributionTarget.
func (a *ApplicationGatewayLoadDistributionTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayLoadDistributionTargetPropertiesFormat.
func (a ApplicationGatewayLoadDistributionTargetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", a.BackendAddressPool)
	populate(objectMap, "weightPerServer", a.WeightPerServer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayLoadDistributionTargetPropertiesFormat.
func (a *ApplicationGatewayLoadDistributionTargetPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &a.BackendAddressPool)
			delete(rawMsg, key)
		case "weightPerServer":
			err = unpopulate(val, "WeightPerServer", &a.WeightPerServer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayOnDemandProbe.
func (a ApplicationGatewayOnDemandProbe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", a.BackendAddressPool)
	populate(objectMap, "backendHttpSettings", a.BackendHTTPSettings)
	populate(objectMap, "host", a.Host)
	populate(objectMap, "match", a.Match)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "pickHostNameFromBackendHttpSettings", a.PickHostNameFromBackendHTTPSettings)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "timeout", a.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayOnDemandProbe.
func (a *ApplicationGatewayOnDemandProbe) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &a.BackendAddressPool)
			delete(rawMsg, key)
		case "backendHttpSettings":
			err = unpopulate(val, "BackendHTTPSettings", &a.BackendHTTPSettings)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &a.Host)
			delete(rawMsg, key)
		case "match":
			err = unpopulate(val, "Match", &a.Match)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &a.Path)
			delete(rawMsg, key)
		case "pickHostNameFromBackendHttpSettings":
			err = unpopulate(val, "PickHostNameFromBackendHTTPSettings", &a.PickHostNameFromBackendHTTPSettings)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &a.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPathRule.
func (a ApplicationGatewayPathRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPathRule.
func (a *ApplicationGatewayPathRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPathRulePropertiesFormat.
func (a ApplicationGatewayPathRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", a.BackendAddressPool)
	populate(objectMap, "backendHttpSettings", a.BackendHTTPSettings)
	populate(objectMap, "firewallPolicy", a.FirewallPolicy)
	populate(objectMap, "loadDistributionPolicy", a.LoadDistributionPolicy)
	populate(objectMap, "paths", a.Paths)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "redirectConfiguration", a.RedirectConfiguration)
	populate(objectMap, "rewriteRuleSet", a.RewriteRuleSet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPathRulePropertiesFormat.
func (a *ApplicationGatewayPathRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &a.BackendAddressPool)
			delete(rawMsg, key)
		case "backendHttpSettings":
			err = unpopulate(val, "BackendHTTPSettings", &a.BackendHTTPSettings)
			delete(rawMsg, key)
		case "firewallPolicy":
			err = unpopulate(val, "FirewallPolicy", &a.FirewallPolicy)
			delete(rawMsg, key)
		case "loadDistributionPolicy":
			err = unpopulate(val, "LoadDistributionPolicy", &a.LoadDistributionPolicy)
			delete(rawMsg, key)
		case "paths":
			err = unpopulate(val, "Paths", &a.Paths)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "redirectConfiguration":
			err = unpopulate(val, "RedirectConfiguration", &a.RedirectConfiguration)
			delete(rawMsg, key)
		case "rewriteRuleSet":
			err = unpopulate(val, "RewriteRuleSet", &a.RewriteRuleSet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateEndpointConnection.
func (a ApplicationGatewayPrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateEndpointConnection.
func (a *ApplicationGatewayPrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateEndpointConnectionListResult.
func (a ApplicationGatewayPrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateEndpointConnectionListResult.
func (a *ApplicationGatewayPrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateEndpointConnectionProperties.
func (a ApplicationGatewayPrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkIdentifier", a.LinkIdentifier)
	populate(objectMap, "privateEndpoint", a.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", a.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateEndpointConnectionProperties.
func (a *ApplicationGatewayPrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkIdentifier":
			err = unpopulate(val, "LinkIdentifier", &a.LinkIdentifier)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &a.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &a.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateLinkConfiguration.
func (a ApplicationGatewayPrivateLinkConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateLinkConfiguration.
func (a *ApplicationGatewayPrivateLinkConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateLinkConfigurationProperties.
func (a ApplicationGatewayPrivateLinkConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipConfigurations", a.IPConfigurations)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateLinkConfigurationProperties.
func (a *ApplicationGatewayPrivateLinkConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &a.IPConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateLinkIPConfiguration.
func (a ApplicationGatewayPrivateLinkIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateLinkIPConfiguration.
func (a *ApplicationGatewayPrivateLinkIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateLinkIPConfigurationProperties.
func (a ApplicationGatewayPrivateLinkIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primary", a.Primary)
	populate(objectMap, "privateIPAddress", a.PrivateIPAddress)
	populate(objectMap, "privateIPAllocationMethod", a.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "subnet", a.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateLinkIPConfigurationProperties.
func (a *ApplicationGatewayPrivateLinkIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primary":
			err = unpopulate(val, "Primary", &a.Primary)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &a.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &a.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &a.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateLinkResource.
func (a ApplicationGatewayPrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateLinkResource.
func (a *ApplicationGatewayPrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateLinkResourceListResult.
func (a ApplicationGatewayPrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateLinkResourceListResult.
func (a *ApplicationGatewayPrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPrivateLinkResourceProperties.
func (a ApplicationGatewayPrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", a.GroupID)
	populate(objectMap, "requiredMembers", a.RequiredMembers)
	populate(objectMap, "requiredZoneNames", a.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPrivateLinkResourceProperties.
func (a *ApplicationGatewayPrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &a.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &a.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &a.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayProbe.
func (a ApplicationGatewayProbe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayProbe.
func (a *ApplicationGatewayProbe) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayProbeHealthResponseMatch.
func (a ApplicationGatewayProbeHealthResponseMatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "body", a.Body)
	populate(objectMap, "statusCodes", a.StatusCodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayProbeHealthResponseMatch.
func (a *ApplicationGatewayProbeHealthResponseMatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "body":
			err = unpopulate(val, "Body", &a.Body)
			delete(rawMsg, key)
		case "statusCodes":
			err = unpopulate(val, "StatusCodes", &a.StatusCodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayProbePropertiesFormat.
func (a ApplicationGatewayProbePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "host", a.Host)
	populate(objectMap, "interval", a.Interval)
	populate(objectMap, "match", a.Match)
	populate(objectMap, "minServers", a.MinServers)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "pickHostNameFromBackendHttpSettings", a.PickHostNameFromBackendHTTPSettings)
	populate(objectMap, "pickHostNameFromBackendSettings", a.PickHostNameFromBackendSettings)
	populate(objectMap, "port", a.Port)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "timeout", a.Timeout)
	populate(objectMap, "unhealthyThreshold", a.UnhealthyThreshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayProbePropertiesFormat.
func (a *ApplicationGatewayProbePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "host":
			err = unpopulate(val, "Host", &a.Host)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &a.Interval)
			delete(rawMsg, key)
		case "match":
			err = unpopulate(val, "Match", &a.Match)
			delete(rawMsg, key)
		case "minServers":
			err = unpopulate(val, "MinServers", &a.MinServers)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &a.Path)
			delete(rawMsg, key)
		case "pickHostNameFromBackendHttpSettings":
			err = unpopulate(val, "PickHostNameFromBackendHTTPSettings", &a.PickHostNameFromBackendHTTPSettings)
			delete(rawMsg, key)
		case "pickHostNameFromBackendSettings":
			err = unpopulate(val, "PickHostNameFromBackendSettings", &a.PickHostNameFromBackendSettings)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &a.Timeout)
			delete(rawMsg, key)
		case "unhealthyThreshold":
			err = unpopulate(val, "UnhealthyThreshold", &a.UnhealthyThreshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayPropertiesFormat.
func (a ApplicationGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationCertificates", a.AuthenticationCertificates)
	populate(objectMap, "autoscaleConfiguration", a.AutoscaleConfiguration)
	populate(objectMap, "backendAddressPools", a.BackendAddressPools)
	populate(objectMap, "backendHttpSettingsCollection", a.BackendHTTPSettingsCollection)
	populate(objectMap, "backendSettingsCollection", a.BackendSettingsCollection)
	populate(objectMap, "customErrorConfigurations", a.CustomErrorConfigurations)
	populate(objectMap, "defaultPredefinedSslPolicy", a.DefaultPredefinedSSLPolicy)
	populate(objectMap, "enableFips", a.EnableFips)
	populate(objectMap, "enableHttp2", a.EnableHTTP2)
	populate(objectMap, "firewallPolicy", a.FirewallPolicy)
	populate(objectMap, "forceFirewallPolicyAssociation", a.ForceFirewallPolicyAssociation)
	populate(objectMap, "frontendIPConfigurations", a.FrontendIPConfigurations)
	populate(objectMap, "frontendPorts", a.FrontendPorts)
	populate(objectMap, "gatewayIPConfigurations", a.GatewayIPConfigurations)
	populate(objectMap, "globalConfiguration", a.GlobalConfiguration)
	populate(objectMap, "httpListeners", a.HTTPListeners)
	populate(objectMap, "listeners", a.Listeners)
	populate(objectMap, "loadDistributionPolicies", a.LoadDistributionPolicies)
	populate(objectMap, "operationalState", a.OperationalState)
	populate(objectMap, "privateEndpointConnections", a.PrivateEndpointConnections)
	populate(objectMap, "privateLinkConfigurations", a.PrivateLinkConfigurations)
	populate(objectMap, "probes", a.Probes)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "redirectConfigurations", a.RedirectConfigurations)
	populate(objectMap, "requestRoutingRules", a.RequestRoutingRules)
	populate(objectMap, "resourceGuid", a.ResourceGUID)
	populate(objectMap, "rewriteRuleSets", a.RewriteRuleSets)
	populate(objectMap, "routingRules", a.RoutingRules)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "sslCertificates", a.SSLCertificates)
	populate(objectMap, "sslPolicy", a.SSLPolicy)
	populate(objectMap, "sslProfiles", a.SSLProfiles)
	populate(objectMap, "trustedClientCertificates", a.TrustedClientCertificates)
	populate(objectMap, "trustedRootCertificates", a.TrustedRootCertificates)
	populate(objectMap, "urlPathMaps", a.URLPathMaps)
	populate(objectMap, "webApplicationFirewallConfiguration", a.WebApplicationFirewallConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayPropertiesFormat.
func (a *ApplicationGatewayPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationCertificates":
			err = unpopulate(val, "AuthenticationCertificates", &a.AuthenticationCertificates)
			delete(rawMsg, key)
		case "autoscaleConfiguration":
			err = unpopulate(val, "AutoscaleConfiguration", &a.AutoscaleConfiguration)
			delete(rawMsg, key)
		case "backendAddressPools":
			err = unpopulate(val, "BackendAddressPools", &a.BackendAddressPools)
			delete(rawMsg, key)
		case "backendHttpSettingsCollection":
			err = unpopulate(val, "BackendHTTPSettingsCollection", &a.BackendHTTPSettingsCollection)
			delete(rawMsg, key)
		case "backendSettingsCollection":
			err = unpopulate(val, "BackendSettingsCollection", &a.BackendSettingsCollection)
			delete(rawMsg, key)
		case "customErrorConfigurations":
			err = unpopulate(val, "CustomErrorConfigurations", &a.CustomErrorConfigurations)
			delete(rawMsg, key)
		case "defaultPredefinedSslPolicy":
			err = unpopulate(val, "DefaultPredefinedSSLPolicy", &a.DefaultPredefinedSSLPolicy)
			delete(rawMsg, key)
		case "enableFips":
			err = unpopulate(val, "EnableFips", &a.EnableFips)
			delete(rawMsg, key)
		case "enableHttp2":
			err = unpopulate(val, "EnableHTTP2", &a.EnableHTTP2)
			delete(rawMsg, key)
		case "firewallPolicy":
			err = unpopulate(val, "FirewallPolicy", &a.FirewallPolicy)
			delete(rawMsg, key)
		case "forceFirewallPolicyAssociation":
			err = unpopulate(val, "ForceFirewallPolicyAssociation", &a.ForceFirewallPolicyAssociation)
			delete(rawMsg, key)
		case "frontendIPConfigurations":
			err = unpopulate(val, "FrontendIPConfigurations", &a.FrontendIPConfigurations)
			delete(rawMsg, key)
		case "frontendPorts":
			err = unpopulate(val, "FrontendPorts", &a.FrontendPorts)
			delete(rawMsg, key)
		case "gatewayIPConfigurations":
			err = unpopulate(val, "GatewayIPConfigurations", &a.GatewayIPConfigurations)
			delete(rawMsg, key)
		case "globalConfiguration":
			err = unpopulate(val, "GlobalConfiguration", &a.GlobalConfiguration)
			delete(rawMsg, key)
		case "httpListeners":
			err = unpopulate(val, "HTTPListeners", &a.HTTPListeners)
			delete(rawMsg, key)
		case "listeners":
			err = unpopulate(val, "Listeners", &a.Listeners)
			delete(rawMsg, key)
		case "loadDistributionPolicies":
			err = unpopulate(val, "LoadDistributionPolicies", &a.LoadDistributionPolicies)
			delete(rawMsg, key)
		case "operationalState":
			err = unpopulate(val, "OperationalState", &a.OperationalState)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &a.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateLinkConfigurations":
			err = unpopulate(val, "PrivateLinkConfigurations", &a.PrivateLinkConfigurations)
			delete(rawMsg, key)
		case "probes":
			err = unpopulate(val, "Probes", &a.Probes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "redirectConfigurations":
			err = unpopulate(val, "RedirectConfigurations", &a.RedirectConfigurations)
			delete(rawMsg, key)
		case "requestRoutingRules":
			err = unpopulate(val, "RequestRoutingRules", &a.RequestRoutingRules)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &a.ResourceGUID)
			delete(rawMsg, key)
		case "rewriteRuleSets":
			err = unpopulate(val, "RewriteRuleSets", &a.RewriteRuleSets)
			delete(rawMsg, key)
		case "routingRules":
			err = unpopulate(val, "RoutingRules", &a.RoutingRules)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "sslCertificates":
			err = unpopulate(val, "SSLCertificates", &a.SSLCertificates)
			delete(rawMsg, key)
		case "sslPolicy":
			err = unpopulate(val, "SSLPolicy", &a.SSLPolicy)
			delete(rawMsg, key)
		case "sslProfiles":
			err = unpopulate(val, "SSLProfiles", &a.SSLProfiles)
			delete(rawMsg, key)
		case "trustedClientCertificates":
			err = unpopulate(val, "TrustedClientCertificates", &a.TrustedClientCertificates)
			delete(rawMsg, key)
		case "trustedRootCertificates":
			err = unpopulate(val, "TrustedRootCertificates", &a.TrustedRootCertificates)
			delete(rawMsg, key)
		case "urlPathMaps":
			err = unpopulate(val, "URLPathMaps", &a.URLPathMaps)
			delete(rawMsg, key)
		case "webApplicationFirewallConfiguration":
			err = unpopulate(val, "WebApplicationFirewallConfiguration", &a.WebApplicationFirewallConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRedirectConfiguration.
func (a ApplicationGatewayRedirectConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRedirectConfiguration.
func (a *ApplicationGatewayRedirectConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRedirectConfigurationPropertiesFormat.
func (a ApplicationGatewayRedirectConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "includePath", a.IncludePath)
	populate(objectMap, "includeQueryString", a.IncludeQueryString)
	populate(objectMap, "pathRules", a.PathRules)
	populate(objectMap, "redirectType", a.RedirectType)
	populate(objectMap, "requestRoutingRules", a.RequestRoutingRules)
	populate(objectMap, "targetListener", a.TargetListener)
	populate(objectMap, "targetUrl", a.TargetURL)
	populate(objectMap, "urlPathMaps", a.URLPathMaps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRedirectConfigurationPropertiesFormat.
func (a *ApplicationGatewayRedirectConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "includePath":
			err = unpopulate(val, "IncludePath", &a.IncludePath)
			delete(rawMsg, key)
		case "includeQueryString":
			err = unpopulate(val, "IncludeQueryString", &a.IncludeQueryString)
			delete(rawMsg, key)
		case "pathRules":
			err = unpopulate(val, "PathRules", &a.PathRules)
			delete(rawMsg, key)
		case "redirectType":
			err = unpopulate(val, "RedirectType", &a.RedirectType)
			delete(rawMsg, key)
		case "requestRoutingRules":
			err = unpopulate(val, "RequestRoutingRules", &a.RequestRoutingRules)
			delete(rawMsg, key)
		case "targetListener":
			err = unpopulate(val, "TargetListener", &a.TargetListener)
			delete(rawMsg, key)
		case "targetUrl":
			err = unpopulate(val, "TargetURL", &a.TargetURL)
			delete(rawMsg, key)
		case "urlPathMaps":
			err = unpopulate(val, "URLPathMaps", &a.URLPathMaps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRequestRoutingRule.
func (a ApplicationGatewayRequestRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRequestRoutingRule.
func (a *ApplicationGatewayRequestRoutingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRequestRoutingRulePropertiesFormat.
func (a ApplicationGatewayRequestRoutingRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", a.BackendAddressPool)
	populate(objectMap, "backendHttpSettings", a.BackendHTTPSettings)
	populate(objectMap, "httpListener", a.HTTPListener)
	populate(objectMap, "loadDistributionPolicy", a.LoadDistributionPolicy)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "redirectConfiguration", a.RedirectConfiguration)
	populate(objectMap, "rewriteRuleSet", a.RewriteRuleSet)
	populate(objectMap, "ruleType", a.RuleType)
	populate(objectMap, "urlPathMap", a.URLPathMap)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRequestRoutingRulePropertiesFormat.
func (a *ApplicationGatewayRequestRoutingRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &a.BackendAddressPool)
			delete(rawMsg, key)
		case "backendHttpSettings":
			err = unpopulate(val, "BackendHTTPSettings", &a.BackendHTTPSettings)
			delete(rawMsg, key)
		case "httpListener":
			err = unpopulate(val, "HTTPListener", &a.HTTPListener)
			delete(rawMsg, key)
		case "loadDistributionPolicy":
			err = unpopulate(val, "LoadDistributionPolicy", &a.LoadDistributionPolicy)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "redirectConfiguration":
			err = unpopulate(val, "RedirectConfiguration", &a.RedirectConfiguration)
			delete(rawMsg, key)
		case "rewriteRuleSet":
			err = unpopulate(val, "RewriteRuleSet", &a.RewriteRuleSet)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &a.RuleType)
			delete(rawMsg, key)
		case "urlPathMap":
			err = unpopulate(val, "URLPathMap", &a.URLPathMap)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRewriteRule.
func (a ApplicationGatewayRewriteRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionSet", a.ActionSet)
	populate(objectMap, "conditions", a.Conditions)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "ruleSequence", a.RuleSequence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRewriteRule.
func (a *ApplicationGatewayRewriteRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionSet":
			err = unpopulate(val, "ActionSet", &a.ActionSet)
			delete(rawMsg, key)
		case "conditions":
			err = unpopulate(val, "Conditions", &a.Conditions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "ruleSequence":
			err = unpopulate(val, "RuleSequence", &a.RuleSequence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRewriteRuleActionSet.
func (a ApplicationGatewayRewriteRuleActionSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requestHeaderConfigurations", a.RequestHeaderConfigurations)
	populate(objectMap, "responseHeaderConfigurations", a.ResponseHeaderConfigurations)
	populate(objectMap, "urlConfiguration", a.URLConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRewriteRuleActionSet.
func (a *ApplicationGatewayRewriteRuleActionSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requestHeaderConfigurations":
			err = unpopulate(val, "RequestHeaderConfigurations", &a.RequestHeaderConfigurations)
			delete(rawMsg, key)
		case "responseHeaderConfigurations":
			err = unpopulate(val, "ResponseHeaderConfigurations", &a.ResponseHeaderConfigurations)
			delete(rawMsg, key)
		case "urlConfiguration":
			err = unpopulate(val, "URLConfiguration", &a.URLConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRewriteRuleCondition.
func (a ApplicationGatewayRewriteRuleCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ignoreCase", a.IgnoreCase)
	populate(objectMap, "negate", a.Negate)
	populate(objectMap, "pattern", a.Pattern)
	populate(objectMap, "variable", a.Variable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRewriteRuleCondition.
func (a *ApplicationGatewayRewriteRuleCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ignoreCase":
			err = unpopulate(val, "IgnoreCase", &a.IgnoreCase)
			delete(rawMsg, key)
		case "negate":
			err = unpopulate(val, "Negate", &a.Negate)
			delete(rawMsg, key)
		case "pattern":
			err = unpopulate(val, "Pattern", &a.Pattern)
			delete(rawMsg, key)
		case "variable":
			err = unpopulate(val, "Variable", &a.Variable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRewriteRuleSet.
func (a ApplicationGatewayRewriteRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRewriteRuleSet.
func (a *ApplicationGatewayRewriteRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRewriteRuleSetPropertiesFormat.
func (a ApplicationGatewayRewriteRuleSetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "rewriteRules", a.RewriteRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRewriteRuleSetPropertiesFormat.
func (a *ApplicationGatewayRewriteRuleSetPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "rewriteRules":
			err = unpopulate(val, "RewriteRules", &a.RewriteRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRoutingRule.
func (a ApplicationGatewayRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRoutingRule.
func (a *ApplicationGatewayRoutingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayRoutingRulePropertiesFormat.
func (a ApplicationGatewayRoutingRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", a.BackendAddressPool)
	populate(objectMap, "backendSettings", a.BackendSettings)
	populate(objectMap, "listener", a.Listener)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "ruleType", a.RuleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayRoutingRulePropertiesFormat.
func (a *ApplicationGatewayRoutingRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &a.BackendAddressPool)
			delete(rawMsg, key)
		case "backendSettings":
			err = unpopulate(val, "BackendSettings", &a.BackendSettings)
			delete(rawMsg, key)
		case "listener":
			err = unpopulate(val, "Listener", &a.Listener)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &a.RuleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewaySKU.
func (a ApplicationGatewaySKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", a.Capacity)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "tier", a.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewaySKU.
func (a *ApplicationGatewaySKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &a.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &a.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewaySSLCertificate.
func (a ApplicationGatewaySSLCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewaySSLCertificate.
func (a *ApplicationGatewaySSLCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewaySSLCertificatePropertiesFormat.
func (a ApplicationGatewaySSLCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", a.Data)
	populate(objectMap, "keyVaultSecretId", a.KeyVaultSecretID)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "publicCertData", a.PublicCertData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewaySSLCertificatePropertiesFormat.
func (a *ApplicationGatewaySSLCertificatePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &a.Data)
			delete(rawMsg, key)
		case "keyVaultSecretId":
			err = unpopulate(val, "KeyVaultSecretID", &a.KeyVaultSecretID)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "publicCertData":
			err = unpopulate(val, "PublicCertData", &a.PublicCertData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewaySSLPolicy.
func (a ApplicationGatewaySSLPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cipherSuites", a.CipherSuites)
	populate(objectMap, "disabledSslProtocols", a.DisabledSSLProtocols)
	populate(objectMap, "minProtocolVersion", a.MinProtocolVersion)
	populate(objectMap, "policyName", a.PolicyName)
	populate(objectMap, "policyType", a.PolicyType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewaySSLPolicy.
func (a *ApplicationGatewaySSLPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cipherSuites":
			err = unpopulate(val, "CipherSuites", &a.CipherSuites)
			delete(rawMsg, key)
		case "disabledSslProtocols":
			err = unpopulate(val, "DisabledSSLProtocols", &a.DisabledSSLProtocols)
			delete(rawMsg, key)
		case "minProtocolVersion":
			err = unpopulate(val, "MinProtocolVersion", &a.MinProtocolVersion)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &a.PolicyName)
			delete(rawMsg, key)
		case "policyType":
			err = unpopulate(val, "PolicyType", &a.PolicyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewaySSLPredefinedPolicy.
func (a ApplicationGatewaySSLPredefinedPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewaySSLPredefinedPolicy.
func (a *ApplicationGatewaySSLPredefinedPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewaySSLPredefinedPolicyPropertiesFormat.
func (a ApplicationGatewaySSLPredefinedPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cipherSuites", a.CipherSuites)
	populate(objectMap, "minProtocolVersion", a.MinProtocolVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewaySSLPredefinedPolicyPropertiesFormat.
func (a *ApplicationGatewaySSLPredefinedPolicyPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cipherSuites":
			err = unpopulate(val, "CipherSuites", &a.CipherSuites)
			delete(rawMsg, key)
		case "minProtocolVersion":
			err = unpopulate(val, "MinProtocolVersion", &a.MinProtocolVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewaySSLProfile.
func (a ApplicationGatewaySSLProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewaySSLProfile.
func (a *ApplicationGatewaySSLProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewaySSLProfilePropertiesFormat.
func (a ApplicationGatewaySSLProfilePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientAuthConfiguration", a.ClientAuthConfiguration)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "sslPolicy", a.SSLPolicy)
	populate(objectMap, "trustedClientCertificates", a.TrustedClientCertificates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewaySSLProfilePropertiesFormat.
func (a *ApplicationGatewaySSLProfilePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientAuthConfiguration":
			err = unpopulate(val, "ClientAuthConfiguration", &a.ClientAuthConfiguration)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "sslPolicy":
			err = unpopulate(val, "SSLPolicy", &a.SSLPolicy)
			delete(rawMsg, key)
		case "trustedClientCertificates":
			err = unpopulate(val, "TrustedClientCertificates", &a.TrustedClientCertificates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayTrustedClientCertificate.
func (a ApplicationGatewayTrustedClientCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayTrustedClientCertificate.
func (a *ApplicationGatewayTrustedClientCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayTrustedClientCertificatePropertiesFormat.
func (a ApplicationGatewayTrustedClientCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientCertIssuerDN", a.ClientCertIssuerDN)
	populate(objectMap, "data", a.Data)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "validatedCertData", a.ValidatedCertData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayTrustedClientCertificatePropertiesFormat.
func (a *ApplicationGatewayTrustedClientCertificatePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientCertIssuerDN":
			err = unpopulate(val, "ClientCertIssuerDN", &a.ClientCertIssuerDN)
			delete(rawMsg, key)
		case "data":
			err = unpopulate(val, "Data", &a.Data)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "validatedCertData":
			err = unpopulate(val, "ValidatedCertData", &a.ValidatedCertData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayTrustedRootCertificate.
func (a ApplicationGatewayTrustedRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayTrustedRootCertificate.
func (a *ApplicationGatewayTrustedRootCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayTrustedRootCertificatePropertiesFormat.
func (a ApplicationGatewayTrustedRootCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", a.Data)
	populate(objectMap, "keyVaultSecretId", a.KeyVaultSecretID)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayTrustedRootCertificatePropertiesFormat.
func (a *ApplicationGatewayTrustedRootCertificatePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &a.Data)
			delete(rawMsg, key)
		case "keyVaultSecretId":
			err = unpopulate(val, "KeyVaultSecretID", &a.KeyVaultSecretID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayURLConfiguration.
func (a ApplicationGatewayURLConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "modifiedPath", a.ModifiedPath)
	populate(objectMap, "modifiedQueryString", a.ModifiedQueryString)
	populate(objectMap, "reroute", a.Reroute)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayURLConfiguration.
func (a *ApplicationGatewayURLConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "modifiedPath":
			err = unpopulate(val, "ModifiedPath", &a.ModifiedPath)
			delete(rawMsg, key)
		case "modifiedQueryString":
			err = unpopulate(val, "ModifiedQueryString", &a.ModifiedQueryString)
			delete(rawMsg, key)
		case "reroute":
			err = unpopulate(val, "Reroute", &a.Reroute)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayURLPathMap.
func (a ApplicationGatewayURLPathMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayURLPathMap.
func (a *ApplicationGatewayURLPathMap) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayURLPathMapPropertiesFormat.
func (a ApplicationGatewayURLPathMapPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultBackendAddressPool", a.DefaultBackendAddressPool)
	populate(objectMap, "defaultBackendHttpSettings", a.DefaultBackendHTTPSettings)
	populate(objectMap, "defaultLoadDistributionPolicy", a.DefaultLoadDistributionPolicy)
	populate(objectMap, "defaultRedirectConfiguration", a.DefaultRedirectConfiguration)
	populate(objectMap, "defaultRewriteRuleSet", a.DefaultRewriteRuleSet)
	populate(objectMap, "pathRules", a.PathRules)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayURLPathMapPropertiesFormat.
func (a *ApplicationGatewayURLPathMapPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultBackendAddressPool":
			err = unpopulate(val, "DefaultBackendAddressPool", &a.DefaultBackendAddressPool)
			delete(rawMsg, key)
		case "defaultBackendHttpSettings":
			err = unpopulate(val, "DefaultBackendHTTPSettings", &a.DefaultBackendHTTPSettings)
			delete(rawMsg, key)
		case "defaultLoadDistributionPolicy":
			err = unpopulate(val, "DefaultLoadDistributionPolicy", &a.DefaultLoadDistributionPolicy)
			delete(rawMsg, key)
		case "defaultRedirectConfiguration":
			err = unpopulate(val, "DefaultRedirectConfiguration", &a.DefaultRedirectConfiguration)
			delete(rawMsg, key)
		case "defaultRewriteRuleSet":
			err = unpopulate(val, "DefaultRewriteRuleSet", &a.DefaultRewriteRuleSet)
			delete(rawMsg, key)
		case "pathRules":
			err = unpopulate(val, "PathRules", &a.PathRules)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayWafDynamicManifestPropertiesResult.
func (a ApplicationGatewayWafDynamicManifestPropertiesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableRuleSets", a.AvailableRuleSets)
	populate(objectMap, "defaultRuleSet", a.DefaultRuleSet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayWafDynamicManifestPropertiesResult.
func (a *ApplicationGatewayWafDynamicManifestPropertiesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableRuleSets":
			err = unpopulate(val, "AvailableRuleSets", &a.AvailableRuleSets)
			delete(rawMsg, key)
		case "defaultRuleSet":
			err = unpopulate(val, "DefaultRuleSet", &a.DefaultRuleSet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayWafDynamicManifestResult.
func (a ApplicationGatewayWafDynamicManifestResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayWafDynamicManifestResult.
func (a *ApplicationGatewayWafDynamicManifestResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayWafDynamicManifestResultList.
func (a ApplicationGatewayWafDynamicManifestResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayWafDynamicManifestResultList.
func (a *ApplicationGatewayWafDynamicManifestResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayWebApplicationFirewallConfiguration.
func (a ApplicationGatewayWebApplicationFirewallConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disabledRuleGroups", a.DisabledRuleGroups)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "exclusions", a.Exclusions)
	populate(objectMap, "fileUploadLimitInMb", a.FileUploadLimitInMb)
	populate(objectMap, "firewallMode", a.FirewallMode)
	populate(objectMap, "maxRequestBodySize", a.MaxRequestBodySize)
	populate(objectMap, "maxRequestBodySizeInKb", a.MaxRequestBodySizeInKb)
	populate(objectMap, "requestBodyCheck", a.RequestBodyCheck)
	populate(objectMap, "ruleSetType", a.RuleSetType)
	populate(objectMap, "ruleSetVersion", a.RuleSetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayWebApplicationFirewallConfiguration.
func (a *ApplicationGatewayWebApplicationFirewallConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disabledRuleGroups":
			err = unpopulate(val, "DisabledRuleGroups", &a.DisabledRuleGroups)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "exclusions":
			err = unpopulate(val, "Exclusions", &a.Exclusions)
			delete(rawMsg, key)
		case "fileUploadLimitInMb":
			err = unpopulate(val, "FileUploadLimitInMb", &a.FileUploadLimitInMb)
			delete(rawMsg, key)
		case "firewallMode":
			err = unpopulate(val, "FirewallMode", &a.FirewallMode)
			delete(rawMsg, key)
		case "maxRequestBodySize":
			err = unpopulate(val, "MaxRequestBodySize", &a.MaxRequestBodySize)
			delete(rawMsg, key)
		case "maxRequestBodySizeInKb":
			err = unpopulate(val, "MaxRequestBodySizeInKb", &a.MaxRequestBodySizeInKb)
			delete(rawMsg, key)
		case "requestBodyCheck":
			err = unpopulate(val, "RequestBodyCheck", &a.RequestBodyCheck)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &a.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &a.RuleSetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationRule.
func (a ApplicationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "destinationAddresses", a.DestinationAddresses)
	populate(objectMap, "fqdnTags", a.FqdnTags)
	populate(objectMap, "httpHeadersToInsert", a.HTTPHeadersToInsert)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "protocols", a.Protocols)
	objectMap["ruleType"] = FirewallPolicyRuleTypeApplicationRule
	populate(objectMap, "sourceAddresses", a.SourceAddresses)
	populate(objectMap, "sourceIpGroups", a.SourceIPGroups)
	populate(objectMap, "targetFqdns", a.TargetFqdns)
	populate(objectMap, "targetUrls", a.TargetUrls)
	populate(objectMap, "terminateTLS", a.TerminateTLS)
	populate(objectMap, "webCategories", a.WebCategories)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationRule.
func (a *ApplicationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "destinationAddresses":
			err = unpopulate(val, "DestinationAddresses", &a.DestinationAddresses)
			delete(rawMsg, key)
		case "fqdnTags":
			err = unpopulate(val, "FqdnTags", &a.FqdnTags)
			delete(rawMsg, key)
		case "httpHeadersToInsert":
			err = unpopulate(val, "HTTPHeadersToInsert", &a.HTTPHeadersToInsert)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &a.RuleType)
			delete(rawMsg, key)
		case "sourceAddresses":
			err = unpopulate(val, "SourceAddresses", &a.SourceAddresses)
			delete(rawMsg, key)
		case "sourceIpGroups":
			err = unpopulate(val, "SourceIPGroups", &a.SourceIPGroups)
			delete(rawMsg, key)
		case "targetFqdns":
			err = unpopulate(val, "TargetFqdns", &a.TargetFqdns)
			delete(rawMsg, key)
		case "targetUrls":
			err = unpopulate(val, "TargetUrls", &a.TargetUrls)
			delete(rawMsg, key)
		case "terminateTLS":
			err = unpopulate(val, "TerminateTLS", &a.TerminateTLS)
			delete(rawMsg, key)
		case "webCategories":
			err = unpopulate(val, "WebCategories", &a.WebCategories)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationSecurityGroup.
func (a ApplicationSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationSecurityGroup.
func (a *ApplicationSecurityGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationSecurityGroupListResult.
func (a ApplicationSecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationSecurityGroupListResult.
func (a *ApplicationSecurityGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationSecurityGroupPropertiesFormat.
func (a ApplicationSecurityGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceGuid", a.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationSecurityGroupPropertiesFormat.
func (a *ApplicationSecurityGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &a.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationListResult.
func (a AuthorizationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationListResult.
func (a *AuthorizationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationPropertiesFormat.
func (a AuthorizationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationKey", a.AuthorizationKey)
	populate(objectMap, "authorizationUseStatus", a.AuthorizationUseStatus)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationPropertiesFormat.
func (a *AuthorizationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationKey":
			err = unpopulate(val, "AuthorizationKey", &a.AuthorizationKey)
			delete(rawMsg, key)
		case "authorizationUseStatus":
			err = unpopulate(val, "AuthorizationUseStatus", &a.AuthorizationUseStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoApprovedPrivateLinkService.
func (a AutoApprovedPrivateLinkService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateLinkService", a.PrivateLinkService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoApprovedPrivateLinkService.
func (a *AutoApprovedPrivateLinkService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateLinkService":
			err = unpopulate(val, "PrivateLinkService", &a.PrivateLinkService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoApprovedPrivateLinkServicesResult.
func (a AutoApprovedPrivateLinkServicesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoApprovedPrivateLinkServicesResult.
func (a *AutoApprovedPrivateLinkServicesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Availability.
func (a Availability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", a.BlobDuration)
	populate(objectMap, "retention", a.Retention)
	populate(objectMap, "timeGrain", a.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Availability.
func (a *Availability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &a.BlobDuration)
			delete(rawMsg, key)
		case "retention":
			err = unpopulate(val, "Retention", &a.Retention)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &a.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableDelegation.
func (a AvailableDelegation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", a.Actions)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "serviceName", a.ServiceName)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableDelegation.
func (a *AvailableDelegation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &a.Actions)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &a.ServiceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableDelegationsResult.
func (a AvailableDelegationsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableDelegationsResult.
func (a *AvailableDelegationsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailablePrivateEndpointType.
func (a AvailablePrivateEndpointType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "resourceName", a.ResourceName)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailablePrivateEndpointType.
func (a *AvailablePrivateEndpointType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &a.ResourceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailablePrivateEndpointTypesResult.
func (a AvailablePrivateEndpointTypesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailablePrivateEndpointTypesResult.
func (a *AvailablePrivateEndpointTypesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableProvidersList.
func (a AvailableProvidersList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "countries", a.Countries)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableProvidersList.
func (a *AvailableProvidersList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "countries":
			err = unpopulate(val, "Countries", &a.Countries)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableProvidersListCity.
func (a AvailableProvidersListCity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cityName", a.CityName)
	populate(objectMap, "providers", a.Providers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableProvidersListCity.
func (a *AvailableProvidersListCity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cityName":
			err = unpopulate(val, "CityName", &a.CityName)
			delete(rawMsg, key)
		case "providers":
			err = unpopulate(val, "Providers", &a.Providers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableProvidersListCountry.
func (a AvailableProvidersListCountry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "countryName", a.CountryName)
	populate(objectMap, "providers", a.Providers)
	populate(objectMap, "states", a.States)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableProvidersListCountry.
func (a *AvailableProvidersListCountry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "countryName":
			err = unpopulate(val, "CountryName", &a.CountryName)
			delete(rawMsg, key)
		case "providers":
			err = unpopulate(val, "Providers", &a.Providers)
			delete(rawMsg, key)
		case "states":
			err = unpopulate(val, "States", &a.States)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableProvidersListParameters.
func (a AvailableProvidersListParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureLocations", a.AzureLocations)
	populate(objectMap, "city", a.City)
	populate(objectMap, "country", a.Country)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableProvidersListParameters.
func (a *AvailableProvidersListParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureLocations":
			err = unpopulate(val, "AzureLocations", &a.AzureLocations)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &a.City)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &a.Country)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableProvidersListState.
func (a AvailableProvidersListState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cities", a.Cities)
	populate(objectMap, "providers", a.Providers)
	populate(objectMap, "stateName", a.StateName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableProvidersListState.
func (a *AvailableProvidersListState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cities":
			err = unpopulate(val, "Cities", &a.Cities)
			delete(rawMsg, key)
		case "providers":
			err = unpopulate(val, "Providers", &a.Providers)
			delete(rawMsg, key)
		case "stateName":
			err = unpopulate(val, "StateName", &a.StateName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableServiceAlias.
func (a AvailableServiceAlias) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "resourceName", a.ResourceName)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableServiceAlias.
func (a *AvailableServiceAlias) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &a.ResourceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableServiceAliasesResult.
func (a AvailableServiceAliasesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableServiceAliasesResult.
func (a *AvailableServiceAliasesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureAsyncOperationResult.
func (a AzureAsyncOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureAsyncOperationResult.
func (a *AzureAsyncOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewall.
func (a AzureFirewall) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "zones", a.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewall.
func (a *AzureFirewall) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &a.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallApplicationRule.
func (a AzureFirewallApplicationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "fqdnTags", a.FqdnTags)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "sourceAddresses", a.SourceAddresses)
	populate(objectMap, "sourceIpGroups", a.SourceIPGroups)
	populate(objectMap, "targetFqdns", a.TargetFqdns)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallApplicationRule.
func (a *AzureFirewallApplicationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "fqdnTags":
			err = unpopulate(val, "FqdnTags", &a.FqdnTags)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "sourceAddresses":
			err = unpopulate(val, "SourceAddresses", &a.SourceAddresses)
			delete(rawMsg, key)
		case "sourceIpGroups":
			err = unpopulate(val, "SourceIPGroups", &a.SourceIPGroups)
			delete(rawMsg, key)
		case "targetFqdns":
			err = unpopulate(val, "TargetFqdns", &a.TargetFqdns)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallApplicationRuleCollection.
func (a AzureFirewallApplicationRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallApplicationRuleCollection.
func (a *AzureFirewallApplicationRuleCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallApplicationRuleCollectionPropertiesFormat.
func (a AzureFirewallApplicationRuleCollectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", a.Action)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "rules", a.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallApplicationRuleCollectionPropertiesFormat.
func (a *AzureFirewallApplicationRuleCollectionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &a.Action)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &a.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallApplicationRuleProtocol.
func (a AzureFirewallApplicationRuleProtocol) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", a.Port)
	populate(objectMap, "protocolType", a.ProtocolType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallApplicationRuleProtocol.
func (a *AzureFirewallApplicationRuleProtocol) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "protocolType":
			err = unpopulate(val, "ProtocolType", &a.ProtocolType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallFqdnTag.
func (a AzureFirewallFqdnTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallFqdnTag.
func (a *AzureFirewallFqdnTag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallFqdnTagListResult.
func (a AzureFirewallFqdnTagListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallFqdnTagListResult.
func (a *AzureFirewallFqdnTagListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallFqdnTagPropertiesFormat.
func (a AzureFirewallFqdnTagPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdnTagName", a.FqdnTagName)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallFqdnTagPropertiesFormat.
func (a *AzureFirewallFqdnTagPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdnTagName":
			err = unpopulate(val, "FqdnTagName", &a.FqdnTagName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallIPConfiguration.
func (a AzureFirewallIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallIPConfiguration.
func (a *AzureFirewallIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallIPConfigurationPropertiesFormat.
func (a AzureFirewallIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAddress", a.PrivateIPAddress)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "publicIPAddress", a.PublicIPAddress)
	populate(objectMap, "subnet", a.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallIPConfigurationPropertiesFormat.
func (a *AzureFirewallIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &a.PrivateIPAddress)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &a.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &a.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallIPGroups.
func (a AzureFirewallIPGroups) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "changeNumber", a.ChangeNumber)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallIPGroups.
func (a *AzureFirewallIPGroups) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changeNumber":
			err = unpopulate(val, "ChangeNumber", &a.ChangeNumber)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallListResult.
func (a AzureFirewallListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallListResult.
func (a *AzureFirewallListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallNatRCAction.
func (a AzureFirewallNatRCAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallNatRCAction.
func (a *AzureFirewallNatRCAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallNatRule.
func (a AzureFirewallNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "destinationAddresses", a.DestinationAddresses)
	populate(objectMap, "destinationPorts", a.DestinationPorts)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "sourceAddresses", a.SourceAddresses)
	populate(objectMap, "sourceIpGroups", a.SourceIPGroups)
	populate(objectMap, "translatedAddress", a.TranslatedAddress)
	populate(objectMap, "translatedFqdn", a.TranslatedFqdn)
	populate(objectMap, "translatedPort", a.TranslatedPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallNatRule.
func (a *AzureFirewallNatRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "destinationAddresses":
			err = unpopulate(val, "DestinationAddresses", &a.DestinationAddresses)
			delete(rawMsg, key)
		case "destinationPorts":
			err = unpopulate(val, "DestinationPorts", &a.DestinationPorts)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "sourceAddresses":
			err = unpopulate(val, "SourceAddresses", &a.SourceAddresses)
			delete(rawMsg, key)
		case "sourceIpGroups":
			err = unpopulate(val, "SourceIPGroups", &a.SourceIPGroups)
			delete(rawMsg, key)
		case "translatedAddress":
			err = unpopulate(val, "TranslatedAddress", &a.TranslatedAddress)
			delete(rawMsg, key)
		case "translatedFqdn":
			err = unpopulate(val, "TranslatedFqdn", &a.TranslatedFqdn)
			delete(rawMsg, key)
		case "translatedPort":
			err = unpopulate(val, "TranslatedPort", &a.TranslatedPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallNatRuleCollection.
func (a AzureFirewallNatRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallNatRuleCollection.
func (a *AzureFirewallNatRuleCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallNatRuleCollectionProperties.
func (a AzureFirewallNatRuleCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", a.Action)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "rules", a.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallNatRuleCollectionProperties.
func (a *AzureFirewallNatRuleCollectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &a.Action)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &a.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallNetworkRule.
func (a AzureFirewallNetworkRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "destinationAddresses", a.DestinationAddresses)
	populate(objectMap, "destinationFqdns", a.DestinationFqdns)
	populate(objectMap, "destinationIpGroups", a.DestinationIPGroups)
	populate(objectMap, "destinationPorts", a.DestinationPorts)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "protocols", a.Protocols)
	populate(objectMap, "sourceAddresses", a.SourceAddresses)
	populate(objectMap, "sourceIpGroups", a.SourceIPGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallNetworkRule.
func (a *AzureFirewallNetworkRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "destinationAddresses":
			err = unpopulate(val, "DestinationAddresses", &a.DestinationAddresses)
			delete(rawMsg, key)
		case "destinationFqdns":
			err = unpopulate(val, "DestinationFqdns", &a.DestinationFqdns)
			delete(rawMsg, key)
		case "destinationIpGroups":
			err = unpopulate(val, "DestinationIPGroups", &a.DestinationIPGroups)
			delete(rawMsg, key)
		case "destinationPorts":
			err = unpopulate(val, "DestinationPorts", &a.DestinationPorts)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &a.Protocols)
			delete(rawMsg, key)
		case "sourceAddresses":
			err = unpopulate(val, "SourceAddresses", &a.SourceAddresses)
			delete(rawMsg, key)
		case "sourceIpGroups":
			err = unpopulate(val, "SourceIPGroups", &a.SourceIPGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallNetworkRuleCollection.
func (a AzureFirewallNetworkRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallNetworkRuleCollection.
func (a *AzureFirewallNetworkRuleCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallNetworkRuleCollectionPropertiesFormat.
func (a AzureFirewallNetworkRuleCollectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", a.Action)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "rules", a.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallNetworkRuleCollectionPropertiesFormat.
func (a *AzureFirewallNetworkRuleCollectionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &a.Action)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &a.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallPacketCaptureFlags.
func (a AzureFirewallPacketCaptureFlags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallPacketCaptureFlags.
func (a *AzureFirewallPacketCaptureFlags) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallPacketCaptureRule.
func (a AzureFirewallPacketCaptureRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationPorts", a.DestinationPorts)
	populate(objectMap, "destinations", a.Destinations)
	populate(objectMap, "sources", a.Sources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallPacketCaptureRule.
func (a *AzureFirewallPacketCaptureRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationPorts":
			err = unpopulate(val, "DestinationPorts", &a.DestinationPorts)
			delete(rawMsg, key)
		case "destinations":
			err = unpopulate(val, "Destinations", &a.Destinations)
			delete(rawMsg, key)
		case "sources":
			err = unpopulate(val, "Sources", &a.Sources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallPropertiesFormat.
func (a AzureFirewallPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalProperties", a.AdditionalProperties)
	populate(objectMap, "applicationRuleCollections", a.ApplicationRuleCollections)
	populate(objectMap, "firewallPolicy", a.FirewallPolicy)
	populate(objectMap, "hubIPAddresses", a.HubIPAddresses)
	populate(objectMap, "ipConfigurations", a.IPConfigurations)
	populate(objectMap, "ipGroups", a.IPGroups)
	populate(objectMap, "managementIpConfiguration", a.ManagementIPConfiguration)
	populate(objectMap, "natRuleCollections", a.NatRuleCollections)
	populate(objectMap, "networkRuleCollections", a.NetworkRuleCollections)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "threatIntelMode", a.ThreatIntelMode)
	populate(objectMap, "virtualHub", a.VirtualHub)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallPropertiesFormat.
func (a *AzureFirewallPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalProperties":
			err = unpopulate(val, "AdditionalProperties", &a.AdditionalProperties)
			delete(rawMsg, key)
		case "applicationRuleCollections":
			err = unpopulate(val, "ApplicationRuleCollections", &a.ApplicationRuleCollections)
			delete(rawMsg, key)
		case "firewallPolicy":
			err = unpopulate(val, "FirewallPolicy", &a.FirewallPolicy)
			delete(rawMsg, key)
		case "hubIPAddresses":
			err = unpopulate(val, "HubIPAddresses", &a.HubIPAddresses)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &a.IPConfigurations)
			delete(rawMsg, key)
		case "ipGroups":
			err = unpopulate(val, "IPGroups", &a.IPGroups)
			delete(rawMsg, key)
		case "managementIpConfiguration":
			err = unpopulate(val, "ManagementIPConfiguration", &a.ManagementIPConfiguration)
			delete(rawMsg, key)
		case "natRuleCollections":
			err = unpopulate(val, "NatRuleCollections", &a.NatRuleCollections)
			delete(rawMsg, key)
		case "networkRuleCollections":
			err = unpopulate(val, "NetworkRuleCollections", &a.NetworkRuleCollections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "threatIntelMode":
			err = unpopulate(val, "ThreatIntelMode", &a.ThreatIntelMode)
			delete(rawMsg, key)
		case "virtualHub":
			err = unpopulate(val, "VirtualHub", &a.VirtualHub)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallPublicIPAddress.
func (a AzureFirewallPublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", a.Address)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallPublicIPAddress.
func (a *AzureFirewallPublicIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &a.Address)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallRCAction.
func (a AzureFirewallRCAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallRCAction.
func (a *AzureFirewallRCAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFirewallSKU.
func (a AzureFirewallSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "tier", a.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFirewallSKU.
func (a *AzureFirewallSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &a.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureReachabilityReport.
func (a AzureReachabilityReport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationLevel", a.AggregationLevel)
	populate(objectMap, "providerLocation", a.ProviderLocation)
	populate(objectMap, "reachabilityReport", a.ReachabilityReport)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureReachabilityReport.
func (a *AzureReachabilityReport) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationLevel":
			err = unpopulate(val, "AggregationLevel", &a.AggregationLevel)
			delete(rawMsg, key)
		case "providerLocation":
			err = unpopulate(val, "ProviderLocation", &a.ProviderLocation)
			delete(rawMsg, key)
		case "reachabilityReport":
			err = unpopulate(val, "ReachabilityReport", &a.ReachabilityReport)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureReachabilityReportItem.
func (a AzureReachabilityReportItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureLocation", a.AzureLocation)
	populate(objectMap, "latencies", a.Latencies)
	populate(objectMap, "provider", a.Provider)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureReachabilityReportItem.
func (a *AzureReachabilityReportItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureLocation":
			err = unpopulate(val, "AzureLocation", &a.AzureLocation)
			delete(rawMsg, key)
		case "latencies":
			err = unpopulate(val, "Latencies", &a.Latencies)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &a.Provider)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureReachabilityReportLatencyInfo.
func (a AzureReachabilityReportLatencyInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "score", a.Score)
	populateDateTimeRFC3339(objectMap, "timeStamp", a.TimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureReachabilityReportLatencyInfo.
func (a *AzureReachabilityReportLatencyInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "score":
			err = unpopulate(val, "Score", &a.Score)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateDateTimeRFC3339(val, "TimeStamp", &a.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureReachabilityReportLocation.
func (a AzureReachabilityReportLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "city", a.City)
	populate(objectMap, "country", a.Country)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureReachabilityReportLocation.
func (a *AzureReachabilityReportLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "city":
			err = unpopulate(val, "City", &a.City)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &a.Country)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureReachabilityReportParameters.
func (a AzureReachabilityReportParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureLocations", a.AzureLocations)
	populateDateTimeRFC3339(objectMap, "endTime", a.EndTime)
	populate(objectMap, "providerLocation", a.ProviderLocation)
	populate(objectMap, "providers", a.Providers)
	populateDateTimeRFC3339(objectMap, "startTime", a.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureReachabilityReportParameters.
func (a *AzureReachabilityReportParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureLocations":
			err = unpopulate(val, "AzureLocations", &a.AzureLocations)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "providerLocation":
			err = unpopulate(val, "ProviderLocation", &a.ProviderLocation)
			delete(rawMsg, key)
		case "providers":
			err = unpopulate(val, "Providers", &a.Providers)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWebCategory.
func (a AzureWebCategory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWebCategory.
func (a *AzureWebCategory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWebCategoryListResult.
func (a AzureWebCategoryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWebCategoryListResult.
func (a *AzureWebCategoryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureWebCategoryPropertiesFormat.
func (a AzureWebCategoryPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "group", a.Group)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureWebCategoryPropertiesFormat.
func (a *AzureWebCategoryPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "group":
			err = unpopulate(val, "Group", &a.Group)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BGPCommunity.
func (b BGPCommunity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "communityName", b.CommunityName)
	populate(objectMap, "communityPrefixes", b.CommunityPrefixes)
	populate(objectMap, "communityValue", b.CommunityValue)
	populate(objectMap, "isAuthorizedToUse", b.IsAuthorizedToUse)
	populate(objectMap, "serviceGroup", b.ServiceGroup)
	populate(objectMap, "serviceSupportedRegion", b.ServiceSupportedRegion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BGPCommunity.
func (b *BGPCommunity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communityName":
			err = unpopulate(val, "CommunityName", &b.CommunityName)
			delete(rawMsg, key)
		case "communityPrefixes":
			err = unpopulate(val, "CommunityPrefixes", &b.CommunityPrefixes)
			delete(rawMsg, key)
		case "communityValue":
			err = unpopulate(val, "CommunityValue", &b.CommunityValue)
			delete(rawMsg, key)
		case "isAuthorizedToUse":
			err = unpopulate(val, "IsAuthorizedToUse", &b.IsAuthorizedToUse)
			delete(rawMsg, key)
		case "serviceGroup":
			err = unpopulate(val, "ServiceGroup", &b.ServiceGroup)
			delete(rawMsg, key)
		case "serviceSupportedRegion":
			err = unpopulate(val, "ServiceSupportedRegion", &b.ServiceSupportedRegion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendAddressInboundNatRulePortMappings.
func (b BackendAddressInboundNatRulePortMappings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inboundNatRulePortMappings", b.InboundNatRulePortMappings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendAddressInboundNatRulePortMappings.
func (b *BackendAddressInboundNatRulePortMappings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inboundNatRulePortMappings":
			err = unpopulate(val, "InboundNatRulePortMappings", &b.InboundNatRulePortMappings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendAddressPool.
func (b BackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendAddressPool.
func (b *BackendAddressPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendAddressPoolPropertiesFormat.
func (b BackendAddressPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendIPConfigurations", b.BackendIPConfigurations)
	populate(objectMap, "drainPeriodInSeconds", b.DrainPeriodInSeconds)
	populate(objectMap, "inboundNatRules", b.InboundNatRules)
	populate(objectMap, "loadBalancerBackendAddresses", b.LoadBalancerBackendAddresses)
	populate(objectMap, "loadBalancingRules", b.LoadBalancingRules)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "outboundRule", b.OutboundRule)
	populate(objectMap, "outboundRules", b.OutboundRules)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "syncMode", b.SyncMode)
	populate(objectMap, "tunnelInterfaces", b.TunnelInterfaces)
	populate(objectMap, "virtualNetwork", b.VirtualNetwork)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendAddressPoolPropertiesFormat.
func (b *BackendAddressPoolPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendIPConfigurations":
			err = unpopulate(val, "BackendIPConfigurations", &b.BackendIPConfigurations)
			delete(rawMsg, key)
		case "drainPeriodInSeconds":
			err = unpopulate(val, "DrainPeriodInSeconds", &b.DrainPeriodInSeconds)
			delete(rawMsg, key)
		case "inboundNatRules":
			err = unpopulate(val, "InboundNatRules", &b.InboundNatRules)
			delete(rawMsg, key)
		case "loadBalancerBackendAddresses":
			err = unpopulate(val, "LoadBalancerBackendAddresses", &b.LoadBalancerBackendAddresses)
			delete(rawMsg, key)
		case "loadBalancingRules":
			err = unpopulate(val, "LoadBalancingRules", &b.LoadBalancingRules)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "outboundRule":
			err = unpopulate(val, "OutboundRule", &b.OutboundRule)
			delete(rawMsg, key)
		case "outboundRules":
			err = unpopulate(val, "OutboundRules", &b.OutboundRules)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &b.SyncMode)
			delete(rawMsg, key)
		case "tunnelInterfaces":
			err = unpopulate(val, "TunnelInterfaces", &b.TunnelInterfaces)
			delete(rawMsg, key)
		case "virtualNetwork":
			err = unpopulate(val, "VirtualNetwork", &b.VirtualNetwork)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BaseAdminRule.
func (b BaseAdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	objectMap["kind"] = b.Kind
	populate(objectMap, "name", b.Name)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaseAdminRule.
func (b *BaseAdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionActiveSession.
func (b BastionActiveSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "protocol", b.Protocol)
	populate(objectMap, "resourceType", b.ResourceType)
	populate(objectMap, "sessionDurationInMins", b.SessionDurationInMins)
	populate(objectMap, "sessionId", b.SessionID)
	populateAny(objectMap, "startTime", b.StartTime)
	populate(objectMap, "targetHostName", b.TargetHostName)
	populate(objectMap, "targetIpAddress", b.TargetIPAddress)
	populate(objectMap, "targetResourceGroup", b.TargetResourceGroup)
	populate(objectMap, "targetResourceId", b.TargetResourceID)
	populate(objectMap, "targetSubscriptionId", b.TargetSubscriptionID)
	populate(objectMap, "userName", b.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionActiveSession.
func (b *BastionActiveSession) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protocol":
			err = unpopulate(val, "Protocol", &b.Protocol)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &b.ResourceType)
			delete(rawMsg, key)
		case "sessionDurationInMins":
			err = unpopulate(val, "SessionDurationInMins", &b.SessionDurationInMins)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &b.SessionID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &b.StartTime)
			delete(rawMsg, key)
		case "targetHostName":
			err = unpopulate(val, "TargetHostName", &b.TargetHostName)
			delete(rawMsg, key)
		case "targetIpAddress":
			err = unpopulate(val, "TargetIPAddress", &b.TargetIPAddress)
			delete(rawMsg, key)
		case "targetResourceGroup":
			err = unpopulate(val, "TargetResourceGroup", &b.TargetResourceGroup)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &b.TargetResourceID)
			delete(rawMsg, key)
		case "targetSubscriptionId":
			err = unpopulate(val, "TargetSubscriptionID", &b.TargetSubscriptionID)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &b.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionActiveSessionListResult.
func (b BastionActiveSessionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionActiveSessionListResult.
func (b *BastionActiveSessionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionHost.
func (b BastionHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "sku", b.SKU)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionHost.
func (b *BastionHost) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &b.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionHostIPConfiguration.
func (b BastionHostIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionHostIPConfiguration.
func (b *BastionHostIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionHostIPConfigurationPropertiesFormat.
func (b BastionHostIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAllocationMethod", b.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "publicIPAddress", b.PublicIPAddress)
	populate(objectMap, "subnet", b.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionHostIPConfigurationPropertiesFormat.
func (b *BastionHostIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &b.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &b.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &b.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionHostListResult.
func (b BastionHostListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionHostListResult.
func (b *BastionHostListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionHostPropertiesFormat.
func (b BastionHostPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsName", b.DNSName)
	populate(objectMap, "disableCopyPaste", b.DisableCopyPaste)
	populate(objectMap, "enableFileCopy", b.EnableFileCopy)
	populate(objectMap, "enableIpConnect", b.EnableIPConnect)
	populate(objectMap, "enableKerberos", b.EnableKerberos)
	populate(objectMap, "enableShareableLink", b.EnableShareableLink)
	populate(objectMap, "enableTunneling", b.EnableTunneling)
	populate(objectMap, "ipConfigurations", b.IPConfigurations)
	populate(objectMap, "networkAcls", b.NetworkACLs)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "scaleUnits", b.ScaleUnits)
	populate(objectMap, "virtualNetwork", b.VirtualNetwork)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionHostPropertiesFormat.
func (b *BastionHostPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsName":
			err = unpopulate(val, "DNSName", &b.DNSName)
			delete(rawMsg, key)
		case "disableCopyPaste":
			err = unpopulate(val, "DisableCopyPaste", &b.DisableCopyPaste)
			delete(rawMsg, key)
		case "enableFileCopy":
			err = unpopulate(val, "EnableFileCopy", &b.EnableFileCopy)
			delete(rawMsg, key)
		case "enableIpConnect":
			err = unpopulate(val, "EnableIPConnect", &b.EnableIPConnect)
			delete(rawMsg, key)
		case "enableKerberos":
			err = unpopulate(val, "EnableKerberos", &b.EnableKerberos)
			delete(rawMsg, key)
		case "enableShareableLink":
			err = unpopulate(val, "EnableShareableLink", &b.EnableShareableLink)
			delete(rawMsg, key)
		case "enableTunneling":
			err = unpopulate(val, "EnableTunneling", &b.EnableTunneling)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &b.IPConfigurations)
			delete(rawMsg, key)
		case "networkAcls":
			err = unpopulate(val, "NetworkACLs", &b.NetworkACLs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "scaleUnits":
			err = unpopulate(val, "ScaleUnits", &b.ScaleUnits)
			delete(rawMsg, key)
		case "virtualNetwork":
			err = unpopulate(val, "VirtualNetwork", &b.VirtualNetwork)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionHostPropertiesFormatNetworkACLs.
func (b BastionHostPropertiesFormatNetworkACLs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipRules", b.IPRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionHostPropertiesFormatNetworkACLs.
func (b *BastionHostPropertiesFormatNetworkACLs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipRules":
			err = unpopulate(val, "IPRules", &b.IPRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionSessionDeleteResult.
func (b BastionSessionDeleteResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionSessionDeleteResult.
func (b *BastionSessionDeleteResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionSessionState.
func (b BastionSessionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", b.Message)
	populate(objectMap, "sessionId", b.SessionID)
	populate(objectMap, "state", b.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionSessionState.
func (b *BastionSessionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &b.Message)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &b.SessionID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &b.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionShareableLink.
func (b BastionShareableLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bsl", b.Bsl)
	populate(objectMap, "createdAt", b.CreatedAt)
	populate(objectMap, "message", b.Message)
	populate(objectMap, "vm", b.VM)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionShareableLink.
func (b *BastionShareableLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bsl":
			err = unpopulate(val, "Bsl", &b.Bsl)
			delete(rawMsg, key)
		case "createdAt":
			err = unpopulate(val, "CreatedAt", &b.CreatedAt)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &b.Message)
			delete(rawMsg, key)
		case "vm":
			err = unpopulate(val, "VM", &b.VM)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionShareableLinkListRequest.
func (b BastionShareableLinkListRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vms", b.VMs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionShareableLinkListRequest.
func (b *BastionShareableLinkListRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vms":
			err = unpopulate(val, "VMs", &b.VMs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BastionShareableLinkListResult.
func (b BastionShareableLinkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BastionShareableLinkListResult.
func (b *BastionShareableLinkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpConnection.
func (b BgpConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpConnection.
func (b *BgpConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpConnectionProperties.
func (b BgpConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionState", b.ConnectionState)
	populate(objectMap, "hubVirtualNetworkConnection", b.HubVirtualNetworkConnection)
	populate(objectMap, "peerAsn", b.PeerAsn)
	populate(objectMap, "peerIp", b.PeerIP)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpConnectionProperties.
func (b *BgpConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionState":
			err = unpopulate(val, "ConnectionState", &b.ConnectionState)
			delete(rawMsg, key)
		case "hubVirtualNetworkConnection":
			err = unpopulate(val, "HubVirtualNetworkConnection", &b.HubVirtualNetworkConnection)
			delete(rawMsg, key)
		case "peerAsn":
			err = unpopulate(val, "PeerAsn", &b.PeerAsn)
			delete(rawMsg, key)
		case "peerIp":
			err = unpopulate(val, "PeerIP", &b.PeerIP)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpPeerStatus.
func (b BgpPeerStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asn", b.Asn)
	populate(objectMap, "connectedDuration", b.ConnectedDuration)
	populate(objectMap, "localAddress", b.LocalAddress)
	populate(objectMap, "messagesReceived", b.MessagesReceived)
	populate(objectMap, "messagesSent", b.MessagesSent)
	populate(objectMap, "neighbor", b.Neighbor)
	populate(objectMap, "routesReceived", b.RoutesReceived)
	populate(objectMap, "state", b.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpPeerStatus.
func (b *BgpPeerStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asn":
			err = unpopulate(val, "Asn", &b.Asn)
			delete(rawMsg, key)
		case "connectedDuration":
			err = unpopulate(val, "ConnectedDuration", &b.ConnectedDuration)
			delete(rawMsg, key)
		case "localAddress":
			err = unpopulate(val, "LocalAddress", &b.LocalAddress)
			delete(rawMsg, key)
		case "messagesReceived":
			err = unpopulate(val, "MessagesReceived", &b.MessagesReceived)
			delete(rawMsg, key)
		case "messagesSent":
			err = unpopulate(val, "MessagesSent", &b.MessagesSent)
			delete(rawMsg, key)
		case "neighbor":
			err = unpopulate(val, "Neighbor", &b.Neighbor)
			delete(rawMsg, key)
		case "routesReceived":
			err = unpopulate(val, "RoutesReceived", &b.RoutesReceived)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &b.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpPeerStatusListResult.
func (b BgpPeerStatusListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpPeerStatusListResult.
func (b *BgpPeerStatusListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpServiceCommunity.
func (b BgpServiceCommunity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpServiceCommunity.
func (b *BgpServiceCommunity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpServiceCommunityListResult.
func (b BgpServiceCommunityListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpServiceCommunityListResult.
func (b *BgpServiceCommunityListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpServiceCommunityPropertiesFormat.
func (b BgpServiceCommunityPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bgpCommunities", b.BgpCommunities)
	populate(objectMap, "serviceName", b.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpServiceCommunityPropertiesFormat.
func (b *BgpServiceCommunityPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bgpCommunities":
			err = unpopulate(val, "BgpCommunities", &b.BgpCommunities)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &b.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpSettings.
func (b BgpSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asn", b.Asn)
	populate(objectMap, "bgpPeeringAddress", b.BgpPeeringAddress)
	populate(objectMap, "bgpPeeringAddresses", b.BgpPeeringAddresses)
	populate(objectMap, "peerWeight", b.PeerWeight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpSettings.
func (b *BgpSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asn":
			err = unpopulate(val, "Asn", &b.Asn)
			delete(rawMsg, key)
		case "bgpPeeringAddress":
			err = unpopulate(val, "BgpPeeringAddress", &b.BgpPeeringAddress)
			delete(rawMsg, key)
		case "bgpPeeringAddresses":
			err = unpopulate(val, "BgpPeeringAddresses", &b.BgpPeeringAddresses)
			delete(rawMsg, key)
		case "peerWeight":
			err = unpopulate(val, "PeerWeight", &b.PeerWeight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BreakOutCategoryPolicies.
func (b BreakOutCategoryPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allow", b.Allow)
	populate(objectMap, "default", b.Default)
	populate(objectMap, "optimize", b.Optimize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BreakOutCategoryPolicies.
func (b *BreakOutCategoryPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allow":
			err = unpopulate(val, "Allow", &b.Allow)
			delete(rawMsg, key)
		case "default":
			err = unpopulate(val, "Default", &b.Default)
			delete(rawMsg, key)
		case "optimize":
			err = unpopulate(val, "Optimize", &b.Optimize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckPrivateLinkServiceVisibilityRequest.
func (c CheckPrivateLinkServiceVisibilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateLinkServiceAlias", c.PrivateLinkServiceAlias)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckPrivateLinkServiceVisibilityRequest.
func (c *CheckPrivateLinkServiceVisibilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateLinkServiceAlias":
			err = unpopulate(val, "PrivateLinkServiceAlias", &c.PrivateLinkServiceAlias)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChildResource.
func (c ChildResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChildResource.
func (c *ChildResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "principalId", c.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c *Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &c.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationDiagnosticParameters.
func (c ConfigurationDiagnosticParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "profiles", c.Profiles)
	populate(objectMap, "targetResourceId", c.TargetResourceID)
	populate(objectMap, "verbosityLevel", c.VerbosityLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationDiagnosticParameters.
func (c *ConfigurationDiagnosticParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "profiles":
			err = unpopulate(val, "Profiles", &c.Profiles)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &c.TargetResourceID)
			delete(rawMsg, key)
		case "verbosityLevel":
			err = unpopulate(val, "VerbosityLevel", &c.VerbosityLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationDiagnosticProfile.
func (c ConfigurationDiagnosticProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", c.Destination)
	populate(objectMap, "destinationPort", c.DestinationPort)
	populate(objectMap, "direction", c.Direction)
	populate(objectMap, "protocol", c.Protocol)
	populate(objectMap, "source", c.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationDiagnosticProfile.
func (c *ConfigurationDiagnosticProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &c.Destination)
			delete(rawMsg, key)
		case "destinationPort":
			err = unpopulate(val, "DestinationPort", &c.DestinationPort)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &c.Direction)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &c.Protocol)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationDiagnosticResponse.
func (c ConfigurationDiagnosticResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "results", c.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationDiagnosticResponse.
func (c *ConfigurationDiagnosticResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "results":
			err = unpopulate(val, "Results", &c.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationDiagnosticResult.
func (c ConfigurationDiagnosticResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkSecurityGroupResult", c.NetworkSecurityGroupResult)
	populate(objectMap, "profile", c.Profile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationDiagnosticResult.
func (c *ConfigurationDiagnosticResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkSecurityGroupResult":
			err = unpopulate(val, "NetworkSecurityGroupResult", &c.NetworkSecurityGroupResult)
			delete(rawMsg, key)
		case "profile":
			err = unpopulate(val, "Profile", &c.Profile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationGroup.
func (c ConfigurationGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationGroup.
func (c *ConfigurationGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitor.
func (c ConnectionMonitor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitor.
func (c *ConnectionMonitor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorDestination.
func (c ConnectionMonitorDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", c.Address)
	populate(objectMap, "port", c.Port)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorDestination.
func (c *ConnectionMonitorDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &c.Address)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorEndpoint.
func (c ConnectionMonitorEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", c.Address)
	populate(objectMap, "coverageLevel", c.CoverageLevel)
	populate(objectMap, "filter", c.Filter)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "resourceId", c.ResourceID)
	populate(objectMap, "scope", c.Scope)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorEndpoint.
func (c *ConnectionMonitorEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &c.Address)
			delete(rawMsg, key)
		case "coverageLevel":
			err = unpopulate(val, "CoverageLevel", &c.CoverageLevel)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &c.Filter)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &c.Scope)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorEndpointFilter.
func (c ConnectionMonitorEndpointFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "items", c.Items)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorEndpointFilter.
func (c *ConnectionMonitorEndpointFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "items":
			err = unpopulate(val, "Items", &c.Items)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorEndpointFilterItem.
func (c ConnectionMonitorEndpointFilterItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", c.Address)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorEndpointFilterItem.
func (c *ConnectionMonitorEndpointFilterItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &c.Address)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorEndpointScope.
func (c ConnectionMonitorEndpointScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exclude", c.Exclude)
	populate(objectMap, "include", c.Include)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorEndpointScope.
func (c *ConnectionMonitorEndpointScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exclude":
			err = unpopulate(val, "Exclude", &c.Exclude)
			delete(rawMsg, key)
		case "include":
			err = unpopulate(val, "Include", &c.Include)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorEndpointScopeItem.
func (c ConnectionMonitorEndpointScopeItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", c.Address)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorEndpointScopeItem.
func (c *ConnectionMonitorEndpointScopeItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &c.Address)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorHTTPConfiguration.
func (c ConnectionMonitorHTTPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "method", c.Method)
	populate(objectMap, "path", c.Path)
	populate(objectMap, "port", c.Port)
	populate(objectMap, "preferHTTPS", c.PreferHTTPS)
	populate(objectMap, "requestHeaders", c.RequestHeaders)
	populate(objectMap, "validStatusCodeRanges", c.ValidStatusCodeRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorHTTPConfiguration.
func (c *ConnectionMonitorHTTPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "method":
			err = unpopulate(val, "Method", &c.Method)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &c.Path)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "preferHTTPS":
			err = unpopulate(val, "PreferHTTPS", &c.PreferHTTPS)
			delete(rawMsg, key)
		case "requestHeaders":
			err = unpopulate(val, "RequestHeaders", &c.RequestHeaders)
			delete(rawMsg, key)
		case "validStatusCodeRanges":
			err = unpopulate(val, "ValidStatusCodeRanges", &c.ValidStatusCodeRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorIcmpConfiguration.
func (c ConnectionMonitorIcmpConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableTraceRoute", c.DisableTraceRoute)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorIcmpConfiguration.
func (c *ConnectionMonitorIcmpConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableTraceRoute":
			err = unpopulate(val, "DisableTraceRoute", &c.DisableTraceRoute)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorListResult.
func (c ConnectionMonitorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorListResult.
func (c *ConnectionMonitorListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorOutput.
func (c ConnectionMonitorOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "workspaceSettings", c.WorkspaceSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorOutput.
func (c *ConnectionMonitorOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "workspaceSettings":
			err = unpopulate(val, "WorkspaceSettings", &c.WorkspaceSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorParameters.
func (c ConnectionMonitorParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoStart", c.AutoStart)
	populate(objectMap, "destination", c.Destination)
	populate(objectMap, "endpoints", c.Endpoints)
	populate(objectMap, "monitoringIntervalInSeconds", c.MonitoringIntervalInSeconds)
	populate(objectMap, "notes", c.Notes)
	populate(objectMap, "outputs", c.Outputs)
	populate(objectMap, "source", c.Source)
	populate(objectMap, "testConfigurations", c.TestConfigurations)
	populate(objectMap, "testGroups", c.TestGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorParameters.
func (c *ConnectionMonitorParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoStart":
			err = unpopulate(val, "AutoStart", &c.AutoStart)
			delete(rawMsg, key)
		case "destination":
			err = unpopulate(val, "Destination", &c.Destination)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &c.Endpoints)
			delete(rawMsg, key)
		case "monitoringIntervalInSeconds":
			err = unpopulate(val, "MonitoringIntervalInSeconds", &c.MonitoringIntervalInSeconds)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &c.Notes)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &c.Outputs)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		case "testConfigurations":
			err = unpopulate(val, "TestConfigurations", &c.TestConfigurations)
			delete(rawMsg, key)
		case "testGroups":
			err = unpopulate(val, "TestGroups", &c.TestGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorQueryResult.
func (c ConnectionMonitorQueryResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceStatus", c.SourceStatus)
	populate(objectMap, "states", c.States)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorQueryResult.
func (c *ConnectionMonitorQueryResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceStatus":
			err = unpopulate(val, "SourceStatus", &c.SourceStatus)
			delete(rawMsg, key)
		case "states":
			err = unpopulate(val, "States", &c.States)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorResult.
func (c ConnectionMonitorResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorResult.
func (c *ConnectionMonitorResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorResultProperties.
func (c ConnectionMonitorResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoStart", c.AutoStart)
	populate(objectMap, "connectionMonitorType", c.ConnectionMonitorType)
	populate(objectMap, "destination", c.Destination)
	populate(objectMap, "endpoints", c.Endpoints)
	populate(objectMap, "monitoringIntervalInSeconds", c.MonitoringIntervalInSeconds)
	populate(objectMap, "monitoringStatus", c.MonitoringStatus)
	populate(objectMap, "notes", c.Notes)
	populate(objectMap, "outputs", c.Outputs)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "source", c.Source)
	populateDateTimeRFC3339(objectMap, "startTime", c.StartTime)
	populate(objectMap, "testConfigurations", c.TestConfigurations)
	populate(objectMap, "testGroups", c.TestGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorResultProperties.
func (c *ConnectionMonitorResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoStart":
			err = unpopulate(val, "AutoStart", &c.AutoStart)
			delete(rawMsg, key)
		case "connectionMonitorType":
			err = unpopulate(val, "ConnectionMonitorType", &c.ConnectionMonitorType)
			delete(rawMsg, key)
		case "destination":
			err = unpopulate(val, "Destination", &c.Destination)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &c.Endpoints)
			delete(rawMsg, key)
		case "monitoringIntervalInSeconds":
			err = unpopulate(val, "MonitoringIntervalInSeconds", &c.MonitoringIntervalInSeconds)
			delete(rawMsg, key)
		case "monitoringStatus":
			err = unpopulate(val, "MonitoringStatus", &c.MonitoringStatus)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &c.Notes)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &c.Outputs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		case "testConfigurations":
			err = unpopulate(val, "TestConfigurations", &c.TestConfigurations)
			delete(rawMsg, key)
		case "testGroups":
			err = unpopulate(val, "TestGroups", &c.TestGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorSource.
func (c ConnectionMonitorSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", c.Port)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorSource.
func (c *ConnectionMonitorSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorSuccessThreshold.
func (c ConnectionMonitorSuccessThreshold) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "checksFailedPercent", c.ChecksFailedPercent)
	populate(objectMap, "roundTripTimeMs", c.RoundTripTimeMs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorSuccessThreshold.
func (c *ConnectionMonitorSuccessThreshold) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "checksFailedPercent":
			err = unpopulate(val, "ChecksFailedPercent", &c.ChecksFailedPercent)
			delete(rawMsg, key)
		case "roundTripTimeMs":
			err = unpopulate(val, "RoundTripTimeMs", &c.RoundTripTimeMs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorTCPConfiguration.
func (c ConnectionMonitorTCPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationPortBehavior", c.DestinationPortBehavior)
	populate(objectMap, "disableTraceRoute", c.DisableTraceRoute)
	populate(objectMap, "port", c.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorTCPConfiguration.
func (c *ConnectionMonitorTCPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationPortBehavior":
			err = unpopulate(val, "DestinationPortBehavior", &c.DestinationPortBehavior)
			delete(rawMsg, key)
		case "disableTraceRoute":
			err = unpopulate(val, "DisableTraceRoute", &c.DisableTraceRoute)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorTestConfiguration.
func (c ConnectionMonitorTestConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "httpConfiguration", c.HTTPConfiguration)
	populate(objectMap, "icmpConfiguration", c.IcmpConfiguration)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "preferredIPVersion", c.PreferredIPVersion)
	populate(objectMap, "protocol", c.Protocol)
	populate(objectMap, "successThreshold", c.SuccessThreshold)
	populate(objectMap, "tcpConfiguration", c.TCPConfiguration)
	populate(objectMap, "testFrequencySec", c.TestFrequencySec)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorTestConfiguration.
func (c *ConnectionMonitorTestConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpConfiguration":
			err = unpopulate(val, "HTTPConfiguration", &c.HTTPConfiguration)
			delete(rawMsg, key)
		case "icmpConfiguration":
			err = unpopulate(val, "IcmpConfiguration", &c.IcmpConfiguration)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "preferredIPVersion":
			err = unpopulate(val, "PreferredIPVersion", &c.PreferredIPVersion)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &c.Protocol)
			delete(rawMsg, key)
		case "successThreshold":
			err = unpopulate(val, "SuccessThreshold", &c.SuccessThreshold)
			delete(rawMsg, key)
		case "tcpConfiguration":
			err = unpopulate(val, "TCPConfiguration", &c.TCPConfiguration)
			delete(rawMsg, key)
		case "testFrequencySec":
			err = unpopulate(val, "TestFrequencySec", &c.TestFrequencySec)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorTestGroup.
func (c ConnectionMonitorTestGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinations", c.Destinations)
	populate(objectMap, "disable", c.Disable)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "sources", c.Sources)
	populate(objectMap, "testConfigurations", c.TestConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorTestGroup.
func (c *ConnectionMonitorTestGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinations":
			err = unpopulate(val, "Destinations", &c.Destinations)
			delete(rawMsg, key)
		case "disable":
			err = unpopulate(val, "Disable", &c.Disable)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "sources":
			err = unpopulate(val, "Sources", &c.Sources)
			delete(rawMsg, key)
		case "testConfigurations":
			err = unpopulate(val, "TestConfigurations", &c.TestConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionMonitorWorkspaceSettings.
func (c ConnectionMonitorWorkspaceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "workspaceResourceId", c.WorkspaceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionMonitorWorkspaceSettings.
func (c *ConnectionMonitorWorkspaceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "workspaceResourceId":
			err = unpopulate(val, "WorkspaceResourceID", &c.WorkspaceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionResetSharedKey.
func (c ConnectionResetSharedKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyLength", c.KeyLength)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionResetSharedKey.
func (c *ConnectionResetSharedKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyLength":
			err = unpopulate(val, "KeyLength", &c.KeyLength)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionSharedKey.
func (c ConnectionSharedKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionSharedKey.
func (c *ConnectionSharedKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionStateSnapshot.
func (c ConnectionStateSnapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "avgLatencyInMs", c.AvgLatencyInMs)
	populate(objectMap, "connectionState", c.ConnectionState)
	populateDateTimeRFC3339(objectMap, "endTime", c.EndTime)
	populate(objectMap, "evaluationState", c.EvaluationState)
	populate(objectMap, "hops", c.Hops)
	populate(objectMap, "maxLatencyInMs", c.MaxLatencyInMs)
	populate(objectMap, "minLatencyInMs", c.MinLatencyInMs)
	populate(objectMap, "probesFailed", c.ProbesFailed)
	populate(objectMap, "probesSent", c.ProbesSent)
	populateDateTimeRFC3339(objectMap, "startTime", c.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionStateSnapshot.
func (c *ConnectionStateSnapshot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "avgLatencyInMs":
			err = unpopulate(val, "AvgLatencyInMs", &c.AvgLatencyInMs)
			delete(rawMsg, key)
		case "connectionState":
			err = unpopulate(val, "ConnectionState", &c.ConnectionState)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &c.EndTime)
			delete(rawMsg, key)
		case "evaluationState":
			err = unpopulate(val, "EvaluationState", &c.EvaluationState)
			delete(rawMsg, key)
		case "hops":
			err = unpopulate(val, "Hops", &c.Hops)
			delete(rawMsg, key)
		case "maxLatencyInMs":
			err = unpopulate(val, "MaxLatencyInMs", &c.MaxLatencyInMs)
			delete(rawMsg, key)
		case "minLatencyInMs":
			err = unpopulate(val, "MinLatencyInMs", &c.MinLatencyInMs)
			delete(rawMsg, key)
		case "probesFailed":
			err = unpopulate(val, "ProbesFailed", &c.ProbesFailed)
			delete(rawMsg, key)
		case "probesSent":
			err = unpopulate(val, "ProbesSent", &c.ProbesSent)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityConfiguration.
func (c ConnectivityConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityConfiguration.
func (c *ConnectivityConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityConfigurationListResult.
func (c ConnectivityConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityConfigurationListResult.
func (c *ConnectivityConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityConfigurationProperties.
func (c ConnectivityConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliesToGroups", c.AppliesToGroups)
	populate(objectMap, "connectivityTopology", c.ConnectivityTopology)
	populate(objectMap, "deleteExistingPeering", c.DeleteExistingPeering)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "hubs", c.Hubs)
	populate(objectMap, "isGlobal", c.IsGlobal)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "resourceGuid", c.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityConfigurationProperties.
func (c *ConnectivityConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliesToGroups":
			err = unpopulate(val, "AppliesToGroups", &c.AppliesToGroups)
			delete(rawMsg, key)
		case "connectivityTopology":
			err = unpopulate(val, "ConnectivityTopology", &c.ConnectivityTopology)
			delete(rawMsg, key)
		case "deleteExistingPeering":
			err = unpopulate(val, "DeleteExistingPeering", &c.DeleteExistingPeering)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "hubs":
			err = unpopulate(val, "Hubs", &c.Hubs)
			delete(rawMsg, key)
		case "isGlobal":
			err = unpopulate(val, "IsGlobal", &c.IsGlobal)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &c.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityDestination.
func (c ConnectivityDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", c.Address)
	populate(objectMap, "port", c.Port)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityDestination.
func (c *ConnectivityDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &c.Address)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityGroupItem.
func (c ConnectivityGroupItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupConnectivity", c.GroupConnectivity)
	populate(objectMap, "isGlobal", c.IsGlobal)
	populate(objectMap, "networkGroupId", c.NetworkGroupID)
	populate(objectMap, "useHubGateway", c.UseHubGateway)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityGroupItem.
func (c *ConnectivityGroupItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupConnectivity":
			err = unpopulate(val, "GroupConnectivity", &c.GroupConnectivity)
			delete(rawMsg, key)
		case "isGlobal":
			err = unpopulate(val, "IsGlobal", &c.IsGlobal)
			delete(rawMsg, key)
		case "networkGroupId":
			err = unpopulate(val, "NetworkGroupID", &c.NetworkGroupID)
			delete(rawMsg, key)
		case "useHubGateway":
			err = unpopulate(val, "UseHubGateway", &c.UseHubGateway)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityHop.
func (c ConnectivityHop) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", c.Address)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "issues", c.Issues)
	populate(objectMap, "links", c.Links)
	populate(objectMap, "nextHopIds", c.NextHopIDs)
	populate(objectMap, "previousHopIds", c.PreviousHopIDs)
	populate(objectMap, "previousLinks", c.PreviousLinks)
	populate(objectMap, "resourceId", c.ResourceID)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityHop.
func (c *ConnectivityHop) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &c.Address)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "issues":
			err = unpopulate(val, "Issues", &c.Issues)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &c.Links)
			delete(rawMsg, key)
		case "nextHopIds":
			err = unpopulate(val, "NextHopIDs", &c.NextHopIDs)
			delete(rawMsg, key)
		case "previousHopIds":
			err = unpopulate(val, "PreviousHopIDs", &c.PreviousHopIDs)
			delete(rawMsg, key)
		case "previousLinks":
			err = unpopulate(val, "PreviousLinks", &c.PreviousLinks)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityInformation.
func (c ConnectivityInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "avgLatencyInMs", c.AvgLatencyInMs)
	populate(objectMap, "connectionStatus", c.ConnectionStatus)
	populate(objectMap, "hops", c.Hops)
	populate(objectMap, "maxLatencyInMs", c.MaxLatencyInMs)
	populate(objectMap, "minLatencyInMs", c.MinLatencyInMs)
	populate(objectMap, "probesFailed", c.ProbesFailed)
	populate(objectMap, "probesSent", c.ProbesSent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityInformation.
func (c *ConnectivityInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "avgLatencyInMs":
			err = unpopulate(val, "AvgLatencyInMs", &c.AvgLatencyInMs)
			delete(rawMsg, key)
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &c.ConnectionStatus)
			delete(rawMsg, key)
		case "hops":
			err = unpopulate(val, "Hops", &c.Hops)
			delete(rawMsg, key)
		case "maxLatencyInMs":
			err = unpopulate(val, "MaxLatencyInMs", &c.MaxLatencyInMs)
			delete(rawMsg, key)
		case "minLatencyInMs":
			err = unpopulate(val, "MinLatencyInMs", &c.MinLatencyInMs)
			delete(rawMsg, key)
		case "probesFailed":
			err = unpopulate(val, "ProbesFailed", &c.ProbesFailed)
			delete(rawMsg, key)
		case "probesSent":
			err = unpopulate(val, "ProbesSent", &c.ProbesSent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityIssue.
func (c ConnectivityIssue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "context", c.Context)
	populate(objectMap, "origin", c.Origin)
	populate(objectMap, "severity", c.Severity)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityIssue.
func (c *ConnectivityIssue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "context":
			err = unpopulate(val, "Context", &c.Context)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &c.Origin)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &c.Severity)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityParameters.
func (c ConnectivityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", c.Destination)
	populate(objectMap, "preferredIPVersion", c.PreferredIPVersion)
	populate(objectMap, "protocol", c.Protocol)
	populate(objectMap, "protocolConfiguration", c.ProtocolConfiguration)
	populate(objectMap, "source", c.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityParameters.
func (c *ConnectivityParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &c.Destination)
			delete(rawMsg, key)
		case "preferredIPVersion":
			err = unpopulate(val, "PreferredIPVersion", &c.PreferredIPVersion)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &c.Protocol)
			delete(rawMsg, key)
		case "protocolConfiguration":
			err = unpopulate(val, "ProtocolConfiguration", &c.ProtocolConfiguration)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivitySource.
func (c ConnectivitySource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", c.Port)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivitySource.
func (c *ConnectivitySource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Container.
func (c Container) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Container.
func (c *Container) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerNetworkInterface.
func (c ContainerNetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerNetworkInterface.
func (c *ContainerNetworkInterface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerNetworkInterfaceConfiguration.
func (c ContainerNetworkInterfaceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerNetworkInterfaceConfiguration.
func (c *ContainerNetworkInterfaceConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerNetworkInterfaceConfigurationPropertiesFormat.
func (c ContainerNetworkInterfaceConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerNetworkInterfaces", c.ContainerNetworkInterfaces)
	populate(objectMap, "ipConfigurations", c.IPConfigurations)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerNetworkInterfaceConfigurationPropertiesFormat.
func (c *ContainerNetworkInterfaceConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerNetworkInterfaces":
			err = unpopulate(val, "ContainerNetworkInterfaces", &c.ContainerNetworkInterfaces)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &c.IPConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerNetworkInterfaceIPConfiguration.
func (c ContainerNetworkInterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerNetworkInterfaceIPConfiguration.
func (c *ContainerNetworkInterfaceIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerNetworkInterfaceIPConfigurationPropertiesFormat.
func (c ContainerNetworkInterfaceIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerNetworkInterfaceIPConfigurationPropertiesFormat.
func (c *ContainerNetworkInterfaceIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerNetworkInterfacePropertiesFormat.
func (c ContainerNetworkInterfacePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "container", c.Container)
	populate(objectMap, "containerNetworkInterfaceConfiguration", c.ContainerNetworkInterfaceConfiguration)
	populate(objectMap, "ipConfigurations", c.IPConfigurations)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerNetworkInterfacePropertiesFormat.
func (c *ContainerNetworkInterfacePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "container":
			err = unpopulate(val, "Container", &c.Container)
			delete(rawMsg, key)
		case "containerNetworkInterfaceConfiguration":
			err = unpopulate(val, "ContainerNetworkInterfaceConfiguration", &c.ContainerNetworkInterfaceConfiguration)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &c.IPConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Criterion.
func (c Criterion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asPath", c.AsPath)
	populate(objectMap, "community", c.Community)
	populate(objectMap, "matchCondition", c.MatchCondition)
	populate(objectMap, "routePrefix", c.RoutePrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Criterion.
func (c *Criterion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asPath":
			err = unpopulate(val, "AsPath", &c.AsPath)
			delete(rawMsg, key)
		case "community":
			err = unpopulate(val, "Community", &c.Community)
			delete(rawMsg, key)
		case "matchCondition":
			err = unpopulate(val, "MatchCondition", &c.MatchCondition)
			delete(rawMsg, key)
		case "routePrefix":
			err = unpopulate(val, "RoutePrefix", &c.RoutePrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CrossTenantScopes.
func (c CrossTenantScopes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managementGroups", c.ManagementGroups)
	populate(objectMap, "subscriptions", c.Subscriptions)
	populate(objectMap, "tenantId", c.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CrossTenantScopes.
func (c *CrossTenantScopes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managementGroups":
			err = unpopulate(val, "ManagementGroups", &c.ManagementGroups)
			delete(rawMsg, key)
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &c.Subscriptions)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDNSConfigPropertiesFormat.
func (c CustomDNSConfigPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdn", c.Fqdn)
	populate(objectMap, "ipAddresses", c.IPAddresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDNSConfigPropertiesFormat.
func (c *CustomDNSConfigPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdn":
			err = unpopulate(val, "Fqdn", &c.Fqdn)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &c.IPAddresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomIPPrefix.
func (c CustomIPPrefix) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomIPPrefix.
func (c *CustomIPPrefix) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomIPPrefixListResult.
func (c CustomIPPrefixListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomIPPrefixListResult.
func (c *CustomIPPrefixListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomIPPrefixPropertiesFormat.
func (c CustomIPPrefixPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asn", c.Asn)
	populate(objectMap, "authorizationMessage", c.AuthorizationMessage)
	populate(objectMap, "childCustomIpPrefixes", c.ChildCustomIPPrefixes)
	populate(objectMap, "cidr", c.Cidr)
	populate(objectMap, "commissionedState", c.CommissionedState)
	populate(objectMap, "customIpPrefixParent", c.CustomIPPrefixParent)
	populate(objectMap, "expressRouteAdvertise", c.ExpressRouteAdvertise)
	populate(objectMap, "failedReason", c.FailedReason)
	populate(objectMap, "geo", c.Geo)
	populate(objectMap, "noInternetAdvertise", c.NoInternetAdvertise)
	populate(objectMap, "prefixType", c.PrefixType)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "publicIpPrefixes", c.PublicIPPrefixes)
	populate(objectMap, "resourceGuid", c.ResourceGUID)
	populate(objectMap, "signedMessage", c.SignedMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomIPPrefixPropertiesFormat.
func (c *CustomIPPrefixPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asn":
			err = unpopulate(val, "Asn", &c.Asn)
			delete(rawMsg, key)
		case "authorizationMessage":
			err = unpopulate(val, "AuthorizationMessage", &c.AuthorizationMessage)
			delete(rawMsg, key)
		case "childCustomIpPrefixes":
			err = unpopulate(val, "ChildCustomIPPrefixes", &c.ChildCustomIPPrefixes)
			delete(rawMsg, key)
		case "cidr":
			err = unpopulate(val, "Cidr", &c.Cidr)
			delete(rawMsg, key)
		case "commissionedState":
			err = unpopulate(val, "CommissionedState", &c.CommissionedState)
			delete(rawMsg, key)
		case "customIpPrefixParent":
			err = unpopulate(val, "CustomIPPrefixParent", &c.CustomIPPrefixParent)
			delete(rawMsg, key)
		case "expressRouteAdvertise":
			err = unpopulate(val, "ExpressRouteAdvertise", &c.ExpressRouteAdvertise)
			delete(rawMsg, key)
		case "failedReason":
			err = unpopulate(val, "FailedReason", &c.FailedReason)
			delete(rawMsg, key)
		case "geo":
			err = unpopulate(val, "Geo", &c.Geo)
			delete(rawMsg, key)
		case "noInternetAdvertise":
			err = unpopulate(val, "NoInternetAdvertise", &c.NoInternetAdvertise)
			delete(rawMsg, key)
		case "prefixType":
			err = unpopulate(val, "PrefixType", &c.PrefixType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpPrefixes":
			err = unpopulate(val, "PublicIPPrefixes", &c.PublicIPPrefixes)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &c.ResourceGUID)
			delete(rawMsg, key)
		case "signedMessage":
			err = unpopulate(val, "SignedMessage", &c.SignedMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DNSNameAvailabilityResult.
func (d DNSNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", d.Available)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DNSNameAvailabilityResult.
func (d *DNSNameAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &d.Available)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DNSSettings.
func (d DNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableProxy", d.EnableProxy)
	populate(objectMap, "requireProxyForNetworkRules", d.RequireProxyForNetworkRules)
	populate(objectMap, "servers", d.Servers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DNSSettings.
func (d *DNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableProxy":
			err = unpopulate(val, "EnableProxy", &d.EnableProxy)
			delete(rawMsg, key)
		case "requireProxyForNetworkRules":
			err = unpopulate(val, "RequireProxyForNetworkRules", &d.RequireProxyForNetworkRules)
			delete(rawMsg, key)
		case "servers":
			err = unpopulate(val, "Servers", &d.Servers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DdosCustomPolicy.
func (d DdosCustomPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DdosCustomPolicy.
func (d *DdosCustomPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DdosCustomPolicyPropertiesFormat.
func (d DdosCustomPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceGuid", d.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DdosCustomPolicyPropertiesFormat.
func (d *DdosCustomPolicyPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &d.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DdosProtectionPlan.
func (d DdosProtectionPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DdosProtectionPlan.
func (d *DdosProtectionPlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DdosProtectionPlanListResult.
func (d DdosProtectionPlanListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DdosProtectionPlanListResult.
func (d *DdosProtectionPlanListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DdosProtectionPlanPropertiesFormat.
func (d DdosProtectionPlanPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "publicIPAddresses", d.PublicIPAddresses)
	populate(objectMap, "resourceGuid", d.ResourceGUID)
	populate(objectMap, "virtualNetworks", d.VirtualNetworks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DdosProtectionPlanPropertiesFormat.
func (d *DdosProtectionPlanPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &d.PublicIPAddresses)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &d.ResourceGUID)
			delete(rawMsg, key)
		case "virtualNetworks":
			err = unpopulate(val, "VirtualNetworks", &d.VirtualNetworks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DdosSettings.
func (d DdosSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ddosProtectionPlan", d.DdosProtectionPlan)
	populate(objectMap, "protectionMode", d.ProtectionMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DdosSettings.
func (d *DdosSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ddosProtectionPlan":
			err = unpopulate(val, "DdosProtectionPlan", &d.DdosProtectionPlan)
			delete(rawMsg, key)
		case "protectionMode":
			err = unpopulate(val, "ProtectionMode", &d.ProtectionMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultAdminPropertiesFormat.
func (d DefaultAdminPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", d.Access)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "destinationPortRanges", d.DestinationPortRanges)
	populate(objectMap, "destinations", d.Destinations)
	populate(objectMap, "direction", d.Direction)
	populate(objectMap, "flag", d.Flag)
	populate(objectMap, "priority", d.Priority)
	populate(objectMap, "protocol", d.Protocol)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceGuid", d.ResourceGUID)
	populate(objectMap, "sourcePortRanges", d.SourcePortRanges)
	populate(objectMap, "sources", d.Sources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultAdminPropertiesFormat.
func (d *DefaultAdminPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &d.Access)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "destinationPortRanges":
			err = unpopulate(val, "DestinationPortRanges", &d.DestinationPortRanges)
			delete(rawMsg, key)
		case "destinations":
			err = unpopulate(val, "Destinations", &d.Destinations)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &d.Direction)
			delete(rawMsg, key)
		case "flag":
			err = unpopulate(val, "Flag", &d.Flag)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &d.Priority)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &d.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &d.ResourceGUID)
			delete(rawMsg, key)
		case "sourcePortRanges":
			err = unpopulate(val, "SourcePortRanges", &d.SourcePortRanges)
			delete(rawMsg, key)
		case "sources":
			err = unpopulate(val, "Sources", &d.Sources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultAdminRule.
func (d DefaultAdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = AdminRuleKindDefault
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultAdminRule.
func (d *DefaultAdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRuleSetPropertyFormat.
func (d DefaultRuleSetPropertyFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleSetType", d.RuleSetType)
	populate(objectMap, "ruleSetVersion", d.RuleSetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRuleSetPropertyFormat.
func (d *DefaultRuleSetPropertyFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &d.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &d.RuleSetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Delegation.
func (d Delegation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Delegation.
func (d *Delegation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelegationProperties.
func (d DelegationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "serviceName", d.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelegationProperties.
func (d *DelegationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &d.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceProperties.
func (d DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceModel", d.DeviceModel)
	populate(objectMap, "deviceVendor", d.DeviceVendor)
	populate(objectMap, "linkSpeedInMbps", d.LinkSpeedInMbps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceProperties.
func (d *DeviceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceModel":
			err = unpopulate(val, "DeviceModel", &d.DeviceModel)
			delete(rawMsg, key)
		case "deviceVendor":
			err = unpopulate(val, "DeviceVendor", &d.DeviceVendor)
			delete(rawMsg, key)
		case "linkSpeedInMbps":
			err = unpopulate(val, "LinkSpeedInMbps", &d.LinkSpeedInMbps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DhcpOptions.
func (d DhcpOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServers", d.DNSServers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DhcpOptions.
func (d *DhcpOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &d.DNSServers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "internalName", d.InternalName)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "internalName":
			err = unpopulate(val, "InternalName", &d.InternalName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscpConfiguration.
func (d DscpConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscpConfiguration.
func (d *DscpConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscpConfigurationListResult.
func (d DscpConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscpConfigurationListResult.
func (d *DscpConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DscpConfigurationPropertiesFormat.
func (d DscpConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedNetworkInterfaces", d.AssociatedNetworkInterfaces)
	populate(objectMap, "destinationIpRanges", d.DestinationIPRanges)
	populate(objectMap, "destinationPortRanges", d.DestinationPortRanges)
	populate(objectMap, "markings", d.Markings)
	populate(objectMap, "protocol", d.Protocol)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "qosCollectionId", d.QosCollectionID)
	populate(objectMap, "qosDefinitionCollection", d.QosDefinitionCollection)
	populate(objectMap, "resourceGuid", d.ResourceGUID)
	populate(objectMap, "sourceIpRanges", d.SourceIPRanges)
	populate(objectMap, "sourcePortRanges", d.SourcePortRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DscpConfigurationPropertiesFormat.
func (d *DscpConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedNetworkInterfaces":
			err = unpopulate(val, "AssociatedNetworkInterfaces", &d.AssociatedNetworkInterfaces)
			delete(rawMsg, key)
		case "destinationIpRanges":
			err = unpopulate(val, "DestinationIPRanges", &d.DestinationIPRanges)
			delete(rawMsg, key)
		case "destinationPortRanges":
			err = unpopulate(val, "DestinationPortRanges", &d.DestinationPortRanges)
			delete(rawMsg, key)
		case "markings":
			err = unpopulate(val, "Markings", &d.Markings)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &d.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "qosCollectionId":
			err = unpopulate(val, "QosCollectionID", &d.QosCollectionID)
			delete(rawMsg, key)
		case "qosDefinitionCollection":
			err = unpopulate(val, "QosDefinitionCollection", &d.QosDefinitionCollection)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &d.ResourceGUID)
			delete(rawMsg, key)
		case "sourceIpRanges":
			err = unpopulate(val, "SourceIPRanges", &d.SourceIPRanges)
			delete(rawMsg, key)
		case "sourcePortRanges":
			err = unpopulate(val, "SourcePortRanges", &d.SourcePortRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveBaseSecurityAdminRule.
func (e EffectiveBaseSecurityAdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationDescription", e.ConfigurationDescription)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = e.Kind
	populate(objectMap, "ruleCollectionAppliesToGroups", e.RuleCollectionAppliesToGroups)
	populate(objectMap, "ruleCollectionDescription", e.RuleCollectionDescription)
	populate(objectMap, "ruleGroups", e.RuleGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveBaseSecurityAdminRule.
func (e *EffectiveBaseSecurityAdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationDescription":
			err = unpopulate(val, "ConfigurationDescription", &e.ConfigurationDescription)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "ruleCollectionAppliesToGroups":
			err = unpopulate(val, "RuleCollectionAppliesToGroups", &e.RuleCollectionAppliesToGroups)
			delete(rawMsg, key)
		case "ruleCollectionDescription":
			err = unpopulate(val, "RuleCollectionDescription", &e.RuleCollectionDescription)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &e.RuleGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveConnectivityConfiguration.
func (e EffectiveConnectivityConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationGroups", e.ConfigurationGroups)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveConnectivityConfiguration.
func (e *EffectiveConnectivityConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationGroups":
			err = unpopulate(val, "ConfigurationGroups", &e.ConfigurationGroups)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveDefaultSecurityAdminRule.
func (e EffectiveDefaultSecurityAdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationDescription", e.ConfigurationDescription)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = EffectiveAdminRuleKindDefault
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "ruleCollectionAppliesToGroups", e.RuleCollectionAppliesToGroups)
	populate(objectMap, "ruleCollectionDescription", e.RuleCollectionDescription)
	populate(objectMap, "ruleGroups", e.RuleGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveDefaultSecurityAdminRule.
func (e *EffectiveDefaultSecurityAdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationDescription":
			err = unpopulate(val, "ConfigurationDescription", &e.ConfigurationDescription)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "ruleCollectionAppliesToGroups":
			err = unpopulate(val, "RuleCollectionAppliesToGroups", &e.RuleCollectionAppliesToGroups)
			delete(rawMsg, key)
		case "ruleCollectionDescription":
			err = unpopulate(val, "RuleCollectionDescription", &e.RuleCollectionDescription)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &e.RuleGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityGroup.
func (e EffectiveNetworkSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "association", e.Association)
	populate(objectMap, "effectiveSecurityRules", e.EffectiveSecurityRules)
	populate(objectMap, "networkSecurityGroup", e.NetworkSecurityGroup)
	populate(objectMap, "tagMap", e.TagMap)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityGroup.
func (e *EffectiveNetworkSecurityGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "association":
			err = unpopulate(val, "Association", &e.Association)
			delete(rawMsg, key)
		case "effectiveSecurityRules":
			err = unpopulate(val, "EffectiveSecurityRules", &e.EffectiveSecurityRules)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &e.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "tagMap":
			err = unpopulate(val, "TagMap", &e.TagMap)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityGroupAssociation.
func (e EffectiveNetworkSecurityGroupAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterface", e.NetworkInterface)
	populate(objectMap, "networkManager", e.NetworkManager)
	populate(objectMap, "subnet", e.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityGroupAssociation.
func (e *EffectiveNetworkSecurityGroupAssociation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterface":
			err = unpopulate(val, "NetworkInterface", &e.NetworkInterface)
			delete(rawMsg, key)
		case "networkManager":
			err = unpopulate(val, "NetworkManager", &e.NetworkManager)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &e.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityGroupListResult.
func (e EffectiveNetworkSecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityGroupListResult.
func (e *EffectiveNetworkSecurityGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityRule.
func (e EffectiveNetworkSecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", e.Access)
	populate(objectMap, "destinationAddressPrefix", e.DestinationAddressPrefix)
	populate(objectMap, "destinationAddressPrefixes", e.DestinationAddressPrefixes)
	populate(objectMap, "destinationPortRange", e.DestinationPortRange)
	populate(objectMap, "destinationPortRanges", e.DestinationPortRanges)
	populate(objectMap, "direction", e.Direction)
	populate(objectMap, "expandedDestinationAddressPrefix", e.ExpandedDestinationAddressPrefix)
	populate(objectMap, "expandedSourceAddressPrefix", e.ExpandedSourceAddressPrefix)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "priority", e.Priority)
	populate(objectMap, "protocol", e.Protocol)
	populate(objectMap, "sourceAddressPrefix", e.SourceAddressPrefix)
	populate(objectMap, "sourceAddressPrefixes", e.SourceAddressPrefixes)
	populate(objectMap, "sourcePortRange", e.SourcePortRange)
	populate(objectMap, "sourcePortRanges", e.SourcePortRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityRule.
func (e *EffectiveNetworkSecurityRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &e.Access)
			delete(rawMsg, key)
		case "destinationAddressPrefix":
			err = unpopulate(val, "DestinationAddressPrefix", &e.DestinationAddressPrefix)
			delete(rawMsg, key)
		case "destinationAddressPrefixes":
			err = unpopulate(val, "DestinationAddressPrefixes", &e.DestinationAddressPrefixes)
			delete(rawMsg, key)
		case "destinationPortRange":
			err = unpopulate(val, "DestinationPortRange", &e.DestinationPortRange)
			delete(rawMsg, key)
		case "destinationPortRanges":
			err = unpopulate(val, "DestinationPortRanges", &e.DestinationPortRanges)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &e.Direction)
			delete(rawMsg, key)
		case "expandedDestinationAddressPrefix":
			err = unpopulate(val, "ExpandedDestinationAddressPrefix", &e.ExpandedDestinationAddressPrefix)
			delete(rawMsg, key)
		case "expandedSourceAddressPrefix":
			err = unpopulate(val, "ExpandedSourceAddressPrefix", &e.ExpandedSourceAddressPrefix)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &e.Priority)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &e.Protocol)
			delete(rawMsg, key)
		case "sourceAddressPrefix":
			err = unpopulate(val, "SourceAddressPrefix", &e.SourceAddressPrefix)
			delete(rawMsg, key)
		case "sourceAddressPrefixes":
			err = unpopulate(val, "SourceAddressPrefixes", &e.SourceAddressPrefixes)
			delete(rawMsg, key)
		case "sourcePortRange":
			err = unpopulate(val, "SourcePortRange", &e.SourcePortRange)
			delete(rawMsg, key)
		case "sourcePortRanges":
			err = unpopulate(val, "SourcePortRanges", &e.SourcePortRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveRoute.
func (e EffectiveRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", e.AddressPrefix)
	populate(objectMap, "disableBgpRoutePropagation", e.DisableBgpRoutePropagation)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "nextHopIpAddress", e.NextHopIPAddress)
	populate(objectMap, "nextHopType", e.NextHopType)
	populate(objectMap, "source", e.Source)
	populate(objectMap, "state", e.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveRoute.
func (e *EffectiveRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &e.AddressPrefix)
			delete(rawMsg, key)
		case "disableBgpRoutePropagation":
			err = unpopulate(val, "DisableBgpRoutePropagation", &e.DisableBgpRoutePropagation)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "nextHopIpAddress":
			err = unpopulate(val, "NextHopIPAddress", &e.NextHopIPAddress)
			delete(rawMsg, key)
		case "nextHopType":
			err = unpopulate(val, "NextHopType", &e.NextHopType)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &e.Source)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveRouteListResult.
func (e EffectiveRouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveRouteListResult.
func (e *EffectiveRouteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveRouteMapRoute.
func (e EffectiveRouteMapRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asPath", e.AsPath)
	populate(objectMap, "bgpCommunities", e.BgpCommunities)
	populate(objectMap, "prefix", e.Prefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveRouteMapRoute.
func (e *EffectiveRouteMapRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asPath":
			err = unpopulate(val, "AsPath", &e.AsPath)
			delete(rawMsg, key)
		case "bgpCommunities":
			err = unpopulate(val, "BgpCommunities", &e.BgpCommunities)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &e.Prefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveRouteMapRouteList.
func (e EffectiveRouteMapRouteList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveRouteMapRouteList.
func (e *EffectiveRouteMapRouteList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveRoutesParameters.
func (e EffectiveRoutesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceId", e.ResourceID)
	populate(objectMap, "virtualWanResourceType", e.VirtualWanResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveRoutesParameters.
func (e *EffectiveRoutesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceId":
			err = unpopulate(val, "ResourceID", &e.ResourceID)
			delete(rawMsg, key)
		case "virtualWanResourceType":
			err = unpopulate(val, "VirtualWanResourceType", &e.VirtualWanResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveSecurityAdminRule.
func (e EffectiveSecurityAdminRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationDescription", e.ConfigurationDescription)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = EffectiveAdminRuleKindCustom
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "ruleCollectionAppliesToGroups", e.RuleCollectionAppliesToGroups)
	populate(objectMap, "ruleCollectionDescription", e.RuleCollectionDescription)
	populate(objectMap, "ruleGroups", e.RuleGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveSecurityAdminRule.
func (e *EffectiveSecurityAdminRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationDescription":
			err = unpopulate(val, "ConfigurationDescription", &e.ConfigurationDescription)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "ruleCollectionAppliesToGroups":
			err = unpopulate(val, "RuleCollectionAppliesToGroups", &e.RuleCollectionAppliesToGroups)
			delete(rawMsg, key)
		case "ruleCollectionDescription":
			err = unpopulate(val, "RuleCollectionDescription", &e.RuleCollectionDescription)
			delete(rawMsg, key)
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &e.RuleGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointServiceResult.
func (e EndpointServiceResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointServiceResult.
func (e *EndpointServiceResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointServicesListResult.
func (e EndpointServicesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointServicesListResult.
func (e *EndpointServicesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "innerError", e.InnerError)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EvaluatedNetworkSecurityGroup.
func (e EvaluatedNetworkSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedTo", e.AppliedTo)
	populate(objectMap, "matchedRule", e.MatchedRule)
	populate(objectMap, "networkSecurityGroupId", e.NetworkSecurityGroupID)
	populate(objectMap, "rulesEvaluationResult", e.RulesEvaluationResult)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EvaluatedNetworkSecurityGroup.
func (e *EvaluatedNetworkSecurityGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedTo":
			err = unpopulate(val, "AppliedTo", &e.AppliedTo)
			delete(rawMsg, key)
		case "matchedRule":
			err = unpopulate(val, "MatchedRule", &e.MatchedRule)
			delete(rawMsg, key)
		case "networkSecurityGroupId":
			err = unpopulate(val, "NetworkSecurityGroupID", &e.NetworkSecurityGroupID)
			delete(rawMsg, key)
		case "rulesEvaluationResult":
			err = unpopulate(val, "RulesEvaluationResult", &e.RulesEvaluationResult)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExclusionManagedRule.
func (e ExclusionManagedRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleId", e.RuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExclusionManagedRule.
func (e *ExclusionManagedRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleId":
			err = unpopulate(val, "RuleID", &e.RuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExclusionManagedRuleGroup.
func (e ExclusionManagedRuleGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleGroupName", e.RuleGroupName)
	populate(objectMap, "rules", e.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExclusionManagedRuleGroup.
func (e *ExclusionManagedRuleGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleGroupName":
			err = unpopulate(val, "RuleGroupName", &e.RuleGroupName)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &e.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExclusionManagedRuleSet.
func (e ExclusionManagedRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleGroups", e.RuleGroups)
	populate(objectMap, "ruleSetType", e.RuleSetType)
	populate(objectMap, "ruleSetVersion", e.RuleSetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExclusionManagedRuleSet.
func (e *ExclusionManagedRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleGroups":
			err = unpopulate(val, "RuleGroups", &e.RuleGroups)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &e.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &e.RuleSetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExplicitProxySettings.
func (e ExplicitProxySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableExplicitProxy", e.EnableExplicitProxy)
	populate(objectMap, "enablePacFile", e.EnablePacFile)
	populate(objectMap, "httpPort", e.HTTPPort)
	populate(objectMap, "httpsPort", e.HTTPSPort)
	populate(objectMap, "pacFile", e.PacFile)
	populate(objectMap, "pacFilePort", e.PacFilePort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExplicitProxySettings.
func (e *ExplicitProxySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableExplicitProxy":
			err = unpopulate(val, "EnableExplicitProxy", &e.EnableExplicitProxy)
			delete(rawMsg, key)
		case "enablePacFile":
			err = unpopulate(val, "EnablePacFile", &e.EnablePacFile)
			delete(rawMsg, key)
		case "httpPort":
			err = unpopulate(val, "HTTPPort", &e.HTTPPort)
			delete(rawMsg, key)
		case "httpsPort":
			err = unpopulate(val, "HTTPSPort", &e.HTTPSPort)
			delete(rawMsg, key)
		case "pacFile":
			err = unpopulate(val, "PacFile", &e.PacFile)
			delete(rawMsg, key)
		case "pacFilePort":
			err = unpopulate(val, "PacFilePort", &e.PacFilePort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuit.
func (e ExpressRouteCircuit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "sku", e.SKU)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuit.
func (e *ExpressRouteCircuit) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &e.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitArpTable.
func (e ExpressRouteCircuitArpTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "age", e.Age)
	populate(objectMap, "ipAddress", e.IPAddress)
	populate(objectMap, "interface", e.Interface)
	populate(objectMap, "macAddress", e.MacAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitArpTable.
func (e *ExpressRouteCircuitArpTable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "age":
			err = unpopulate(val, "Age", &e.Age)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &e.IPAddress)
			delete(rawMsg, key)
		case "interface":
			err = unpopulate(val, "Interface", &e.Interface)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &e.MacAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitAuthorization.
func (e ExpressRouteCircuitAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitAuthorization.
func (e *ExpressRouteCircuitAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitConnection.
func (e ExpressRouteCircuitConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitConnection.
func (e *ExpressRouteCircuitConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitConnectionListResult.
func (e ExpressRouteCircuitConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitConnectionListResult.
func (e *ExpressRouteCircuitConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitConnectionPropertiesFormat.
func (e ExpressRouteCircuitConnectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", e.AddressPrefix)
	populate(objectMap, "authorizationKey", e.AuthorizationKey)
	populate(objectMap, "circuitConnectionStatus", e.CircuitConnectionStatus)
	populate(objectMap, "expressRouteCircuitPeering", e.ExpressRouteCircuitPeering)
	populate(objectMap, "ipv6CircuitConnectionConfig", e.IPv6CircuitConnectionConfig)
	populate(objectMap, "peerExpressRouteCircuitPeering", e.PeerExpressRouteCircuitPeering)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitConnectionPropertiesFormat.
func (e *ExpressRouteCircuitConnectionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &e.AddressPrefix)
			delete(rawMsg, key)
		case "authorizationKey":
			err = unpopulate(val, "AuthorizationKey", &e.AuthorizationKey)
			delete(rawMsg, key)
		case "circuitConnectionStatus":
			err = unpopulate(val, "CircuitConnectionStatus", &e.CircuitConnectionStatus)
			delete(rawMsg, key)
		case "expressRouteCircuitPeering":
			err = unpopulate(val, "ExpressRouteCircuitPeering", &e.ExpressRouteCircuitPeering)
			delete(rawMsg, key)
		case "ipv6CircuitConnectionConfig":
			err = unpopulate(val, "IPv6CircuitConnectionConfig", &e.IPv6CircuitConnectionConfig)
			delete(rawMsg, key)
		case "peerExpressRouteCircuitPeering":
			err = unpopulate(val, "PeerExpressRouteCircuitPeering", &e.PeerExpressRouteCircuitPeering)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitListResult.
func (e ExpressRouteCircuitListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitListResult.
func (e *ExpressRouteCircuitListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitPeering.
func (e ExpressRouteCircuitPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitPeering.
func (e *ExpressRouteCircuitPeering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitPeeringConfig.
func (e ExpressRouteCircuitPeeringConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "advertisedCommunities", e.AdvertisedCommunities)
	populate(objectMap, "advertisedPublicPrefixes", e.AdvertisedPublicPrefixes)
	populate(objectMap, "advertisedPublicPrefixesState", e.AdvertisedPublicPrefixesState)
	populate(objectMap, "customerASN", e.CustomerASN)
	populate(objectMap, "legacyMode", e.LegacyMode)
	populate(objectMap, "routingRegistryName", e.RoutingRegistryName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitPeeringConfig.
func (e *ExpressRouteCircuitPeeringConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advertisedCommunities":
			err = unpopulate(val, "AdvertisedCommunities", &e.AdvertisedCommunities)
			delete(rawMsg, key)
		case "advertisedPublicPrefixes":
			err = unpopulate(val, "AdvertisedPublicPrefixes", &e.AdvertisedPublicPrefixes)
			delete(rawMsg, key)
		case "advertisedPublicPrefixesState":
			err = unpopulate(val, "AdvertisedPublicPrefixesState", &e.AdvertisedPublicPrefixesState)
			delete(rawMsg, key)
		case "customerASN":
			err = unpopulate(val, "CustomerASN", &e.CustomerASN)
			delete(rawMsg, key)
		case "legacyMode":
			err = unpopulate(val, "LegacyMode", &e.LegacyMode)
			delete(rawMsg, key)
		case "routingRegistryName":
			err = unpopulate(val, "RoutingRegistryName", &e.RoutingRegistryName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitPeeringID.
func (e ExpressRouteCircuitPeeringID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitPeeringID.
func (e *ExpressRouteCircuitPeeringID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitPeeringListResult.
func (e ExpressRouteCircuitPeeringListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitPeeringListResult.
func (e *ExpressRouteCircuitPeeringListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitPeeringPropertiesFormat.
func (e ExpressRouteCircuitPeeringPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureASN", e.AzureASN)
	populate(objectMap, "connections", e.Connections)
	populate(objectMap, "expressRouteConnection", e.ExpressRouteConnection)
	populate(objectMap, "gatewayManagerEtag", e.GatewayManagerEtag)
	populate(objectMap, "ipv6PeeringConfig", e.IPv6PeeringConfig)
	populate(objectMap, "lastModifiedBy", e.LastModifiedBy)
	populate(objectMap, "microsoftPeeringConfig", e.MicrosoftPeeringConfig)
	populate(objectMap, "peerASN", e.PeerASN)
	populate(objectMap, "peeredConnections", e.PeeredConnections)
	populate(objectMap, "peeringType", e.PeeringType)
	populate(objectMap, "primaryAzurePort", e.PrimaryAzurePort)
	populate(objectMap, "primaryPeerAddressPrefix", e.PrimaryPeerAddressPrefix)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "routeFilter", e.RouteFilter)
	populate(objectMap, "secondaryAzurePort", e.SecondaryAzurePort)
	populate(objectMap, "secondaryPeerAddressPrefix", e.SecondaryPeerAddressPrefix)
	populate(objectMap, "sharedKey", e.SharedKey)
	populate(objectMap, "state", e.State)
	populate(objectMap, "stats", e.Stats)
	populate(objectMap, "vlanId", e.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitPeeringPropertiesFormat.
func (e *ExpressRouteCircuitPeeringPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureASN":
			err = unpopulate(val, "AzureASN", &e.AzureASN)
			delete(rawMsg, key)
		case "connections":
			err = unpopulate(val, "Connections", &e.Connections)
			delete(rawMsg, key)
		case "expressRouteConnection":
			err = unpopulate(val, "ExpressRouteConnection", &e.ExpressRouteConnection)
			delete(rawMsg, key)
		case "gatewayManagerEtag":
			err = unpopulate(val, "GatewayManagerEtag", &e.GatewayManagerEtag)
			delete(rawMsg, key)
		case "ipv6PeeringConfig":
			err = unpopulate(val, "IPv6PeeringConfig", &e.IPv6PeeringConfig)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &e.LastModifiedBy)
			delete(rawMsg, key)
		case "microsoftPeeringConfig":
			err = unpopulate(val, "MicrosoftPeeringConfig", &e.MicrosoftPeeringConfig)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &e.PeerASN)
			delete(rawMsg, key)
		case "peeredConnections":
			err = unpopulate(val, "PeeredConnections", &e.PeeredConnections)
			delete(rawMsg, key)
		case "peeringType":
			err = unpopulate(val, "PeeringType", &e.PeeringType)
			delete(rawMsg, key)
		case "primaryAzurePort":
			err = unpopulate(val, "PrimaryAzurePort", &e.PrimaryAzurePort)
			delete(rawMsg, key)
		case "primaryPeerAddressPrefix":
			err = unpopulate(val, "PrimaryPeerAddressPrefix", &e.PrimaryPeerAddressPrefix)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "routeFilter":
			err = unpopulate(val, "RouteFilter", &e.RouteFilter)
			delete(rawMsg, key)
		case "secondaryAzurePort":
			err = unpopulate(val, "SecondaryAzurePort", &e.SecondaryAzurePort)
			delete(rawMsg, key)
		case "secondaryPeerAddressPrefix":
			err = unpopulate(val, "SecondaryPeerAddressPrefix", &e.SecondaryPeerAddressPrefix)
			delete(rawMsg, key)
		case "sharedKey":
			err = unpopulate(val, "SharedKey", &e.SharedKey)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "stats":
			err = unpopulate(val, "Stats", &e.Stats)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &e.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitPropertiesFormat.
func (e ExpressRouteCircuitPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowClassicOperations", e.AllowClassicOperations)
	populate(objectMap, "authorizationKey", e.AuthorizationKey)
	populate(objectMap, "authorizationStatus", e.AuthorizationStatus)
	populate(objectMap, "authorizations", e.Authorizations)
	populate(objectMap, "bandwidthInGbps", e.BandwidthInGbps)
	populate(objectMap, "circuitProvisioningState", e.CircuitProvisioningState)
	populate(objectMap, "expressRoutePort", e.ExpressRoutePort)
	populate(objectMap, "gatewayManagerEtag", e.GatewayManagerEtag)
	populate(objectMap, "globalReachEnabled", e.GlobalReachEnabled)
	populate(objectMap, "peerings", e.Peerings)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "serviceKey", e.ServiceKey)
	populate(objectMap, "serviceProviderNotes", e.ServiceProviderNotes)
	populate(objectMap, "serviceProviderProperties", e.ServiceProviderProperties)
	populate(objectMap, "serviceProviderProvisioningState", e.ServiceProviderProvisioningState)
	populate(objectMap, "stag", e.Stag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitPropertiesFormat.
func (e *ExpressRouteCircuitPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowClassicOperations":
			err = unpopulate(val, "AllowClassicOperations", &e.AllowClassicOperations)
			delete(rawMsg, key)
		case "authorizationKey":
			err = unpopulate(val, "AuthorizationKey", &e.AuthorizationKey)
			delete(rawMsg, key)
		case "authorizationStatus":
			err = unpopulate(val, "AuthorizationStatus", &e.AuthorizationStatus)
			delete(rawMsg, key)
		case "authorizations":
			err = unpopulate(val, "Authorizations", &e.Authorizations)
			delete(rawMsg, key)
		case "bandwidthInGbps":
			err = unpopulate(val, "BandwidthInGbps", &e.BandwidthInGbps)
			delete(rawMsg, key)
		case "circuitProvisioningState":
			err = unpopulate(val, "CircuitProvisioningState", &e.CircuitProvisioningState)
			delete(rawMsg, key)
		case "expressRoutePort":
			err = unpopulate(val, "ExpressRoutePort", &e.ExpressRoutePort)
			delete(rawMsg, key)
		case "gatewayManagerEtag":
			err = unpopulate(val, "GatewayManagerEtag", &e.GatewayManagerEtag)
			delete(rawMsg, key)
		case "globalReachEnabled":
			err = unpopulate(val, "GlobalReachEnabled", &e.GlobalReachEnabled)
			delete(rawMsg, key)
		case "peerings":
			err = unpopulate(val, "Peerings", &e.Peerings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "serviceKey":
			err = unpopulate(val, "ServiceKey", &e.ServiceKey)
			delete(rawMsg, key)
		case "serviceProviderNotes":
			err = unpopulate(val, "ServiceProviderNotes", &e.ServiceProviderNotes)
			delete(rawMsg, key)
		case "serviceProviderProperties":
			err = unpopulate(val, "ServiceProviderProperties", &e.ServiceProviderProperties)
			delete(rawMsg, key)
		case "serviceProviderProvisioningState":
			err = unpopulate(val, "ServiceProviderProvisioningState", &e.ServiceProviderProvisioningState)
			delete(rawMsg, key)
		case "stag":
			err = unpopulate(val, "Stag", &e.Stag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitReference.
func (e ExpressRouteCircuitReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitReference.
func (e *ExpressRouteCircuitReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitRoutesTable.
func (e ExpressRouteCircuitRoutesTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locPrf", e.LocPrf)
	populate(objectMap, "network", e.Network)
	populate(objectMap, "nextHop", e.NextHop)
	populate(objectMap, "path", e.Path)
	populate(objectMap, "weight", e.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitRoutesTable.
func (e *ExpressRouteCircuitRoutesTable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locPrf":
			err = unpopulate(val, "LocPrf", &e.LocPrf)
			delete(rawMsg, key)
		case "network":
			err = unpopulate(val, "Network", &e.Network)
			delete(rawMsg, key)
		case "nextHop":
			err = unpopulate(val, "NextHop", &e.NextHop)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &e.Path)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &e.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitRoutesTableSummary.
func (e ExpressRouteCircuitRoutesTableSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "as", e.As)
	populate(objectMap, "neighbor", e.Neighbor)
	populate(objectMap, "statePfxRcd", e.StatePfxRcd)
	populate(objectMap, "upDown", e.UpDown)
	populate(objectMap, "v", e.V)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitRoutesTableSummary.
func (e *ExpressRouteCircuitRoutesTableSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "as":
			err = unpopulate(val, "As", &e.As)
			delete(rawMsg, key)
		case "neighbor":
			err = unpopulate(val, "Neighbor", &e.Neighbor)
			delete(rawMsg, key)
		case "statePfxRcd":
			err = unpopulate(val, "StatePfxRcd", &e.StatePfxRcd)
			delete(rawMsg, key)
		case "upDown":
			err = unpopulate(val, "UpDown", &e.UpDown)
			delete(rawMsg, key)
		case "v":
			err = unpopulate(val, "V", &e.V)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitSKU.
func (e ExpressRouteCircuitSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "family", e.Family)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "tier", e.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitSKU.
func (e *ExpressRouteCircuitSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "family":
			err = unpopulate(val, "Family", &e.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &e.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitServiceProviderProperties.
func (e ExpressRouteCircuitServiceProviderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bandwidthInMbps", e.BandwidthInMbps)
	populate(objectMap, "peeringLocation", e.PeeringLocation)
	populate(objectMap, "serviceProviderName", e.ServiceProviderName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitServiceProviderProperties.
func (e *ExpressRouteCircuitServiceProviderProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bandwidthInMbps":
			err = unpopulate(val, "BandwidthInMbps", &e.BandwidthInMbps)
			delete(rawMsg, key)
		case "peeringLocation":
			err = unpopulate(val, "PeeringLocation", &e.PeeringLocation)
			delete(rawMsg, key)
		case "serviceProviderName":
			err = unpopulate(val, "ServiceProviderName", &e.ServiceProviderName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitStats.
func (e ExpressRouteCircuitStats) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primarybytesIn", e.PrimarybytesIn)
	populate(objectMap, "primarybytesOut", e.PrimarybytesOut)
	populate(objectMap, "secondarybytesIn", e.SecondarybytesIn)
	populate(objectMap, "secondarybytesOut", e.SecondarybytesOut)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitStats.
func (e *ExpressRouteCircuitStats) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primarybytesIn":
			err = unpopulate(val, "PrimarybytesIn", &e.PrimarybytesIn)
			delete(rawMsg, key)
		case "primarybytesOut":
			err = unpopulate(val, "PrimarybytesOut", &e.PrimarybytesOut)
			delete(rawMsg, key)
		case "secondarybytesIn":
			err = unpopulate(val, "SecondarybytesIn", &e.SecondarybytesIn)
			delete(rawMsg, key)
		case "secondarybytesOut":
			err = unpopulate(val, "SecondarybytesOut", &e.SecondarybytesOut)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitsArpTableListResult.
func (e ExpressRouteCircuitsArpTableListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitsArpTableListResult.
func (e *ExpressRouteCircuitsArpTableListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitsRoutesTableListResult.
func (e ExpressRouteCircuitsRoutesTableListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitsRoutesTableListResult.
func (e *ExpressRouteCircuitsRoutesTableListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCircuitsRoutesTableSummaryListResult.
func (e ExpressRouteCircuitsRoutesTableSummaryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCircuitsRoutesTableSummaryListResult.
func (e *ExpressRouteCircuitsRoutesTableSummaryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteConnection.
func (e ExpressRouteConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteConnection.
func (e *ExpressRouteConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteConnectionID.
func (e ExpressRouteConnectionID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteConnectionID.
func (e *ExpressRouteConnectionID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteConnectionList.
func (e ExpressRouteConnectionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteConnectionList.
func (e *ExpressRouteConnectionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteConnectionProperties.
func (e ExpressRouteConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationKey", e.AuthorizationKey)
	populate(objectMap, "enableInternetSecurity", e.EnableInternetSecurity)
	populate(objectMap, "enablePrivateLinkFastPath", e.EnablePrivateLinkFastPath)
	populate(objectMap, "expressRouteCircuitPeering", e.ExpressRouteCircuitPeering)
	populate(objectMap, "expressRouteGatewayBypass", e.ExpressRouteGatewayBypass)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "routingConfiguration", e.RoutingConfiguration)
	populate(objectMap, "routingWeight", e.RoutingWeight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteConnectionProperties.
func (e *ExpressRouteConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationKey":
			err = unpopulate(val, "AuthorizationKey", &e.AuthorizationKey)
			delete(rawMsg, key)
		case "enableInternetSecurity":
			err = unpopulate(val, "EnableInternetSecurity", &e.EnableInternetSecurity)
			delete(rawMsg, key)
		case "enablePrivateLinkFastPath":
			err = unpopulate(val, "EnablePrivateLinkFastPath", &e.EnablePrivateLinkFastPath)
			delete(rawMsg, key)
		case "expressRouteCircuitPeering":
			err = unpopulate(val, "ExpressRouteCircuitPeering", &e.ExpressRouteCircuitPeering)
			delete(rawMsg, key)
		case "expressRouteGatewayBypass":
			err = unpopulate(val, "ExpressRouteGatewayBypass", &e.ExpressRouteGatewayBypass)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "routingConfiguration":
			err = unpopulate(val, "RoutingConfiguration", &e.RoutingConfiguration)
			delete(rawMsg, key)
		case "routingWeight":
			err = unpopulate(val, "RoutingWeight", &e.RoutingWeight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCrossConnection.
func (e ExpressRouteCrossConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCrossConnection.
func (e *ExpressRouteCrossConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCrossConnectionListResult.
func (e ExpressRouteCrossConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCrossConnectionListResult.
func (e *ExpressRouteCrossConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCrossConnectionPeering.
func (e ExpressRouteCrossConnectionPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCrossConnectionPeering.
func (e *ExpressRouteCrossConnectionPeering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCrossConnectionPeeringList.
func (e ExpressRouteCrossConnectionPeeringList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCrossConnectionPeeringList.
func (e *ExpressRouteCrossConnectionPeeringList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCrossConnectionPeeringProperties.
func (e ExpressRouteCrossConnectionPeeringProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureASN", e.AzureASN)
	populate(objectMap, "gatewayManagerEtag", e.GatewayManagerEtag)
	populate(objectMap, "ipv6PeeringConfig", e.IPv6PeeringConfig)
	populate(objectMap, "lastModifiedBy", e.LastModifiedBy)
	populate(objectMap, "microsoftPeeringConfig", e.MicrosoftPeeringConfig)
	populate(objectMap, "peerASN", e.PeerASN)
	populate(objectMap, "peeringType", e.PeeringType)
	populate(objectMap, "primaryAzurePort", e.PrimaryAzurePort)
	populate(objectMap, "primaryPeerAddressPrefix", e.PrimaryPeerAddressPrefix)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "secondaryAzurePort", e.SecondaryAzurePort)
	populate(objectMap, "secondaryPeerAddressPrefix", e.SecondaryPeerAddressPrefix)
	populate(objectMap, "sharedKey", e.SharedKey)
	populate(objectMap, "state", e.State)
	populate(objectMap, "vlanId", e.VlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCrossConnectionPeeringProperties.
func (e *ExpressRouteCrossConnectionPeeringProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureASN":
			err = unpopulate(val, "AzureASN", &e.AzureASN)
			delete(rawMsg, key)
		case "gatewayManagerEtag":
			err = unpopulate(val, "GatewayManagerEtag", &e.GatewayManagerEtag)
			delete(rawMsg, key)
		case "ipv6PeeringConfig":
			err = unpopulate(val, "IPv6PeeringConfig", &e.IPv6PeeringConfig)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &e.LastModifiedBy)
			delete(rawMsg, key)
		case "microsoftPeeringConfig":
			err = unpopulate(val, "MicrosoftPeeringConfig", &e.MicrosoftPeeringConfig)
			delete(rawMsg, key)
		case "peerASN":
			err = unpopulate(val, "PeerASN", &e.PeerASN)
			delete(rawMsg, key)
		case "peeringType":
			err = unpopulate(val, "PeeringType", &e.PeeringType)
			delete(rawMsg, key)
		case "primaryAzurePort":
			err = unpopulate(val, "PrimaryAzurePort", &e.PrimaryAzurePort)
			delete(rawMsg, key)
		case "primaryPeerAddressPrefix":
			err = unpopulate(val, "PrimaryPeerAddressPrefix", &e.PrimaryPeerAddressPrefix)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "secondaryAzurePort":
			err = unpopulate(val, "SecondaryAzurePort", &e.SecondaryAzurePort)
			delete(rawMsg, key)
		case "secondaryPeerAddressPrefix":
			err = unpopulate(val, "SecondaryPeerAddressPrefix", &e.SecondaryPeerAddressPrefix)
			delete(rawMsg, key)
		case "sharedKey":
			err = unpopulate(val, "SharedKey", &e.SharedKey)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "vlanId":
			err = unpopulate(val, "VlanID", &e.VlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCrossConnectionProperties.
func (e ExpressRouteCrossConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bandwidthInMbps", e.BandwidthInMbps)
	populate(objectMap, "expressRouteCircuit", e.ExpressRouteCircuit)
	populate(objectMap, "peeringLocation", e.PeeringLocation)
	populate(objectMap, "peerings", e.Peerings)
	populate(objectMap, "primaryAzurePort", e.PrimaryAzurePort)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "sTag", e.STag)
	populate(objectMap, "secondaryAzurePort", e.SecondaryAzurePort)
	populate(objectMap, "serviceProviderNotes", e.ServiceProviderNotes)
	populate(objectMap, "serviceProviderProvisioningState", e.ServiceProviderProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCrossConnectionProperties.
func (e *ExpressRouteCrossConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bandwidthInMbps":
			err = unpopulate(val, "BandwidthInMbps", &e.BandwidthInMbps)
			delete(rawMsg, key)
		case "expressRouteCircuit":
			err = unpopulate(val, "ExpressRouteCircuit", &e.ExpressRouteCircuit)
			delete(rawMsg, key)
		case "peeringLocation":
			err = unpopulate(val, "PeeringLocation", &e.PeeringLocation)
			delete(rawMsg, key)
		case "peerings":
			err = unpopulate(val, "Peerings", &e.Peerings)
			delete(rawMsg, key)
		case "primaryAzurePort":
			err = unpopulate(val, "PrimaryAzurePort", &e.PrimaryAzurePort)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "sTag":
			err = unpopulate(val, "STag", &e.STag)
			delete(rawMsg, key)
		case "secondaryAzurePort":
			err = unpopulate(val, "SecondaryAzurePort", &e.SecondaryAzurePort)
			delete(rawMsg, key)
		case "serviceProviderNotes":
			err = unpopulate(val, "ServiceProviderNotes", &e.ServiceProviderNotes)
			delete(rawMsg, key)
		case "serviceProviderProvisioningState":
			err = unpopulate(val, "ServiceProviderProvisioningState", &e.ServiceProviderProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCrossConnectionRoutesTableSummary.
func (e ExpressRouteCrossConnectionRoutesTableSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asn", e.Asn)
	populate(objectMap, "neighbor", e.Neighbor)
	populate(objectMap, "stateOrPrefixesReceived", e.StateOrPrefixesReceived)
	populate(objectMap, "upDown", e.UpDown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCrossConnectionRoutesTableSummary.
func (e *ExpressRouteCrossConnectionRoutesTableSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asn":
			err = unpopulate(val, "Asn", &e.Asn)
			delete(rawMsg, key)
		case "neighbor":
			err = unpopulate(val, "Neighbor", &e.Neighbor)
			delete(rawMsg, key)
		case "stateOrPrefixesReceived":
			err = unpopulate(val, "StateOrPrefixesReceived", &e.StateOrPrefixesReceived)
			delete(rawMsg, key)
		case "upDown":
			err = unpopulate(val, "UpDown", &e.UpDown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteCrossConnectionsRoutesTableSummaryListResult.
func (e ExpressRouteCrossConnectionsRoutesTableSummaryListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteCrossConnectionsRoutesTableSummaryListResult.
func (e *ExpressRouteCrossConnectionsRoutesTableSummaryListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteGateway.
func (e ExpressRouteGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteGateway.
func (e *ExpressRouteGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteGatewayList.
func (e ExpressRouteGatewayList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteGatewayList.
func (e *ExpressRouteGatewayList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteGatewayProperties.
func (e ExpressRouteGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowNonVirtualWanTraffic", e.AllowNonVirtualWanTraffic)
	populate(objectMap, "autoScaleConfiguration", e.AutoScaleConfiguration)
	populate(objectMap, "expressRouteConnections", e.ExpressRouteConnections)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "virtualHub", e.VirtualHub)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteGatewayProperties.
func (e *ExpressRouteGatewayProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowNonVirtualWanTraffic":
			err = unpopulate(val, "AllowNonVirtualWanTraffic", &e.AllowNonVirtualWanTraffic)
			delete(rawMsg, key)
		case "autoScaleConfiguration":
			err = unpopulate(val, "AutoScaleConfiguration", &e.AutoScaleConfiguration)
			delete(rawMsg, key)
		case "expressRouteConnections":
			err = unpopulate(val, "ExpressRouteConnections", &e.ExpressRouteConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "virtualHub":
			err = unpopulate(val, "VirtualHub", &e.VirtualHub)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteGatewayPropertiesAutoScaleConfiguration.
func (e ExpressRouteGatewayPropertiesAutoScaleConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bounds", e.Bounds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteGatewayPropertiesAutoScaleConfiguration.
func (e *ExpressRouteGatewayPropertiesAutoScaleConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bounds":
			err = unpopulate(val, "Bounds", &e.Bounds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds.
func (e ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "max", e.Max)
	populate(objectMap, "min", e.Min)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds.
func (e *ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "max":
			err = unpopulate(val, "Max", &e.Max)
			delete(rawMsg, key)
		case "min":
			err = unpopulate(val, "Min", &e.Min)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteLink.
func (e ExpressRouteLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteLink.
func (e *ExpressRouteLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteLinkListResult.
func (e ExpressRouteLinkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteLinkListResult.
func (e *ExpressRouteLinkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteLinkMacSecConfig.
func (e ExpressRouteLinkMacSecConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cakSecretIdentifier", e.CakSecretIdentifier)
	populate(objectMap, "cipher", e.Cipher)
	populate(objectMap, "cknSecretIdentifier", e.CknSecretIdentifier)
	populate(objectMap, "sciState", e.SciState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteLinkMacSecConfig.
func (e *ExpressRouteLinkMacSecConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cakSecretIdentifier":
			err = unpopulate(val, "CakSecretIdentifier", &e.CakSecretIdentifier)
			delete(rawMsg, key)
		case "cipher":
			err = unpopulate(val, "Cipher", &e.Cipher)
			delete(rawMsg, key)
		case "cknSecretIdentifier":
			err = unpopulate(val, "CknSecretIdentifier", &e.CknSecretIdentifier)
			delete(rawMsg, key)
		case "sciState":
			err = unpopulate(val, "SciState", &e.SciState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteLinkPropertiesFormat.
func (e ExpressRouteLinkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminState", e.AdminState)
	populate(objectMap, "coloLocation", e.ColoLocation)
	populate(objectMap, "connectorType", e.ConnectorType)
	populate(objectMap, "interfaceName", e.InterfaceName)
	populate(objectMap, "macSecConfig", e.MacSecConfig)
	populate(objectMap, "patchPanelId", e.PatchPanelID)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "rackId", e.RackID)
	populate(objectMap, "routerName", e.RouterName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteLinkPropertiesFormat.
func (e *ExpressRouteLinkPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminState":
			err = unpopulate(val, "AdminState", &e.AdminState)
			delete(rawMsg, key)
		case "coloLocation":
			err = unpopulate(val, "ColoLocation", &e.ColoLocation)
			delete(rawMsg, key)
		case "connectorType":
			err = unpopulate(val, "ConnectorType", &e.ConnectorType)
			delete(rawMsg, key)
		case "interfaceName":
			err = unpopulate(val, "InterfaceName", &e.InterfaceName)
			delete(rawMsg, key)
		case "macSecConfig":
			err = unpopulate(val, "MacSecConfig", &e.MacSecConfig)
			delete(rawMsg, key)
		case "patchPanelId":
			err = unpopulate(val, "PatchPanelID", &e.PatchPanelID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "rackId":
			err = unpopulate(val, "RackID", &e.RackID)
			delete(rawMsg, key)
		case "routerName":
			err = unpopulate(val, "RouterName", &e.RouterName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePort.
func (e ExpressRoutePort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "identity", e.Identity)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePort.
func (e *ExpressRoutePort) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &e.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortAuthorization.
func (e ExpressRoutePortAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortAuthorization.
func (e *ExpressRoutePortAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortAuthorizationListResult.
func (e ExpressRoutePortAuthorizationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortAuthorizationListResult.
func (e *ExpressRoutePortAuthorizationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortAuthorizationPropertiesFormat.
func (e ExpressRoutePortAuthorizationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationKey", e.AuthorizationKey)
	populate(objectMap, "authorizationUseStatus", e.AuthorizationUseStatus)
	populate(objectMap, "circuitResourceUri", e.CircuitResourceURI)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortAuthorizationPropertiesFormat.
func (e *ExpressRoutePortAuthorizationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationKey":
			err = unpopulate(val, "AuthorizationKey", &e.AuthorizationKey)
			delete(rawMsg, key)
		case "authorizationUseStatus":
			err = unpopulate(val, "AuthorizationUseStatus", &e.AuthorizationUseStatus)
			delete(rawMsg, key)
		case "circuitResourceUri":
			err = unpopulate(val, "CircuitResourceURI", &e.CircuitResourceURI)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortListResult.
func (e ExpressRoutePortListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortListResult.
func (e *ExpressRoutePortListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortPropertiesFormat.
func (e ExpressRoutePortPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocationDate", e.AllocationDate)
	populate(objectMap, "bandwidthInGbps", e.BandwidthInGbps)
	populate(objectMap, "billingType", e.BillingType)
	populate(objectMap, "circuits", e.Circuits)
	populate(objectMap, "encapsulation", e.Encapsulation)
	populate(objectMap, "etherType", e.EtherType)
	populate(objectMap, "links", e.Links)
	populate(objectMap, "mtu", e.Mtu)
	populate(objectMap, "peeringLocation", e.PeeringLocation)
	populate(objectMap, "provisionedBandwidthInGbps", e.ProvisionedBandwidthInGbps)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "resourceGuid", e.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortPropertiesFormat.
func (e *ExpressRoutePortPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationDate":
			err = unpopulate(val, "AllocationDate", &e.AllocationDate)
			delete(rawMsg, key)
		case "bandwidthInGbps":
			err = unpopulate(val, "BandwidthInGbps", &e.BandwidthInGbps)
			delete(rawMsg, key)
		case "billingType":
			err = unpopulate(val, "BillingType", &e.BillingType)
			delete(rawMsg, key)
		case "circuits":
			err = unpopulate(val, "Circuits", &e.Circuits)
			delete(rawMsg, key)
		case "encapsulation":
			err = unpopulate(val, "Encapsulation", &e.Encapsulation)
			delete(rawMsg, key)
		case "etherType":
			err = unpopulate(val, "EtherType", &e.EtherType)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &e.Links)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &e.Mtu)
			delete(rawMsg, key)
		case "peeringLocation":
			err = unpopulate(val, "PeeringLocation", &e.PeeringLocation)
			delete(rawMsg, key)
		case "provisionedBandwidthInGbps":
			err = unpopulate(val, "ProvisionedBandwidthInGbps", &e.ProvisionedBandwidthInGbps)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &e.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortsLocation.
func (e ExpressRoutePortsLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortsLocation.
func (e *ExpressRoutePortsLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortsLocationBandwidths.
func (e ExpressRoutePortsLocationBandwidths) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "offerName", e.OfferName)
	populate(objectMap, "valueInGbps", e.ValueInGbps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortsLocationBandwidths.
func (e *ExpressRoutePortsLocationBandwidths) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "offerName":
			err = unpopulate(val, "OfferName", &e.OfferName)
			delete(rawMsg, key)
		case "valueInGbps":
			err = unpopulate(val, "ValueInGbps", &e.ValueInGbps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortsLocationListResult.
func (e ExpressRoutePortsLocationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortsLocationListResult.
func (e *ExpressRoutePortsLocationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRoutePortsLocationPropertiesFormat.
func (e ExpressRoutePortsLocationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", e.Address)
	populate(objectMap, "availableBandwidths", e.AvailableBandwidths)
	populate(objectMap, "contact", e.Contact)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRoutePortsLocationPropertiesFormat.
func (e *ExpressRoutePortsLocationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &e.Address)
			delete(rawMsg, key)
		case "availableBandwidths":
			err = unpopulate(val, "AvailableBandwidths", &e.AvailableBandwidths)
			delete(rawMsg, key)
		case "contact":
			err = unpopulate(val, "Contact", &e.Contact)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteProviderPort.
func (e ExpressRouteProviderPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteProviderPort.
func (e *ExpressRouteProviderPort) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteProviderPortListResult.
func (e ExpressRouteProviderPortListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteProviderPortListResult.
func (e *ExpressRouteProviderPortListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteProviderPortProperties.
func (e ExpressRouteProviderPortProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "overprovisionFactor", e.OverprovisionFactor)
	populate(objectMap, "peeringLocation", e.PeeringLocation)
	populate(objectMap, "portBandwidthInMbps", e.PortBandwidthInMbps)
	populate(objectMap, "portPairDescriptor", e.PortPairDescriptor)
	populate(objectMap, "primaryAzurePort", e.PrimaryAzurePort)
	populate(objectMap, "remainingBandwidthInMbps", e.RemainingBandwidthInMbps)
	populate(objectMap, "secondaryAzurePort", e.SecondaryAzurePort)
	populate(objectMap, "usedBandwidthInMbps", e.UsedBandwidthInMbps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteProviderPortProperties.
func (e *ExpressRouteProviderPortProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "overprovisionFactor":
			err = unpopulate(val, "OverprovisionFactor", &e.OverprovisionFactor)
			delete(rawMsg, key)
		case "peeringLocation":
			err = unpopulate(val, "PeeringLocation", &e.PeeringLocation)
			delete(rawMsg, key)
		case "portBandwidthInMbps":
			err = unpopulate(val, "PortBandwidthInMbps", &e.PortBandwidthInMbps)
			delete(rawMsg, key)
		case "portPairDescriptor":
			err = unpopulate(val, "PortPairDescriptor", &e.PortPairDescriptor)
			delete(rawMsg, key)
		case "primaryAzurePort":
			err = unpopulate(val, "PrimaryAzurePort", &e.PrimaryAzurePort)
			delete(rawMsg, key)
		case "remainingBandwidthInMbps":
			err = unpopulate(val, "RemainingBandwidthInMbps", &e.RemainingBandwidthInMbps)
			delete(rawMsg, key)
		case "secondaryAzurePort":
			err = unpopulate(val, "SecondaryAzurePort", &e.SecondaryAzurePort)
			delete(rawMsg, key)
		case "usedBandwidthInMbps":
			err = unpopulate(val, "UsedBandwidthInMbps", &e.UsedBandwidthInMbps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteServiceProvider.
func (e ExpressRouteServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteServiceProvider.
func (e *ExpressRouteServiceProvider) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteServiceProviderBandwidthsOffered.
func (e ExpressRouteServiceProviderBandwidthsOffered) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "offerName", e.OfferName)
	populate(objectMap, "valueInMbps", e.ValueInMbps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteServiceProviderBandwidthsOffered.
func (e *ExpressRouteServiceProviderBandwidthsOffered) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "offerName":
			err = unpopulate(val, "OfferName", &e.OfferName)
			delete(rawMsg, key)
		case "valueInMbps":
			err = unpopulate(val, "ValueInMbps", &e.ValueInMbps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteServiceProviderListResult.
func (e ExpressRouteServiceProviderListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteServiceProviderListResult.
func (e *ExpressRouteServiceProviderListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpressRouteServiceProviderPropertiesFormat.
func (e ExpressRouteServiceProviderPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bandwidthsOffered", e.BandwidthsOffered)
	populate(objectMap, "peeringLocations", e.PeeringLocations)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpressRouteServiceProviderPropertiesFormat.
func (e *ExpressRouteServiceProviderPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bandwidthsOffered":
			err = unpopulate(val, "BandwidthsOffered", &e.BandwidthsOffered)
			delete(rawMsg, key)
		case "peeringLocations":
			err = unpopulate(val, "PeeringLocations", &e.PeeringLocations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilterItems.
func (f FilterItems) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "field", f.Field)
	populate(objectMap, "values", f.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilterItems.
func (f *FilterItems) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "field":
			err = unpopulate(val, "Field", &f.Field)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &f.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPacketCaptureParameters.
func (f FirewallPacketCaptureParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "properties", f.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPacketCaptureParameters.
func (f *FirewallPacketCaptureParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPacketCaptureParametersFormat.
func (f FirewallPacketCaptureParametersFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "durationInSeconds", f.DurationInSeconds)
	populate(objectMap, "fileName", f.FileName)
	populate(objectMap, "filters", f.Filters)
	populate(objectMap, "flags", f.Flags)
	populate(objectMap, "numberOfPacketsToCapture", f.NumberOfPacketsToCapture)
	populate(objectMap, "protocol", f.Protocol)
	populate(objectMap, "sasUrl", f.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPacketCaptureParametersFormat.
func (f *FirewallPacketCaptureParametersFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "durationInSeconds":
			err = unpopulate(val, "DurationInSeconds", &f.DurationInSeconds)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &f.FileName)
			delete(rawMsg, key)
		case "filters":
			err = unpopulate(val, "Filters", &f.Filters)
			delete(rawMsg, key)
		case "flags":
			err = unpopulate(val, "Flags", &f.Flags)
			delete(rawMsg, key)
		case "numberOfPacketsToCapture":
			err = unpopulate(val, "NumberOfPacketsToCapture", &f.NumberOfPacketsToCapture)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &f.Protocol)
			delete(rawMsg, key)
		case "sasUrl":
			err = unpopulate(val, "SasURL", &f.SasURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicy.
func (f FirewallPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "identity", f.Identity)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicy.
func (f *FirewallPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &f.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyCertificateAuthority.
func (f FirewallPolicyCertificateAuthority) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyVaultSecretId", f.KeyVaultSecretID)
	populate(objectMap, "name", f.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyCertificateAuthority.
func (f *FirewallPolicyCertificateAuthority) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyVaultSecretId":
			err = unpopulate(val, "KeyVaultSecretID", &f.KeyVaultSecretID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyFilterRuleCollection.
func (f FirewallPolicyFilterRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", f.Action)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "priority", f.Priority)
	objectMap["ruleCollectionType"] = FirewallPolicyRuleCollectionTypeFirewallPolicyFilterRuleCollection
	populate(objectMap, "rules", f.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyFilterRuleCollection.
func (f *FirewallPolicyFilterRuleCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &f.Action)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &f.Priority)
			delete(rawMsg, key)
		case "ruleCollectionType":
			err = unpopulate(val, "RuleCollectionType", &f.RuleCollectionType)
			delete(rawMsg, key)
		case "rules":
			f.Rules, err = unmarshalFirewallPolicyRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyFilterRuleCollectionAction.
func (f FirewallPolicyFilterRuleCollectionAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyFilterRuleCollectionAction.
func (f *FirewallPolicyFilterRuleCollectionAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyHTTPHeaderToInsert.
func (f FirewallPolicyHTTPHeaderToInsert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "headerName", f.HeaderName)
	populate(objectMap, "headerValue", f.HeaderValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyHTTPHeaderToInsert.
func (f *FirewallPolicyHTTPHeaderToInsert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headerName":
			err = unpopulate(val, "HeaderName", &f.HeaderName)
			delete(rawMsg, key)
		case "headerValue":
			err = unpopulate(val, "HeaderValue", &f.HeaderValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyInsights.
func (f FirewallPolicyInsights) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isEnabled", f.IsEnabled)
	populate(objectMap, "logAnalyticsResources", f.LogAnalyticsResources)
	populate(objectMap, "retentionDays", f.RetentionDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyInsights.
func (f *FirewallPolicyInsights) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &f.IsEnabled)
			delete(rawMsg, key)
		case "logAnalyticsResources":
			err = unpopulate(val, "LogAnalyticsResources", &f.LogAnalyticsResources)
			delete(rawMsg, key)
		case "retentionDays":
			err = unpopulate(val, "RetentionDays", &f.RetentionDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyIntrusionDetection.
func (f FirewallPolicyIntrusionDetection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configuration", f.Configuration)
	populate(objectMap, "mode", f.Mode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyIntrusionDetection.
func (f *FirewallPolicyIntrusionDetection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &f.Configuration)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &f.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyIntrusionDetectionBypassTrafficSpecifications.
func (f FirewallPolicyIntrusionDetectionBypassTrafficSpecifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "destinationAddresses", f.DestinationAddresses)
	populate(objectMap, "destinationIpGroups", f.DestinationIPGroups)
	populate(objectMap, "destinationPorts", f.DestinationPorts)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "protocol", f.Protocol)
	populate(objectMap, "sourceAddresses", f.SourceAddresses)
	populate(objectMap, "sourceIpGroups", f.SourceIPGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyIntrusionDetectionBypassTrafficSpecifications.
func (f *FirewallPolicyIntrusionDetectionBypassTrafficSpecifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "destinationAddresses":
			err = unpopulate(val, "DestinationAddresses", &f.DestinationAddresses)
			delete(rawMsg, key)
		case "destinationIpGroups":
			err = unpopulate(val, "DestinationIPGroups", &f.DestinationIPGroups)
			delete(rawMsg, key)
		case "destinationPorts":
			err = unpopulate(val, "DestinationPorts", &f.DestinationPorts)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &f.Protocol)
			delete(rawMsg, key)
		case "sourceAddresses":
			err = unpopulate(val, "SourceAddresses", &f.SourceAddresses)
			delete(rawMsg, key)
		case "sourceIpGroups":
			err = unpopulate(val, "SourceIPGroups", &f.SourceIPGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyIntrusionDetectionConfiguration.
func (f FirewallPolicyIntrusionDetectionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bypassTrafficSettings", f.BypassTrafficSettings)
	populate(objectMap, "privateRanges", f.PrivateRanges)
	populate(objectMap, "signatureOverrides", f.SignatureOverrides)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyIntrusionDetectionConfiguration.
func (f *FirewallPolicyIntrusionDetectionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bypassTrafficSettings":
			err = unpopulate(val, "BypassTrafficSettings", &f.BypassTrafficSettings)
			delete(rawMsg, key)
		case "privateRanges":
			err = unpopulate(val, "PrivateRanges", &f.PrivateRanges)
			delete(rawMsg, key)
		case "signatureOverrides":
			err = unpopulate(val, "SignatureOverrides", &f.SignatureOverrides)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyIntrusionDetectionSignatureSpecification.
func (f FirewallPolicyIntrusionDetectionSignatureSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "mode", f.Mode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyIntrusionDetectionSignatureSpecification.
func (f *FirewallPolicyIntrusionDetectionSignatureSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &f.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyListResult.
func (f FirewallPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyListResult.
func (f *FirewallPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyLogAnalyticsResources.
func (f FirewallPolicyLogAnalyticsResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultWorkspaceId", f.DefaultWorkspaceID)
	populate(objectMap, "workspaces", f.Workspaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyLogAnalyticsResources.
func (f *FirewallPolicyLogAnalyticsResources) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultWorkspaceId":
			err = unpopulate(val, "DefaultWorkspaceID", &f.DefaultWorkspaceID)
			delete(rawMsg, key)
		case "workspaces":
			err = unpopulate(val, "Workspaces", &f.Workspaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyLogAnalyticsWorkspace.
func (f FirewallPolicyLogAnalyticsWorkspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "region", f.Region)
	populate(objectMap, "workspaceId", f.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyLogAnalyticsWorkspace.
func (f *FirewallPolicyLogAnalyticsWorkspace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "region":
			err = unpopulate(val, "Region", &f.Region)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &f.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyNatRuleCollection.
func (f FirewallPolicyNatRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", f.Action)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "priority", f.Priority)
	objectMap["ruleCollectionType"] = FirewallPolicyRuleCollectionTypeFirewallPolicyNatRuleCollection
	populate(objectMap, "rules", f.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyNatRuleCollection.
func (f *FirewallPolicyNatRuleCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &f.Action)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &f.Priority)
			delete(rawMsg, key)
		case "ruleCollectionType":
			err = unpopulate(val, "RuleCollectionType", &f.RuleCollectionType)
			delete(rawMsg, key)
		case "rules":
			f.Rules, err = unmarshalFirewallPolicyRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyNatRuleCollectionAction.
func (f FirewallPolicyNatRuleCollectionAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyNatRuleCollectionAction.
func (f *FirewallPolicyNatRuleCollectionAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyPropertiesFormat.
func (f FirewallPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "basePolicy", f.BasePolicy)
	populate(objectMap, "childPolicies", f.ChildPolicies)
	populate(objectMap, "dnsSettings", f.DNSSettings)
	populate(objectMap, "explicitProxySettings", f.ExplicitProxySettings)
	populate(objectMap, "firewalls", f.Firewalls)
	populate(objectMap, "insights", f.Insights)
	populate(objectMap, "intrusionDetection", f.IntrusionDetection)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "ruleCollectionGroups", f.RuleCollectionGroups)
	populate(objectMap, "sku", f.SKU)
	populate(objectMap, "sql", f.SQL)
	populate(objectMap, "size", f.Size)
	populate(objectMap, "snat", f.Snat)
	populate(objectMap, "threatIntelMode", f.ThreatIntelMode)
	populate(objectMap, "threatIntelWhitelist", f.ThreatIntelWhitelist)
	populate(objectMap, "transportSecurity", f.TransportSecurity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyPropertiesFormat.
func (f *FirewallPolicyPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "basePolicy":
			err = unpopulate(val, "BasePolicy", &f.BasePolicy)
			delete(rawMsg, key)
		case "childPolicies":
			err = unpopulate(val, "ChildPolicies", &f.ChildPolicies)
			delete(rawMsg, key)
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &f.DNSSettings)
			delete(rawMsg, key)
		case "explicitProxySettings":
			err = unpopulate(val, "ExplicitProxySettings", &f.ExplicitProxySettings)
			delete(rawMsg, key)
		case "firewalls":
			err = unpopulate(val, "Firewalls", &f.Firewalls)
			delete(rawMsg, key)
		case "insights":
			err = unpopulate(val, "Insights", &f.Insights)
			delete(rawMsg, key)
		case "intrusionDetection":
			err = unpopulate(val, "IntrusionDetection", &f.IntrusionDetection)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "ruleCollectionGroups":
			err = unpopulate(val, "RuleCollectionGroups", &f.RuleCollectionGroups)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &f.SKU)
			delete(rawMsg, key)
		case "sql":
			err = unpopulate(val, "SQL", &f.SQL)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &f.Size)
			delete(rawMsg, key)
		case "snat":
			err = unpopulate(val, "Snat", &f.Snat)
			delete(rawMsg, key)
		case "threatIntelMode":
			err = unpopulate(val, "ThreatIntelMode", &f.ThreatIntelMode)
			delete(rawMsg, key)
		case "threatIntelWhitelist":
			err = unpopulate(val, "ThreatIntelWhitelist", &f.ThreatIntelWhitelist)
			delete(rawMsg, key)
		case "transportSecurity":
			err = unpopulate(val, "TransportSecurity", &f.TransportSecurity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyRule.
func (f FirewallPolicyRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "name", f.Name)
	objectMap["ruleType"] = f.RuleType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyRule.
func (f *FirewallPolicyRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &f.RuleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyRuleApplicationProtocol.
func (f FirewallPolicyRuleApplicationProtocol) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", f.Port)
	populate(objectMap, "protocolType", f.ProtocolType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyRuleApplicationProtocol.
func (f *FirewallPolicyRuleApplicationProtocol) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &f.Port)
			delete(rawMsg, key)
		case "protocolType":
			err = unpopulate(val, "ProtocolType", &f.ProtocolType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyRuleCollection.
func (f FirewallPolicyRuleCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "priority", f.Priority)
	objectMap["ruleCollectionType"] = f.RuleCollectionType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyRuleCollection.
func (f *FirewallPolicyRuleCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &f.Priority)
			delete(rawMsg, key)
		case "ruleCollectionType":
			err = unpopulate(val, "RuleCollectionType", &f.RuleCollectionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyRuleCollectionGroup.
func (f FirewallPolicyRuleCollectionGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyRuleCollectionGroup.
func (f *FirewallPolicyRuleCollectionGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyRuleCollectionGroupListResult.
func (f FirewallPolicyRuleCollectionGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyRuleCollectionGroupListResult.
func (f *FirewallPolicyRuleCollectionGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyRuleCollectionGroupProperties.
func (f FirewallPolicyRuleCollectionGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "priority", f.Priority)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "ruleCollections", f.RuleCollections)
	populate(objectMap, "size", f.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyRuleCollectionGroupProperties.
func (f *FirewallPolicyRuleCollectionGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "priority":
			err = unpopulate(val, "Priority", &f.Priority)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "ruleCollections":
			f.RuleCollections, err = unmarshalFirewallPolicyRuleCollectionClassificationArray(val)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &f.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicySKU.
func (f FirewallPolicySKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tier", f.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicySKU.
func (f *FirewallPolicySKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tier":
			err = unpopulate(val, "Tier", &f.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicySNAT.
func (f FirewallPolicySNAT) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoLearnPrivateRanges", f.AutoLearnPrivateRanges)
	populate(objectMap, "privateRanges", f.PrivateRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicySNAT.
func (f *FirewallPolicySNAT) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoLearnPrivateRanges":
			err = unpopulate(val, "AutoLearnPrivateRanges", &f.AutoLearnPrivateRanges)
			delete(rawMsg, key)
		case "privateRanges":
			err = unpopulate(val, "PrivateRanges", &f.PrivateRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicySQL.
func (f FirewallPolicySQL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowSqlRedirect", f.AllowSQLRedirect)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicySQL.
func (f *FirewallPolicySQL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowSqlRedirect":
			err = unpopulate(val, "AllowSQLRedirect", &f.AllowSQLRedirect)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyThreatIntelWhitelist.
func (f FirewallPolicyThreatIntelWhitelist) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdns", f.Fqdns)
	populate(objectMap, "ipAddresses", f.IPAddresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyThreatIntelWhitelist.
func (f *FirewallPolicyThreatIntelWhitelist) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdns":
			err = unpopulate(val, "Fqdns", &f.Fqdns)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &f.IPAddresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FirewallPolicyTransportSecurity.
func (f FirewallPolicyTransportSecurity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateAuthority", f.CertificateAuthority)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FirewallPolicyTransportSecurity.
func (f *FirewallPolicyTransportSecurity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateAuthority":
			err = unpopulate(val, "CertificateAuthority", &f.CertificateAuthority)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowLog.
func (f FlowLog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowLog.
func (f *FlowLog) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowLogFormatParameters.
func (f FlowLogFormatParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", f.Type)
	populate(objectMap, "version", f.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowLogFormatParameters.
func (f *FlowLogFormatParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &f.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowLogInformation.
func (f FlowLogInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "flowAnalyticsConfiguration", f.FlowAnalyticsConfiguration)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "targetResourceId", f.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowLogInformation.
func (f *FlowLogInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "flowAnalyticsConfiguration":
			err = unpopulate(val, "FlowAnalyticsConfiguration", &f.FlowAnalyticsConfiguration)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &f.TargetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowLogListResult.
func (f FlowLogListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowLogListResult.
func (f *FlowLogListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowLogProperties.
func (f FlowLogProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", f.Enabled)
	populate(objectMap, "format", f.Format)
	populate(objectMap, "retentionPolicy", f.RetentionPolicy)
	populate(objectMap, "storageId", f.StorageID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowLogProperties.
func (f *FlowLogProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &f.Enabled)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &f.Format)
			delete(rawMsg, key)
		case "retentionPolicy":
			err = unpopulate(val, "RetentionPolicy", &f.RetentionPolicy)
			delete(rawMsg, key)
		case "storageId":
			err = unpopulate(val, "StorageID", &f.StorageID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowLogPropertiesFormat.
func (f FlowLogPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", f.Enabled)
	populate(objectMap, "flowAnalyticsConfiguration", f.FlowAnalyticsConfiguration)
	populate(objectMap, "format", f.Format)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "retentionPolicy", f.RetentionPolicy)
	populate(objectMap, "storageId", f.StorageID)
	populate(objectMap, "targetResourceGuid", f.TargetResourceGUID)
	populate(objectMap, "targetResourceId", f.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowLogPropertiesFormat.
func (f *FlowLogPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &f.Enabled)
			delete(rawMsg, key)
		case "flowAnalyticsConfiguration":
			err = unpopulate(val, "FlowAnalyticsConfiguration", &f.FlowAnalyticsConfiguration)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &f.Format)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "retentionPolicy":
			err = unpopulate(val, "RetentionPolicy", &f.RetentionPolicy)
			delete(rawMsg, key)
		case "storageId":
			err = unpopulate(val, "StorageID", &f.StorageID)
			delete(rawMsg, key)
		case "targetResourceGuid":
			err = unpopulate(val, "TargetResourceGUID", &f.TargetResourceGUID)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &f.TargetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowLogStatusParameters.
func (f FlowLogStatusParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetResourceId", f.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowLogStatusParameters.
func (f *FlowLogStatusParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &f.TargetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendIPConfiguration.
func (f FrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "type", f.Type)
	populate(objectMap, "zones", f.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendIPConfiguration.
func (f *FrontendIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &f.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendIPConfigurationPropertiesFormat.
func (f FrontendIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "gatewayLoadBalancer", f.GatewayLoadBalancer)
	populate(objectMap, "inboundNatPools", f.InboundNatPools)
	populate(objectMap, "inboundNatRules", f.InboundNatRules)
	populate(objectMap, "loadBalancingRules", f.LoadBalancingRules)
	populate(objectMap, "outboundRules", f.OutboundRules)
	populate(objectMap, "privateIPAddress", f.PrivateIPAddress)
	populate(objectMap, "privateIPAddressVersion", f.PrivateIPAddressVersion)
	populate(objectMap, "privateIPAllocationMethod", f.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "publicIPAddress", f.PublicIPAddress)
	populate(objectMap, "publicIPPrefix", f.PublicIPPrefix)
	populate(objectMap, "subnet", f.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendIPConfigurationPropertiesFormat.
func (f *FrontendIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "gatewayLoadBalancer":
			err = unpopulate(val, "GatewayLoadBalancer", &f.GatewayLoadBalancer)
			delete(rawMsg, key)
		case "inboundNatPools":
			err = unpopulate(val, "InboundNatPools", &f.InboundNatPools)
			delete(rawMsg, key)
		case "inboundNatRules":
			err = unpopulate(val, "InboundNatRules", &f.InboundNatRules)
			delete(rawMsg, key)
		case "loadBalancingRules":
			err = unpopulate(val, "LoadBalancingRules", &f.LoadBalancingRules)
			delete(rawMsg, key)
		case "outboundRules":
			err = unpopulate(val, "OutboundRules", &f.OutboundRules)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &f.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &f.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &f.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &f.PublicIPAddress)
			delete(rawMsg, key)
		case "publicIPPrefix":
			err = unpopulate(val, "PublicIPPrefix", &f.PublicIPPrefix)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &f.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayCustomBgpIPAddressIPConfiguration.
func (g GatewayCustomBgpIPAddressIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customBgpIpAddress", g.CustomBgpIPAddress)
	populate(objectMap, "ipConfigurationId", g.IPConfigurationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayCustomBgpIPAddressIPConfiguration.
func (g *GatewayCustomBgpIPAddressIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customBgpIpAddress":
			err = unpopulate(val, "CustomBgpIPAddress", &g.CustomBgpIPAddress)
			delete(rawMsg, key)
		case "ipConfigurationId":
			err = unpopulate(val, "IPConfigurationID", &g.IPConfigurationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayLoadBalancerTunnelInterface.
func (g GatewayLoadBalancerTunnelInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identifier", g.Identifier)
	populate(objectMap, "port", g.Port)
	populate(objectMap, "protocol", g.Protocol)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayLoadBalancerTunnelInterface.
func (g *GatewayLoadBalancerTunnelInterface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identifier":
			err = unpopulate(val, "Identifier", &g.Identifier)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &g.Port)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &g.Protocol)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayRoute.
func (g GatewayRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asPath", g.AsPath)
	populate(objectMap, "localAddress", g.LocalAddress)
	populate(objectMap, "network", g.Network)
	populate(objectMap, "nextHop", g.NextHop)
	populate(objectMap, "origin", g.Origin)
	populate(objectMap, "sourcePeer", g.SourcePeer)
	populate(objectMap, "weight", g.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayRoute.
func (g *GatewayRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asPath":
			err = unpopulate(val, "AsPath", &g.AsPath)
			delete(rawMsg, key)
		case "localAddress":
			err = unpopulate(val, "LocalAddress", &g.LocalAddress)
			delete(rawMsg, key)
		case "network":
			err = unpopulate(val, "Network", &g.Network)
			delete(rawMsg, key)
		case "nextHop":
			err = unpopulate(val, "NextHop", &g.NextHop)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &g.Origin)
			delete(rawMsg, key)
		case "sourcePeer":
			err = unpopulate(val, "SourcePeer", &g.SourcePeer)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &g.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayRouteListResult.
func (g GatewayRouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayRouteListResult.
func (g *GatewayRouteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateExpressRoutePortsLOARequest.
func (g GenerateExpressRoutePortsLOARequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customerName", g.CustomerName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateExpressRoutePortsLOARequest.
func (g *GenerateExpressRoutePortsLOARequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customerName":
			err = unpopulate(val, "CustomerName", &g.CustomerName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateExpressRoutePortsLOAResult.
func (g GenerateExpressRoutePortsLOAResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encodedContent", g.EncodedContent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateExpressRoutePortsLOAResult.
func (g *GenerateExpressRoutePortsLOAResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encodedContent":
			err = unpopulate(val, "EncodedContent", &g.EncodedContent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetInboundRoutesParameters.
func (g GetInboundRoutesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionType", g.ConnectionType)
	populate(objectMap, "resourceUri", g.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetInboundRoutesParameters.
func (g *GetInboundRoutesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionType":
			err = unpopulate(val, "ConnectionType", &g.ConnectionType)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &g.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetOutboundRoutesParameters.
func (g GetOutboundRoutesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionType", g.ConnectionType)
	populate(objectMap, "resourceUri", g.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetOutboundRoutesParameters.
func (g *GetOutboundRoutesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionType":
			err = unpopulate(val, "ConnectionType", &g.ConnectionType)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &g.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetVPNSitesConfigurationRequest.
func (g GetVPNSitesConfigurationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "outputBlobSasUrl", g.OutputBlobSasURL)
	populate(objectMap, "vpnSites", g.VPNSites)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetVPNSitesConfigurationRequest.
func (g *GetVPNSitesConfigurationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "outputBlobSasUrl":
			err = unpopulate(val, "OutputBlobSasURL", &g.OutputBlobSasURL)
			delete(rawMsg, key)
		case "vpnSites":
			err = unpopulate(val, "VPNSites", &g.VPNSites)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", g.Etag)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "systemData", g.SystemData)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Group.
func (g *Group) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &g.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &g.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupByUserSession.
func (g GroupByUserSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupByVariables", g.GroupByVariables)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupByUserSession.
func (g *GroupByUserSession) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupByVariables":
			err = unpopulate(val, "GroupByVariables", &g.GroupByVariables)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupByVariable.
func (g GroupByVariable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "variableName", g.VariableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupByVariable.
func (g *GroupByVariable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "variableName":
			err = unpopulate(val, "VariableName", &g.VariableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupListResult.
func (g GroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupListResult.
func (g *GroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupProperties.
func (g GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "resourceGuid", g.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupProperties.
func (g *GroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &g.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPConfiguration.
func (h HTTPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "headers", h.Headers)
	populate(objectMap, "method", h.Method)
	populate(objectMap, "validStatusCodes", h.ValidStatusCodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPConfiguration.
func (h *HTTPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headers":
			err = unpopulate(val, "Headers", &h.Headers)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &h.Method)
			delete(rawMsg, key)
		case "validStatusCodes":
			err = unpopulate(val, "ValidStatusCodes", &h.ValidStatusCodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPHeader.
func (h HTTPHeader) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPHeader.
func (h *HTTPHeader) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HopLink.
func (h HopLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "context", h.Context)
	populate(objectMap, "issues", h.Issues)
	populate(objectMap, "linkType", h.LinkType)
	populate(objectMap, "nextHopId", h.NextHopID)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "resourceId", h.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HopLink.
func (h *HopLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "context":
			err = unpopulate(val, "Context", &h.Context)
			delete(rawMsg, key)
		case "issues":
			err = unpopulate(val, "Issues", &h.Issues)
			delete(rawMsg, key)
		case "linkType":
			err = unpopulate(val, "LinkType", &h.LinkType)
			delete(rawMsg, key)
		case "nextHopId":
			err = unpopulate(val, "NextHopID", &h.NextHopID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &h.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HopLinkProperties.
func (h HopLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "roundTripTimeAvg", h.RoundTripTimeAvg)
	populate(objectMap, "roundTripTimeMax", h.RoundTripTimeMax)
	populate(objectMap, "roundTripTimeMin", h.RoundTripTimeMin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HopLinkProperties.
func (h *HopLinkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "roundTripTimeAvg":
			err = unpopulate(val, "RoundTripTimeAvg", &h.RoundTripTimeAvg)
			delete(rawMsg, key)
		case "roundTripTimeMax":
			err = unpopulate(val, "RoundTripTimeMax", &h.RoundTripTimeMax)
			delete(rawMsg, key)
		case "roundTripTimeMin":
			err = unpopulate(val, "RoundTripTimeMin", &h.RoundTripTimeMin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Hub.
func (h Hub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceId", h.ResourceID)
	populate(objectMap, "resourceType", h.ResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Hub.
func (h *Hub) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceId":
			err = unpopulate(val, "ResourceID", &h.ResourceID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &h.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubIPAddresses.
func (h HubIPAddresses) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAddress", h.PrivateIPAddress)
	populate(objectMap, "publicIPs", h.PublicIPs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubIPAddresses.
func (h *HubIPAddresses) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &h.PrivateIPAddress)
			delete(rawMsg, key)
		case "publicIPs":
			err = unpopulate(val, "PublicIPs", &h.PublicIPs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubIPConfiguration.
func (h HubIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", h.Etag)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubIPConfiguration.
func (h *HubIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &h.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubIPConfigurationPropertiesFormat.
func (h HubIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAddress", h.PrivateIPAddress)
	populate(objectMap, "privateIPAllocationMethod", h.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "publicIPAddress", h.PublicIPAddress)
	populate(objectMap, "subnet", h.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubIPConfigurationPropertiesFormat.
func (h *HubIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &h.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &h.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &h.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &h.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubPublicIPAddresses.
func (h HubPublicIPAddresses) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addresses", h.Addresses)
	populate(objectMap, "count", h.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubPublicIPAddresses.
func (h *HubPublicIPAddresses) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addresses":
			err = unpopulate(val, "Addresses", &h.Addresses)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &h.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubRoute.
func (h HubRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationType", h.DestinationType)
	populate(objectMap, "destinations", h.Destinations)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "nextHop", h.NextHop)
	populate(objectMap, "nextHopType", h.NextHopType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubRoute.
func (h *HubRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationType":
			err = unpopulate(val, "DestinationType", &h.DestinationType)
			delete(rawMsg, key)
		case "destinations":
			err = unpopulate(val, "Destinations", &h.Destinations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "nextHop":
			err = unpopulate(val, "NextHop", &h.NextHop)
			delete(rawMsg, key)
		case "nextHopType":
			err = unpopulate(val, "NextHopType", &h.NextHopType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubRouteTable.
func (h HubRouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", h.Etag)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubRouteTable.
func (h *HubRouteTable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &h.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubRouteTableProperties.
func (h HubRouteTableProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedConnections", h.AssociatedConnections)
	populate(objectMap, "labels", h.Labels)
	populate(objectMap, "propagatingConnections", h.PropagatingConnections)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "routes", h.Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubRouteTableProperties.
func (h *HubRouteTableProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedConnections":
			err = unpopulate(val, "AssociatedConnections", &h.AssociatedConnections)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &h.Labels)
			delete(rawMsg, key)
		case "propagatingConnections":
			err = unpopulate(val, "PropagatingConnections", &h.PropagatingConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &h.Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubVirtualNetworkConnection.
func (h HubVirtualNetworkConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", h.Etag)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubVirtualNetworkConnection.
func (h *HubVirtualNetworkConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &h.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubVirtualNetworkConnectionProperties.
func (h HubVirtualNetworkConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowHubToRemoteVnetTransit", h.AllowHubToRemoteVnetTransit)
	populate(objectMap, "allowRemoteVnetToUseHubVnetGateways", h.AllowRemoteVnetToUseHubVnetGateways)
	populate(objectMap, "enableInternetSecurity", h.EnableInternetSecurity)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "remoteVirtualNetwork", h.RemoteVirtualNetwork)
	populate(objectMap, "routingConfiguration", h.RoutingConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubVirtualNetworkConnectionProperties.
func (h *HubVirtualNetworkConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowHubToRemoteVnetTransit":
			err = unpopulate(val, "AllowHubToRemoteVnetTransit", &h.AllowHubToRemoteVnetTransit)
			delete(rawMsg, key)
		case "allowRemoteVnetToUseHubVnetGateways":
			err = unpopulate(val, "AllowRemoteVnetToUseHubVnetGateways", &h.AllowRemoteVnetToUseHubVnetGateways)
			delete(rawMsg, key)
		case "enableInternetSecurity":
			err = unpopulate(val, "EnableInternetSecurity", &h.EnableInternetSecurity)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "remoteVirtualNetwork":
			err = unpopulate(val, "RemoteVirtualNetwork", &h.RemoteVirtualNetwork)
			delete(rawMsg, key)
		case "routingConfiguration":
			err = unpopulate(val, "RoutingConfiguration", &h.RoutingConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IDPSQueryObject.
func (i IDPSQueryObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filters", i.Filters)
	populate(objectMap, "orderBy", i.OrderBy)
	populate(objectMap, "resultsPerPage", i.ResultsPerPage)
	populate(objectMap, "search", i.Search)
	populate(objectMap, "skip", i.Skip)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IDPSQueryObject.
func (i *IDPSQueryObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filters":
			err = unpopulate(val, "Filters", &i.Filters)
			delete(rawMsg, key)
		case "orderBy":
			err = unpopulate(val, "OrderBy", &i.OrderBy)
			delete(rawMsg, key)
		case "resultsPerPage":
			err = unpopulate(val, "ResultsPerPage", &i.ResultsPerPage)
			delete(rawMsg, key)
		case "search":
			err = unpopulate(val, "Search", &i.Search)
			delete(rawMsg, key)
		case "skip":
			err = unpopulate(val, "Skip", &i.Skip)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddressAvailabilityResult.
func (i IPAddressAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", i.Available)
	populate(objectMap, "availableIPAddresses", i.AvailableIPAddresses)
	populate(objectMap, "isPlatformReserved", i.IsPlatformReserved)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddressAvailabilityResult.
func (i *IPAddressAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &i.Available)
			delete(rawMsg, key)
		case "availableIPAddresses":
			err = unpopulate(val, "AvailableIPAddresses", &i.AvailableIPAddresses)
			delete(rawMsg, key)
		case "isPlatformReserved":
			err = unpopulate(val, "IsPlatformReserved", &i.IsPlatformReserved)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAllocation.
func (i IPAllocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAllocation.
func (i *IPAllocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAllocationListResult.
func (i IPAllocationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAllocationListResult.
func (i *IPAllocationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAllocationPropertiesFormat.
func (i IPAllocationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocationTags", i.AllocationTags)
	populate(objectMap, "ipamAllocationId", i.IpamAllocationID)
	populate(objectMap, "prefix", i.Prefix)
	populate(objectMap, "prefixLength", i.PrefixLength)
	populate(objectMap, "prefixType", i.PrefixType)
	populate(objectMap, "subnet", i.Subnet)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "virtualNetwork", i.VirtualNetwork)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAllocationPropertiesFormat.
func (i *IPAllocationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationTags":
			err = unpopulate(val, "AllocationTags", &i.AllocationTags)
			delete(rawMsg, key)
		case "ipamAllocationId":
			err = unpopulate(val, "IpamAllocationID", &i.IpamAllocationID)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &i.Prefix)
			delete(rawMsg, key)
		case "prefixLength":
			err = unpopulate(val, "PrefixLength", &i.PrefixLength)
			delete(rawMsg, key)
		case "prefixType":
			err = unpopulate(val, "PrefixType", &i.PrefixType)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "virtualNetwork":
			err = unpopulate(val, "VirtualNetwork", &i.VirtualNetwork)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfiguration.
func (i IPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfiguration.
func (i *IPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigurationBgpPeeringAddress.
func (i IPConfigurationBgpPeeringAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customBgpIpAddresses", i.CustomBgpIPAddresses)
	populate(objectMap, "defaultBgpIpAddresses", i.DefaultBgpIPAddresses)
	populate(objectMap, "ipconfigurationId", i.IPConfigurationID)
	populate(objectMap, "tunnelIpAddresses", i.TunnelIPAddresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigurationBgpPeeringAddress.
func (i *IPConfigurationBgpPeeringAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customBgpIpAddresses":
			err = unpopulate(val, "CustomBgpIPAddresses", &i.CustomBgpIPAddresses)
			delete(rawMsg, key)
		case "defaultBgpIpAddresses":
			err = unpopulate(val, "DefaultBgpIPAddresses", &i.DefaultBgpIPAddresses)
			delete(rawMsg, key)
		case "ipconfigurationId":
			err = unpopulate(val, "IPConfigurationID", &i.IPConfigurationID)
			delete(rawMsg, key)
		case "tunnelIpAddresses":
			err = unpopulate(val, "TunnelIPAddresses", &i.TunnelIPAddresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigurationProfile.
func (i IPConfigurationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigurationProfile.
func (i *IPConfigurationProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigurationProfilePropertiesFormat.
func (i IPConfigurationProfilePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "subnet", i.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigurationProfilePropertiesFormat.
func (i *IPConfigurationProfilePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigurationPropertiesFormat.
func (i IPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAddress", i.PrivateIPAddress)
	populate(objectMap, "privateIPAllocationMethod", i.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "publicIPAddress", i.PublicIPAddress)
	populate(objectMap, "subnet", i.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigurationPropertiesFormat.
func (i *IPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &i.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &i.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &i.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPGroup.
func (i IPGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPGroup.
func (i *IPGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPGroupListResult.
func (i IPGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPGroupListResult.
func (i *IPGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPGroupPropertiesFormat.
func (i IPGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "firewallPolicies", i.FirewallPolicies)
	populate(objectMap, "firewalls", i.Firewalls)
	populate(objectMap, "ipAddresses", i.IPAddresses)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPGroupPropertiesFormat.
func (i *IPGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "firewallPolicies":
			err = unpopulate(val, "FirewallPolicies", &i.FirewallPolicies)
			delete(rawMsg, key)
		case "firewalls":
			err = unpopulate(val, "Firewalls", &i.Firewalls)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &i.IPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPPrefixesList.
func (i IPPrefixesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipPrefixes", i.IPPrefixes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPPrefixesList.
func (i *IPPrefixesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipPrefixes":
			err = unpopulate(val, "IPPrefixes", &i.IPPrefixes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPRule.
func (i IPRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", i.AddressPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPRule.
func (i *IPRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &i.AddressPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPSecPolicy.
func (i IPSecPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dhGroup", i.DhGroup)
	populate(objectMap, "ipsecEncryption", i.IPSecEncryption)
	populate(objectMap, "ipsecIntegrity", i.IPSecIntegrity)
	populate(objectMap, "ikeEncryption", i.IkeEncryption)
	populate(objectMap, "ikeIntegrity", i.IkeIntegrity)
	populate(objectMap, "pfsGroup", i.PfsGroup)
	populate(objectMap, "saDataSizeKilobytes", i.SaDataSizeKilobytes)
	populate(objectMap, "saLifeTimeSeconds", i.SaLifeTimeSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPSecPolicy.
func (i *IPSecPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dhGroup":
			err = unpopulate(val, "DhGroup", &i.DhGroup)
			delete(rawMsg, key)
		case "ipsecEncryption":
			err = unpopulate(val, "IPSecEncryption", &i.IPSecEncryption)
			delete(rawMsg, key)
		case "ipsecIntegrity":
			err = unpopulate(val, "IPSecIntegrity", &i.IPSecIntegrity)
			delete(rawMsg, key)
		case "ikeEncryption":
			err = unpopulate(val, "IkeEncryption", &i.IkeEncryption)
			delete(rawMsg, key)
		case "ikeIntegrity":
			err = unpopulate(val, "IkeIntegrity", &i.IkeIntegrity)
			delete(rawMsg, key)
		case "pfsGroup":
			err = unpopulate(val, "PfsGroup", &i.PfsGroup)
			delete(rawMsg, key)
		case "saDataSizeKilobytes":
			err = unpopulate(val, "SaDataSizeKilobytes", &i.SaDataSizeKilobytes)
			delete(rawMsg, key)
		case "saLifeTimeSeconds":
			err = unpopulate(val, "SaLifeTimeSeconds", &i.SaLifeTimeSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPTag.
func (i IPTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipTagType", i.IPTagType)
	populate(objectMap, "tag", i.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPTag.
func (i *IPTag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipTagType":
			err = unpopulate(val, "IPTagType", &i.IPTagType)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &i.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPv6CircuitConnectionConfig.
func (i IPv6CircuitConnectionConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", i.AddressPrefix)
	populate(objectMap, "circuitConnectionStatus", i.CircuitConnectionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPv6CircuitConnectionConfig.
func (i *IPv6CircuitConnectionConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &i.AddressPrefix)
			delete(rawMsg, key)
		case "circuitConnectionStatus":
			err = unpopulate(val, "CircuitConnectionStatus", &i.CircuitConnectionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPv6ExpressRouteCircuitPeeringConfig.
func (i IPv6ExpressRouteCircuitPeeringConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "microsoftPeeringConfig", i.MicrosoftPeeringConfig)
	populate(objectMap, "primaryPeerAddressPrefix", i.PrimaryPeerAddressPrefix)
	populate(objectMap, "routeFilter", i.RouteFilter)
	populate(objectMap, "secondaryPeerAddressPrefix", i.SecondaryPeerAddressPrefix)
	populate(objectMap, "state", i.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPv6ExpressRouteCircuitPeeringConfig.
func (i *IPv6ExpressRouteCircuitPeeringConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "microsoftPeeringConfig":
			err = unpopulate(val, "MicrosoftPeeringConfig", &i.MicrosoftPeeringConfig)
			delete(rawMsg, key)
		case "primaryPeerAddressPrefix":
			err = unpopulate(val, "PrimaryPeerAddressPrefix", &i.PrimaryPeerAddressPrefix)
			delete(rawMsg, key)
		case "routeFilter":
			err = unpopulate(val, "RouteFilter", &i.RouteFilter)
			delete(rawMsg, key)
		case "secondaryPeerAddressPrefix":
			err = unpopulate(val, "SecondaryPeerAddressPrefix", &i.SecondaryPeerAddressPrefix)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatPool.
func (i InboundNatPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatPool.
func (i *InboundNatPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatPoolPropertiesFormat.
func (i InboundNatPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPort", i.BackendPort)
	populate(objectMap, "enableFloatingIP", i.EnableFloatingIP)
	populate(objectMap, "enableTcpReset", i.EnableTCPReset)
	populate(objectMap, "frontendIPConfiguration", i.FrontendIPConfiguration)
	populate(objectMap, "frontendPortRangeEnd", i.FrontendPortRangeEnd)
	populate(objectMap, "frontendPortRangeStart", i.FrontendPortRangeStart)
	populate(objectMap, "idleTimeoutInMinutes", i.IdleTimeoutInMinutes)
	populate(objectMap, "protocol", i.Protocol)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatPoolPropertiesFormat.
func (i *InboundNatPoolPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPort":
			err = unpopulate(val, "BackendPort", &i.BackendPort)
			delete(rawMsg, key)
		case "enableFloatingIP":
			err = unpopulate(val, "EnableFloatingIP", &i.EnableFloatingIP)
			delete(rawMsg, key)
		case "enableTcpReset":
			err = unpopulate(val, "EnableTCPReset", &i.EnableTCPReset)
			delete(rawMsg, key)
		case "frontendIPConfiguration":
			err = unpopulate(val, "FrontendIPConfiguration", &i.FrontendIPConfiguration)
			delete(rawMsg, key)
		case "frontendPortRangeEnd":
			err = unpopulate(val, "FrontendPortRangeEnd", &i.FrontendPortRangeEnd)
			delete(rawMsg, key)
		case "frontendPortRangeStart":
			err = unpopulate(val, "FrontendPortRangeStart", &i.FrontendPortRangeStart)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &i.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &i.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatRule.
func (i InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatRule.
func (i *InboundNatRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatRuleListResult.
func (i InboundNatRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatRuleListResult.
func (i *InboundNatRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatRulePortMapping.
func (i InboundNatRulePortMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPort", i.BackendPort)
	populate(objectMap, "frontendPort", i.FrontendPort)
	populate(objectMap, "inboundNatRuleName", i.InboundNatRuleName)
	populate(objectMap, "protocol", i.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatRulePortMapping.
func (i *InboundNatRulePortMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPort":
			err = unpopulate(val, "BackendPort", &i.BackendPort)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &i.FrontendPort)
			delete(rawMsg, key)
		case "inboundNatRuleName":
			err = unpopulate(val, "InboundNatRuleName", &i.InboundNatRuleName)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &i.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatRulePropertiesFormat.
func (i InboundNatRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", i.BackendAddressPool)
	populate(objectMap, "backendIPConfiguration", i.BackendIPConfiguration)
	populate(objectMap, "backendPort", i.BackendPort)
	populate(objectMap, "enableFloatingIP", i.EnableFloatingIP)
	populate(objectMap, "enableTcpReset", i.EnableTCPReset)
	populate(objectMap, "frontendIPConfiguration", i.FrontendIPConfiguration)
	populate(objectMap, "frontendPort", i.FrontendPort)
	populate(objectMap, "frontendPortRangeEnd", i.FrontendPortRangeEnd)
	populate(objectMap, "frontendPortRangeStart", i.FrontendPortRangeStart)
	populate(objectMap, "idleTimeoutInMinutes", i.IdleTimeoutInMinutes)
	populate(objectMap, "protocol", i.Protocol)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatRulePropertiesFormat.
func (i *InboundNatRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &i.BackendAddressPool)
			delete(rawMsg, key)
		case "backendIPConfiguration":
			err = unpopulate(val, "BackendIPConfiguration", &i.BackendIPConfiguration)
			delete(rawMsg, key)
		case "backendPort":
			err = unpopulate(val, "BackendPort", &i.BackendPort)
			delete(rawMsg, key)
		case "enableFloatingIP":
			err = unpopulate(val, "EnableFloatingIP", &i.EnableFloatingIP)
			delete(rawMsg, key)
		case "enableTcpReset":
			err = unpopulate(val, "EnableTCPReset", &i.EnableTCPReset)
			delete(rawMsg, key)
		case "frontendIPConfiguration":
			err = unpopulate(val, "FrontendIPConfiguration", &i.FrontendIPConfiguration)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &i.FrontendPort)
			delete(rawMsg, key)
		case "frontendPortRangeEnd":
			err = unpopulate(val, "FrontendPortRangeEnd", &i.FrontendPortRangeEnd)
			delete(rawMsg, key)
		case "frontendPortRangeStart":
			err = unpopulate(val, "FrontendPortRangeStart", &i.FrontendPortRangeStart)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &i.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &i.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundSecurityRule.
func (i InboundSecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundSecurityRule.
func (i *InboundSecurityRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundSecurityRuleProperties.
func (i InboundSecurityRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "rules", i.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundSecurityRuleProperties.
func (i *InboundSecurityRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &i.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundSecurityRules.
func (i InboundSecurityRules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationPortRange", i.DestinationPortRange)
	populate(objectMap, "protocol", i.Protocol)
	populate(objectMap, "sourceAddressPrefix", i.SourceAddressPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundSecurityRules.
func (i *InboundSecurityRules) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationPortRange":
			err = unpopulate(val, "DestinationPortRange", &i.DestinationPortRange)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &i.Protocol)
			delete(rawMsg, key)
		case "sourceAddressPrefix":
			err = unpopulate(val, "SourceAddressPrefix", &i.SourceAddressPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntentPolicy.
func (i IntentPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntentPolicy.
func (i *IntentPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntentPolicyConfiguration.
func (i IntentPolicyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkIntentPolicyName", i.NetworkIntentPolicyName)
	populate(objectMap, "sourceNetworkIntentPolicy", i.SourceNetworkIntentPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntentPolicyConfiguration.
func (i *IntentPolicyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkIntentPolicyName":
			err = unpopulate(val, "NetworkIntentPolicyName", &i.NetworkIntentPolicyName)
			delete(rawMsg, key)
		case "sourceNetworkIntentPolicy":
			err = unpopulate(val, "SourceNetworkIntentPolicy", &i.SourceNetworkIntentPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Interface.
func (i Interface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "extendedLocation", i.ExtendedLocation)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Interface.
func (i *Interface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &i.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceAssociation.
func (i InterfaceAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "securityRules", i.SecurityRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceAssociation.
func (i *InterfaceAssociation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "securityRules":
			err = unpopulate(val, "SecurityRules", &i.SecurityRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceDNSSettings.
func (i InterfaceDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedDnsServers", i.AppliedDNSServers)
	populate(objectMap, "dnsServers", i.DNSServers)
	populate(objectMap, "internalDnsNameLabel", i.InternalDNSNameLabel)
	populate(objectMap, "internalDomainNameSuffix", i.InternalDomainNameSuffix)
	populate(objectMap, "internalFqdn", i.InternalFqdn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceDNSSettings.
func (i *InterfaceDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedDnsServers":
			err = unpopulate(val, "AppliedDNSServers", &i.AppliedDNSServers)
			delete(rawMsg, key)
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &i.DNSServers)
			delete(rawMsg, key)
		case "internalDnsNameLabel":
			err = unpopulate(val, "InternalDNSNameLabel", &i.InternalDNSNameLabel)
			delete(rawMsg, key)
		case "internalDomainNameSuffix":
			err = unpopulate(val, "InternalDomainNameSuffix", &i.InternalDomainNameSuffix)
			delete(rawMsg, key)
		case "internalFqdn":
			err = unpopulate(val, "InternalFqdn", &i.InternalFqdn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceIPConfiguration.
func (i InterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceIPConfiguration.
func (i *InterfaceIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceIPConfigurationListResult.
func (i InterfaceIPConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceIPConfigurationListResult.
func (i *InterfaceIPConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceIPConfigurationPrivateLinkConnectionProperties.
func (i InterfaceIPConfigurationPrivateLinkConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdns", i.Fqdns)
	populate(objectMap, "groupId", i.GroupID)
	populate(objectMap, "requiredMemberName", i.RequiredMemberName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceIPConfigurationPrivateLinkConnectionProperties.
func (i *InterfaceIPConfigurationPrivateLinkConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdns":
			err = unpopulate(val, "Fqdns", &i.Fqdns)
			delete(rawMsg, key)
		case "groupId":
			err = unpopulate(val, "GroupID", &i.GroupID)
			delete(rawMsg, key)
		case "requiredMemberName":
			err = unpopulate(val, "RequiredMemberName", &i.RequiredMemberName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceIPConfigurationPropertiesFormat.
func (i InterfaceIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGatewayBackendAddressPools", i.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", i.ApplicationSecurityGroups)
	populate(objectMap, "gatewayLoadBalancer", i.GatewayLoadBalancer)
	populate(objectMap, "loadBalancerBackendAddressPools", i.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerInboundNatRules", i.LoadBalancerInboundNatRules)
	populate(objectMap, "primary", i.Primary)
	populate(objectMap, "privateIPAddress", i.PrivateIPAddress)
	populate(objectMap, "privateIPAddressVersion", i.PrivateIPAddressVersion)
	populate(objectMap, "privateIPAllocationMethod", i.PrivateIPAllocationMethod)
	populate(objectMap, "privateLinkConnectionProperties", i.PrivateLinkConnectionProperties)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "publicIPAddress", i.PublicIPAddress)
	populate(objectMap, "subnet", i.Subnet)
	populate(objectMap, "virtualNetworkTaps", i.VirtualNetworkTaps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceIPConfigurationPropertiesFormat.
func (i *InterfaceIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGatewayBackendAddressPools":
			err = unpopulate(val, "ApplicationGatewayBackendAddressPools", &i.ApplicationGatewayBackendAddressPools)
			delete(rawMsg, key)
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &i.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "gatewayLoadBalancer":
			err = unpopulate(val, "GatewayLoadBalancer", &i.GatewayLoadBalancer)
			delete(rawMsg, key)
		case "loadBalancerBackendAddressPools":
			err = unpopulate(val, "LoadBalancerBackendAddressPools", &i.LoadBalancerBackendAddressPools)
			delete(rawMsg, key)
		case "loadBalancerInboundNatRules":
			err = unpopulate(val, "LoadBalancerInboundNatRules", &i.LoadBalancerInboundNatRules)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &i.Primary)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &i.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &i.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &i.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "privateLinkConnectionProperties":
			err = unpopulate(val, "PrivateLinkConnectionProperties", &i.PrivateLinkConnectionProperties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &i.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		case "virtualNetworkTaps":
			err = unpopulate(val, "VirtualNetworkTaps", &i.VirtualNetworkTaps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceListResult.
func (i InterfaceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceListResult.
func (i *InterfaceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceLoadBalancerListResult.
func (i InterfaceLoadBalancerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceLoadBalancerListResult.
func (i *InterfaceLoadBalancerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfacePropertiesFormat.
func (i InterfacePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "auxiliaryMode", i.AuxiliaryMode)
	populate(objectMap, "auxiliarySku", i.AuxiliarySKU)
	populate(objectMap, "dnsSettings", i.DNSSettings)
	populate(objectMap, "disableTcpStateTracking", i.DisableTCPStateTracking)
	populate(objectMap, "dscpConfiguration", i.DscpConfiguration)
	populate(objectMap, "enableAcceleratedNetworking", i.EnableAcceleratedNetworking)
	populate(objectMap, "enableIPForwarding", i.EnableIPForwarding)
	populate(objectMap, "hostedWorkloads", i.HostedWorkloads)
	populate(objectMap, "ipConfigurations", i.IPConfigurations)
	populate(objectMap, "macAddress", i.MacAddress)
	populate(objectMap, "migrationPhase", i.MigrationPhase)
	populate(objectMap, "networkSecurityGroup", i.NetworkSecurityGroup)
	populate(objectMap, "nicType", i.NicType)
	populate(objectMap, "primary", i.Primary)
	populate(objectMap, "privateEndpoint", i.PrivateEndpoint)
	populate(objectMap, "privateLinkService", i.PrivateLinkService)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "resourceGuid", i.ResourceGUID)
	populate(objectMap, "tapConfigurations", i.TapConfigurations)
	populate(objectMap, "virtualMachine", i.VirtualMachine)
	populate(objectMap, "vnetEncryptionSupported", i.VnetEncryptionSupported)
	populate(objectMap, "workloadType", i.WorkloadType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfacePropertiesFormat.
func (i *InterfacePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "auxiliaryMode":
			err = unpopulate(val, "AuxiliaryMode", &i.AuxiliaryMode)
			delete(rawMsg, key)
		case "auxiliarySku":
			err = unpopulate(val, "AuxiliarySKU", &i.AuxiliarySKU)
			delete(rawMsg, key)
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &i.DNSSettings)
			delete(rawMsg, key)
		case "disableTcpStateTracking":
			err = unpopulate(val, "DisableTCPStateTracking", &i.DisableTCPStateTracking)
			delete(rawMsg, key)
		case "dscpConfiguration":
			err = unpopulate(val, "DscpConfiguration", &i.DscpConfiguration)
			delete(rawMsg, key)
		case "enableAcceleratedNetworking":
			err = unpopulate(val, "EnableAcceleratedNetworking", &i.EnableAcceleratedNetworking)
			delete(rawMsg, key)
		case "enableIPForwarding":
			err = unpopulate(val, "EnableIPForwarding", &i.EnableIPForwarding)
			delete(rawMsg, key)
		case "hostedWorkloads":
			err = unpopulate(val, "HostedWorkloads", &i.HostedWorkloads)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &i.IPConfigurations)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &i.MacAddress)
			delete(rawMsg, key)
		case "migrationPhase":
			err = unpopulate(val, "MigrationPhase", &i.MigrationPhase)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &i.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "nicType":
			err = unpopulate(val, "NicType", &i.NicType)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &i.Primary)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &i.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkService":
			err = unpopulate(val, "PrivateLinkService", &i.PrivateLinkService)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &i.ResourceGUID)
			delete(rawMsg, key)
		case "tapConfigurations":
			err = unpopulate(val, "TapConfigurations", &i.TapConfigurations)
			delete(rawMsg, key)
		case "virtualMachine":
			err = unpopulate(val, "VirtualMachine", &i.VirtualMachine)
			delete(rawMsg, key)
		case "vnetEncryptionSupported":
			err = unpopulate(val, "VnetEncryptionSupported", &i.VnetEncryptionSupported)
			delete(rawMsg, key)
		case "workloadType":
			err = unpopulate(val, "WorkloadType", &i.WorkloadType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceTapConfiguration.
func (i InterfaceTapConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceTapConfiguration.
func (i *InterfaceTapConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceTapConfigurationListResult.
func (i InterfaceTapConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceTapConfigurationListResult.
func (i *InterfaceTapConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceTapConfigurationPropertiesFormat.
func (i InterfaceTapConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "virtualNetworkTap", i.VirtualNetworkTap)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceTapConfigurationPropertiesFormat.
func (i *InterfaceTapConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "virtualNetworkTap":
			err = unpopulate(val, "VirtualNetworkTap", &i.VirtualNetworkTap)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListHubRouteTablesResult.
func (l ListHubRouteTablesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListHubRouteTablesResult.
func (l *ListHubRouteTablesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListHubVirtualNetworkConnectionsResult.
func (l ListHubVirtualNetworkConnectionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListHubVirtualNetworkConnectionsResult.
func (l *ListHubVirtualNetworkConnectionsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListP2SVPNGatewaysResult.
func (l ListP2SVPNGatewaysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListP2SVPNGatewaysResult.
func (l *ListP2SVPNGatewaysResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListRouteMapsResult.
func (l ListRouteMapsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListRouteMapsResult.
func (l *ListRouteMapsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListRoutingIntentResult.
func (l ListRoutingIntentResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListRoutingIntentResult.
func (l *ListRoutingIntentResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVPNConnectionsResult.
func (l ListVPNConnectionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVPNConnectionsResult.
func (l *ListVPNConnectionsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVPNGatewayNatRulesResult.
func (l ListVPNGatewayNatRulesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVPNGatewayNatRulesResult.
func (l *ListVPNGatewayNatRulesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVPNGatewaysResult.
func (l ListVPNGatewaysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVPNGatewaysResult.
func (l *ListVPNGatewaysResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVPNServerConfigurationPolicyGroupsResult.
func (l ListVPNServerConfigurationPolicyGroupsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVPNServerConfigurationPolicyGroupsResult.
func (l *ListVPNServerConfigurationPolicyGroupsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVPNServerConfigurationsResult.
func (l ListVPNServerConfigurationsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVPNServerConfigurationsResult.
func (l *ListVPNServerConfigurationsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVPNSiteLinkConnectionsResult.
func (l ListVPNSiteLinkConnectionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVPNSiteLinkConnectionsResult.
func (l *ListVPNSiteLinkConnectionsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVPNSiteLinksResult.
func (l ListVPNSiteLinksResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVPNSiteLinksResult.
func (l *ListVPNSiteLinksResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVPNSitesResult.
func (l ListVPNSitesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVPNSitesResult.
func (l *ListVPNSitesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVirtualHubBgpConnectionResults.
func (l ListVirtualHubBgpConnectionResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVirtualHubBgpConnectionResults.
func (l *ListVirtualHubBgpConnectionResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVirtualHubIPConfigurationResults.
func (l ListVirtualHubIPConfigurationResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVirtualHubIPConfigurationResults.
func (l *ListVirtualHubIPConfigurationResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVirtualHubRouteTableV2SResult.
func (l ListVirtualHubRouteTableV2SResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVirtualHubRouteTableV2SResult.
func (l *ListVirtualHubRouteTableV2SResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVirtualHubsResult.
func (l ListVirtualHubsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVirtualHubsResult.
func (l *ListVirtualHubsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVirtualNetworkGatewayNatRulesResult.
func (l ListVirtualNetworkGatewayNatRulesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVirtualNetworkGatewayNatRulesResult.
func (l *ListVirtualNetworkGatewayNatRulesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListVirtualWANsResult.
func (l ListVirtualWANsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListVirtualWANsResult.
func (l *ListVirtualWANsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancer.
func (l LoadBalancer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "extendedLocation", l.ExtendedLocation)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "sku", l.SKU)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancer.
func (l *LoadBalancer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &l.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &l.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerBackendAddress.
func (l LoadBalancerBackendAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerBackendAddress.
func (l *LoadBalancerBackendAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerBackendAddressPoolListResult.
func (l LoadBalancerBackendAddressPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerBackendAddressPoolListResult.
func (l *LoadBalancerBackendAddressPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerBackendAddressPropertiesFormat.
func (l LoadBalancerBackendAddressPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminState", l.AdminState)
	populate(objectMap, "ipAddress", l.IPAddress)
	populate(objectMap, "inboundNatRulesPortMapping", l.InboundNatRulesPortMapping)
	populate(objectMap, "loadBalancerFrontendIPConfiguration", l.LoadBalancerFrontendIPConfiguration)
	populate(objectMap, "networkInterfaceIPConfiguration", l.NetworkInterfaceIPConfiguration)
	populate(objectMap, "subnet", l.Subnet)
	populate(objectMap, "virtualNetwork", l.VirtualNetwork)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerBackendAddressPropertiesFormat.
func (l *LoadBalancerBackendAddressPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminState":
			err = unpopulate(val, "AdminState", &l.AdminState)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &l.IPAddress)
			delete(rawMsg, key)
		case "inboundNatRulesPortMapping":
			err = unpopulate(val, "InboundNatRulesPortMapping", &l.InboundNatRulesPortMapping)
			delete(rawMsg, key)
		case "loadBalancerFrontendIPConfiguration":
			err = unpopulate(val, "LoadBalancerFrontendIPConfiguration", &l.LoadBalancerFrontendIPConfiguration)
			delete(rawMsg, key)
		case "networkInterfaceIPConfiguration":
			err = unpopulate(val, "NetworkInterfaceIPConfiguration", &l.NetworkInterfaceIPConfiguration)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &l.Subnet)
			delete(rawMsg, key)
		case "virtualNetwork":
			err = unpopulate(val, "VirtualNetwork", &l.VirtualNetwork)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerFrontendIPConfigurationListResult.
func (l LoadBalancerFrontendIPConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerFrontendIPConfigurationListResult.
func (l *LoadBalancerFrontendIPConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerListResult.
func (l LoadBalancerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerListResult.
func (l *LoadBalancerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerLoadBalancingRuleListResult.
func (l LoadBalancerLoadBalancingRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerLoadBalancingRuleListResult.
func (l *LoadBalancerLoadBalancingRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerOutboundRuleListResult.
func (l LoadBalancerOutboundRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerOutboundRuleListResult.
func (l *LoadBalancerOutboundRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerProbeListResult.
func (l LoadBalancerProbeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerProbeListResult.
func (l *LoadBalancerProbeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerPropertiesFormat.
func (l LoadBalancerPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPools", l.BackendAddressPools)
	populate(objectMap, "frontendIPConfigurations", l.FrontendIPConfigurations)
	populate(objectMap, "inboundNatPools", l.InboundNatPools)
	populate(objectMap, "inboundNatRules", l.InboundNatRules)
	populate(objectMap, "loadBalancingRules", l.LoadBalancingRules)
	populate(objectMap, "outboundRules", l.OutboundRules)
	populate(objectMap, "probes", l.Probes)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resourceGuid", l.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerPropertiesFormat.
func (l *LoadBalancerPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPools":
			err = unpopulate(val, "BackendAddressPools", &l.BackendAddressPools)
			delete(rawMsg, key)
		case "frontendIPConfigurations":
			err = unpopulate(val, "FrontendIPConfigurations", &l.FrontendIPConfigurations)
			delete(rawMsg, key)
		case "inboundNatPools":
			err = unpopulate(val, "InboundNatPools", &l.InboundNatPools)
			delete(rawMsg, key)
		case "inboundNatRules":
			err = unpopulate(val, "InboundNatRules", &l.InboundNatRules)
			delete(rawMsg, key)
		case "loadBalancingRules":
			err = unpopulate(val, "LoadBalancingRules", &l.LoadBalancingRules)
			delete(rawMsg, key)
		case "outboundRules":
			err = unpopulate(val, "OutboundRules", &l.OutboundRules)
			delete(rawMsg, key)
		case "probes":
			err = unpopulate(val, "Probes", &l.Probes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &l.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerSKU.
func (l LoadBalancerSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "tier", l.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerSKU.
func (l *LoadBalancerSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &l.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerVipSwapRequest.
func (l LoadBalancerVipSwapRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "frontendIPConfigurations", l.FrontendIPConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerVipSwapRequest.
func (l *LoadBalancerVipSwapRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frontendIPConfigurations":
			err = unpopulate(val, "FrontendIPConfigurations", &l.FrontendIPConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerVipSwapRequestFrontendIPConfiguration.
func (l LoadBalancerVipSwapRequestFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerVipSwapRequestFrontendIPConfiguration.
func (l *LoadBalancerVipSwapRequestFrontendIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerVipSwapRequestFrontendIPConfigurationProperties.
func (l LoadBalancerVipSwapRequestFrontendIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicIPAddress", l.PublicIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerVipSwapRequestFrontendIPConfigurationProperties.
func (l *LoadBalancerVipSwapRequestFrontendIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &l.PublicIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingRule.
func (l LoadBalancingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingRule.
func (l *LoadBalancingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingRulePropertiesFormat.
func (l LoadBalancingRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", l.BackendAddressPool)
	populate(objectMap, "backendAddressPools", l.BackendAddressPools)
	populate(objectMap, "backendPort", l.BackendPort)
	populate(objectMap, "disableOutboundSnat", l.DisableOutboundSnat)
	populate(objectMap, "enableFloatingIP", l.EnableFloatingIP)
	populate(objectMap, "enableTcpReset", l.EnableTCPReset)
	populate(objectMap, "frontendIPConfiguration", l.FrontendIPConfiguration)
	populate(objectMap, "frontendPort", l.FrontendPort)
	populate(objectMap, "idleTimeoutInMinutes", l.IdleTimeoutInMinutes)
	populate(objectMap, "loadDistribution", l.LoadDistribution)
	populate(objectMap, "probe", l.Probe)
	populate(objectMap, "protocol", l.Protocol)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingRulePropertiesFormat.
func (l *LoadBalancingRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &l.BackendAddressPool)
			delete(rawMsg, key)
		case "backendAddressPools":
			err = unpopulate(val, "BackendAddressPools", &l.BackendAddressPools)
			delete(rawMsg, key)
		case "backendPort":
			err = unpopulate(val, "BackendPort", &l.BackendPort)
			delete(rawMsg, key)
		case "disableOutboundSnat":
			err = unpopulate(val, "DisableOutboundSnat", &l.DisableOutboundSnat)
			delete(rawMsg, key)
		case "enableFloatingIP":
			err = unpopulate(val, "EnableFloatingIP", &l.EnableFloatingIP)
			delete(rawMsg, key)
		case "enableTcpReset":
			err = unpopulate(val, "EnableTCPReset", &l.EnableTCPReset)
			delete(rawMsg, key)
		case "frontendIPConfiguration":
			err = unpopulate(val, "FrontendIPConfiguration", &l.FrontendIPConfiguration)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &l.FrontendPort)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &l.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "loadDistribution":
			err = unpopulate(val, "LoadDistribution", &l.LoadDistribution)
			delete(rawMsg, key)
		case "probe":
			err = unpopulate(val, "Probe", &l.Probe)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &l.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalNetworkGateway.
func (l LocalNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalNetworkGateway.
func (l *LocalNetworkGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalNetworkGatewayListResult.
func (l LocalNetworkGatewayListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalNetworkGatewayListResult.
func (l *LocalNetworkGatewayListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalNetworkGatewayPropertiesFormat.
func (l LocalNetworkGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bgpSettings", l.BgpSettings)
	populate(objectMap, "fqdn", l.Fqdn)
	populate(objectMap, "gatewayIpAddress", l.GatewayIPAddress)
	populate(objectMap, "localNetworkAddressSpace", l.LocalNetworkAddressSpace)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resourceGuid", l.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalNetworkGatewayPropertiesFormat.
func (l *LocalNetworkGatewayPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bgpSettings":
			err = unpopulate(val, "BgpSettings", &l.BgpSettings)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &l.Fqdn)
			delete(rawMsg, key)
		case "gatewayIpAddress":
			err = unpopulate(val, "GatewayIPAddress", &l.GatewayIPAddress)
			delete(rawMsg, key)
		case "localNetworkAddressSpace":
			err = unpopulate(val, "LocalNetworkAddressSpace", &l.LocalNetworkAddressSpace)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &l.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", l.BlobDuration)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &l.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleGroupOverride.
func (m ManagedRuleGroupOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleGroupName", m.RuleGroupName)
	populate(objectMap, "rules", m.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleGroupOverride.
func (m *ManagedRuleGroupOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleGroupName":
			err = unpopulate(val, "RuleGroupName", &m.RuleGroupName)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &m.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleOverride.
func (m ManagedRuleOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", m.Action)
	populate(objectMap, "ruleId", m.RuleID)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleOverride.
func (m *ManagedRuleOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &m.Action)
			delete(rawMsg, key)
		case "ruleId":
			err = unpopulate(val, "RuleID", &m.RuleID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRuleSet.
func (m ManagedRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ruleGroupOverrides", m.RuleGroupOverrides)
	populate(objectMap, "ruleSetType", m.RuleSetType)
	populate(objectMap, "ruleSetVersion", m.RuleSetVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRuleSet.
func (m *ManagedRuleSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ruleGroupOverrides":
			err = unpopulate(val, "RuleGroupOverrides", &m.RuleGroupOverrides)
			delete(rawMsg, key)
		case "ruleSetType":
			err = unpopulate(val, "RuleSetType", &m.RuleSetType)
			delete(rawMsg, key)
		case "ruleSetVersion":
			err = unpopulate(val, "RuleSetVersion", &m.RuleSetVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedRulesDefinition.
func (m ManagedRulesDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exclusions", m.Exclusions)
	populate(objectMap, "managedRuleSets", m.ManagedRuleSets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedRulesDefinition.
func (m *ManagedRulesDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exclusions":
			err = unpopulate(val, "Exclusions", &m.Exclusions)
			delete(rawMsg, key)
		case "managedRuleSets":
			err = unpopulate(val, "ManagedRuleSets", &m.ManagedRuleSets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Manager.
func (m Manager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Manager.
func (m *Manager) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerCommit.
func (m ManagerCommit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commitId", m.CommitID)
	populate(objectMap, "commitType", m.CommitType)
	populate(objectMap, "configurationIds", m.ConfigurationIDs)
	populate(objectMap, "targetLocations", m.TargetLocations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerCommit.
func (m *ManagerCommit) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitId":
			err = unpopulate(val, "CommitID", &m.CommitID)
			delete(rawMsg, key)
		case "commitType":
			err = unpopulate(val, "CommitType", &m.CommitType)
			delete(rawMsg, key)
		case "configurationIds":
			err = unpopulate(val, "ConfigurationIDs", &m.ConfigurationIDs)
			delete(rawMsg, key)
		case "targetLocations":
			err = unpopulate(val, "TargetLocations", &m.TargetLocations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerConnection.
func (m ManagerConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerConnection.
func (m *ManagerConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerConnectionListResult.
func (m ManagerConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerConnectionListResult.
func (m *ManagerConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerConnectionProperties.
func (m ManagerConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionState", m.ConnectionState)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "networkManagerId", m.NetworkManagerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerConnectionProperties.
func (m *ManagerConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionState":
			err = unpopulate(val, "ConnectionState", &m.ConnectionState)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "networkManagerId":
			err = unpopulate(val, "NetworkManagerID", &m.NetworkManagerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerDeploymentStatus.
func (m ManagerDeploymentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "commitTime", m.CommitTime)
	populate(objectMap, "configurationIds", m.ConfigurationIDs)
	populate(objectMap, "deploymentStatus", m.DeploymentStatus)
	populate(objectMap, "deploymentType", m.DeploymentType)
	populate(objectMap, "errorMessage", m.ErrorMessage)
	populate(objectMap, "region", m.Region)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerDeploymentStatus.
func (m *ManagerDeploymentStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitTime":
			err = unpopulateDateTimeRFC3339(val, "CommitTime", &m.CommitTime)
			delete(rawMsg, key)
		case "configurationIds":
			err = unpopulate(val, "ConfigurationIDs", &m.ConfigurationIDs)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &m.DeploymentStatus)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &m.DeploymentType)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &m.ErrorMessage)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &m.Region)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerDeploymentStatusListResult.
func (m ManagerDeploymentStatusListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipToken", m.SkipToken)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerDeploymentStatusListResult.
func (m *ManagerDeploymentStatusListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipToken":
			err = unpopulate(val, "SkipToken", &m.SkipToken)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerDeploymentStatusParameter.
func (m ManagerDeploymentStatusParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentTypes", m.DeploymentTypes)
	populate(objectMap, "regions", m.Regions)
	populate(objectMap, "skipToken", m.SkipToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerDeploymentStatusParameter.
func (m *ManagerDeploymentStatusParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentTypes":
			err = unpopulate(val, "DeploymentTypes", &m.DeploymentTypes)
			delete(rawMsg, key)
		case "regions":
			err = unpopulate(val, "Regions", &m.Regions)
			delete(rawMsg, key)
		case "skipToken":
			err = unpopulate(val, "SkipToken", &m.SkipToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerEffectiveConnectivityConfigurationListResult.
func (m ManagerEffectiveConnectivityConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipToken", m.SkipToken)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerEffectiveConnectivityConfigurationListResult.
func (m *ManagerEffectiveConnectivityConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipToken":
			err = unpopulate(val, "SkipToken", &m.SkipToken)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerEffectiveSecurityAdminRulesListResult.
func (m ManagerEffectiveSecurityAdminRulesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipToken", m.SkipToken)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerEffectiveSecurityAdminRulesListResult.
func (m *ManagerEffectiveSecurityAdminRulesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipToken":
			err = unpopulate(val, "SkipToken", &m.SkipToken)
			delete(rawMsg, key)
		case "value":
			m.Value, err = unmarshalEffectiveBaseSecurityAdminRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerListResult.
func (m ManagerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerListResult.
func (m *ManagerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerProperties.
func (m ManagerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "networkManagerScopeAccesses", m.NetworkManagerScopeAccesses)
	populate(objectMap, "networkManagerScopes", m.NetworkManagerScopes)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "resourceGuid", m.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerProperties.
func (m *ManagerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "networkManagerScopeAccesses":
			err = unpopulate(val, "NetworkManagerScopeAccesses", &m.NetworkManagerScopeAccesses)
			delete(rawMsg, key)
		case "networkManagerScopes":
			err = unpopulate(val, "NetworkManagerScopes", &m.NetworkManagerScopes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &m.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerPropertiesNetworkManagerScopes.
func (m ManagerPropertiesNetworkManagerScopes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "crossTenantScopes", m.CrossTenantScopes)
	populate(objectMap, "managementGroups", m.ManagementGroups)
	populate(objectMap, "subscriptions", m.Subscriptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerPropertiesNetworkManagerScopes.
func (m *ManagerPropertiesNetworkManagerScopes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crossTenantScopes":
			err = unpopulate(val, "CrossTenantScopes", &m.CrossTenantScopes)
			delete(rawMsg, key)
		case "managementGroups":
			err = unpopulate(val, "ManagementGroups", &m.ManagementGroups)
			delete(rawMsg, key)
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &m.Subscriptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerSecurityGroupItem.
func (m ManagerSecurityGroupItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkGroupId", m.NetworkGroupID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerSecurityGroupItem.
func (m *ManagerSecurityGroupItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkGroupId":
			err = unpopulate(val, "NetworkGroupID", &m.NetworkGroupID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MatchCondition.
func (m MatchCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchValues", m.MatchValues)
	populate(objectMap, "matchVariables", m.MatchVariables)
	populate(objectMap, "negationConditon", m.NegationConditon)
	populate(objectMap, "operator", m.Operator)
	populate(objectMap, "transforms", m.Transforms)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MatchCondition.
func (m *MatchCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchValues":
			err = unpopulate(val, "MatchValues", &m.MatchValues)
			delete(rawMsg, key)
		case "matchVariables":
			err = unpopulate(val, "MatchVariables", &m.MatchVariables)
			delete(rawMsg, key)
		case "negationConditon":
			err = unpopulate(val, "NegationConditon", &m.NegationConditon)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &m.Operator)
			delete(rawMsg, key)
		case "transforms":
			err = unpopulate(val, "Transforms", &m.Transforms)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MatchVariable.
func (m MatchVariable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "selector", m.Selector)
	populate(objectMap, "variableName", m.VariableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MatchVariable.
func (m *MatchVariable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "selector":
			err = unpopulate(val, "Selector", &m.Selector)
			delete(rawMsg, key)
		case "variableName":
			err = unpopulate(val, "VariableName", &m.VariableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MatchedRule.
func (m MatchedRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", m.Action)
	populate(objectMap, "ruleName", m.RuleName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MatchedRule.
func (m *MatchedRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &m.Action)
			delete(rawMsg, key)
		case "ruleName":
			err = unpopulate(val, "RuleName", &m.RuleName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "availabilities", m.Availabilities)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "enableRegionalMdmAccount", m.EnableRegionalMdmAccount)
	populate(objectMap, "fillGapWithZero", m.FillGapWithZero)
	populate(objectMap, "isInternal", m.IsInternal)
	populate(objectMap, "metricFilterPattern", m.MetricFilterPattern)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "resourceIdDimensionNameOverride", m.ResourceIDDimensionNameOverride)
	populate(objectMap, "sourceMdmAccount", m.SourceMdmAccount)
	populate(objectMap, "sourceMdmNamespace", m.SourceMdmNamespace)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "availabilities":
			err = unpopulate(val, "Availabilities", &m.Availabilities)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "enableRegionalMdmAccount":
			err = unpopulate(val, "EnableRegionalMdmAccount", &m.EnableRegionalMdmAccount)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &m.FillGapWithZero)
			delete(rawMsg, key)
		case "isInternal":
			err = unpopulate(val, "IsInternal", &m.IsInternal)
			delete(rawMsg, key)
		case "metricFilterPattern":
			err = unpopulate(val, "MetricFilterPattern", &m.MetricFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "resourceIdDimensionNameOverride":
			err = unpopulate(val, "ResourceIDDimensionNameOverride", &m.ResourceIDDimensionNameOverride)
			delete(rawMsg, key)
		case "sourceMdmAccount":
			err = unpopulate(val, "SourceMdmAccount", &m.SourceMdmAccount)
			delete(rawMsg, key)
		case "sourceMdmNamespace":
			err = unpopulate(val, "SourceMdmNamespace", &m.SourceMdmNamespace)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateLoadBalancerToIPBasedRequest.
func (m MigrateLoadBalancerToIPBasedRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pools", m.Pools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateLoadBalancerToIPBasedRequest.
func (m *MigrateLoadBalancerToIPBasedRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pools":
			err = unpopulate(val, "Pools", &m.Pools)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigratedPools.
func (m MigratedPools) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "migratedPools", m.MigratedPools)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigratedPools.
func (m *MigratedPools) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "migratedPools":
			err = unpopulate(val, "MigratedPools", &m.MigratedPools)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NatGateway.
func (n NatGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", n.Etag)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "sku", n.SKU)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	populate(objectMap, "zones", n.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NatGateway.
func (n *NatGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &n.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &n.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &n.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NatGatewayListResult.
func (n NatGatewayListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NatGatewayListResult.
func (n *NatGatewayListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NatGatewayPropertiesFormat.
func (n NatGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "idleTimeoutInMinutes", n.IdleTimeoutInMinutes)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "publicIpAddresses", n.PublicIPAddresses)
	populate(objectMap, "publicIpPrefixes", n.PublicIPPrefixes)
	populate(objectMap, "resourceGuid", n.ResourceGUID)
	populate(objectMap, "subnets", n.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NatGatewayPropertiesFormat.
func (n *NatGatewayPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &n.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpAddresses":
			err = unpopulate(val, "PublicIPAddresses", &n.PublicIPAddresses)
			delete(rawMsg, key)
		case "publicIpPrefixes":
			err = unpopulate(val, "PublicIPPrefixes", &n.PublicIPPrefixes)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &n.ResourceGUID)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &n.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NatGatewaySKU.
func (n NatGatewaySKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NatGatewaySKU.
func (n *NatGatewaySKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NatRule.
func (n NatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "destinationAddresses", n.DestinationAddresses)
	populate(objectMap, "destinationPorts", n.DestinationPorts)
	populate(objectMap, "ipProtocols", n.IPProtocols)
	populate(objectMap, "name", n.Name)
	objectMap["ruleType"] = FirewallPolicyRuleTypeNatRule
	populate(objectMap, "sourceAddresses", n.SourceAddresses)
	populate(objectMap, "sourceIpGroups", n.SourceIPGroups)
	populate(objectMap, "translatedAddress", n.TranslatedAddress)
	populate(objectMap, "translatedFqdn", n.TranslatedFqdn)
	populate(objectMap, "translatedPort", n.TranslatedPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NatRule.
func (n *NatRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "destinationAddresses":
			err = unpopulate(val, "DestinationAddresses", &n.DestinationAddresses)
			delete(rawMsg, key)
		case "destinationPorts":
			err = unpopulate(val, "DestinationPorts", &n.DestinationPorts)
			delete(rawMsg, key)
		case "ipProtocols":
			err = unpopulate(val, "IPProtocols", &n.IPProtocols)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &n.RuleType)
			delete(rawMsg, key)
		case "sourceAddresses":
			err = unpopulate(val, "SourceAddresses", &n.SourceAddresses)
			delete(rawMsg, key)
		case "sourceIpGroups":
			err = unpopulate(val, "SourceIPGroups", &n.SourceIPGroups)
			delete(rawMsg, key)
		case "translatedAddress":
			err = unpopulate(val, "TranslatedAddress", &n.TranslatedAddress)
			delete(rawMsg, key)
		case "translatedFqdn":
			err = unpopulate(val, "TranslatedFqdn", &n.TranslatedFqdn)
			delete(rawMsg, key)
		case "translatedPort":
			err = unpopulate(val, "TranslatedPort", &n.TranslatedPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NatRulePortMapping.
func (n NatRulePortMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPort", n.BackendPort)
	populate(objectMap, "frontendPort", n.FrontendPort)
	populate(objectMap, "inboundNatRuleName", n.InboundNatRuleName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NatRulePortMapping.
func (n *NatRulePortMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPort":
			err = unpopulate(val, "BackendPort", &n.BackendPort)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &n.FrontendPort)
			delete(rawMsg, key)
		case "inboundNatRuleName":
			err = unpopulate(val, "InboundNatRuleName", &n.InboundNatRuleName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NextHopParameters.
func (n NextHopParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationIPAddress", n.DestinationIPAddress)
	populate(objectMap, "sourceIPAddress", n.SourceIPAddress)
	populate(objectMap, "targetNicResourceId", n.TargetNicResourceID)
	populate(objectMap, "targetResourceId", n.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NextHopParameters.
func (n *NextHopParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationIPAddress":
			err = unpopulate(val, "DestinationIPAddress", &n.DestinationIPAddress)
			delete(rawMsg, key)
		case "sourceIPAddress":
			err = unpopulate(val, "SourceIPAddress", &n.SourceIPAddress)
			delete(rawMsg, key)
		case "targetNicResourceId":
			err = unpopulate(val, "TargetNicResourceID", &n.TargetNicResourceID)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &n.TargetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NextHopResult.
func (n NextHopResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextHopIpAddress", n.NextHopIPAddress)
	populate(objectMap, "nextHopType", n.NextHopType)
	populate(objectMap, "routeTableId", n.RouteTableID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NextHopResult.
func (n *NextHopResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextHopIpAddress":
			err = unpopulate(val, "NextHopIPAddress", &n.NextHopIPAddress)
			delete(rawMsg, key)
		case "nextHopType":
			err = unpopulate(val, "NextHopType", &n.NextHopType)
			delete(rawMsg, key)
		case "routeTableId":
			err = unpopulate(val, "RouteTableID", &n.RouteTableID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type O365BreakOutCategoryPolicies.
func (o O365BreakOutCategoryPolicies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allow", o.Allow)
	populate(objectMap, "default", o.Default)
	populate(objectMap, "optimize", o.Optimize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type O365BreakOutCategoryPolicies.
func (o *O365BreakOutCategoryPolicies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allow":
			err = unpopulate(val, "Allow", &o.Allow)
			delete(rawMsg, key)
		case "default":
			err = unpopulate(val, "Default", &o.Default)
			delete(rawMsg, key)
		case "optimize":
			err = unpopulate(val, "Optimize", &o.Optimize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type O365PolicyProperties.
func (o O365PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "breakOutCategories", o.BreakOutCategories)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type O365PolicyProperties.
func (o *O365PolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "breakOutCategories":
			err = unpopulate(val, "BreakOutCategories", &o.BreakOutCategories)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Office365PolicyProperties.
func (o Office365PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "breakOutCategories", o.BreakOutCategories)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Office365PolicyProperties.
func (o *Office365PolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "breakOutCategories":
			err = unpopulate(val, "BreakOutCategories", &o.BreakOutCategories)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationPropertiesFormat.
func (o OperationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationPropertiesFormat.
func (o *OperationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationPropertiesFormatServiceSpecification.
func (o OperationPropertiesFormatServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", o.LogSpecifications)
	populate(objectMap, "metricSpecifications", o.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationPropertiesFormatServiceSpecification.
func (o *OperationPropertiesFormatServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &o.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &o.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderBy.
func (o OrderBy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "field", o.Field)
	populate(objectMap, "order", o.Order)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderBy.
func (o *OrderBy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "field":
			err = unpopulate(val, "Field", &o.Field)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &o.Order)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundRule.
func (o OutboundRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", o.Etag)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundRule.
func (o *OutboundRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &o.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundRulePropertiesFormat.
func (o OutboundRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocatedOutboundPorts", o.AllocatedOutboundPorts)
	populate(objectMap, "backendAddressPool", o.BackendAddressPool)
	populate(objectMap, "enableTcpReset", o.EnableTCPReset)
	populate(objectMap, "frontendIPConfigurations", o.FrontendIPConfigurations)
	populate(objectMap, "idleTimeoutInMinutes", o.IdleTimeoutInMinutes)
	populate(objectMap, "protocol", o.Protocol)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundRulePropertiesFormat.
func (o *OutboundRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocatedOutboundPorts":
			err = unpopulate(val, "AllocatedOutboundPorts", &o.AllocatedOutboundPorts)
			delete(rawMsg, key)
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &o.BackendAddressPool)
			delete(rawMsg, key)
		case "enableTcpReset":
			err = unpopulate(val, "EnableTCPReset", &o.EnableTCPReset)
			delete(rawMsg, key)
		case "frontendIPConfigurations":
			err = unpopulate(val, "FrontendIPConfigurations", &o.FrontendIPConfigurations)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &o.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &o.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OwaspCrsExclusionEntry.
func (o OwaspCrsExclusionEntry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exclusionManagedRuleSets", o.ExclusionManagedRuleSets)
	populate(objectMap, "matchVariable", o.MatchVariable)
	populate(objectMap, "selector", o.Selector)
	populate(objectMap, "selectorMatchOperator", o.SelectorMatchOperator)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OwaspCrsExclusionEntry.
func (o *OwaspCrsExclusionEntry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exclusionManagedRuleSets":
			err = unpopulate(val, "ExclusionManagedRuleSets", &o.ExclusionManagedRuleSets)
			delete(rawMsg, key)
		case "matchVariable":
			err = unpopulate(val, "MatchVariable", &o.MatchVariable)
			delete(rawMsg, key)
		case "selector":
			err = unpopulate(val, "Selector", &o.Selector)
			delete(rawMsg, key)
		case "selectorMatchOperator":
			err = unpopulate(val, "SelectorMatchOperator", &o.SelectorMatchOperator)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type P2SConnectionConfiguration.
func (p P2SConnectionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type P2SConnectionConfiguration.
func (p *P2SConnectionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type P2SConnectionConfigurationProperties.
func (p P2SConnectionConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationPolicyGroupAssociations", p.ConfigurationPolicyGroupAssociations)
	populate(objectMap, "enableInternetSecurity", p.EnableInternetSecurity)
	populate(objectMap, "previousConfigurationPolicyGroupAssociations", p.PreviousConfigurationPolicyGroupAssociations)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "routingConfiguration", p.RoutingConfiguration)
	populate(objectMap, "vpnClientAddressPool", p.VPNClientAddressPool)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type P2SConnectionConfigurationProperties.
func (p *P2SConnectionConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationPolicyGroupAssociations":
			err = unpopulate(val, "ConfigurationPolicyGroupAssociations", &p.ConfigurationPolicyGroupAssociations)
			delete(rawMsg, key)
		case "enableInternetSecurity":
			err = unpopulate(val, "EnableInternetSecurity", &p.EnableInternetSecurity)
			delete(rawMsg, key)
		case "previousConfigurationPolicyGroupAssociations":
			err = unpopulate(val, "PreviousConfigurationPolicyGroupAssociations", &p.PreviousConfigurationPolicyGroupAssociations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "routingConfiguration":
			err = unpopulate(val, "RoutingConfiguration", &p.RoutingConfiguration)
			delete(rawMsg, key)
		case "vpnClientAddressPool":
			err = unpopulate(val, "VPNClientAddressPool", &p.VPNClientAddressPool)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type P2SVPNConnectionHealth.
func (p P2SVPNConnectionHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sasUrl", p.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type P2SVPNConnectionHealth.
func (p *P2SVPNConnectionHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sasUrl":
			err = unpopulate(val, "SasURL", &p.SasURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type P2SVPNConnectionHealthRequest.
func (p P2SVPNConnectionHealthRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "outputBlobSasUrl", p.OutputBlobSasURL)
	populate(objectMap, "vpnUserNamesFilter", p.VPNUserNamesFilter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type P2SVPNConnectionHealthRequest.
func (p *P2SVPNConnectionHealthRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "outputBlobSasUrl":
			err = unpopulate(val, "OutputBlobSasURL", &p.OutputBlobSasURL)
			delete(rawMsg, key)
		case "vpnUserNamesFilter":
			err = unpopulate(val, "VPNUserNamesFilter", &p.VPNUserNamesFilter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type P2SVPNConnectionRequest.
func (p P2SVPNConnectionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vpnConnectionIds", p.VPNConnectionIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type P2SVPNConnectionRequest.
func (p *P2SVPNConnectionRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vpnConnectionIds":
			err = unpopulate(val, "VPNConnectionIDs", &p.VPNConnectionIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type P2SVPNGateway.
func (p P2SVPNGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type P2SVPNGateway.
func (p *P2SVPNGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type P2SVPNGatewayProperties.
func (p P2SVPNGatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customDnsServers", p.CustomDNSServers)
	populate(objectMap, "isRoutingPreferenceInternet", p.IsRoutingPreferenceInternet)
	populate(objectMap, "p2SConnectionConfigurations", p.P2SConnectionConfigurations)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "vpnClientConnectionHealth", p.VPNClientConnectionHealth)
	populate(objectMap, "vpnGatewayScaleUnit", p.VPNGatewayScaleUnit)
	populate(objectMap, "vpnServerConfiguration", p.VPNServerConfiguration)
	populate(objectMap, "virtualHub", p.VirtualHub)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type P2SVPNGatewayProperties.
func (p *P2SVPNGatewayProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDnsServers":
			err = unpopulate(val, "CustomDNSServers", &p.CustomDNSServers)
			delete(rawMsg, key)
		case "isRoutingPreferenceInternet":
			err = unpopulate(val, "IsRoutingPreferenceInternet", &p.IsRoutingPreferenceInternet)
			delete(rawMsg, key)
		case "p2SConnectionConfigurations":
			err = unpopulate(val, "P2SConnectionConfigurations", &p.P2SConnectionConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "vpnClientConnectionHealth":
			err = unpopulate(val, "VPNClientConnectionHealth", &p.VPNClientConnectionHealth)
			delete(rawMsg, key)
		case "vpnGatewayScaleUnit":
			err = unpopulate(val, "VPNGatewayScaleUnit", &p.VPNGatewayScaleUnit)
			delete(rawMsg, key)
		case "vpnServerConfiguration":
			err = unpopulate(val, "VPNServerConfiguration", &p.VPNServerConfiguration)
			delete(rawMsg, key)
		case "virtualHub":
			err = unpopulate(val, "VirtualHub", &p.VirtualHub)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type P2SVPNProfileParameters.
func (p P2SVPNProfileParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMethod", p.AuthenticationMethod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type P2SVPNProfileParameters.
func (p *P2SVPNProfileParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMethod":
			err = unpopulate(val, "AuthenticationMethod", &p.AuthenticationMethod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCapture.
func (p PacketCapture) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCapture.
func (p *PacketCapture) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureFilter.
func (p PacketCaptureFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localIPAddress", p.LocalIPAddress)
	populate(objectMap, "localPort", p.LocalPort)
	populate(objectMap, "protocol", p.Protocol)
	populate(objectMap, "remoteIPAddress", p.RemoteIPAddress)
	populate(objectMap, "remotePort", p.RemotePort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureFilter.
func (p *PacketCaptureFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localIPAddress":
			err = unpopulate(val, "LocalIPAddress", &p.LocalIPAddress)
			delete(rawMsg, key)
		case "localPort":
			err = unpopulate(val, "LocalPort", &p.LocalPort)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &p.Protocol)
			delete(rawMsg, key)
		case "remoteIPAddress":
			err = unpopulate(val, "RemoteIPAddress", &p.RemoteIPAddress)
			delete(rawMsg, key)
		case "remotePort":
			err = unpopulate(val, "RemotePort", &p.RemotePort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureListResult.
func (p PacketCaptureListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureListResult.
func (p *PacketCaptureListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureMachineScope.
func (p PacketCaptureMachineScope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exclude", p.Exclude)
	populate(objectMap, "include", p.Include)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureMachineScope.
func (p *PacketCaptureMachineScope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exclude":
			err = unpopulate(val, "Exclude", &p.Exclude)
			delete(rawMsg, key)
		case "include":
			err = unpopulate(val, "Include", &p.Include)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureParameters.
func (p PacketCaptureParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bytesToCapturePerPacket", p.BytesToCapturePerPacket)
	populate(objectMap, "filters", p.Filters)
	populate(objectMap, "scope", p.Scope)
	populate(objectMap, "storageLocation", p.StorageLocation)
	populate(objectMap, "target", p.Target)
	populate(objectMap, "targetType", p.TargetType)
	populate(objectMap, "timeLimitInSeconds", p.TimeLimitInSeconds)
	populate(objectMap, "totalBytesPerSession", p.TotalBytesPerSession)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureParameters.
func (p *PacketCaptureParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytesToCapturePerPacket":
			err = unpopulate(val, "BytesToCapturePerPacket", &p.BytesToCapturePerPacket)
			delete(rawMsg, key)
		case "filters":
			err = unpopulate(val, "Filters", &p.Filters)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &p.Scope)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &p.StorageLocation)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &p.Target)
			delete(rawMsg, key)
		case "targetType":
			err = unpopulate(val, "TargetType", &p.TargetType)
			delete(rawMsg, key)
		case "timeLimitInSeconds":
			err = unpopulate(val, "TimeLimitInSeconds", &p.TimeLimitInSeconds)
			delete(rawMsg, key)
		case "totalBytesPerSession":
			err = unpopulate(val, "TotalBytesPerSession", &p.TotalBytesPerSession)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureQueryStatusResult.
func (p PacketCaptureQueryStatusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "captureStartTime", p.CaptureStartTime)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "packetCaptureError", p.PacketCaptureError)
	populate(objectMap, "packetCaptureStatus", p.PacketCaptureStatus)
	populate(objectMap, "stopReason", p.StopReason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureQueryStatusResult.
func (p *PacketCaptureQueryStatusResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "captureStartTime":
			err = unpopulateDateTimeRFC3339(val, "CaptureStartTime", &p.CaptureStartTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "packetCaptureError":
			err = unpopulate(val, "PacketCaptureError", &p.PacketCaptureError)
			delete(rawMsg, key)
		case "packetCaptureStatus":
			err = unpopulate(val, "PacketCaptureStatus", &p.PacketCaptureStatus)
			delete(rawMsg, key)
		case "stopReason":
			err = unpopulate(val, "StopReason", &p.StopReason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureResult.
func (p PacketCaptureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureResult.
func (p *PacketCaptureResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureResultProperties.
func (p PacketCaptureResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bytesToCapturePerPacket", p.BytesToCapturePerPacket)
	populate(objectMap, "filters", p.Filters)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "scope", p.Scope)
	populate(objectMap, "storageLocation", p.StorageLocation)
	populate(objectMap, "target", p.Target)
	populate(objectMap, "targetType", p.TargetType)
	populate(objectMap, "timeLimitInSeconds", p.TimeLimitInSeconds)
	populate(objectMap, "totalBytesPerSession", p.TotalBytesPerSession)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureResultProperties.
func (p *PacketCaptureResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bytesToCapturePerPacket":
			err = unpopulate(val, "BytesToCapturePerPacket", &p.BytesToCapturePerPacket)
			delete(rawMsg, key)
		case "filters":
			err = unpopulate(val, "Filters", &p.Filters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &p.Scope)
			delete(rawMsg, key)
		case "storageLocation":
			err = unpopulate(val, "StorageLocation", &p.StorageLocation)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &p.Target)
			delete(rawMsg, key)
		case "targetType":
			err = unpopulate(val, "TargetType", &p.TargetType)
			delete(rawMsg, key)
		case "timeLimitInSeconds":
			err = unpopulate(val, "TimeLimitInSeconds", &p.TimeLimitInSeconds)
			delete(rawMsg, key)
		case "totalBytesPerSession":
			err = unpopulate(val, "TotalBytesPerSession", &p.TotalBytesPerSession)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PacketCaptureStorageLocation.
func (p PacketCaptureStorageLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filePath", p.FilePath)
	populate(objectMap, "storageId", p.StorageID)
	populate(objectMap, "storagePath", p.StoragePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PacketCaptureStorageLocation.
func (p *PacketCaptureStorageLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filePath":
			err = unpopulate(val, "FilePath", &p.FilePath)
			delete(rawMsg, key)
		case "storageId":
			err = unpopulate(val, "StorageID", &p.StorageID)
			delete(rawMsg, key)
		case "storagePath":
			err = unpopulate(val, "StoragePath", &p.StoragePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Parameter.
func (p Parameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asPath", p.AsPath)
	populate(objectMap, "community", p.Community)
	populate(objectMap, "routePrefix", p.RoutePrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Parameter.
func (p *Parameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asPath":
			err = unpopulate(val, "AsPath", &p.AsPath)
			delete(rawMsg, key)
		case "community":
			err = unpopulate(val, "Community", &p.Community)
			delete(rawMsg, key)
		case "routePrefix":
			err = unpopulate(val, "RoutePrefix", &p.RoutePrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartnerManagedResourceProperties.
func (p PartnerManagedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "internalLoadBalancerId", p.InternalLoadBalancerID)
	populate(objectMap, "standardLoadBalancerId", p.StandardLoadBalancerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartnerManagedResourceProperties.
func (p *PartnerManagedResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "internalLoadBalancerId":
			err = unpopulate(val, "InternalLoadBalancerID", &p.InternalLoadBalancerID)
			delete(rawMsg, key)
		case "standardLoadBalancerId":
			err = unpopulate(val, "StandardLoadBalancerID", &p.StandardLoadBalancerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchObject.
func (p PatchObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchObject.
func (p *PatchObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchRouteFilter.
func (p PatchRouteFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchRouteFilter.
func (p *PatchRouteFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchRouteFilterRule.
func (p PatchRouteFilterRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchRouteFilterRule.
func (p *PatchRouteFilterRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PeerExpressRouteCircuitConnection.
func (p PeerExpressRouteCircuitConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PeerExpressRouteCircuitConnection.
func (p *PeerExpressRouteCircuitConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PeerExpressRouteCircuitConnectionListResult.
func (p PeerExpressRouteCircuitConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PeerExpressRouteCircuitConnectionListResult.
func (p *PeerExpressRouteCircuitConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PeerExpressRouteCircuitConnectionPropertiesFormat.
func (p PeerExpressRouteCircuitConnectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", p.AddressPrefix)
	populate(objectMap, "authResourceGuid", p.AuthResourceGUID)
	populate(objectMap, "circuitConnectionStatus", p.CircuitConnectionStatus)
	populate(objectMap, "connectionName", p.ConnectionName)
	populate(objectMap, "expressRouteCircuitPeering", p.ExpressRouteCircuitPeering)
	populate(objectMap, "peerExpressRouteCircuitPeering", p.PeerExpressRouteCircuitPeering)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PeerExpressRouteCircuitConnectionPropertiesFormat.
func (p *PeerExpressRouteCircuitConnectionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &p.AddressPrefix)
			delete(rawMsg, key)
		case "authResourceGuid":
			err = unpopulate(val, "AuthResourceGUID", &p.AuthResourceGUID)
			delete(rawMsg, key)
		case "circuitConnectionStatus":
			err = unpopulate(val, "CircuitConnectionStatus", &p.CircuitConnectionStatus)
			delete(rawMsg, key)
		case "connectionName":
			err = unpopulate(val, "ConnectionName", &p.ConnectionName)
			delete(rawMsg, key)
		case "expressRouteCircuitPeering":
			err = unpopulate(val, "ExpressRouteCircuitPeering", &p.ExpressRouteCircuitPeering)
			delete(rawMsg, key)
		case "peerExpressRouteCircuitPeering":
			err = unpopulate(val, "PeerExpressRouteCircuitPeering", &p.PeerExpressRouteCircuitPeering)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PeerRoute.
func (p PeerRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asPath", p.AsPath)
	populate(objectMap, "localAddress", p.LocalAddress)
	populate(objectMap, "network", p.Network)
	populate(objectMap, "nextHop", p.NextHop)
	populate(objectMap, "origin", p.Origin)
	populate(objectMap, "sourcePeer", p.SourcePeer)
	populate(objectMap, "weight", p.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PeerRoute.
func (p *PeerRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asPath":
			err = unpopulate(val, "AsPath", &p.AsPath)
			delete(rawMsg, key)
		case "localAddress":
			err = unpopulate(val, "LocalAddress", &p.LocalAddress)
			delete(rawMsg, key)
		case "network":
			err = unpopulate(val, "Network", &p.Network)
			delete(rawMsg, key)
		case "nextHop":
			err = unpopulate(val, "NextHop", &p.NextHop)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &p.Origin)
			delete(rawMsg, key)
		case "sourcePeer":
			err = unpopulate(val, "SourcePeer", &p.SourcePeer)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &p.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicySettings.
func (p PolicySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customBlockResponseBody", p.CustomBlockResponseBody)
	populate(objectMap, "customBlockResponseStatusCode", p.CustomBlockResponseStatusCode)
	populate(objectMap, "fileUploadEnforcement", p.FileUploadEnforcement)
	populate(objectMap, "fileUploadLimitInMb", p.FileUploadLimitInMb)
	populate(objectMap, "logScrubbing", p.LogScrubbing)
	populate(objectMap, "maxRequestBodySizeInKb", p.MaxRequestBodySizeInKb)
	populate(objectMap, "mode", p.Mode)
	populate(objectMap, "requestBodyCheck", p.RequestBodyCheck)
	populate(objectMap, "requestBodyEnforcement", p.RequestBodyEnforcement)
	populate(objectMap, "requestBodyInspectLimitInKB", p.RequestBodyInspectLimitInKB)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicySettings.
func (p *PolicySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customBlockResponseBody":
			err = unpopulate(val, "CustomBlockResponseBody", &p.CustomBlockResponseBody)
			delete(rawMsg, key)
		case "customBlockResponseStatusCode":
			err = unpopulate(val, "CustomBlockResponseStatusCode", &p.CustomBlockResponseStatusCode)
			delete(rawMsg, key)
		case "fileUploadEnforcement":
			err = unpopulate(val, "FileUploadEnforcement", &p.FileUploadEnforcement)
			delete(rawMsg, key)
		case "fileUploadLimitInMb":
			err = unpopulate(val, "FileUploadLimitInMb", &p.FileUploadLimitInMb)
			delete(rawMsg, key)
		case "logScrubbing":
			err = unpopulate(val, "LogScrubbing", &p.LogScrubbing)
			delete(rawMsg, key)
		case "maxRequestBodySizeInKb":
			err = unpopulate(val, "MaxRequestBodySizeInKb", &p.MaxRequestBodySizeInKb)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &p.Mode)
			delete(rawMsg, key)
		case "requestBodyCheck":
			err = unpopulate(val, "RequestBodyCheck", &p.RequestBodyCheck)
			delete(rawMsg, key)
		case "requestBodyEnforcement":
			err = unpopulate(val, "RequestBodyEnforcement", &p.RequestBodyEnforcement)
			delete(rawMsg, key)
		case "requestBodyInspectLimitInKB":
			err = unpopulate(val, "RequestBodyInspectLimitInKB", &p.RequestBodyInspectLimitInKB)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicySettingsLogScrubbing.
func (p PolicySettingsLogScrubbing) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scrubbingRules", p.ScrubbingRules)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicySettingsLogScrubbing.
func (p *PolicySettingsLogScrubbing) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scrubbingRules":
			err = unpopulate(val, "ScrubbingRules", &p.ScrubbingRules)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrepareNetworkPoliciesRequest.
func (p PrepareNetworkPoliciesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkIntentPolicyConfigurations", p.NetworkIntentPolicyConfigurations)
	populate(objectMap, "serviceName", p.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrepareNetworkPoliciesRequest.
func (p *PrepareNetworkPoliciesRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkIntentPolicyConfigurations":
			err = unpopulate(val, "NetworkIntentPolicyConfigurations", &p.NetworkIntentPolicyConfigurations)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &p.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateDNSZoneConfig.
func (p PrivateDNSZoneConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateDNSZoneConfig.
func (p *PrivateDNSZoneConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateDNSZoneGroup.
func (p PrivateDNSZoneGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateDNSZoneGroup.
func (p *PrivateDNSZoneGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateDNSZoneGroupListResult.
func (p PrivateDNSZoneGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateDNSZoneGroupListResult.
func (p *PrivateDNSZoneGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateDNSZoneGroupPropertiesFormat.
func (p PrivateDNSZoneGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateDnsZoneConfigs", p.PrivateDNSZoneConfigs)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateDNSZoneGroupPropertiesFormat.
func (p *PrivateDNSZoneGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateDnsZoneConfigs":
			err = unpopulate(val, "PrivateDNSZoneConfigs", &p.PrivateDNSZoneConfigs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateDNSZonePropertiesFormat.
func (p PrivateDNSZonePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateDnsZoneId", p.PrivateDNSZoneID)
	populate(objectMap, "recordSets", p.RecordSets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateDNSZonePropertiesFormat.
func (p *PrivateDNSZonePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateDnsZoneId":
			err = unpopulate(val, "PrivateDNSZoneID", &p.PrivateDNSZoneID)
			delete(rawMsg, key)
		case "recordSets":
			err = unpopulate(val, "RecordSets", &p.RecordSets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "extendedLocation", p.ExtendedLocation)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &p.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkIdentifier", p.LinkIdentifier)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateEndpointLocation", p.PrivateEndpointLocation)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkIdentifier":
			err = unpopulate(val, "LinkIdentifier", &p.LinkIdentifier)
			delete(rawMsg, key)
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateEndpointLocation":
			err = unpopulate(val, "PrivateEndpointLocation", &p.PrivateEndpointLocation)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointIPConfiguration.
func (p PrivateEndpointIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointIPConfiguration.
func (p *PrivateEndpointIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointIPConfigurationProperties.
func (p PrivateEndpointIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "memberName", p.MemberName)
	populate(objectMap, "privateIPAddress", p.PrivateIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointIPConfigurationProperties.
func (p *PrivateEndpointIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "memberName":
			err = unpopulate(val, "MemberName", &p.MemberName)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &p.PrivateIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointListResult.
func (p PrivateEndpointListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointListResult.
func (p *PrivateEndpointListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointProperties.
func (p PrivateEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationSecurityGroups", p.ApplicationSecurityGroups)
	populate(objectMap, "customDnsConfigs", p.CustomDNSConfigs)
	populate(objectMap, "customNetworkInterfaceName", p.CustomNetworkInterfaceName)
	populate(objectMap, "ipConfigurations", p.IPConfigurations)
	populate(objectMap, "manualPrivateLinkServiceConnections", p.ManualPrivateLinkServiceConnections)
	populate(objectMap, "networkInterfaces", p.NetworkInterfaces)
	populate(objectMap, "privateLinkServiceConnections", p.PrivateLinkServiceConnections)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "subnet", p.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointProperties.
func (p *PrivateEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &p.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "customDnsConfigs":
			err = unpopulate(val, "CustomDNSConfigs", &p.CustomDNSConfigs)
			delete(rawMsg, key)
		case "customNetworkInterfaceName":
			err = unpopulate(val, "CustomNetworkInterfaceName", &p.CustomNetworkInterfaceName)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &p.IPConfigurations)
			delete(rawMsg, key)
		case "manualPrivateLinkServiceConnections":
			err = unpopulate(val, "ManualPrivateLinkServiceConnections", &p.ManualPrivateLinkServiceConnections)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &p.NetworkInterfaces)
			delete(rawMsg, key)
		case "privateLinkServiceConnections":
			err = unpopulate(val, "PrivateLinkServiceConnections", &p.PrivateLinkServiceConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &p.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkService.
func (p PrivateLinkService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "extendedLocation", p.ExtendedLocation)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkService.
func (p *PrivateLinkService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &p.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnection.
func (p PrivateLinkServiceConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnection.
func (p *PrivateLinkServiceConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionProperties.
func (p PrivateLinkServiceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "privateLinkServiceId", p.PrivateLinkServiceID)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "requestMessage", p.RequestMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionProperties.
func (p *PrivateLinkServiceConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupIds":
			err = unpopulate(val, "GroupIDs", &p.GroupIDs)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "privateLinkServiceId":
			err = unpopulate(val, "PrivateLinkServiceID", &p.PrivateLinkServiceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "requestMessage":
			err = unpopulate(val, "RequestMessage", &p.RequestMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceIPConfiguration.
func (p PrivateLinkServiceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceIPConfiguration.
func (p *PrivateLinkServiceIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceIPConfigurationProperties.
func (p PrivateLinkServiceIPConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primary", p.Primary)
	populate(objectMap, "privateIPAddress", p.PrivateIPAddress)
	populate(objectMap, "privateIPAddressVersion", p.PrivateIPAddressVersion)
	populate(objectMap, "privateIPAllocationMethod", p.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "subnet", p.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceIPConfigurationProperties.
func (p *PrivateLinkServiceIPConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primary":
			err = unpopulate(val, "Primary", &p.Primary)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &p.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &p.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &p.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &p.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceListResult.
func (p PrivateLinkServiceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceListResult.
func (p *PrivateLinkServiceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceProperties.
func (p PrivateLinkServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alias", p.Alias)
	populate(objectMap, "autoApproval", p.AutoApproval)
	populate(objectMap, "enableProxyProtocol", p.EnableProxyProtocol)
	populate(objectMap, "fqdns", p.Fqdns)
	populate(objectMap, "ipConfigurations", p.IPConfigurations)
	populate(objectMap, "loadBalancerFrontendIpConfigurations", p.LoadBalancerFrontendIPConfigurations)
	populate(objectMap, "networkInterfaces", p.NetworkInterfaces)
	populate(objectMap, "privateEndpointConnections", p.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "visibility", p.Visibility)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceProperties.
func (p *PrivateLinkServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alias":
			err = unpopulate(val, "Alias", &p.Alias)
			delete(rawMsg, key)
		case "autoApproval":
			err = unpopulate(val, "AutoApproval", &p.AutoApproval)
			delete(rawMsg, key)
		case "enableProxyProtocol":
			err = unpopulate(val, "EnableProxyProtocol", &p.EnableProxyProtocol)
			delete(rawMsg, key)
		case "fqdns":
			err = unpopulate(val, "Fqdns", &p.Fqdns)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &p.IPConfigurations)
			delete(rawMsg, key)
		case "loadBalancerFrontendIpConfigurations":
			err = unpopulate(val, "LoadBalancerFrontendIPConfigurations", &p.LoadBalancerFrontendIPConfigurations)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &p.NetworkInterfaces)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &p.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "visibility":
			err = unpopulate(val, "Visibility", &p.Visibility)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServicePropertiesAutoApproval.
func (p PrivateLinkServicePropertiesAutoApproval) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subscriptions", p.Subscriptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServicePropertiesAutoApproval.
func (p *PrivateLinkServicePropertiesAutoApproval) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &p.Subscriptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServicePropertiesVisibility.
func (p PrivateLinkServicePropertiesVisibility) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subscriptions", p.Subscriptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServicePropertiesVisibility.
func (p *PrivateLinkServicePropertiesVisibility) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &p.Subscriptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceVisibility.
func (p PrivateLinkServiceVisibility) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "visible", p.Visible)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceVisibility.
func (p *PrivateLinkServiceVisibility) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "visible":
			err = unpopulate(val, "Visible", &p.Visible)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Probe.
func (p Probe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Probe.
func (p *Probe) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProbePropertiesFormat.
func (p ProbePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "intervalInSeconds", p.IntervalInSeconds)
	populate(objectMap, "loadBalancingRules", p.LoadBalancingRules)
	populate(objectMap, "numberOfProbes", p.NumberOfProbes)
	populate(objectMap, "port", p.Port)
	populate(objectMap, "probeThreshold", p.ProbeThreshold)
	populate(objectMap, "protocol", p.Protocol)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "requestPath", p.RequestPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProbePropertiesFormat.
func (p *ProbePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "intervalInSeconds":
			err = unpopulate(val, "IntervalInSeconds", &p.IntervalInSeconds)
			delete(rawMsg, key)
		case "loadBalancingRules":
			err = unpopulate(val, "LoadBalancingRules", &p.LoadBalancingRules)
			delete(rawMsg, key)
		case "numberOfProbes":
			err = unpopulate(val, "NumberOfProbes", &p.NumberOfProbes)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &p.Port)
			delete(rawMsg, key)
		case "probeThreshold":
			err = unpopulate(val, "ProbeThreshold", &p.ProbeThreshold)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &p.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "requestPath":
			err = unpopulate(val, "RequestPath", &p.RequestPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Profile.
func (p *Profile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfileListResult.
func (p ProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfileListResult.
func (p *ProfileListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProfilePropertiesFormat.
func (p ProfilePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerNetworkInterfaceConfigurations", p.ContainerNetworkInterfaceConfigurations)
	populate(objectMap, "containerNetworkInterfaces", p.ContainerNetworkInterfaces)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "resourceGuid", p.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProfilePropertiesFormat.
func (p *ProfilePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerNetworkInterfaceConfigurations":
			err = unpopulate(val, "ContainerNetworkInterfaceConfigurations", &p.ContainerNetworkInterfaceConfigurations)
			delete(rawMsg, key)
		case "containerNetworkInterfaces":
			err = unpopulate(val, "ContainerNetworkInterfaces", &p.ContainerNetworkInterfaces)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &p.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropagatedRouteTable.
func (p PropagatedRouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ids", p.IDs)
	populate(objectMap, "labels", p.Labels)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropagatedRouteTable.
func (p *PropagatedRouteTable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ids":
			err = unpopulate(val, "IDs", &p.IDs)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &p.Labels)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropagatedRouteTableNfv.
func (p PropagatedRouteTableNfv) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ids", p.IDs)
	populate(objectMap, "labels", p.Labels)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropagatedRouteTableNfv.
func (p *PropagatedRouteTableNfv) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ids":
			err = unpopulate(val, "IDs", &p.IDs)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &p.Labels)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtocolConfiguration.
func (p ProtocolConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "HTTPConfiguration", p.HTTPConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtocolConfiguration.
func (p *ProtocolConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "HTTPConfiguration":
			err = unpopulate(val, "HTTPConfiguration", &p.HTTPConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddress.
func (p PublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "extendedLocation", p.ExtendedLocation)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "zones", p.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddress.
func (p *PublicIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &p.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &p.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressDNSSettings.
func (p PublicIPAddressDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainNameLabel", p.DomainNameLabel)
	populate(objectMap, "domainNameLabelScope", p.DomainNameLabelScope)
	populate(objectMap, "fqdn", p.Fqdn)
	populate(objectMap, "reverseFqdn", p.ReverseFqdn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressDNSSettings.
func (p *PublicIPAddressDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainNameLabel":
			err = unpopulate(val, "DomainNameLabel", &p.DomainNameLabel)
			delete(rawMsg, key)
		case "domainNameLabelScope":
			err = unpopulate(val, "DomainNameLabelScope", &p.DomainNameLabelScope)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &p.Fqdn)
			delete(rawMsg, key)
		case "reverseFqdn":
			err = unpopulate(val, "ReverseFqdn", &p.ReverseFqdn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressListResult.
func (p PublicIPAddressListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressListResult.
func (p *PublicIPAddressListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressPropertiesFormat.
func (p PublicIPAddressPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", p.DNSSettings)
	populate(objectMap, "ddosSettings", p.DdosSettings)
	populate(objectMap, "deleteOption", p.DeleteOption)
	populate(objectMap, "ipAddress", p.IPAddress)
	populate(objectMap, "ipConfiguration", p.IPConfiguration)
	populate(objectMap, "ipTags", p.IPTags)
	populate(objectMap, "idleTimeoutInMinutes", p.IdleTimeoutInMinutes)
	populate(objectMap, "linkedPublicIPAddress", p.LinkedPublicIPAddress)
	populate(objectMap, "migrationPhase", p.MigrationPhase)
	populate(objectMap, "natGateway", p.NatGateway)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicIPAddressVersion", p.PublicIPAddressVersion)
	populate(objectMap, "publicIPAllocationMethod", p.PublicIPAllocationMethod)
	populate(objectMap, "publicIPPrefix", p.PublicIPPrefix)
	populate(objectMap, "resourceGuid", p.ResourceGUID)
	populate(objectMap, "servicePublicIPAddress", p.ServicePublicIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressPropertiesFormat.
func (p *PublicIPAddressPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &p.DNSSettings)
			delete(rawMsg, key)
		case "ddosSettings":
			err = unpopulate(val, "DdosSettings", &p.DdosSettings)
			delete(rawMsg, key)
		case "deleteOption":
			err = unpopulate(val, "DeleteOption", &p.DeleteOption)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &p.IPAddress)
			delete(rawMsg, key)
		case "ipConfiguration":
			err = unpopulate(val, "IPConfiguration", &p.IPConfiguration)
			delete(rawMsg, key)
		case "ipTags":
			err = unpopulate(val, "IPTags", &p.IPTags)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &p.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "linkedPublicIPAddress":
			err = unpopulate(val, "LinkedPublicIPAddress", &p.LinkedPublicIPAddress)
			delete(rawMsg, key)
		case "migrationPhase":
			err = unpopulate(val, "MigrationPhase", &p.MigrationPhase)
			delete(rawMsg, key)
		case "natGateway":
			err = unpopulate(val, "NatGateway", &p.NatGateway)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddressVersion":
			err = unpopulate(val, "PublicIPAddressVersion", &p.PublicIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAllocationMethod":
			err = unpopulate(val, "PublicIPAllocationMethod", &p.PublicIPAllocationMethod)
			delete(rawMsg, key)
		case "publicIPPrefix":
			err = unpopulate(val, "PublicIPPrefix", &p.PublicIPPrefix)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &p.ResourceGUID)
			delete(rawMsg, key)
		case "servicePublicIPAddress":
			err = unpopulate(val, "ServicePublicIPAddress", &p.ServicePublicIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressSKU.
func (p PublicIPAddressSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "tier", p.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressSKU.
func (p *PublicIPAddressSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &p.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPDdosProtectionStatusResult.
func (p PublicIPDdosProtectionStatusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ddosProtectionPlanId", p.DdosProtectionPlanID)
	populate(objectMap, "isWorkloadProtected", p.IsWorkloadProtected)
	populate(objectMap, "publicIpAddress", p.PublicIPAddress)
	populate(objectMap, "publicIpAddressId", p.PublicIPAddressID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPDdosProtectionStatusResult.
func (p *PublicIPDdosProtectionStatusResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ddosProtectionPlanId":
			err = unpopulate(val, "DdosProtectionPlanID", &p.DdosProtectionPlanID)
			delete(rawMsg, key)
		case "isWorkloadProtected":
			err = unpopulate(val, "IsWorkloadProtected", &p.IsWorkloadProtected)
			delete(rawMsg, key)
		case "publicIpAddress":
			err = unpopulate(val, "PublicIPAddress", &p.PublicIPAddress)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &p.PublicIPAddressID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPPrefix.
func (p PublicIPPrefix) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "extendedLocation", p.ExtendedLocation)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "zones", p.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPPrefix.
func (p *PublicIPPrefix) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &p.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &p.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPPrefixListResult.
func (p PublicIPPrefixListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPPrefixListResult.
func (p *PublicIPPrefixListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPPrefixPropertiesFormat.
func (p PublicIPPrefixPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customIPPrefix", p.CustomIPPrefix)
	populate(objectMap, "ipPrefix", p.IPPrefix)
	populate(objectMap, "ipTags", p.IPTags)
	populate(objectMap, "loadBalancerFrontendIpConfiguration", p.LoadBalancerFrontendIPConfiguration)
	populate(objectMap, "natGateway", p.NatGateway)
	populate(objectMap, "prefixLength", p.PrefixLength)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicIPAddressVersion", p.PublicIPAddressVersion)
	populate(objectMap, "publicIPAddresses", p.PublicIPAddresses)
	populate(objectMap, "resourceGuid", p.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPPrefixPropertiesFormat.
func (p *PublicIPPrefixPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customIPPrefix":
			err = unpopulate(val, "CustomIPPrefix", &p.CustomIPPrefix)
			delete(rawMsg, key)
		case "ipPrefix":
			err = unpopulate(val, "IPPrefix", &p.IPPrefix)
			delete(rawMsg, key)
		case "ipTags":
			err = unpopulate(val, "IPTags", &p.IPTags)
			delete(rawMsg, key)
		case "loadBalancerFrontendIpConfiguration":
			err = unpopulate(val, "LoadBalancerFrontendIPConfiguration", &p.LoadBalancerFrontendIPConfiguration)
			delete(rawMsg, key)
		case "natGateway":
			err = unpopulate(val, "NatGateway", &p.NatGateway)
			delete(rawMsg, key)
		case "prefixLength":
			err = unpopulate(val, "PrefixLength", &p.PrefixLength)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddressVersion":
			err = unpopulate(val, "PublicIPAddressVersion", &p.PublicIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAddresses":
			err = unpopulate(val, "PublicIPAddresses", &p.PublicIPAddresses)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &p.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPPrefixSKU.
func (p PublicIPPrefixSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "tier", p.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPPrefixSKU.
func (p *PublicIPPrefixSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &p.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QosDefinition.
func (q QosDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationIpRanges", q.DestinationIPRanges)
	populate(objectMap, "destinationPortRanges", q.DestinationPortRanges)
	populate(objectMap, "markings", q.Markings)
	populate(objectMap, "protocol", q.Protocol)
	populate(objectMap, "sourceIpRanges", q.SourceIPRanges)
	populate(objectMap, "sourcePortRanges", q.SourcePortRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QosDefinition.
func (q *QosDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationIpRanges":
			err = unpopulate(val, "DestinationIPRanges", &q.DestinationIPRanges)
			delete(rawMsg, key)
		case "destinationPortRanges":
			err = unpopulate(val, "DestinationPortRanges", &q.DestinationPortRanges)
			delete(rawMsg, key)
		case "markings":
			err = unpopulate(val, "Markings", &q.Markings)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &q.Protocol)
			delete(rawMsg, key)
		case "sourceIpRanges":
			err = unpopulate(val, "SourceIPRanges", &q.SourceIPRanges)
			delete(rawMsg, key)
		case "sourcePortRanges":
			err = unpopulate(val, "SourcePortRanges", &q.SourcePortRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QosIPRange.
func (q QosIPRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endIP", q.EndIP)
	populate(objectMap, "startIP", q.StartIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QosIPRange.
func (q *QosIPRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endIP":
			err = unpopulate(val, "EndIP", &q.EndIP)
			delete(rawMsg, key)
		case "startIP":
			err = unpopulate(val, "StartIP", &q.StartIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QosPortRange.
func (q QosPortRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "end", q.End)
	populate(objectMap, "start", q.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QosPortRange.
func (q *QosPortRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			err = unpopulate(val, "End", &q.End)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &q.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryInboundNatRulePortMappingRequest.
func (q QueryInboundNatRulePortMappingRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddress", q.IPAddress)
	populate(objectMap, "ipConfiguration", q.IPConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryInboundNatRulePortMappingRequest.
func (q *QueryInboundNatRulePortMappingRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &q.IPAddress)
			delete(rawMsg, key)
		case "ipConfiguration":
			err = unpopulate(val, "IPConfiguration", &q.IPConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryRequestOptions.
func (q QueryRequestOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipToken", q.SkipToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryRequestOptions.
func (q *QueryRequestOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipToken":
			err = unpopulate(val, "SkipToken", &q.SkipToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryResults.
func (q QueryResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "matchingRecordsCount", q.MatchingRecordsCount)
	populate(objectMap, "signatures", q.Signatures)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryResults.
func (q *QueryResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "matchingRecordsCount":
			err = unpopulate(val, "MatchingRecordsCount", &q.MatchingRecordsCount)
			delete(rawMsg, key)
		case "signatures":
			err = unpopulate(val, "Signatures", &q.Signatures)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryTroubleshootingParameters.
func (q QueryTroubleshootingParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetResourceId", q.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryTroubleshootingParameters.
func (q *QueryTroubleshootingParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &q.TargetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RadiusServer.
func (r RadiusServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "radiusServerAddress", r.RadiusServerAddress)
	populate(objectMap, "radiusServerScore", r.RadiusServerScore)
	populate(objectMap, "radiusServerSecret", r.RadiusServerSecret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RadiusServer.
func (r *RadiusServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "radiusServerAddress":
			err = unpopulate(val, "RadiusServerAddress", &r.RadiusServerAddress)
			delete(rawMsg, key)
		case "radiusServerScore":
			err = unpopulate(val, "RadiusServerScore", &r.RadiusServerScore)
			delete(rawMsg, key)
		case "radiusServerSecret":
			err = unpopulate(val, "RadiusServerSecret", &r.RadiusServerSecret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecordSet.
func (r RecordSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdn", r.Fqdn)
	populate(objectMap, "ipAddresses", r.IPAddresses)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "recordSetName", r.RecordSetName)
	populate(objectMap, "recordType", r.RecordType)
	populate(objectMap, "ttl", r.TTL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecordSet.
func (r *RecordSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &r.IPAddresses)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "recordSetName":
			err = unpopulate(val, "RecordSetName", &r.RecordSetName)
			delete(rawMsg, key)
		case "recordType":
			err = unpopulate(val, "RecordType", &r.RecordType)
			delete(rawMsg, key)
		case "ttl":
			err = unpopulate(val, "TTL", &r.TTL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReferencedPublicIPAddress.
func (r ReferencedPublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReferencedPublicIPAddress.
func (r *ReferencedPublicIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNavigationLink.
func (r ResourceNavigationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNavigationLink.
func (r *ResourceNavigationLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNavigationLinkFormat.
func (r ResourceNavigationLinkFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "link", r.Link)
	populate(objectMap, "linkedResourceType", r.LinkedResourceType)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNavigationLinkFormat.
func (r *ResourceNavigationLinkFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "link":
			err = unpopulate(val, "Link", &r.Link)
			delete(rawMsg, key)
		case "linkedResourceType":
			err = unpopulate(val, "LinkedResourceType", &r.LinkedResourceType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNavigationLinksListResult.
func (r ResourceNavigationLinksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNavigationLinksListResult.
func (r *ResourceNavigationLinksListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSet.
func (r ResourceSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subscriptions", r.Subscriptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSet.
func (r *ResourceSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &r.Subscriptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetentionPolicyParameters.
func (r RetentionPolicyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "days", r.Days)
	populate(objectMap, "enabled", r.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetentionPolicyParameters.
func (r *RetentionPolicyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "days":
			err = unpopulate(val, "Days", &r.Days)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Route.
func (r *Route) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteFilter.
func (r RouteFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteFilter.
func (r *RouteFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteFilterListResult.
func (r RouteFilterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteFilterListResult.
func (r *RouteFilterListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteFilterPropertiesFormat.
func (r RouteFilterPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipv6Peerings", r.IPv6Peerings)
	populate(objectMap, "peerings", r.Peerings)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "rules", r.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteFilterPropertiesFormat.
func (r *RouteFilterPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipv6Peerings":
			err = unpopulate(val, "IPv6Peerings", &r.IPv6Peerings)
			delete(rawMsg, key)
		case "peerings":
			err = unpopulate(val, "Peerings", &r.Peerings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &r.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteFilterRule.
func (r RouteFilterRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteFilterRule.
func (r *RouteFilterRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteFilterRuleListResult.
func (r RouteFilterRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteFilterRuleListResult.
func (r *RouteFilterRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteFilterRulePropertiesFormat.
func (r RouteFilterRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", r.Access)
	populate(objectMap, "communities", r.Communities)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "routeFilterRuleType", r.RouteFilterRuleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteFilterRulePropertiesFormat.
func (r *RouteFilterRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &r.Access)
			delete(rawMsg, key)
		case "communities":
			err = unpopulate(val, "Communities", &r.Communities)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "routeFilterRuleType":
			err = unpopulate(val, "RouteFilterRuleType", &r.RouteFilterRuleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteListResult.
func (r RouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteListResult.
func (r *RouteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteMap.
func (r RouteMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteMap.
func (r *RouteMap) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteMapProperties.
func (r RouteMapProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedInboundConnections", r.AssociatedInboundConnections)
	populate(objectMap, "associatedOutboundConnections", r.AssociatedOutboundConnections)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "rules", r.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteMapProperties.
func (r *RouteMapProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedInboundConnections":
			err = unpopulate(val, "AssociatedInboundConnections", &r.AssociatedInboundConnections)
			delete(rawMsg, key)
		case "associatedOutboundConnections":
			err = unpopulate(val, "AssociatedOutboundConnections", &r.AssociatedOutboundConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &r.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteMapRule.
func (r RouteMapRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", r.Actions)
	populate(objectMap, "matchCriteria", r.MatchCriteria)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "nextStepIfMatched", r.NextStepIfMatched)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteMapRule.
func (r *RouteMapRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &r.Actions)
			delete(rawMsg, key)
		case "matchCriteria":
			err = unpopulate(val, "MatchCriteria", &r.MatchCriteria)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "nextStepIfMatched":
			err = unpopulate(val, "NextStepIfMatched", &r.NextStepIfMatched)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutePropertiesFormat.
func (r RoutePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", r.AddressPrefix)
	populate(objectMap, "hasBgpOverride", r.HasBgpOverride)
	populate(objectMap, "nextHopIpAddress", r.NextHopIPAddress)
	populate(objectMap, "nextHopType", r.NextHopType)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutePropertiesFormat.
func (r *RoutePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &r.AddressPrefix)
			delete(rawMsg, key)
		case "hasBgpOverride":
			err = unpopulate(val, "HasBgpOverride", &r.HasBgpOverride)
			delete(rawMsg, key)
		case "nextHopIpAddress":
			err = unpopulate(val, "NextHopIPAddress", &r.NextHopIPAddress)
			delete(rawMsg, key)
		case "nextHopType":
			err = unpopulate(val, "NextHopType", &r.NextHopType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteTable.
func (r RouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteTable.
func (r *RouteTable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteTableListResult.
func (r RouteTableListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteTableListResult.
func (r *RouteTableListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteTablePropertiesFormat.
func (r RouteTablePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableBgpRoutePropagation", r.DisableBgpRoutePropagation)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "resourceGuid", r.ResourceGUID)
	populate(objectMap, "routes", r.Routes)
	populate(objectMap, "subnets", r.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteTablePropertiesFormat.
func (r *RouteTablePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableBgpRoutePropagation":
			err = unpopulate(val, "DisableBgpRoutePropagation", &r.DisableBgpRoutePropagation)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &r.ResourceGUID)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &r.Routes)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &r.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingConfiguration.
func (r RoutingConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedRouteTable", r.AssociatedRouteTable)
	populate(objectMap, "inboundRouteMap", r.InboundRouteMap)
	populate(objectMap, "outboundRouteMap", r.OutboundRouteMap)
	populate(objectMap, "propagatedRouteTables", r.PropagatedRouteTables)
	populate(objectMap, "vnetRoutes", r.VnetRoutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingConfiguration.
func (r *RoutingConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedRouteTable":
			err = unpopulate(val, "AssociatedRouteTable", &r.AssociatedRouteTable)
			delete(rawMsg, key)
		case "inboundRouteMap":
			err = unpopulate(val, "InboundRouteMap", &r.InboundRouteMap)
			delete(rawMsg, key)
		case "outboundRouteMap":
			err = unpopulate(val, "OutboundRouteMap", &r.OutboundRouteMap)
			delete(rawMsg, key)
		case "propagatedRouteTables":
			err = unpopulate(val, "PropagatedRouteTables", &r.PropagatedRouteTables)
			delete(rawMsg, key)
		case "vnetRoutes":
			err = unpopulate(val, "VnetRoutes", &r.VnetRoutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingConfigurationNfv.
func (r RoutingConfigurationNfv) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associatedRouteTable", r.AssociatedRouteTable)
	populate(objectMap, "inboundRouteMap", r.InboundRouteMap)
	populate(objectMap, "outboundRouteMap", r.OutboundRouteMap)
	populate(objectMap, "propagatedRouteTables", r.PropagatedRouteTables)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingConfigurationNfv.
func (r *RoutingConfigurationNfv) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associatedRouteTable":
			err = unpopulate(val, "AssociatedRouteTable", &r.AssociatedRouteTable)
			delete(rawMsg, key)
		case "inboundRouteMap":
			err = unpopulate(val, "InboundRouteMap", &r.InboundRouteMap)
			delete(rawMsg, key)
		case "outboundRouteMap":
			err = unpopulate(val, "OutboundRouteMap", &r.OutboundRouteMap)
			delete(rawMsg, key)
		case "propagatedRouteTables":
			err = unpopulate(val, "PropagatedRouteTables", &r.PropagatedRouteTables)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingConfigurationNfvSubResource.
func (r RoutingConfigurationNfvSubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", r.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingConfigurationNfvSubResource.
func (r *RoutingConfigurationNfvSubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingIntent.
func (r RoutingIntent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingIntent.
func (r *RoutingIntent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingIntentProperties.
func (r RoutingIntentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "routingPolicies", r.RoutingPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingIntentProperties.
func (r *RoutingIntentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "routingPolicies":
			err = unpopulate(val, "RoutingPolicies", &r.RoutingPolicies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutingPolicy.
func (r RoutingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinations", r.Destinations)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "nextHop", r.NextHop)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutingPolicy.
func (r *RoutingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinations":
			err = unpopulate(val, "Destinations", &r.Destinations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "nextHop":
			err = unpopulate(val, "NextHop", &r.NextHop)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Rule.
func (r Rule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "destinationAddresses", r.DestinationAddresses)
	populate(objectMap, "destinationFqdns", r.DestinationFqdns)
	populate(objectMap, "destinationIpGroups", r.DestinationIPGroups)
	populate(objectMap, "destinationPorts", r.DestinationPorts)
	populate(objectMap, "ipProtocols", r.IPProtocols)
	populate(objectMap, "name", r.Name)
	objectMap["ruleType"] = FirewallPolicyRuleTypeNetworkRule
	populate(objectMap, "sourceAddresses", r.SourceAddresses)
	populate(objectMap, "sourceIpGroups", r.SourceIPGroups)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Rule.
func (r *Rule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "destinationAddresses":
			err = unpopulate(val, "DestinationAddresses", &r.DestinationAddresses)
			delete(rawMsg, key)
		case "destinationFqdns":
			err = unpopulate(val, "DestinationFqdns", &r.DestinationFqdns)
			delete(rawMsg, key)
		case "destinationIpGroups":
			err = unpopulate(val, "DestinationIPGroups", &r.DestinationIPGroups)
			delete(rawMsg, key)
		case "destinationPorts":
			err = unpopulate(val, "DestinationPorts", &r.DestinationPorts)
			delete(rawMsg, key)
		case "ipProtocols":
			err = unpopulate(val, "IPProtocols", &r.IPProtocols)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "ruleType":
			err = unpopulate(val, "RuleType", &r.RuleType)
			delete(rawMsg, key)
		case "sourceAddresses":
			err = unpopulate(val, "SourceAddresses", &r.SourceAddresses)
			delete(rawMsg, key)
		case "sourceIpGroups":
			err = unpopulate(val, "SourceIPGroups", &r.SourceIPGroups)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScopeConnection.
func (s ScopeConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScopeConnection.
func (s *ScopeConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScopeConnectionListResult.
func (s ScopeConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScopeConnectionListResult.
func (s *ScopeConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScopeConnectionProperties.
func (s ScopeConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionState", s.ConnectionState)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "resourceId", s.ResourceID)
	populate(objectMap, "tenantId", s.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScopeConnectionProperties.
func (s *ScopeConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionState":
			err = unpopulate(val, "ConnectionState", &s.ConnectionState)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &s.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAdminConfiguration.
func (s SecurityAdminConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAdminConfiguration.
func (s *SecurityAdminConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAdminConfigurationListResult.
func (s SecurityAdminConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAdminConfigurationListResult.
func (s *SecurityAdminConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAdminConfigurationPropertiesFormat.
func (s SecurityAdminConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applyOnNetworkIntentPolicyBasedServices", s.ApplyOnNetworkIntentPolicyBasedServices)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceGuid", s.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAdminConfigurationPropertiesFormat.
func (s *SecurityAdminConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applyOnNetworkIntentPolicyBasedServices":
			err = unpopulate(val, "ApplyOnNetworkIntentPolicyBasedServices", &s.ApplyOnNetworkIntentPolicyBasedServices)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &s.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroup.
func (s SecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroup.
func (s *SecurityGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupListResult.
func (s SecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupListResult.
func (s *SecurityGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupNetworkInterface.
func (s SecurityGroupNetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "securityRuleAssociations", s.SecurityRuleAssociations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupNetworkInterface.
func (s *SecurityGroupNetworkInterface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "securityRuleAssociations":
			err = unpopulate(val, "SecurityRuleAssociations", &s.SecurityRuleAssociations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupPropertiesFormat.
func (s SecurityGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultSecurityRules", s.DefaultSecurityRules)
	populate(objectMap, "flowLogs", s.FlowLogs)
	populate(objectMap, "flushConnection", s.FlushConnection)
	populate(objectMap, "networkInterfaces", s.NetworkInterfaces)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceGuid", s.ResourceGUID)
	populate(objectMap, "securityRules", s.SecurityRules)
	populate(objectMap, "subnets", s.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupPropertiesFormat.
func (s *SecurityGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultSecurityRules":
			err = unpopulate(val, "DefaultSecurityRules", &s.DefaultSecurityRules)
			delete(rawMsg, key)
		case "flowLogs":
			err = unpopulate(val, "FlowLogs", &s.FlowLogs)
			delete(rawMsg, key)
		case "flushConnection":
			err = unpopulate(val, "FlushConnection", &s.FlushConnection)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &s.NetworkInterfaces)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &s.ResourceGUID)
			delete(rawMsg, key)
		case "securityRules":
			err = unpopulate(val, "SecurityRules", &s.SecurityRules)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &s.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupResult.
func (s SecurityGroupResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "evaluatedNetworkSecurityGroups", s.EvaluatedNetworkSecurityGroups)
	populate(objectMap, "securityRuleAccessResult", s.SecurityRuleAccessResult)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupResult.
func (s *SecurityGroupResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "evaluatedNetworkSecurityGroups":
			err = unpopulate(val, "EvaluatedNetworkSecurityGroups", &s.EvaluatedNetworkSecurityGroups)
			delete(rawMsg, key)
		case "securityRuleAccessResult":
			err = unpopulate(val, "SecurityRuleAccessResult", &s.SecurityRuleAccessResult)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupViewParameters.
func (s SecurityGroupViewParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetResourceId", s.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupViewParameters.
func (s *SecurityGroupViewParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &s.TargetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupViewResult.
func (s SecurityGroupViewResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterfaces", s.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupViewResult.
func (s *SecurityGroupViewResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &s.NetworkInterfaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPartnerProvider.
func (s SecurityPartnerProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPartnerProvider.
func (s *SecurityPartnerProvider) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPartnerProviderListResult.
func (s SecurityPartnerProviderListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPartnerProviderListResult.
func (s *SecurityPartnerProviderListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityPartnerProviderPropertiesFormat.
func (s SecurityPartnerProviderPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionStatus", s.ConnectionStatus)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "securityProviderName", s.SecurityProviderName)
	populate(objectMap, "virtualHub", s.VirtualHub)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityPartnerProviderPropertiesFormat.
func (s *SecurityPartnerProviderPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &s.ConnectionStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "securityProviderName":
			err = unpopulate(val, "SecurityProviderName", &s.SecurityProviderName)
			delete(rawMsg, key)
		case "virtualHub":
			err = unpopulate(val, "VirtualHub", &s.VirtualHub)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityRule.
func (s SecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityRule.
func (s *SecurityRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityRuleAssociations.
func (s SecurityRuleAssociations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultSecurityRules", s.DefaultSecurityRules)
	populate(objectMap, "effectiveSecurityRules", s.EffectiveSecurityRules)
	populate(objectMap, "networkInterfaceAssociation", s.NetworkInterfaceAssociation)
	populate(objectMap, "subnetAssociation", s.SubnetAssociation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityRuleAssociations.
func (s *SecurityRuleAssociations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultSecurityRules":
			err = unpopulate(val, "DefaultSecurityRules", &s.DefaultSecurityRules)
			delete(rawMsg, key)
		case "effectiveSecurityRules":
			err = unpopulate(val, "EffectiveSecurityRules", &s.EffectiveSecurityRules)
			delete(rawMsg, key)
		case "networkInterfaceAssociation":
			err = unpopulate(val, "NetworkInterfaceAssociation", &s.NetworkInterfaceAssociation)
			delete(rawMsg, key)
		case "subnetAssociation":
			err = unpopulate(val, "SubnetAssociation", &s.SubnetAssociation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityRuleListResult.
func (s SecurityRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityRuleListResult.
func (s *SecurityRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityRulePropertiesFormat.
func (s SecurityRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", s.Access)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "destinationAddressPrefix", s.DestinationAddressPrefix)
	populate(objectMap, "destinationAddressPrefixes", s.DestinationAddressPrefixes)
	populate(objectMap, "destinationApplicationSecurityGroups", s.DestinationApplicationSecurityGroups)
	populate(objectMap, "destinationPortRange", s.DestinationPortRange)
	populate(objectMap, "destinationPortRanges", s.DestinationPortRanges)
	populate(objectMap, "direction", s.Direction)
	populate(objectMap, "priority", s.Priority)
	populate(objectMap, "protocol", s.Protocol)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "sourceAddressPrefix", s.SourceAddressPrefix)
	populate(objectMap, "sourceAddressPrefixes", s.SourceAddressPrefixes)
	populate(objectMap, "sourceApplicationSecurityGroups", s.SourceApplicationSecurityGroups)
	populate(objectMap, "sourcePortRange", s.SourcePortRange)
	populate(objectMap, "sourcePortRanges", s.SourcePortRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityRulePropertiesFormat.
func (s *SecurityRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &s.Access)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "destinationAddressPrefix":
			err = unpopulate(val, "DestinationAddressPrefix", &s.DestinationAddressPrefix)
			delete(rawMsg, key)
		case "destinationAddressPrefixes":
			err = unpopulate(val, "DestinationAddressPrefixes", &s.DestinationAddressPrefixes)
			delete(rawMsg, key)
		case "destinationApplicationSecurityGroups":
			err = unpopulate(val, "DestinationApplicationSecurityGroups", &s.DestinationApplicationSecurityGroups)
			delete(rawMsg, key)
		case "destinationPortRange":
			err = unpopulate(val, "DestinationPortRange", &s.DestinationPortRange)
			delete(rawMsg, key)
		case "destinationPortRanges":
			err = unpopulate(val, "DestinationPortRanges", &s.DestinationPortRanges)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &s.Direction)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &s.Priority)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &s.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "sourceAddressPrefix":
			err = unpopulate(val, "SourceAddressPrefix", &s.SourceAddressPrefix)
			delete(rawMsg, key)
		case "sourceAddressPrefixes":
			err = unpopulate(val, "SourceAddressPrefixes", &s.SourceAddressPrefixes)
			delete(rawMsg, key)
		case "sourceApplicationSecurityGroups":
			err = unpopulate(val, "SourceApplicationSecurityGroups", &s.SourceApplicationSecurityGroups)
			delete(rawMsg, key)
		case "sourcePortRange":
			err = unpopulate(val, "SourcePortRange", &s.SourcePortRange)
			delete(rawMsg, key)
		case "sourcePortRanges":
			err = unpopulate(val, "SourcePortRanges", &s.SourcePortRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityRulesEvaluationResult.
func (s SecurityRulesEvaluationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationMatched", s.DestinationMatched)
	populate(objectMap, "destinationPortMatched", s.DestinationPortMatched)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "protocolMatched", s.ProtocolMatched)
	populate(objectMap, "sourceMatched", s.SourceMatched)
	populate(objectMap, "sourcePortMatched", s.SourcePortMatched)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityRulesEvaluationResult.
func (s *SecurityRulesEvaluationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationMatched":
			err = unpopulate(val, "DestinationMatched", &s.DestinationMatched)
			delete(rawMsg, key)
		case "destinationPortMatched":
			err = unpopulate(val, "DestinationPortMatched", &s.DestinationPortMatched)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "protocolMatched":
			err = unpopulate(val, "ProtocolMatched", &s.ProtocolMatched)
			delete(rawMsg, key)
		case "sourceMatched":
			err = unpopulate(val, "SourceMatched", &s.SourceMatched)
			delete(rawMsg, key)
		case "sourcePortMatched":
			err = unpopulate(val, "SourcePortMatched", &s.SourcePortMatched)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceAssociationLink.
func (s ServiceAssociationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceAssociationLink.
func (s *ServiceAssociationLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceAssociationLinkPropertiesFormat.
func (s ServiceAssociationLinkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowDelete", s.AllowDelete)
	populate(objectMap, "link", s.Link)
	populate(objectMap, "linkedResourceType", s.LinkedResourceType)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceAssociationLinkPropertiesFormat.
func (s *ServiceAssociationLinkPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowDelete":
			err = unpopulate(val, "AllowDelete", &s.AllowDelete)
			delete(rawMsg, key)
		case "link":
			err = unpopulate(val, "Link", &s.Link)
			delete(rawMsg, key)
		case "linkedResourceType":
			err = unpopulate(val, "LinkedResourceType", &s.LinkedResourceType)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceAssociationLinksListResult.
func (s ServiceAssociationLinksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceAssociationLinksListResult.
func (s *ServiceAssociationLinksListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceDelegationPropertiesFormat.
func (s ServiceDelegationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", s.Actions)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "serviceName", s.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceDelegationPropertiesFormat.
func (s *ServiceDelegationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &s.Actions)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &s.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicy.
func (s ServiceEndpointPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicy.
func (s *ServiceEndpointPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicyDefinition.
func (s ServiceEndpointPolicyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicyDefinition.
func (s *ServiceEndpointPolicyDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicyDefinitionListResult.
func (s ServiceEndpointPolicyDefinitionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicyDefinitionListResult.
func (s *ServiceEndpointPolicyDefinitionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicyDefinitionPropertiesFormat.
func (s ServiceEndpointPolicyDefinitionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "service", s.Service)
	populate(objectMap, "serviceResources", s.ServiceResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicyDefinitionPropertiesFormat.
func (s *ServiceEndpointPolicyDefinitionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "service":
			err = unpopulate(val, "Service", &s.Service)
			delete(rawMsg, key)
		case "serviceResources":
			err = unpopulate(val, "ServiceResources", &s.ServiceResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicyListResult.
func (s ServiceEndpointPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicyListResult.
func (s *ServiceEndpointPolicyListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicyPropertiesFormat.
func (s ServiceEndpointPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contextualServiceEndpointPolicies", s.ContextualServiceEndpointPolicies)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceGuid", s.ResourceGUID)
	populate(objectMap, "serviceAlias", s.ServiceAlias)
	populate(objectMap, "serviceEndpointPolicyDefinitions", s.ServiceEndpointPolicyDefinitions)
	populate(objectMap, "subnets", s.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicyPropertiesFormat.
func (s *ServiceEndpointPolicyPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contextualServiceEndpointPolicies":
			err = unpopulate(val, "ContextualServiceEndpointPolicies", &s.ContextualServiceEndpointPolicies)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &s.ResourceGUID)
			delete(rawMsg, key)
		case "serviceAlias":
			err = unpopulate(val, "ServiceAlias", &s.ServiceAlias)
			delete(rawMsg, key)
		case "serviceEndpointPolicyDefinitions":
			err = unpopulate(val, "ServiceEndpointPolicyDefinitions", &s.ServiceEndpointPolicyDefinitions)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &s.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPropertiesFormat.
func (s ServiceEndpointPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "service", s.Service)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPropertiesFormat.
func (s *ServiceEndpointPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "service":
			err = unpopulate(val, "Service", &s.Service)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTagInformation.
func (s ServiceTagInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "serviceTagChangeNumber", s.ServiceTagChangeNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTagInformation.
func (s *ServiceTagInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "serviceTagChangeNumber":
			err = unpopulate(val, "ServiceTagChangeNumber", &s.ServiceTagChangeNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTagInformationListResult.
func (s ServiceTagInformationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTagInformationListResult.
func (s *ServiceTagInformationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTagInformationPropertiesFormat.
func (s ServiceTagInformationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefixes", s.AddressPrefixes)
	populate(objectMap, "changeNumber", s.ChangeNumber)
	populate(objectMap, "region", s.Region)
	populate(objectMap, "state", s.State)
	populate(objectMap, "systemService", s.SystemService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTagInformationPropertiesFormat.
func (s *ServiceTagInformationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefixes":
			err = unpopulate(val, "AddressPrefixes", &s.AddressPrefixes)
			delete(rawMsg, key)
		case "changeNumber":
			err = unpopulate(val, "ChangeNumber", &s.ChangeNumber)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &s.Region)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "systemService":
			err = unpopulate(val, "SystemService", &s.SystemService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTagsListResult.
func (s ServiceTagsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "changeNumber", s.ChangeNumber)
	populate(objectMap, "cloud", s.Cloud)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTagsListResult.
func (s *ServiceTagsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changeNumber":
			err = unpopulate(val, "ChangeNumber", &s.ChangeNumber)
			delete(rawMsg, key)
		case "cloud":
			err = unpopulate(val, "Cloud", &s.Cloud)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SessionIDs.
func (s SessionIDs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sessionIds", s.SessionIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SessionIDs.
func (s *SessionIDs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sessionIds":
			err = unpopulate(val, "SessionIDs", &s.SessionIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignatureOverridesFilterValuesQuery.
func (s SignatureOverridesFilterValuesQuery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filterName", s.FilterName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignatureOverridesFilterValuesQuery.
func (s *SignatureOverridesFilterValuesQuery) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filterName":
			err = unpopulate(val, "FilterName", &s.FilterName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignatureOverridesFilterValuesResponse.
func (s SignatureOverridesFilterValuesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filterValues", s.FilterValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignatureOverridesFilterValuesResponse.
func (s *SignatureOverridesFilterValuesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filterValues":
			err = unpopulate(val, "FilterValues", &s.FilterValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignaturesOverrides.
func (s SignaturesOverrides) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignaturesOverrides.
func (s *SignaturesOverrides) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignaturesOverridesList.
func (s SignaturesOverridesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignaturesOverridesList.
func (s *SignaturesOverridesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignaturesOverridesProperties.
func (s SignaturesOverridesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "signatures", s.Signatures)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignaturesOverridesProperties.
func (s *SignaturesOverridesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "signatures":
			err = unpopulate(val, "Signatures", &s.Signatures)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SingleQueryResult.
func (s SingleQueryResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "destinationPorts", s.DestinationPorts)
	populate(objectMap, "direction", s.Direction)
	populate(objectMap, "group", s.Group)
	populate(objectMap, "inheritedFromParentPolicy", s.InheritedFromParentPolicy)
	populate(objectMap, "lastUpdated", s.LastUpdated)
	populate(objectMap, "mode", s.Mode)
	populate(objectMap, "protocol", s.Protocol)
	populate(objectMap, "severity", s.Severity)
	populate(objectMap, "signatureId", s.SignatureID)
	populate(objectMap, "sourcePorts", s.SourcePorts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SingleQueryResult.
func (s *SingleQueryResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "destinationPorts":
			err = unpopulate(val, "DestinationPorts", &s.DestinationPorts)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &s.Direction)
			delete(rawMsg, key)
		case "group":
			err = unpopulate(val, "Group", &s.Group)
			delete(rawMsg, key)
		case "inheritedFromParentPolicy":
			err = unpopulate(val, "InheritedFromParentPolicy", &s.InheritedFromParentPolicy)
			delete(rawMsg, key)
		case "lastUpdated":
			err = unpopulate(val, "LastUpdated", &s.LastUpdated)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &s.Mode)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &s.Protocol)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &s.Severity)
			delete(rawMsg, key)
		case "signatureId":
			err = unpopulate(val, "SignatureID", &s.SignatureID)
			delete(rawMsg, key)
		case "sourcePorts":
			err = unpopulate(val, "SourcePorts", &s.SourcePorts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticMember.
func (s StaticMember) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticMember.
func (s *StaticMember) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticMemberListResult.
func (s StaticMemberListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticMemberListResult.
func (s *StaticMemberListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticMemberProperties.
func (s StaticMemberProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "region", s.Region)
	populate(objectMap, "resourceId", s.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticMemberProperties.
func (s *StaticMemberProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &s.Region)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticRoute.
func (s StaticRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefixes", s.AddressPrefixes)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "nextHopIpAddress", s.NextHopIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticRoute.
func (s *StaticRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefixes":
			err = unpopulate(val, "AddressPrefixes", &s.AddressPrefixes)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "nextHopIpAddress":
			err = unpopulate(val, "NextHopIPAddress", &s.NextHopIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticRoutesConfig.
func (s StaticRoutesConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "propagateStaticRoutes", s.PropagateStaticRoutes)
	populate(objectMap, "vnetLocalRouteOverrideCriteria", s.VnetLocalRouteOverrideCriteria)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticRoutesConfig.
func (s *StaticRoutesConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "propagateStaticRoutes":
			err = unpopulate(val, "PropagateStaticRoutes", &s.PropagateStaticRoutes)
			delete(rawMsg, key)
		case "vnetLocalRouteOverrideCriteria":
			err = unpopulate(val, "VnetLocalRouteOverrideCriteria", &s.VnetLocalRouteOverrideCriteria)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Subnet.
func (s *Subnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetAssociation.
func (s SubnetAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "securityRules", s.SecurityRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetAssociation.
func (s *SubnetAssociation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "securityRules":
			err = unpopulate(val, "SecurityRules", &s.SecurityRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetListResult.
func (s SubnetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetListResult.
func (s *SubnetListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetPropertiesFormat.
func (s SubnetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", s.AddressPrefix)
	populate(objectMap, "addressPrefixes", s.AddressPrefixes)
	populate(objectMap, "applicationGatewayIPConfigurations", s.ApplicationGatewayIPConfigurations)
	populate(objectMap, "defaultOutboundAccess", s.DefaultOutboundAccess)
	populate(objectMap, "delegations", s.Delegations)
	populate(objectMap, "ipAllocations", s.IPAllocations)
	populate(objectMap, "ipConfigurationProfiles", s.IPConfigurationProfiles)
	populate(objectMap, "ipConfigurations", s.IPConfigurations)
	populate(objectMap, "natGateway", s.NatGateway)
	populate(objectMap, "networkSecurityGroup", s.NetworkSecurityGroup)
	populate(objectMap, "privateEndpointNetworkPolicies", s.PrivateEndpointNetworkPolicies)
	populate(objectMap, "privateEndpoints", s.PrivateEndpoints)
	populate(objectMap, "privateLinkServiceNetworkPolicies", s.PrivateLinkServiceNetworkPolicies)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "purpose", s.Purpose)
	populate(objectMap, "resourceNavigationLinks", s.ResourceNavigationLinks)
	populate(objectMap, "routeTable", s.RouteTable)
	populate(objectMap, "serviceAssociationLinks", s.ServiceAssociationLinks)
	populate(objectMap, "serviceEndpointPolicies", s.ServiceEndpointPolicies)
	populate(objectMap, "serviceEndpoints", s.ServiceEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetPropertiesFormat.
func (s *SubnetPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &s.AddressPrefix)
			delete(rawMsg, key)
		case "addressPrefixes":
			err = unpopulate(val, "AddressPrefixes", &s.AddressPrefixes)
			delete(rawMsg, key)
		case "applicationGatewayIPConfigurations":
			err = unpopulate(val, "ApplicationGatewayIPConfigurations", &s.ApplicationGatewayIPConfigurations)
			delete(rawMsg, key)
		case "defaultOutboundAccess":
			err = unpopulate(val, "DefaultOutboundAccess", &s.DefaultOutboundAccess)
			delete(rawMsg, key)
		case "delegations":
			err = unpopulate(val, "Delegations", &s.Delegations)
			delete(rawMsg, key)
		case "ipAllocations":
			err = unpopulate(val, "IPAllocations", &s.IPAllocations)
			delete(rawMsg, key)
		case "ipConfigurationProfiles":
			err = unpopulate(val, "IPConfigurationProfiles", &s.IPConfigurationProfiles)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &s.IPConfigurations)
			delete(rawMsg, key)
		case "natGateway":
			err = unpopulate(val, "NatGateway", &s.NatGateway)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &s.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "privateEndpointNetworkPolicies":
			err = unpopulate(val, "PrivateEndpointNetworkPolicies", &s.PrivateEndpointNetworkPolicies)
			delete(rawMsg, key)
		case "privateEndpoints":
			err = unpopulate(val, "PrivateEndpoints", &s.PrivateEndpoints)
			delete(rawMsg, key)
		case "privateLinkServiceNetworkPolicies":
			err = unpopulate(val, "PrivateLinkServiceNetworkPolicies", &s.PrivateLinkServiceNetworkPolicies)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "purpose":
			err = unpopulate(val, "Purpose", &s.Purpose)
			delete(rawMsg, key)
		case "resourceNavigationLinks":
			err = unpopulate(val, "ResourceNavigationLinks", &s.ResourceNavigationLinks)
			delete(rawMsg, key)
		case "routeTable":
			err = unpopulate(val, "RouteTable", &s.RouteTable)
			delete(rawMsg, key)
		case "serviceAssociationLinks":
			err = unpopulate(val, "ServiceAssociationLinks", &s.ServiceAssociationLinks)
			delete(rawMsg, key)
		case "serviceEndpointPolicies":
			err = unpopulate(val, "ServiceEndpointPolicies", &s.ServiceEndpointPolicies)
			delete(rawMsg, key)
		case "serviceEndpoints":
			err = unpopulate(val, "ServiceEndpoints", &s.ServiceEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwapResource.
func (s SwapResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwapResource.
func (s *SwapResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwapResourceListResult.
func (s SwapResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwapResourceListResult.
func (s *SwapResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwapResourceProperties.
func (s SwapResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "slotType", s.SlotType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwapResourceProperties.
func (s *SwapResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "slotType":
			err = unpopulate(val, "SlotType", &s.SlotType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Topology.
func (t Topology) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDateTime", t.CreatedDateTime)
	populate(objectMap, "id", t.ID)
	populateDateTimeRFC3339(objectMap, "lastModified", t.LastModified)
	populate(objectMap, "resources", t.Resources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Topology.
func (t *Topology) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDateTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateTime", &t.CreatedDateTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateDateTimeRFC3339(val, "LastModified", &t.LastModified)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &t.Resources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologyAssociation.
func (t TopologyAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associationType", t.AssociationType)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "resourceId", t.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologyAssociation.
func (t *TopologyAssociation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associationType":
			err = unpopulate(val, "AssociationType", &t.AssociationType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &t.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologyParameters.
func (t TopologyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetResourceGroupName", t.TargetResourceGroupName)
	populate(objectMap, "targetSubnet", t.TargetSubnet)
	populate(objectMap, "targetVirtualNetwork", t.TargetVirtualNetwork)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologyParameters.
func (t *TopologyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetResourceGroupName":
			err = unpopulate(val, "TargetResourceGroupName", &t.TargetResourceGroupName)
			delete(rawMsg, key)
		case "targetSubnet":
			err = unpopulate(val, "TargetSubnet", &t.TargetSubnet)
			delete(rawMsg, key)
		case "targetVirtualNetwork":
			err = unpopulate(val, "TargetVirtualNetwork", &t.TargetVirtualNetwork)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopologyResource.
func (t TopologyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "associations", t.Associations)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopologyResource.
func (t *TopologyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "associations":
			err = unpopulate(val, "Associations", &t.Associations)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrafficAnalyticsConfigurationProperties.
func (t TrafficAnalyticsConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", t.Enabled)
	populate(objectMap, "trafficAnalyticsInterval", t.TrafficAnalyticsInterval)
	populate(objectMap, "workspaceId", t.WorkspaceID)
	populate(objectMap, "workspaceRegion", t.WorkspaceRegion)
	populate(objectMap, "workspaceResourceId", t.WorkspaceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrafficAnalyticsConfigurationProperties.
func (t *TrafficAnalyticsConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &t.Enabled)
			delete(rawMsg, key)
		case "trafficAnalyticsInterval":
			err = unpopulate(val, "TrafficAnalyticsInterval", &t.TrafficAnalyticsInterval)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &t.WorkspaceID)
			delete(rawMsg, key)
		case "workspaceRegion":
			err = unpopulate(val, "WorkspaceRegion", &t.WorkspaceRegion)
			delete(rawMsg, key)
		case "workspaceResourceId":
			err = unpopulate(val, "WorkspaceResourceID", &t.WorkspaceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrafficAnalyticsProperties.
func (t TrafficAnalyticsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkWatcherFlowAnalyticsConfiguration", t.NetworkWatcherFlowAnalyticsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrafficAnalyticsProperties.
func (t *TrafficAnalyticsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkWatcherFlowAnalyticsConfiguration":
			err = unpopulate(val, "NetworkWatcherFlowAnalyticsConfiguration", &t.NetworkWatcherFlowAnalyticsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrafficSelectorPolicy.
func (t TrafficSelectorPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localAddressRanges", t.LocalAddressRanges)
	populate(objectMap, "remoteAddressRanges", t.RemoteAddressRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrafficSelectorPolicy.
func (t *TrafficSelectorPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localAddressRanges":
			err = unpopulate(val, "LocalAddressRanges", &t.LocalAddressRanges)
			delete(rawMsg, key)
		case "remoteAddressRanges":
			err = unpopulate(val, "RemoteAddressRanges", &t.RemoteAddressRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TroubleshootingDetails.
func (t TroubleshootingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detail", t.Detail)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "reasonType", t.ReasonType)
	populate(objectMap, "recommendedActions", t.RecommendedActions)
	populate(objectMap, "summary", t.Summary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TroubleshootingDetails.
func (t *TroubleshootingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detail":
			err = unpopulate(val, "Detail", &t.Detail)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "reasonType":
			err = unpopulate(val, "ReasonType", &t.ReasonType)
			delete(rawMsg, key)
		case "recommendedActions":
			err = unpopulate(val, "RecommendedActions", &t.RecommendedActions)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &t.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TroubleshootingParameters.
func (t TroubleshootingParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "targetResourceId", t.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TroubleshootingParameters.
func (t *TroubleshootingParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &t.TargetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TroubleshootingProperties.
func (t TroubleshootingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "storageId", t.StorageID)
	populate(objectMap, "storagePath", t.StoragePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TroubleshootingProperties.
func (t *TroubleshootingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageId":
			err = unpopulate(val, "StorageID", &t.StorageID)
			delete(rawMsg, key)
		case "storagePath":
			err = unpopulate(val, "StoragePath", &t.StoragePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TroubleshootingRecommendedActions.
func (t TroubleshootingRecommendedActions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionId", t.ActionID)
	populate(objectMap, "actionText", t.ActionText)
	populate(objectMap, "actionUri", t.ActionURI)
	populate(objectMap, "actionUriText", t.ActionURIText)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TroubleshootingRecommendedActions.
func (t *TroubleshootingRecommendedActions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionId":
			err = unpopulate(val, "ActionID", &t.ActionID)
			delete(rawMsg, key)
		case "actionText":
			err = unpopulate(val, "ActionText", &t.ActionText)
			delete(rawMsg, key)
		case "actionUri":
			err = unpopulate(val, "ActionURI", &t.ActionURI)
			delete(rawMsg, key)
		case "actionUriText":
			err = unpopulate(val, "ActionURIText", &t.ActionURIText)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TroubleshootingResult.
func (t TroubleshootingResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", t.Code)
	populateDateTimeRFC3339(objectMap, "endTime", t.EndTime)
	populate(objectMap, "results", t.Results)
	populateDateTimeRFC3339(objectMap, "startTime", t.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TroubleshootingResult.
func (t *TroubleshootingResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &t.Code)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &t.EndTime)
			delete(rawMsg, key)
		case "results":
			err = unpopulate(val, "Results", &t.Results)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &t.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TunnelConnectionHealth.
func (t TunnelConnectionHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionStatus", t.ConnectionStatus)
	populate(objectMap, "egressBytesTransferred", t.EgressBytesTransferred)
	populate(objectMap, "ingressBytesTransferred", t.IngressBytesTransferred)
	populate(objectMap, "lastConnectionEstablishedUtcTime", t.LastConnectionEstablishedUTCTime)
	populate(objectMap, "tunnel", t.Tunnel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TunnelConnectionHealth.
func (t *TunnelConnectionHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &t.ConnectionStatus)
			delete(rawMsg, key)
		case "egressBytesTransferred":
			err = unpopulate(val, "EgressBytesTransferred", &t.EgressBytesTransferred)
			delete(rawMsg, key)
		case "ingressBytesTransferred":
			err = unpopulate(val, "IngressBytesTransferred", &t.IngressBytesTransferred)
			delete(rawMsg, key)
		case "lastConnectionEstablishedUtcTime":
			err = unpopulate(val, "LastConnectionEstablishedUTCTime", &t.LastConnectionEstablishedUTCTime)
			delete(rawMsg, key)
		case "tunnel":
			err = unpopulate(val, "Tunnel", &t.Tunnel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnprepareNetworkPoliciesRequest.
func (u UnprepareNetworkPoliciesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceName", u.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnprepareNetworkPoliciesRequest.
func (u *UnprepareNetworkPoliciesRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceName":
			err = unpopulate(val, "ServiceName", &u.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageName.
func (u UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", u.LocalizedValue)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageName.
func (u *UsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &u.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsagesListResult.
func (u UsagesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsagesListResult.
func (u *UsagesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VM.
func (v VM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VM.
func (v *VM) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientConfiguration.
func (v VPNClientConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadAudience", v.AADAudience)
	populate(objectMap, "aadIssuer", v.AADIssuer)
	populate(objectMap, "aadTenant", v.AADTenant)
	populate(objectMap, "radiusServerAddress", v.RadiusServerAddress)
	populate(objectMap, "radiusServerSecret", v.RadiusServerSecret)
	populate(objectMap, "radiusServers", v.RadiusServers)
	populate(objectMap, "vpnAuthenticationTypes", v.VPNAuthenticationTypes)
	populate(objectMap, "vpnClientAddressPool", v.VPNClientAddressPool)
	populate(objectMap, "vpnClientIpsecPolicies", v.VPNClientIPSecPolicies)
	populate(objectMap, "vpnClientProtocols", v.VPNClientProtocols)
	populate(objectMap, "vpnClientRevokedCertificates", v.VPNClientRevokedCertificates)
	populate(objectMap, "vpnClientRootCertificates", v.VPNClientRootCertificates)
	populate(objectMap, "vngClientConnectionConfigurations", v.VngClientConnectionConfigurations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientConfiguration.
func (v *VPNClientConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadAudience":
			err = unpopulate(val, "AADAudience", &v.AADAudience)
			delete(rawMsg, key)
		case "aadIssuer":
			err = unpopulate(val, "AADIssuer", &v.AADIssuer)
			delete(rawMsg, key)
		case "aadTenant":
			err = unpopulate(val, "AADTenant", &v.AADTenant)
			delete(rawMsg, key)
		case "radiusServerAddress":
			err = unpopulate(val, "RadiusServerAddress", &v.RadiusServerAddress)
			delete(rawMsg, key)
		case "radiusServerSecret":
			err = unpopulate(val, "RadiusServerSecret", &v.RadiusServerSecret)
			delete(rawMsg, key)
		case "radiusServers":
			err = unpopulate(val, "RadiusServers", &v.RadiusServers)
			delete(rawMsg, key)
		case "vpnAuthenticationTypes":
			err = unpopulate(val, "VPNAuthenticationTypes", &v.VPNAuthenticationTypes)
			delete(rawMsg, key)
		case "vpnClientAddressPool":
			err = unpopulate(val, "VPNClientAddressPool", &v.VPNClientAddressPool)
			delete(rawMsg, key)
		case "vpnClientIpsecPolicies":
			err = unpopulate(val, "VPNClientIPSecPolicies", &v.VPNClientIPSecPolicies)
			delete(rawMsg, key)
		case "vpnClientProtocols":
			err = unpopulate(val, "VPNClientProtocols", &v.VPNClientProtocols)
			delete(rawMsg, key)
		case "vpnClientRevokedCertificates":
			err = unpopulate(val, "VPNClientRevokedCertificates", &v.VPNClientRevokedCertificates)
			delete(rawMsg, key)
		case "vpnClientRootCertificates":
			err = unpopulate(val, "VPNClientRootCertificates", &v.VPNClientRootCertificates)
			delete(rawMsg, key)
		case "vngClientConnectionConfigurations":
			err = unpopulate(val, "VngClientConnectionConfigurations", &v.VngClientConnectionConfigurations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientConnectionHealth.
func (v VPNClientConnectionHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocatedIpAddresses", v.AllocatedIPAddresses)
	populate(objectMap, "totalEgressBytesTransferred", v.TotalEgressBytesTransferred)
	populate(objectMap, "totalIngressBytesTransferred", v.TotalIngressBytesTransferred)
	populate(objectMap, "vpnClientConnectionsCount", v.VPNClientConnectionsCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientConnectionHealth.
func (v *VPNClientConnectionHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocatedIpAddresses":
			err = unpopulate(val, "AllocatedIPAddresses", &v.AllocatedIPAddresses)
			delete(rawMsg, key)
		case "totalEgressBytesTransferred":
			err = unpopulate(val, "TotalEgressBytesTransferred", &v.TotalEgressBytesTransferred)
			delete(rawMsg, key)
		case "totalIngressBytesTransferred":
			err = unpopulate(val, "TotalIngressBytesTransferred", &v.TotalIngressBytesTransferred)
			delete(rawMsg, key)
		case "vpnClientConnectionsCount":
			err = unpopulate(val, "VPNClientConnectionsCount", &v.VPNClientConnectionsCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientConnectionHealthDetail.
func (v VPNClientConnectionHealthDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "egressBytesTransferred", v.EgressBytesTransferred)
	populate(objectMap, "egressPacketsTransferred", v.EgressPacketsTransferred)
	populate(objectMap, "ingressBytesTransferred", v.IngressBytesTransferred)
	populate(objectMap, "ingressPacketsTransferred", v.IngressPacketsTransferred)
	populate(objectMap, "maxBandwidth", v.MaxBandwidth)
	populate(objectMap, "maxPacketsPerSecond", v.MaxPacketsPerSecond)
	populate(objectMap, "privateIpAddress", v.PrivateIPAddress)
	populate(objectMap, "publicIpAddress", v.PublicIPAddress)
	populate(objectMap, "vpnConnectionDuration", v.VPNConnectionDuration)
	populate(objectMap, "vpnConnectionId", v.VPNConnectionID)
	populate(objectMap, "vpnConnectionTime", v.VPNConnectionTime)
	populate(objectMap, "vpnUserName", v.VPNUserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientConnectionHealthDetail.
func (v *VPNClientConnectionHealthDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "egressBytesTransferred":
			err = unpopulate(val, "EgressBytesTransferred", &v.EgressBytesTransferred)
			delete(rawMsg, key)
		case "egressPacketsTransferred":
			err = unpopulate(val, "EgressPacketsTransferred", &v.EgressPacketsTransferred)
			delete(rawMsg, key)
		case "ingressBytesTransferred":
			err = unpopulate(val, "IngressBytesTransferred", &v.IngressBytesTransferred)
			delete(rawMsg, key)
		case "ingressPacketsTransferred":
			err = unpopulate(val, "IngressPacketsTransferred", &v.IngressPacketsTransferred)
			delete(rawMsg, key)
		case "maxBandwidth":
			err = unpopulate(val, "MaxBandwidth", &v.MaxBandwidth)
			delete(rawMsg, key)
		case "maxPacketsPerSecond":
			err = unpopulate(val, "MaxPacketsPerSecond", &v.MaxPacketsPerSecond)
			delete(rawMsg, key)
		case "privateIpAddress":
			err = unpopulate(val, "PrivateIPAddress", &v.PrivateIPAddress)
			delete(rawMsg, key)
		case "publicIpAddress":
			err = unpopulate(val, "PublicIPAddress", &v.PublicIPAddress)
			delete(rawMsg, key)
		case "vpnConnectionDuration":
			err = unpopulate(val, "VPNConnectionDuration", &v.VPNConnectionDuration)
			delete(rawMsg, key)
		case "vpnConnectionId":
			err = unpopulate(val, "VPNConnectionID", &v.VPNConnectionID)
			delete(rawMsg, key)
		case "vpnConnectionTime":
			err = unpopulate(val, "VPNConnectionTime", &v.VPNConnectionTime)
			delete(rawMsg, key)
		case "vpnUserName":
			err = unpopulate(val, "VPNUserName", &v.VPNUserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientConnectionHealthDetailListResult.
func (v VPNClientConnectionHealthDetailListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientConnectionHealthDetailListResult.
func (v *VPNClientConnectionHealthDetailListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientIPsecParameters.
func (v VPNClientIPsecParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dhGroup", v.DhGroup)
	populate(objectMap, "ipsecEncryption", v.IPSecEncryption)
	populate(objectMap, "ipsecIntegrity", v.IPSecIntegrity)
	populate(objectMap, "ikeEncryption", v.IkeEncryption)
	populate(objectMap, "ikeIntegrity", v.IkeIntegrity)
	populate(objectMap, "pfsGroup", v.PfsGroup)
	populate(objectMap, "saDataSizeKilobytes", v.SaDataSizeKilobytes)
	populate(objectMap, "saLifeTimeSeconds", v.SaLifeTimeSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientIPsecParameters.
func (v *VPNClientIPsecParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dhGroup":
			err = unpopulate(val, "DhGroup", &v.DhGroup)
			delete(rawMsg, key)
		case "ipsecEncryption":
			err = unpopulate(val, "IPSecEncryption", &v.IPSecEncryption)
			delete(rawMsg, key)
		case "ipsecIntegrity":
			err = unpopulate(val, "IPSecIntegrity", &v.IPSecIntegrity)
			delete(rawMsg, key)
		case "ikeEncryption":
			err = unpopulate(val, "IkeEncryption", &v.IkeEncryption)
			delete(rawMsg, key)
		case "ikeIntegrity":
			err = unpopulate(val, "IkeIntegrity", &v.IkeIntegrity)
			delete(rawMsg, key)
		case "pfsGroup":
			err = unpopulate(val, "PfsGroup", &v.PfsGroup)
			delete(rawMsg, key)
		case "saDataSizeKilobytes":
			err = unpopulate(val, "SaDataSizeKilobytes", &v.SaDataSizeKilobytes)
			delete(rawMsg, key)
		case "saLifeTimeSeconds":
			err = unpopulate(val, "SaLifeTimeSeconds", &v.SaLifeTimeSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientParameters.
func (v VPNClientParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMethod", v.AuthenticationMethod)
	populate(objectMap, "clientRootCertificates", v.ClientRootCertificates)
	populate(objectMap, "processorArchitecture", v.ProcessorArchitecture)
	populate(objectMap, "radiusServerAuthCertificate", v.RadiusServerAuthCertificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientParameters.
func (v *VPNClientParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMethod":
			err = unpopulate(val, "AuthenticationMethod", &v.AuthenticationMethod)
			delete(rawMsg, key)
		case "clientRootCertificates":
			err = unpopulate(val, "ClientRootCertificates", &v.ClientRootCertificates)
			delete(rawMsg, key)
		case "processorArchitecture":
			err = unpopulate(val, "ProcessorArchitecture", &v.ProcessorArchitecture)
			delete(rawMsg, key)
		case "radiusServerAuthCertificate":
			err = unpopulate(val, "RadiusServerAuthCertificate", &v.RadiusServerAuthCertificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientRevokedCertificate.
func (v VPNClientRevokedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientRevokedCertificate.
func (v *VPNClientRevokedCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientRevokedCertificatePropertiesFormat.
func (v VPNClientRevokedCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "thumbprint", v.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientRevokedCertificatePropertiesFormat.
func (v *VPNClientRevokedCertificatePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &v.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientRootCertificate.
func (v VPNClientRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientRootCertificate.
func (v *VPNClientRootCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientRootCertificatePropertiesFormat.
func (v VPNClientRootCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "publicCertData", v.PublicCertData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientRootCertificatePropertiesFormat.
func (v *VPNClientRootCertificatePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "publicCertData":
			err = unpopulate(val, "PublicCertData", &v.PublicCertData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNConnection.
func (v VPNConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNConnection.
func (v *VPNConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNConnectionPacketCaptureStartParameters.
func (v VPNConnectionPacketCaptureStartParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filterData", v.FilterData)
	populate(objectMap, "linkConnectionNames", v.LinkConnectionNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNConnectionPacketCaptureStartParameters.
func (v *VPNConnectionPacketCaptureStartParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filterData":
			err = unpopulate(val, "FilterData", &v.FilterData)
			delete(rawMsg, key)
		case "linkConnectionNames":
			err = unpopulate(val, "LinkConnectionNames", &v.LinkConnectionNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNConnectionPacketCaptureStopParameters.
func (v VPNConnectionPacketCaptureStopParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkConnectionNames", v.LinkConnectionNames)
	populate(objectMap, "sasUrl", v.SasURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNConnectionPacketCaptureStopParameters.
func (v *VPNConnectionPacketCaptureStopParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkConnectionNames":
			err = unpopulate(val, "LinkConnectionNames", &v.LinkConnectionNames)
			delete(rawMsg,