//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dataprotection/armdataprotection/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ExportJobsServer is a fake server for instances of the armdataprotection.ExportJobsClient type.
type ExportJobsServer struct {
	// BeginTrigger is the fake for method ExportJobsClient.BeginTrigger
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginTrigger func(ctx context.Context, resourceGroupName string, vaultName string, options *armdataprotection.ExportJobsClientBeginTriggerOptions) (resp azfake.PollerResponder[armdataprotection.ExportJobsClientTriggerResponse], errResp azfake.ErrorResponder)
}

// NewExportJobsServerTransport creates a new instance of ExportJobsServerTransport with the provided implementation.
// The returned ExportJobsServerTransport instance is connected to an instance of armdataprotection.ExportJobsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExportJobsServerTransport(srv *ExportJobsServer) *ExportJobsServerTransport {
	return &ExportJobsServerTransport{
		srv:          srv,
		beginTrigger: newTracker[azfake.PollerResponder[armdataprotection.ExportJobsClientTriggerResponse]](),
	}
}

// ExportJobsServerTransport connects instances of armdataprotection.ExportJobsClient to instances of ExportJobsServer.
// Don't use this type directly, use NewExportJobsServerTransport instead.
type ExportJobsServerTransport struct {
	srv          *ExportJobsServer
	beginTrigger *tracker[azfake.PollerResponder[armdataprotection.ExportJobsClientTriggerResponse]]
}

// Do implements the policy.Transporter interface for ExportJobsServerTransport.
func (e *ExportJobsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExportJobsClient.BeginTrigger":
		resp, err = e.dispatchBeginTrigger(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExportJobsServerTransport) dispatchBeginTrigger(req *http.Request) (*http.Response, error) {
	if e.srv.BeginTrigger == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTrigger not implemented")}
	}
	beginTrigger := e.beginTrigger.get(req)
	if beginTrigger == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportBackupJobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginTrigger(req.Context(), resourceGroupNameParam, vaultNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTrigger = &respr
		e.beginTrigger.add(req, beginTrigger)
	}

	resp, err := server.PollerResponderNext(beginTrigger, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		e.beginTrigger.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTrigger) {
		e.beginTrigger.remove(req)
	}

	return resp, nil
}
