// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all tenants associated with a specific resource.
//
// This operation returns a list of tenants that are associated with the specified
// resource. This is useful for understanding which tenants are currently using a
// particular resource such as an email identity, configuration set, or email
// template.
func (c *Client) ListResourceTenants(ctx context.Context, params *ListResourceTenantsInput, optFns ...func(*Options)) (*ListResourceTenantsOutput, error) {
	if params == nil {
		params = &ListResourceTenantsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceTenants", params, optFns, c.addOperationListResourceTenantsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceTenantsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to list tenants associated with a specific resource.
type ListResourceTenantsInput struct {

	// The Amazon Resource Name (ARN) of the resource to list associated tenants for.
	//
	// This member is required.
	ResourceArn *string

	// A token returned from a previous call to ListResourceTenants to indicate the
	// position in the list of resource tenants.
	NextToken *string

	// The number of results to show in a single call to ListResourceTenants . If the
	// number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	PageSize *int32

	noSmithyDocumentSerde
}

// Information about tenants associated with a specific resource.
type ListResourceTenantsOutput struct {

	// A token that indicates that there are additional tenants to list. To view
	// additional tenants, issue another request to ListResourceTenants , and pass this
	// token in the NextToken parameter.
	NextToken *string

	// An array that contains information about each tenant associated with the
	// resource.
	ResourceTenants []types.ResourceTenantMetadata

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceTenantsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListResourceTenants{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListResourceTenants{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceTenants"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListResourceTenantsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceTenants(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListResourceTenantsPaginatorOptions is the paginator options for
// ListResourceTenants
type ListResourceTenantsPaginatorOptions struct {
	// The number of results to show in a single call to ListResourceTenants . If the
	// number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceTenantsPaginator is a paginator for ListResourceTenants
type ListResourceTenantsPaginator struct {
	options   ListResourceTenantsPaginatorOptions
	client    ListResourceTenantsAPIClient
	params    *ListResourceTenantsInput
	nextToken *string
	firstPage bool
}

// NewListResourceTenantsPaginator returns a new ListResourceTenantsPaginator
func NewListResourceTenantsPaginator(client ListResourceTenantsAPIClient, params *ListResourceTenantsInput, optFns ...func(*ListResourceTenantsPaginatorOptions)) *ListResourceTenantsPaginator {
	if params == nil {
		params = &ListResourceTenantsInput{}
	}

	options := ListResourceTenantsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceTenantsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceTenantsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceTenants page.
func (p *ListResourceTenantsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceTenantsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourceTenants(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourceTenantsAPIClient is a client that implements the
// ListResourceTenants operation.
type ListResourceTenantsAPIClient interface {
	ListResourceTenants(context.Context, *ListResourceTenantsInput, ...func(*Options)) (*ListResourceTenantsOutput, error)
}

var _ ListResourceTenantsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourceTenants(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceTenants",
	}
}
