// Code generated by smithy-go-codegen DO NOT EDIT.

package mediatailor

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mediatailor/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpConfigureLogsForChannel struct {
}

func (*awsRestjson1_serializeOpConfigureLogsForChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpConfigureLogsForChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfigureLogsForChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configureLogs/channel")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentConfigureLogsForChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsConfigureLogsForChannelInput(v *ConfigureLogsForChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentConfigureLogsForChannelInput(v *ConfigureLogsForChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelName != nil {
		ok := object.Key("ChannelName")
		ok.String(*v.ChannelName)
	}

	if v.LogTypes != nil {
		ok := object.Key("LogTypes")
		if err := awsRestjson1_serializeDocumentLogTypes(v.LogTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpConfigureLogsForPlaybackConfiguration struct {
}

func (*awsRestjson1_serializeOpConfigureLogsForPlaybackConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpConfigureLogsForPlaybackConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfigureLogsForPlaybackConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configureLogs/playbackConfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentConfigureLogsForPlaybackConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsConfigureLogsForPlaybackConfigurationInput(v *ConfigureLogsForPlaybackConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentConfigureLogsForPlaybackConfigurationInput(v *ConfigureLogsForPlaybackConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdsInteractionLog != nil {
		ok := object.Key("AdsInteractionLog")
		if err := awsRestjson1_serializeDocumentAdsInteractionLog(v.AdsInteractionLog, ok); err != nil {
			return err
		}
	}

	if v.EnabledLoggingStrategies != nil {
		ok := object.Key("EnabledLoggingStrategies")
		if err := awsRestjson1_serializeDocument__listOfLoggingStrategies(v.EnabledLoggingStrategies, ok); err != nil {
			return err
		}
	}

	if v.ManifestServiceInteractionLog != nil {
		ok := object.Key("ManifestServiceInteractionLog")
		if err := awsRestjson1_serializeDocumentManifestServiceInteractionLog(v.ManifestServiceInteractionLog, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("PercentEnabled")
		ok.Integer(v.PercentEnabled)
	}

	if v.PlaybackConfigurationName != nil {
		ok := object.Key("PlaybackConfigurationName")
		ok.String(*v.PlaybackConfigurationName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateChannel struct {
}

func (*awsRestjson1_serializeOpCreateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelInput(v *CreateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelInput(v *CreateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Audiences != nil {
		ok := object.Key("Audiences")
		if err := awsRestjson1_serializeDocumentAudiences(v.Audiences, ok); err != nil {
			return err
		}
	}

	if v.FillerSlate != nil {
		ok := object.Key("FillerSlate")
		if err := awsRestjson1_serializeDocumentSlateSource(v.FillerSlate, ok); err != nil {
			return err
		}
	}

	if v.Outputs != nil {
		ok := object.Key("Outputs")
		if err := awsRestjson1_serializeDocumentRequestOutputs(v.Outputs, ok); err != nil {
			return err
		}
	}

	if len(v.PlaybackMode) > 0 {
		ok := object.Key("PlaybackMode")
		ok.String(string(v.PlaybackMode))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Tier) > 0 {
		ok := object.Key("Tier")
		ok.String(string(v.Tier))
	}

	if v.TimeShiftConfiguration != nil {
		ok := object.Key("TimeShiftConfiguration")
		if err := awsRestjson1_serializeDocumentTimeShiftConfiguration(v.TimeShiftConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateLiveSource struct {
}

func (*awsRestjson1_serializeOpCreateLiveSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateLiveSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLiveSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/liveSource/{LiveSourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateLiveSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateLiveSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateLiveSourceInput(v *CreateLiveSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LiveSourceName == nil || len(*v.LiveSourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LiveSourceName must not be empty")}
	}
	if v.LiveSourceName != nil {
		if err := encoder.SetURI("LiveSourceName").String(*v.LiveSourceName); err != nil {
			return err
		}
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateLiveSourceInput(v *CreateLiveSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpPackageConfigurations != nil {
		ok := object.Key("HttpPackageConfigurations")
		if err := awsRestjson1_serializeDocumentHttpPackageConfigurations(v.HttpPackageConfigurations, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePrefetchSchedule struct {
}

func (*awsRestjson1_serializeOpCreatePrefetchSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePrefetchSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePrefetchScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prefetchSchedule/{PlaybackConfigurationName}/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreatePrefetchScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePrefetchScheduleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePrefetchScheduleInput(v *CreatePrefetchScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	if v.PlaybackConfigurationName == nil || len(*v.PlaybackConfigurationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PlaybackConfigurationName must not be empty")}
	}
	if v.PlaybackConfigurationName != nil {
		if err := encoder.SetURI("PlaybackConfigurationName").String(*v.PlaybackConfigurationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePrefetchScheduleInput(v *CreatePrefetchScheduleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Consumption != nil {
		ok := object.Key("Consumption")
		if err := awsRestjson1_serializeDocumentPrefetchConsumption(v.Consumption, ok); err != nil {
			return err
		}
	}

	if v.RecurringPrefetchConfiguration != nil {
		ok := object.Key("RecurringPrefetchConfiguration")
		if err := awsRestjson1_serializeDocumentRecurringPrefetchConfiguration(v.RecurringPrefetchConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Retrieval != nil {
		ok := object.Key("Retrieval")
		if err := awsRestjson1_serializeDocumentPrefetchRetrieval(v.Retrieval, ok); err != nil {
			return err
		}
	}

	if len(v.ScheduleType) > 0 {
		ok := object.Key("ScheduleType")
		ok.String(string(v.ScheduleType))
	}

	if v.StreamId != nil {
		ok := object.Key("StreamId")
		ok.String(*v.StreamId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateProgram struct {
}

func (*awsRestjson1_serializeOpCreateProgram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateProgram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProgramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/program/{ProgramName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateProgramInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateProgramInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateProgramInput(v *CreateProgramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.ProgramName == nil || len(*v.ProgramName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ProgramName must not be empty")}
	}
	if v.ProgramName != nil {
		if err := encoder.SetURI("ProgramName").String(*v.ProgramName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateProgramInput(v *CreateProgramInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdBreaks != nil {
		ok := object.Key("AdBreaks")
		if err := awsRestjson1_serializeDocument__listOfAdBreak(v.AdBreaks, ok); err != nil {
			return err
		}
	}

	if v.AudienceMedia != nil {
		ok := object.Key("AudienceMedia")
		if err := awsRestjson1_serializeDocument__listOfAudienceMedia(v.AudienceMedia, ok); err != nil {
			return err
		}
	}

	if v.LiveSourceName != nil {
		ok := object.Key("LiveSourceName")
		ok.String(*v.LiveSourceName)
	}

	if v.ScheduleConfiguration != nil {
		ok := object.Key("ScheduleConfiguration")
		if err := awsRestjson1_serializeDocumentScheduleConfiguration(v.ScheduleConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SourceLocationName != nil {
		ok := object.Key("SourceLocationName")
		ok.String(*v.SourceLocationName)
	}

	if v.VodSourceName != nil {
		ok := object.Key("VodSourceName")
		ok.String(*v.VodSourceName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateSourceLocation struct {
}

func (*awsRestjson1_serializeOpCreateSourceLocation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSourceLocation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSourceLocationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSourceLocationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSourceLocationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSourceLocationInput(v *CreateSourceLocationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSourceLocationInput(v *CreateSourceLocationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessConfiguration != nil {
		ok := object.Key("AccessConfiguration")
		if err := awsRestjson1_serializeDocumentAccessConfiguration(v.AccessConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DefaultSegmentDeliveryConfiguration != nil {
		ok := object.Key("DefaultSegmentDeliveryConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultSegmentDeliveryConfiguration(v.DefaultSegmentDeliveryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HttpConfiguration != nil {
		ok := object.Key("HttpConfiguration")
		if err := awsRestjson1_serializeDocumentHttpConfiguration(v.HttpConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SegmentDeliveryConfigurations != nil {
		ok := object.Key("SegmentDeliveryConfigurations")
		if err := awsRestjson1_serializeDocument__listOfSegmentDeliveryConfiguration(v.SegmentDeliveryConfigurations, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateVodSource struct {
}

func (*awsRestjson1_serializeOpCreateVodSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateVodSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVodSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/vodSource/{VodSourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateVodSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateVodSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateVodSourceInput(v *CreateVodSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	if v.VodSourceName == nil || len(*v.VodSourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VodSourceName must not be empty")}
	}
	if v.VodSourceName != nil {
		if err := encoder.SetURI("VodSourceName").String(*v.VodSourceName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateVodSourceInput(v *CreateVodSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpPackageConfigurations != nil {
		ok := object.Key("HttpPackageConfigurations")
		if err := awsRestjson1_serializeDocumentHttpPackageConfigurations(v.HttpPackageConfigurations, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannel struct {
}

func (*awsRestjson1_serializeOpDeleteChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(v *DeleteChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannelPolicy struct {
}

func (*awsRestjson1_serializeOpDeleteChannelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelPolicyInput(v *DeleteChannelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteLiveSource struct {
}

func (*awsRestjson1_serializeOpDeleteLiveSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteLiveSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLiveSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/liveSource/{LiveSourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteLiveSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteLiveSourceInput(v *DeleteLiveSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LiveSourceName == nil || len(*v.LiveSourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LiveSourceName must not be empty")}
	}
	if v.LiveSourceName != nil {
		if err := encoder.SetURI("LiveSourceName").String(*v.LiveSourceName); err != nil {
			return err
		}
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePlaybackConfiguration struct {
}

func (*awsRestjson1_serializeOpDeletePlaybackConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePlaybackConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePlaybackConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/playbackConfiguration/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePlaybackConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePlaybackConfigurationInput(v *DeletePlaybackConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePrefetchSchedule struct {
}

func (*awsRestjson1_serializeOpDeletePrefetchSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePrefetchSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePrefetchScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prefetchSchedule/{PlaybackConfigurationName}/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePrefetchScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePrefetchScheduleInput(v *DeletePrefetchScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	if v.PlaybackConfigurationName == nil || len(*v.PlaybackConfigurationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PlaybackConfigurationName must not be empty")}
	}
	if v.PlaybackConfigurationName != nil {
		if err := encoder.SetURI("PlaybackConfigurationName").String(*v.PlaybackConfigurationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProgram struct {
}

func (*awsRestjson1_serializeOpDeleteProgram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProgram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProgramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/program/{ProgramName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProgramInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProgramInput(v *DeleteProgramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.ProgramName == nil || len(*v.ProgramName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ProgramName must not be empty")}
	}
	if v.ProgramName != nil {
		if err := encoder.SetURI("ProgramName").String(*v.ProgramName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSourceLocation struct {
}

func (*awsRestjson1_serializeOpDeleteSourceLocation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSourceLocation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSourceLocationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSourceLocationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSourceLocationInput(v *DeleteSourceLocationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVodSource struct {
}

func (*awsRestjson1_serializeOpDeleteVodSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVodSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVodSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/vodSource/{VodSourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVodSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVodSourceInput(v *DeleteVodSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	if v.VodSourceName == nil || len(*v.VodSourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VodSourceName must not be empty")}
	}
	if v.VodSourceName != nil {
		if err := encoder.SetURI("VodSourceName").String(*v.VodSourceName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannel struct {
}

func (*awsRestjson1_serializeOpDescribeChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelInput(v *DescribeChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeLiveSource struct {
}

func (*awsRestjson1_serializeOpDescribeLiveSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeLiveSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLiveSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/liveSource/{LiveSourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeLiveSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeLiveSourceInput(v *DescribeLiveSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LiveSourceName == nil || len(*v.LiveSourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LiveSourceName must not be empty")}
	}
	if v.LiveSourceName != nil {
		if err := encoder.SetURI("LiveSourceName").String(*v.LiveSourceName); err != nil {
			return err
		}
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeProgram struct {
}

func (*awsRestjson1_serializeOpDescribeProgram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeProgram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeProgramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/program/{ProgramName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeProgramInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeProgramInput(v *DescribeProgramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.ProgramName == nil || len(*v.ProgramName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ProgramName must not be empty")}
	}
	if v.ProgramName != nil {
		if err := encoder.SetURI("ProgramName").String(*v.ProgramName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeSourceLocation struct {
}

func (*awsRestjson1_serializeOpDescribeSourceLocation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeSourceLocation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSourceLocationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeSourceLocationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeSourceLocationInput(v *DescribeSourceLocationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeVodSource struct {
}

func (*awsRestjson1_serializeOpDescribeVodSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeVodSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVodSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/vodSource/{VodSourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeVodSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeVodSourceInput(v *DescribeVodSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	if v.VodSourceName == nil || len(*v.VodSourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VodSourceName must not be empty")}
	}
	if v.VodSourceName != nil {
		if err := encoder.SetURI("VodSourceName").String(*v.VodSourceName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetChannelPolicy struct {
}

func (*awsRestjson1_serializeOpGetChannelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChannelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChannelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChannelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChannelPolicyInput(v *GetChannelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetChannelSchedule struct {
}

func (*awsRestjson1_serializeOpGetChannelSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChannelSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChannelScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/schedule")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChannelScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChannelScheduleInput(v *GetChannelScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Audience != nil {
		encoder.SetQuery("audience").String(*v.Audience)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.DurationMinutes != nil {
		encoder.SetQuery("durationMinutes").String(*v.DurationMinutes)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetPlaybackConfiguration struct {
}

func (*awsRestjson1_serializeOpGetPlaybackConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPlaybackConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPlaybackConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/playbackConfiguration/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPlaybackConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPlaybackConfigurationInput(v *GetPlaybackConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPrefetchSchedule struct {
}

func (*awsRestjson1_serializeOpGetPrefetchSchedule) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPrefetchSchedule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPrefetchScheduleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prefetchSchedule/{PlaybackConfigurationName}/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPrefetchScheduleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPrefetchScheduleInput(v *GetPrefetchScheduleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	if v.PlaybackConfigurationName == nil || len(*v.PlaybackConfigurationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PlaybackConfigurationName must not be empty")}
	}
	if v.PlaybackConfigurationName != nil {
		if err := encoder.SetURI("PlaybackConfigurationName").String(*v.PlaybackConfigurationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAlerts struct {
}

func (*awsRestjson1_serializeOpListAlerts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAlerts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAlertsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/alerts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAlertsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAlertsInput(v *ListAlertsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpListChannels struct {
}

func (*awsRestjson1_serializeOpListChannels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelsInput(v *ListChannelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListLiveSources struct {
}

func (*awsRestjson1_serializeOpListLiveSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLiveSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLiveSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/liveSources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLiveSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLiveSourcesInput(v *ListLiveSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPlaybackConfigurations struct {
}

func (*awsRestjson1_serializeOpListPlaybackConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPlaybackConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPlaybackConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/playbackConfigurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPlaybackConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPlaybackConfigurationsInput(v *ListPlaybackConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListPrefetchSchedules struct {
}

func (*awsRestjson1_serializeOpListPrefetchSchedules) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPrefetchSchedules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPrefetchSchedulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/prefetchSchedule/{PlaybackConfigurationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPrefetchSchedulesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListPrefetchSchedulesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPrefetchSchedulesInput(v *ListPrefetchSchedulesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PlaybackConfigurationName == nil || len(*v.PlaybackConfigurationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PlaybackConfigurationName must not be empty")}
	}
	if v.PlaybackConfigurationName != nil {
		if err := encoder.SetURI("PlaybackConfigurationName").String(*v.PlaybackConfigurationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListPrefetchSchedulesInput(v *ListPrefetchSchedulesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.ScheduleType) > 0 {
		ok := object.Key("ScheduleType")
		ok.String(string(v.ScheduleType))
	}

	if v.StreamId != nil {
		ok := object.Key("StreamId")
		ok.String(*v.StreamId)
	}

	return nil
}

type awsRestjson1_serializeOpListSourceLocations struct {
}

func (*awsRestjson1_serializeOpListSourceLocations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSourceLocations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSourceLocationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSourceLocationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSourceLocationsInput(v *ListSourceLocationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListVodSources struct {
}

func (*awsRestjson1_serializeOpListVodSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVodSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVodSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/vodSources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListVodSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVodSourcesInput(v *ListVodSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutChannelPolicy struct {
}

func (*awsRestjson1_serializeOpPutChannelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutChannelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutChannelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutChannelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutChannelPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutChannelPolicyInput(v *PutChannelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutChannelPolicyInput(v *PutChannelPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	return nil
}

type awsRestjson1_serializeOpPutPlaybackConfiguration struct {
}

func (*awsRestjson1_serializeOpPutPlaybackConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutPlaybackConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutPlaybackConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/playbackConfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutPlaybackConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutPlaybackConfigurationInput(v *PutPlaybackConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutPlaybackConfigurationInput(v *PutPlaybackConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdConditioningConfiguration != nil {
		ok := object.Key("AdConditioningConfiguration")
		if err := awsRestjson1_serializeDocumentAdConditioningConfiguration(v.AdConditioningConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AdDecisionServerUrl != nil {
		ok := object.Key("AdDecisionServerUrl")
		ok.String(*v.AdDecisionServerUrl)
	}

	if v.AvailSuppression != nil {
		ok := object.Key("AvailSuppression")
		if err := awsRestjson1_serializeDocumentAvailSuppression(v.AvailSuppression, ok); err != nil {
			return err
		}
	}

	if v.Bumper != nil {
		ok := object.Key("Bumper")
		if err := awsRestjson1_serializeDocumentBumper(v.Bumper, ok); err != nil {
			return err
		}
	}

	if v.CdnConfiguration != nil {
		ok := object.Key("CdnConfiguration")
		if err := awsRestjson1_serializeDocumentCdnConfiguration(v.CdnConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ConfigurationAliases != nil {
		ok := object.Key("ConfigurationAliases")
		if err := awsRestjson1_serializeDocumentConfigurationAliasesRequest(v.ConfigurationAliases, ok); err != nil {
			return err
		}
	}

	if v.DashConfiguration != nil {
		ok := object.Key("DashConfiguration")
		if err := awsRestjson1_serializeDocumentDashConfigurationForPut(v.DashConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.InsertionMode) > 0 {
		ok := object.Key("InsertionMode")
		ok.String(string(v.InsertionMode))
	}

	if v.LivePreRollConfiguration != nil {
		ok := object.Key("LivePreRollConfiguration")
		if err := awsRestjson1_serializeDocumentLivePreRollConfiguration(v.LivePreRollConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ManifestProcessingRules != nil {
		ok := object.Key("ManifestProcessingRules")
		if err := awsRestjson1_serializeDocumentManifestProcessingRules(v.ManifestProcessingRules, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PersonalizationThresholdSeconds != nil {
		ok := object.Key("PersonalizationThresholdSeconds")
		ok.Integer(*v.PersonalizationThresholdSeconds)
	}

	if v.SlateAdUrl != nil {
		ok := object.Key("SlateAdUrl")
		ok.String(*v.SlateAdUrl)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TranscodeProfileName != nil {
		ok := object.Key("TranscodeProfileName")
		ok.String(*v.TranscodeProfileName)
	}

	if v.VideoContentSourceUrl != nil {
		ok := object.Key("VideoContentSourceUrl")
		ok.String(*v.VideoContentSourceUrl)
	}

	return nil
}

type awsRestjson1_serializeOpStartChannel struct {
}

func (*awsRestjson1_serializeOpStartChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/start")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartChannelInput(v *StartChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopChannel struct {
}

func (*awsRestjson1_serializeOpStopChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopChannelInput(v *StopChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannel struct {
}

func (*awsRestjson1_serializeOpUpdateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(v *UpdateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChannelInput(v *UpdateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Audiences != nil {
		ok := object.Key("Audiences")
		if err := awsRestjson1_serializeDocumentAudiences(v.Audiences, ok); err != nil {
			return err
		}
	}

	if v.FillerSlate != nil {
		ok := object.Key("FillerSlate")
		if err := awsRestjson1_serializeDocumentSlateSource(v.FillerSlate, ok); err != nil {
			return err
		}
	}

	if v.Outputs != nil {
		ok := object.Key("Outputs")
		if err := awsRestjson1_serializeDocumentRequestOutputs(v.Outputs, ok); err != nil {
			return err
		}
	}

	if v.TimeShiftConfiguration != nil {
		ok := object.Key("TimeShiftConfiguration")
		if err := awsRestjson1_serializeDocumentTimeShiftConfiguration(v.TimeShiftConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateLiveSource struct {
}

func (*awsRestjson1_serializeOpUpdateLiveSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateLiveSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLiveSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/liveSource/{LiveSourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateLiveSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateLiveSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateLiveSourceInput(v *UpdateLiveSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LiveSourceName == nil || len(*v.LiveSourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member LiveSourceName must not be empty")}
	}
	if v.LiveSourceName != nil {
		if err := encoder.SetURI("LiveSourceName").String(*v.LiveSourceName); err != nil {
			return err
		}
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateLiveSourceInput(v *UpdateLiveSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpPackageConfigurations != nil {
		ok := object.Key("HttpPackageConfigurations")
		if err := awsRestjson1_serializeDocumentHttpPackageConfigurations(v.HttpPackageConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateProgram struct {
}

func (*awsRestjson1_serializeOpUpdateProgram) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateProgram) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateProgramInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channel/{ChannelName}/program/{ProgramName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateProgramInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateProgramInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateProgramInput(v *UpdateProgramInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ChannelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("ChannelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.ProgramName == nil || len(*v.ProgramName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ProgramName must not be empty")}
	}
	if v.ProgramName != nil {
		if err := encoder.SetURI("ProgramName").String(*v.ProgramName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateProgramInput(v *UpdateProgramInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdBreaks != nil {
		ok := object.Key("AdBreaks")
		if err := awsRestjson1_serializeDocument__listOfAdBreak(v.AdBreaks, ok); err != nil {
			return err
		}
	}

	if v.AudienceMedia != nil {
		ok := object.Key("AudienceMedia")
		if err := awsRestjson1_serializeDocument__listOfAudienceMedia(v.AudienceMedia, ok); err != nil {
			return err
		}
	}

	if v.ScheduleConfiguration != nil {
		ok := object.Key("ScheduleConfiguration")
		if err := awsRestjson1_serializeDocumentUpdateProgramScheduleConfiguration(v.ScheduleConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSourceLocation struct {
}

func (*awsRestjson1_serializeOpUpdateSourceLocation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSourceLocation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSourceLocationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSourceLocationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSourceLocationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSourceLocationInput(v *UpdateSourceLocationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSourceLocationInput(v *UpdateSourceLocationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessConfiguration != nil {
		ok := object.Key("AccessConfiguration")
		if err := awsRestjson1_serializeDocumentAccessConfiguration(v.AccessConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DefaultSegmentDeliveryConfiguration != nil {
		ok := object.Key("DefaultSegmentDeliveryConfiguration")
		if err := awsRestjson1_serializeDocumentDefaultSegmentDeliveryConfiguration(v.DefaultSegmentDeliveryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.HttpConfiguration != nil {
		ok := object.Key("HttpConfiguration")
		if err := awsRestjson1_serializeDocumentHttpConfiguration(v.HttpConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SegmentDeliveryConfigurations != nil {
		ok := object.Key("SegmentDeliveryConfigurations")
		if err := awsRestjson1_serializeDocument__listOfSegmentDeliveryConfiguration(v.SegmentDeliveryConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateVodSource struct {
}

func (*awsRestjson1_serializeOpUpdateVodSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateVodSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVodSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/sourceLocation/{SourceLocationName}/vodSource/{VodSourceName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateVodSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateVodSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateVodSourceInput(v *UpdateVodSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceLocationName == nil || len(*v.SourceLocationName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SourceLocationName must not be empty")}
	}
	if v.SourceLocationName != nil {
		if err := encoder.SetURI("SourceLocationName").String(*v.SourceLocationName); err != nil {
			return err
		}
	}

	if v.VodSourceName == nil || len(*v.VodSourceName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VodSourceName must not be empty")}
	}
	if v.VodSourceName != nil {
		if err := encoder.SetURI("VodSourceName").String(*v.VodSourceName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateVodSourceInput(v *UpdateVodSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpPackageConfigurations != nil {
		ok := object.Key("HttpPackageConfigurations")
		if err := awsRestjson1_serializeDocumentHttpPackageConfigurations(v.HttpPackageConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocument__adsInteractionExcludeEventTypesList(v []types.AdsInteractionExcludeEventType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__adsInteractionPublishOptInEventTypesList(v []types.AdsInteractionPublishOptInEventType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAdBreak(v []types.AdBreak, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAdBreak(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAlternateMedia(v []types.AlternateMedia, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAlternateMedia(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAudienceMedia(v []types.AudienceMedia, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAudienceMedia(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAvailMatchingCriteria(v []types.AvailMatchingCriteria, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAvailMatchingCriteria(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfLoggingStrategies(v []types.LoggingStrategy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfSegmentDeliveryConfiguration(v []types.SegmentDeliveryConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSegmentDeliveryConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__manifestServiceExcludeEventTypesList(v []types.ManifestServiceExcludeEventType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOf__string(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAccessConfiguration(v *types.AccessConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AccessType) > 0 {
		ok := object.Key("AccessType")
		ok.String(string(v.AccessType))
	}

	if v.SecretsManagerAccessTokenConfiguration != nil {
		ok := object.Key("SecretsManagerAccessTokenConfiguration")
		if err := awsRestjson1_serializeDocumentSecretsManagerAccessTokenConfiguration(v.SecretsManagerAccessTokenConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAdBreak(v *types.AdBreak, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdBreakMetadata != nil {
		ok := object.Key("AdBreakMetadata")
		if err := awsRestjson1_serializeDocumentAdBreakMetadataList(v.AdBreakMetadata, ok); err != nil {
			return err
		}
	}

	if len(v.MessageType) > 0 {
		ok := object.Key("MessageType")
		ok.String(string(v.MessageType))
	}

	{
		ok := object.Key("OffsetMillis")
		ok.Long(v.OffsetMillis)
	}

	if v.Slate != nil {
		ok := object.Key("Slate")
		if err := awsRestjson1_serializeDocumentSlateSource(v.Slate, ok); err != nil {
			return err
		}
	}

	if v.SpliceInsertMessage != nil {
		ok := object.Key("SpliceInsertMessage")
		if err := awsRestjson1_serializeDocumentSpliceInsertMessage(v.SpliceInsertMessage, ok); err != nil {
			return err
		}
	}

	if v.TimeSignalMessage != nil {
		ok := object.Key("TimeSignalMessage")
		if err := awsRestjson1_serializeDocumentTimeSignalMessage(v.TimeSignalMessage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAdBreakMetadataList(v []types.KeyValuePair, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentKeyValuePair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAdConditioningConfiguration(v *types.AdConditioningConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.StreamingMediaFileConditioning) > 0 {
		ok := object.Key("StreamingMediaFileConditioning")
		ok.String(string(v.StreamingMediaFileConditioning))
	}

	return nil
}

func awsRestjson1_serializeDocumentAdMarkerPassthrough(v *types.AdMarkerPassthrough, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("Enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAdMarkupTypes(v []types.AdMarkupType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentAdsInteractionLog(v *types.AdsInteractionLog, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExcludeEventTypes != nil {
		ok := object.Key("ExcludeEventTypes")
		if err := awsRestjson1_serializeDocument__adsInteractionExcludeEventTypesList(v.ExcludeEventTypes, ok); err != nil {
			return err
		}
	}

	if v.PublishOptInEventTypes != nil {
		ok := object.Key("PublishOptInEventTypes")
		if err := awsRestjson1_serializeDocument__adsInteractionPublishOptInEventTypesList(v.PublishOptInEventTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAlternateMedia(v *types.AlternateMedia, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdBreaks != nil {
		ok := object.Key("AdBreaks")
		if err := awsRestjson1_serializeDocument__listOfAdBreak(v.AdBreaks, ok); err != nil {
			return err
		}
	}

	if v.ClipRange != nil {
		ok := object.Key("ClipRange")
		if err := awsRestjson1_serializeDocumentClipRange(v.ClipRange, ok); err != nil {
			return err
		}
	}

	if v.DurationMillis != nil {
		ok := object.Key("DurationMillis")
		ok.Long(*v.DurationMillis)
	}

	if v.LiveSourceName != nil {
		ok := object.Key("LiveSourceName")
		ok.String(*v.LiveSourceName)
	}

	if v.ScheduledStartTimeMillis != nil {
		ok := object.Key("ScheduledStartTimeMillis")
		ok.Long(*v.ScheduledStartTimeMillis)
	}

	if v.SourceLocationName != nil {
		ok := object.Key("SourceLocationName")
		ok.String(*v.SourceLocationName)
	}

	if v.VodSourceName != nil {
		ok := object.Key("VodSourceName")
		ok.String(*v.VodSourceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudienceMedia(v *types.AudienceMedia, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlternateMedia != nil {
		ok := object.Key("AlternateMedia")
		if err := awsRestjson1_serializeDocument__listOfAlternateMedia(v.AlternateMedia, ok); err != nil {
			return err
		}
	}

	if v.Audience != nil {
		ok := object.Key("Audience")
		ok.String(*v.Audience)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudiences(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAvailMatchingCriteria(v *types.AvailMatchingCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DynamicVariable != nil {
		ok := object.Key("DynamicVariable")
		ok.String(*v.DynamicVariable)
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	return nil
}

func awsRestjson1_serializeDocumentAvailSuppression(v *types.AvailSuppression, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FillPolicy) > 0 {
		ok := object.Key("FillPolicy")
		ok.String(string(v.FillPolicy))
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentBumper(v *types.Bumper, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndUrl != nil {
		ok := object.Key("EndUrl")
		ok.String(*v.EndUrl)
	}

	if v.StartUrl != nil {
		ok := object.Key("StartUrl")
		ok.String(*v.StartUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentCdnConfiguration(v *types.CdnConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdSegmentUrlPrefix != nil {
		ok := object.Key("AdSegmentUrlPrefix")
		ok.String(*v.AdSegmentUrlPrefix)
	}

	if v.ContentSegmentUrlPrefix != nil {
		ok := object.Key("ContentSegmentUrlPrefix")
		ok.String(*v.ContentSegmentUrlPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentClipRange(v *types.ClipRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndOffsetMillis != nil {
		ok := object.Key("EndOffsetMillis")
		ok.Long(*v.EndOffsetMillis)
	}

	if v.StartOffsetMillis != nil {
		ok := object.Key("StartOffsetMillis")
		ok.Long(*v.StartOffsetMillis)
	}

	return nil
}

func awsRestjson1_serializeDocumentConfigurationAliasesRequest(v map[string]map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocument__mapOf__string(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDashConfigurationForPut(v *types.DashConfigurationForPut, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MpdLocation != nil {
		ok := object.Key("MpdLocation")
		ok.String(*v.MpdLocation)
	}

	if len(v.OriginManifestType) > 0 {
		ok := object.Key("OriginManifestType")
		ok.String(string(v.OriginManifestType))
	}

	return nil
}

func awsRestjson1_serializeDocumentDashPlaylistSettings(v *types.DashPlaylistSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestWindowSeconds != nil {
		ok := object.Key("ManifestWindowSeconds")
		ok.Integer(*v.ManifestWindowSeconds)
	}

	if v.MinBufferTimeSeconds != nil {
		ok := object.Key("MinBufferTimeSeconds")
		ok.Integer(*v.MinBufferTimeSeconds)
	}

	if v.MinUpdatePeriodSeconds != nil {
		ok := object.Key("MinUpdatePeriodSeconds")
		ok.Integer(*v.MinUpdatePeriodSeconds)
	}

	if v.SuggestedPresentationDelaySeconds != nil {
		ok := object.Key("SuggestedPresentationDelaySeconds")
		ok.Integer(*v.SuggestedPresentationDelaySeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultSegmentDeliveryConfiguration(v *types.DefaultSegmentDeliveryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseUrl != nil {
		ok := object.Key("BaseUrl")
		ok.String(*v.BaseUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsPlaylistSettings(v *types.HlsPlaylistSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdMarkupType != nil {
		ok := object.Key("AdMarkupType")
		if err := awsRestjson1_serializeDocumentAdMarkupTypes(v.AdMarkupType, ok); err != nil {
			return err
		}
	}

	if v.ManifestWindowSeconds != nil {
		ok := object.Key("ManifestWindowSeconds")
		ok.Integer(*v.ManifestWindowSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpConfiguration(v *types.HttpConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseUrl != nil {
		ok := object.Key("BaseUrl")
		ok.String(*v.BaseUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpPackageConfiguration(v *types.HttpPackageConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if v.SourceGroup != nil {
		ok := object.Key("SourceGroup")
		ok.String(*v.SourceGroup)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentHttpPackageConfigurations(v []types.HttpPackageConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHttpPackageConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentKeyValuePair(v *types.KeyValuePair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentLivePreRollConfiguration(v *types.LivePreRollConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdDecisionServerUrl != nil {
		ok := object.Key("AdDecisionServerUrl")
		ok.String(*v.AdDecisionServerUrl)
	}

	if v.MaxDurationSeconds != nil {
		ok := object.Key("MaxDurationSeconds")
		ok.Integer(*v.MaxDurationSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentLogTypes(v []types.LogType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentManifestProcessingRules(v *types.ManifestProcessingRules, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdMarkerPassthrough != nil {
		ok := object.Key("AdMarkerPassthrough")
		if err := awsRestjson1_serializeDocumentAdMarkerPassthrough(v.AdMarkerPassthrough, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentManifestServiceInteractionLog(v *types.ManifestServiceInteractionLog, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExcludeEventTypes != nil {
		ok := object.Key("ExcludeEventTypes")
		if err := awsRestjson1_serializeDocument__manifestServiceExcludeEventTypesList(v.ExcludeEventTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPrefetchConsumption(v *types.PrefetchConsumption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailMatchingCriteria != nil {
		ok := object.Key("AvailMatchingCriteria")
		if err := awsRestjson1_serializeDocument__listOfAvailMatchingCriteria(v.AvailMatchingCriteria, ok); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentPrefetchRetrieval(v *types.PrefetchRetrieval, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DynamicVariables != nil {
		ok := object.Key("DynamicVariables")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.DynamicVariables, ok); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	if v.TrafficShapingRetrievalWindow != nil {
		ok := object.Key("TrafficShapingRetrievalWindow")
		if err := awsRestjson1_serializeDocumentTrafficShapingRetrievalWindow(v.TrafficShapingRetrievalWindow, ok); err != nil {
			return err
		}
	}

	if len(v.TrafficShapingType) > 0 {
		ok := object.Key("TrafficShapingType")
		ok.String(string(v.TrafficShapingType))
	}

	return nil
}

func awsRestjson1_serializeDocumentRecurringConsumption(v *types.RecurringConsumption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailMatchingCriteria != nil {
		ok := object.Key("AvailMatchingCriteria")
		if err := awsRestjson1_serializeDocument__listOfAvailMatchingCriteria(v.AvailMatchingCriteria, ok); err != nil {
			return err
		}
	}

	if v.RetrievedAdExpirationSeconds != nil {
		ok := object.Key("RetrievedAdExpirationSeconds")
		ok.Integer(*v.RetrievedAdExpirationSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentRecurringPrefetchConfiguration(v *types.RecurringPrefetchConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.RecurringConsumption != nil {
		ok := object.Key("RecurringConsumption")
		if err := awsRestjson1_serializeDocumentRecurringConsumption(v.RecurringConsumption, ok); err != nil {
			return err
		}
	}

	if v.RecurringRetrieval != nil {
		ok := object.Key("RecurringRetrieval")
		if err := awsRestjson1_serializeDocumentRecurringRetrieval(v.RecurringRetrieval, ok); err != nil {
			return err
		}
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentRecurringRetrieval(v *types.RecurringRetrieval, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DelayAfterAvailEndSeconds != nil {
		ok := object.Key("DelayAfterAvailEndSeconds")
		ok.Integer(*v.DelayAfterAvailEndSeconds)
	}

	if v.DynamicVariables != nil {
		ok := object.Key("DynamicVariables")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.DynamicVariables, ok); err != nil {
			return err
		}
	}

	if v.TrafficShapingRetrievalWindow != nil {
		ok := object.Key("TrafficShapingRetrievalWindow")
		if err := awsRestjson1_serializeDocumentTrafficShapingRetrievalWindow(v.TrafficShapingRetrievalWindow, ok); err != nil {
			return err
		}
	}

	if len(v.TrafficShapingType) > 0 {
		ok := object.Key("TrafficShapingType")
		ok.String(string(v.TrafficShapingType))
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestOutputItem(v *types.RequestOutputItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashPlaylistSettings != nil {
		ok := object.Key("DashPlaylistSettings")
		if err := awsRestjson1_serializeDocumentDashPlaylistSettings(v.DashPlaylistSettings, ok); err != nil {
			return err
		}
	}

	if v.HlsPlaylistSettings != nil {
		ok := object.Key("HlsPlaylistSettings")
		if err := awsRestjson1_serializeDocumentHlsPlaylistSettings(v.HlsPlaylistSettings, ok); err != nil {
			return err
		}
	}

	if v.ManifestName != nil {
		ok := object.Key("ManifestName")
		ok.String(*v.ManifestName)
	}

	if v.SourceGroup != nil {
		ok := object.Key("SourceGroup")
		ok.String(*v.SourceGroup)
	}

	return nil
}

func awsRestjson1_serializeDocumentRequestOutputs(v []types.RequestOutputItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRequestOutputItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentScheduleConfiguration(v *types.ScheduleConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClipRange != nil {
		ok := object.Key("ClipRange")
		if err := awsRestjson1_serializeDocumentClipRange(v.ClipRange, ok); err != nil {
			return err
		}
	}

	if v.Transition != nil {
		ok := object.Key("Transition")
		if err := awsRestjson1_serializeDocumentTransition(v.Transition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecretsManagerAccessTokenConfiguration(v *types.SecretsManagerAccessTokenConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HeaderName != nil {
		ok := object.Key("HeaderName")
		ok.String(*v.HeaderName)
	}

	if v.SecretArn != nil {
		ok := object.Key("SecretArn")
		ok.String(*v.SecretArn)
	}

	if v.SecretStringKey != nil {
		ok := object.Key("SecretStringKey")
		ok.String(*v.SecretStringKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentationDescriptor(v *types.SegmentationDescriptor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SegmentationEventId != nil {
		ok := object.Key("SegmentationEventId")
		ok.Integer(*v.SegmentationEventId)
	}

	if v.SegmentationTypeId != nil {
		ok := object.Key("SegmentationTypeId")
		ok.Integer(*v.SegmentationTypeId)
	}

	if v.SegmentationUpid != nil {
		ok := object.Key("SegmentationUpid")
		ok.String(*v.SegmentationUpid)
	}

	if v.SegmentationUpidType != nil {
		ok := object.Key("SegmentationUpidType")
		ok.Integer(*v.SegmentationUpidType)
	}

	if v.SegmentNum != nil {
		ok := object.Key("SegmentNum")
		ok.Integer(*v.SegmentNum)
	}

	if v.SegmentsExpected != nil {
		ok := object.Key("SegmentsExpected")
		ok.Integer(*v.SegmentsExpected)
	}

	if v.SubSegmentNum != nil {
		ok := object.Key("SubSegmentNum")
		ok.Integer(*v.SubSegmentNum)
	}

	if v.SubSegmentsExpected != nil {
		ok := object.Key("SubSegmentsExpected")
		ok.Integer(*v.SubSegmentsExpected)
	}

	return nil
}

func awsRestjson1_serializeDocumentSegmentationDescriptorList(v []types.SegmentationDescriptor, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSegmentationDescriptor(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSegmentDeliveryConfiguration(v *types.SegmentDeliveryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseUrl != nil {
		ok := object.Key("BaseUrl")
		ok.String(*v.BaseUrl)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentSlateSource(v *types.SlateSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceLocationName != nil {
		ok := object.Key("SourceLocationName")
		ok.String(*v.SourceLocationName)
	}

	if v.VodSourceName != nil {
		ok := object.Key("VodSourceName")
		ok.String(*v.VodSourceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentSpliceInsertMessage(v *types.SpliceInsertMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailNum != nil {
		ok := object.Key("AvailNum")
		ok.Integer(*v.AvailNum)
	}

	if v.AvailsExpected != nil {
		ok := object.Key("AvailsExpected")
		ok.Integer(*v.AvailsExpected)
	}

	if v.SpliceEventId != nil {
		ok := object.Key("SpliceEventId")
		ok.Integer(*v.SpliceEventId)
	}

	if v.UniqueProgramId != nil {
		ok := object.Key("UniqueProgramId")
		ok.Integer(*v.UniqueProgramId)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimeShiftConfiguration(v *types.TimeShiftConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxTimeDelaySeconds != nil {
		ok := object.Key("MaxTimeDelaySeconds")
		ok.Integer(*v.MaxTimeDelaySeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimeSignalMessage(v *types.TimeSignalMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SegmentationDescriptors != nil {
		ok := object.Key("SegmentationDescriptors")
		if err := awsRestjson1_serializeDocumentSegmentationDescriptorList(v.SegmentationDescriptors, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrafficShapingRetrievalWindow(v *types.TrafficShapingRetrievalWindow, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RetrievalWindowDurationSeconds != nil {
		ok := object.Key("RetrievalWindowDurationSeconds")
		ok.Integer(*v.RetrievalWindowDurationSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentTransition(v *types.Transition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationMillis != nil {
		ok := object.Key("DurationMillis")
		ok.Long(*v.DurationMillis)
	}

	if len(v.RelativePosition) > 0 {
		ok := object.Key("RelativePosition")
		ok.String(string(v.RelativePosition))
	}

	if v.RelativeProgram != nil {
		ok := object.Key("RelativeProgram")
		ok.String(*v.RelativeProgram)
	}

	if v.ScheduledStartTimeMillis != nil {
		ok := object.Key("ScheduledStartTimeMillis")
		ok.Long(*v.ScheduledStartTimeMillis)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateProgramScheduleConfiguration(v *types.UpdateProgramScheduleConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClipRange != nil {
		ok := object.Key("ClipRange")
		if err := awsRestjson1_serializeDocumentClipRange(v.ClipRange, ok); err != nil {
			return err
		}
	}

	if v.Transition != nil {
		ok := object.Key("Transition")
		if err := awsRestjson1_serializeDocumentUpdateProgramTransition(v.Transition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateProgramTransition(v *types.UpdateProgramTransition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationMillis != nil {
		ok := object.Key("DurationMillis")
		ok.Long(*v.DurationMillis)
	}

	if v.ScheduledStartTimeMillis != nil {
		ok := object.Key("ScheduledStartTimeMillis")
		ok.Long(*v.ScheduledStartTimeMillis)
	}

	return nil
}
