"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mir = exports.MirType = void 0;
const errors_1 = require("@ot-builder/errors");
const CffInterp = require("../../interp/ir");
const operator_1 = require("../../interp/operator");
var MirType;
(function (MirType) {
    MirType[MirType["Nop"] = 0] = "Nop";
    MirType[MirType["Operand"] = 1] = "Operand";
    MirType[MirType["Operator"] = 2] = "Operator";
    MirType[MirType["NonTerminal"] = 3] = "NonTerminal";
})(MirType || (exports.MirType = MirType = {}));
var Mir;
(function (Mir) {
    function nop() {
        return { type: MirType.Nop, stackRidge: 0, stackRise: 0 };
    }
    Mir.nop = nop;
    function operand(x) {
        return { type: MirType.Operand, arg: x, stackRidge: 1, stackRise: 1 };
    }
    Mir.operand = operand;
    function operator(opCode, sr, flags) {
        return { type: MirType.Operator, opCode, flags, stackRidge: 0, stackRise: sr };
    }
    Mir.operator = operator;
    function isNonTerminal(ir) {
        return ir.type !== MirType.NonTerminal;
    }
    Mir.isNonTerminal = isNonTerminal;
    function rectifyMirStr(s) {
        return s
            .trim()
            .replace(/[ \t]*\n[ \t]*/g, "\n")
            .replace(/\n+/g, "\n")
            .replace(/[ \t]+/g, " ");
    }
    Mir.rectifyMirStr = rectifyMirStr;
    function printCharString(mirSeq) {
        let s = "";
        for (const mir of mirSeq) {
            switch (mir.type) {
                case MirType.Operand:
                    s += mir.arg + " ";
                    break;
                case MirType.Operator:
                    s += operator_1.CharStringOperator[mir.opCode];
                    if (mir.flags)
                        s += `[${mir.flags.join(" ")}]`;
                    s += "\n";
                    break;
                case MirType.NonTerminal:
                    s += `{${mir.id}}\n`;
            }
        }
        return s;
    }
    Mir.printCharString = printCharString;
    function* toInterpIrSeq(mirSeq) {
        for (const mir of mirSeq) {
            switch (mir.type) {
                case MirType.Operand:
                    yield CffInterp.operand(mir.arg);
                    break;
                case MirType.Operator:
                    yield CffInterp.operator(mir.opCode, mir.flags);
                    break;
                default:
                    throw errors_1.Errors.Unreachable();
            }
        }
    }
    Mir.toInterpIrSeq = toInterpIrSeq;
})(Mir || (exports.Mir = Mir = {}));
//# sourceMappingURL=mir.js.map