#!/bin/bash

set -e

server="$1"
tempfile=$(mktemp)

trap debug_failure ERR

debug_failure()
{
  sudo systemctl status "$server" || true
  sudo journalctl --no-pager -t "$server"
  cat "$tempfile"
  rm "$tempfile"
}

wait_until_ready()
{
  server="$1"
  port="$2"
  count=0
  while ! nc -z localhost "${port:-8080}" >/dev/null 2>&1; do
    if [ $count -gt 60 ]; then
      break
    fi
    count=$((count + 1))
    sleep 1
  done
  if [ ! $count -gt 60 ]; then
    echo "$server is now up and running at http://localhost:${port:-8080}"
    echo "Startup took $count seconds."
    exit
  else
    echo "$server failed starting up in less than 60 seconds"
    exit 1
  fi
}

PORT=8080

if [ -n "$AUTOPKGTEST_TMP" ]; then
  case "$server" in
  tomcat10)
    sudo sed -i '/common.loader/ s#$#,/usr/share/tomcat-jakartaee-migration/lib/*.jar#' "/etc/tomcat10/catalina.properties"
    ;;
  tomcat11)
    sudo sed -i '/common.loader/ s#$#,/usr/share/tomcat-jakartaee-migration/lib/*.jar#' "/etc/tomcat11/catalina.properties"
    ;;
  esac

  sudo systemctl restart "$server"
  wait_until_ready "$server" "$PORT"
  sudo systemctl status "$server"
fi




#echo "current path: $PWD"

curl -v --stderr - \
  -F file=@debian/tests/sample.css \
  -F profile=css3svg  \
  -F usermedium=all  \
  -F warning=1  \
  -F vextwarning=  \
  -F lang=en \
  -o "$tempfile" \
  "http://localhost:${PORT:-8080}/css-validator/validator"

if grep "<h3>Congratulations! No Error Found.</h3>" "$tempfile"; then
  echo "Validation of file was successful."
else
  debug_failure
  echo "-------------"
  cat "$tempfile"
  echo "-------------"
  echo "Issue validating the file. Output is above."
  exit 1
fi

rm "$tempfile"
