# Changelog

All notable changes to this project will be documented here.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [itself](https://github.com/miniscruff/changie).

## v1.24.0 on 2025-11-21

### ✨ Added

* [#830](https://github.com/miniscruff/changie/issues/830) Support for after release notes white space control
* [#776](https://github.com/miniscruff/changie/issues/776) Option to specify the generated release notes file name

## v1.23.0 on 2025-11-18

### ✨ Added

* [#826](https://github.com/miniscruff/changie/issues/826) Option to fail batch command if no change fragments exist
* [#801](https://github.com/miniscruff/changie/issues/801) Load env var values when running new command

## v1.22.1 on 2025-07-27

### 🪲 Fixed

* [#794](https://github.com/miniscruff/changie/issues/794) scroll long enum option lists

## v1.22.0 on 2025-06-01

### ✨ Added

* [#771](https://github.com/miniscruff/changie/issues/771) Interactive flag to new command to support terminals that can not take user inputs
* [#780](https://github.com/miniscruff/changie/issues/780) Diff command to output release notes between versions

### 🪲 Fixed

* [#760](https://github.com/miniscruff/changie/issues/760) Update Go to 1.24

## v1.21.1 on 2025-02-08

### 🪲 Fixed

* [#743](https://github.com/miniscruff/changie/issues/743) Merging when configured to use projects but the changelog path does not yet exist
* [#743](https://github.com/miniscruff/changie/issues/743) next version with projects without any releases returns v1.0.0 instead of an error
* [#687](https://github.com/miniscruff/changie/issues/687) Missing yaml struct tags on a few configs for json schema
* [#745](https://github.com/miniscruff/changie/issues/745) Do not output usage when errors occur

## v1.21.0 on 2024-09-12

### ✨ Added

* [#713](https://github.com/miniscruff/changie/issues/713) Support filepath globs in replacements

### 🪲 Fixed

* [#714](https://github.com/miniscruff/changie/issues/714) Clean up release notes files if any error takes place during the batch process

## v1.20.1 on 2024-09-08

### 🪲 Fixed

* [#688](https://github.com/miniscruff/changie/issues/688) Validate kinds match config in fragment when batching release notes

## v1.20.0 on 2024-09-08

### ✨ Added

* [#702](https://github.com/miniscruff/changie/issues/702) Rework replacement to support grouping
* [#706](https://github.com/miniscruff/changie/issues/706) KindKey and KindLabel values to Change data to be used in formats

## v1.19.1 on 2024-06-25

### 🪲 Fixed

* [#675](https://github.com/miniscruff/changie/issues/675) New command can now properly create a fragment via custom CLI arguments if using a kind with custom choices.

## v1.19.0 on 2024-05-13

### ✨ Added

* [#651](https://github.com/miniscruff/changie/issues/651) Search upwards for a changie config file
* [#612](https://github.com/miniscruff/changie/issues/612) Key option to kind configs to separate visual labels from file names and fragment values

## v1.18.0 on 2024-01-15

### Added

* [#591](https://github.com/miniscruff/changie/issues/591) Replacements can now be configured per project in a monorepo setup

### Removed

* [#597](https://github.com/miniscruff/changie/issues/597) Preview warning when using projects

## v1.17.0 on 2023-12-15

### Added

* [#586](https://github.com/miniscruff/changie/issues/586) VersionNoFormat can be used in the VersionFormat configuration
* [#584](https://github.com/miniscruff/changie/issues/584) New command will create the unreleased folder if it does not already exist

## v1.16.1 on 2023-12-08

### Fixed

* [#582](https://github.com/miniscruff/changie/issues/582) Running changie through NPM did not redirect the input stream, rendering 'changie new' inoperable

## v1.16.0 on 2023-11-12

### Changed

* [#571](https://github.com/miniscruff/changie/issues/571) Project prompt is now a multichoose prompt to allow one change to affect multiple projects without repeating the prompts
* [#571](https://github.com/miniscruff/changie/issues/571) Project command line argument for new is now a list of projects and uses --projects instead of --project

## v1.15.1 on 2023-10-29

### Fixed

* [#569](https://github.com/miniscruff/changie/issues/569) Merge unreleased now only merges project-specific changes into each project.

## v1.15.0 on 2023-10-27

### Added

* [#561](https://github.com/miniscruff/changie/issues/561) Changie is now available as an [NPM package](https://www.npmjs.com/package/changie).

### Changed

* [#552](https://github.com/miniscruff/changie/issues/552) Merge will merge all projects versions if projects are enabled.

### Fixed

* [#554](https://github.com/miniscruff/changie/issues/554) Provide a better error message if a change file is invalid.
* [#559](https://github.com/miniscruff/changie/issues/559) Slashes in FragmentFileFormat resulting in unexpected file paths.

## v1.14.0 on 2023-10-03

### Added

* [#530](https://github.com/miniscruff/changie/issues/530) Option to use "none" as auto level to skip changes when calculating bump version

## v1.13.1 on 2023-09-16

### Fixed

* [#536](https://github.com/miniscruff/changie/issues/536) customs template function returns an empty string instead of an error for missing keys.

## v1.13.0 on 2023-08-19

### Added

* [#505](https://github.com/miniscruff/changie/issues/505) Option to edit body messages with a text editor using `-e/--editor`
* [#503](https://github.com/miniscruff/changie/issues/503) Option to batch unreleased changes when merging changelogs
* [#520](https://github.com/miniscruff/changie/issues/520) Allow usage of prefixed environment variables in post
* [#512](https://github.com/miniscruff/changie/issues/512) Projects configuration options and command arguments for monorepo support. Currently in preview mode.

## v1.12.0 on 2023-03-16

### Added

* [#93](https://github.com/miniscruff/changie/issues/93) Support for multiline prompts and bodies

### Changed

* [#457](https://github.com/miniscruff/changie/issues/457) Switched prompt tool to cqroot/prompt, a bubbletea based prompt

## v1.11.1 on 2023-02-05

### Fixed

* [#453](https://github.com/miniscruff/changie/issues/453) Default auto level for deprecation is now minor to match semver

## v1.11.0 on 2023-01-26

### Added

* [#439](https://github.com/miniscruff/changie/issues/439) Auto mode to batch and new which uses kind configs to automatically determine the next bump level

## v1.10.2 on 2022-12-19

### Fixed

* [#430](https://github.com/miniscruff/changie/issues/430) Remove extra newline character from the output of `changie latest`

## v1.10.1 on 2022-12-11

### Fixed

* [#404](https://github.com/miniscruff/changie/issues/404) Init command will exit if a changie config file already exists, a new force option exists if you want to reset your config
* [#406](https://github.com/miniscruff/changie/issues/406) Batch command will exit if the version file already exists, a new force option was added if you want to override it

## v1.10.0 on 2022-10-22

### Added

* [#372](https://github.com/miniscruff/changie/issues/372) Environment variable loading based on prefix

## v1.9.1 on 2022-09-20

### Fixed

* [#368](https://github.com/miniscruff/changie/issues/368) Unable to create a change fragment using `--custom` if your custom prompt had a Label

## v1.9.0 on 2022-08-28

### Added

* [#339](https://github.com/miniscruff/changie/issues/339) Kind option to new command
* [#338](https://github.com/miniscruff/changie/issues/338) Body option to new command
* [#348](https://github.com/miniscruff/changie/issues/348) Component option to new command
* [#340](https://github.com/miniscruff/changie/issues/340) Custom option to new command
* [#355](https://github.com/miniscruff/changie/issues/355) Options for post processing at global and per kind levels

## v1.8.0 on 2022-06-21

### Added

* [#238](https://github.com/miniscruff/changie/issues/238) Options to add additional newlines before and after elements in batch files
* [#323](https://github.com/miniscruff/changie/issues/323) Options to add additional newlines before and after elements when merging a changelog file

### Changed

* [#324](https://github.com/miniscruff/changie/issues/324) Header path is now optional when merging the changelog

## v1.7.0 on 2022-05-16

### Added

* [#311](https://github.com/miniscruff/changie/issues/311) Option to customize filename for change fragments
* [#312](https://github.com/miniscruff/changie/issues/312) Option to specify custom choices are optional
* [#297](https://github.com/miniscruff/changie/issues/297) Major, minor, patch, prerelease and metadata values for templates that include the latest version

## v1.6.1 on 2022-03-19

### Fixed

* [#292](https://github.com/miniscruff/changie/issues/292) Version should not include minor or patch values if not included as argument to batch

## v1.6.0 on 2022-03-17

### Added

* [#283](https://github.com/miniscruff/changie/issues/283) skip-prereleases option to latest command

### Fixed

* [#284](https://github.com/miniscruff/changie/issues/284) next command enforces argument to be major, minor or patch

## v1.5.1 on 2022-02-23

### Fixed

* [#263](https://github.com/miniscruff/changie/issues/263) Includes option properly deletes files included
* [#264](https://github.com/miniscruff/changie/issues/264) Includes option deletes the directory if no files remain

## v1.5.0 on 2022-02-22

### Added

* [#247](https://github.com/miniscruff/changie/issues/247) Prerelease and metadata options for next and batch
* [#248](https://github.com/miniscruff/changie/issues/248) Option to move unreleased files after batching
* [#249](https://github.com/miniscruff/changie/issues/249) Option to include additional directories of change files when batching versions
* [#250](https://github.com/miniscruff/changie/issues/250) Option to remove prerelease versions when batching

## v1.4.0 on 2022-02-17

### Added

* [#225](https://github.com/miniscruff/changie/issues/225) Previous version field to version header template data
* [#222](https://github.com/miniscruff/changie/issues/222) Footers can be inserted at the end of version files using version footer flag or version footer config
* [#229](https://github.com/miniscruff/changie/issues/229) Allow for use of sprig functions in templates
* [#230](https://github.com/miniscruff/changie/issues/230) Header and footer templates config options for batch command
* [#240](https://github.com/miniscruff/changie/issues/240) Header and footer files can use go templates and sprig functions
* [#240](https://github.com/miniscruff/changie/issues/240) Template functions for working with changes for header and footer files or templates

### Changed

* [#235](https://github.com/miniscruff/changie/issues/235) Create files without exec bit (+x)
* [#243](https://github.com/miniscruff/changie/issues/243) Changes are sorted oldest first instead of newest first

### Deprecated

* [#228](https://github.com/miniscruff/changie/issues/228) Batch commands `--headerPath` argument, use `--header-path` instead

## v1.3.0 on 2022-01-28

### Added

* [#203](https://github.com/miniscruff/changie/issues/203) dry-run option to merge command
* [#202](https://github.com/miniscruff/changie/issues/202) dry-run option to new command
* [#201](https://github.com/miniscruff/changie/issues/201) dry-run option to batch command
* [#196](https://github.com/miniscruff/changie/issues/196) Keep option to batch command to not delete fragments

### Changed

* [#204](https://github.com/miniscruff/changie/issues/204) Default directory name to .changes for `init` command

## v1.2.0 on 2021-11-10

### Added

* [#180](https://github.com/miniscruff/changie/issues/180) Regular expression flag option for replacements

## v1.1.0 on 2021-10-24

### Added

* [#166](https://github.com/miniscruff/changie/issues/166) Option to use environment variable for config path
* [#166](https://github.com/miniscruff/changie/issues/166) Try and load .changie.yml if .changie.yaml fails

## v1.0.0 on 2021-09-04

With this release Changie aims to maintain compatibility for the CLI and options.
Support for and use of Changie as an imported package is not recommended.

## v0.7.0 on 2021-07-12

### Added

* [#123](https://github.com/miniscruff/changie/issues/123) Option to customize body prompt similar to string choice
* [#123](https://github.com/miniscruff/changie/issues/123) Min and max length checks for string choices
* [#136](https://github.com/miniscruff/changie/issues/136) Option for additional choices per kind
* [#136](https://github.com/miniscruff/changie/issues/136) Option to skip global choices per kind
* [#136](https://github.com/miniscruff/changie/issues/136) Option to skip body prompts per kind
* [#137](https://github.com/miniscruff/changie/issues/137) Change format option per kind

### Changed

* [#141](https://github.com/miniscruff/changie/issues/141) Default kind format does not have a newline to start

## v0.6.0 on 2021-07-04

### Added

* [#116](https://github.com/miniscruff/changie/issues/116) Optional component layer above kinds

### Changed

* [#118](https://github.com/miniscruff/changie/issues/118) Kinds can be extended with custom headers
* [#116](https://github.com/miniscruff/changie/issues/116) Kind prompt can be toggled off
* [#116](https://github.com/miniscruff/changie/issues/116) Kind headers are now optional

## v0.5.0 on 2021-05-10

### Added

* [#92](https://github.com/miniscruff/changie/issues/92) Option to include a header file when batching fragments into a version file.
* [#98](https://github.com/miniscruff/changie/issues/98) Next command that echoes the latest version incremented by one.
* [#100](https://github.com/miniscruff/changie/issues/100) Batch now supports bumping major, minor, and patch

## v0.4.1 on 2021-02-23

### Fixed

* [#48](https://github.com/miniscruff/changie/issues/48) Add maintainer to deb and rpm releases
* [#48](https://github.com/miniscruff/changie/issues/48) Update homepage in releases to changie.dev

## v0.4.0 on 2021-01-01

### Added

* [#34](https://github.com/miniscruff/changie/issues/34) Option to find and replace in files during merge command

### Fixed

* [#33](https://github.com/miniscruff/changie/issues/33) Latest command when no releases exist will return v0.0.0 instead of panicking

## v0.3.0 on 2020-12-28

### Added

* [#29](https://github.com/miniscruff/changie/issues/29) Reference to changie in default header template

### Changed

* [#28](https://github.com/miniscruff/changie/issues/28) Custom choices is now an array of Custom instead of a map

### Fixed

* [#25](https://github.com/miniscruff/changie/issues/25) Incorrect file permissions on init when creating unreleased directory

## v0.2.0 on 2020-12-27

### Changed

* [#22](https://github.com/miniscruff/changie/issues/22) Remove prefix argument in latest command is now a bool

## v0.1.0 on 2020-12-20

Initial release
