# This is a CamiTK python action
import camitk
from PySideX.QtCore import QTimer
import sys

def tick(self):
    counter = self.getParameterValue("Counter")
    print(f"test_parameter_interaction_timer tick {counter}", file=sys.stderr)
    
    counter += 1
    self.setParameterValue("Counter", counter)
    
    self.timer.setInterval(int(1000.0 / float(counter%10 + 1)))
    self.updateWidget()
    print(f"test_parameter_interaction_timer tick {counter}", file=sys.stderr)

def init(self:camitk.Action):
    print("test_parameter_interaction_timer  init", file=sys.stderr)
    self.timer = None
    self.setApplyButtonText("Start")

def process(self:camitk.Action):
    self.counter = self.getParameterValue("Counter")
    print(f"test_parameter_interaction_timer process {self.counter}", file=sys.stderr)

    if not self.timer:
        self.timer = QTimer()
        connected = self.timer.timeout.connect(lambda: tick(self))     

    if not self.timer.isActive():
        self.setApplyButtonText("Stop")
        self.timer.start(1000)
    else:
        self.setApplyButtonText("Restart")
        self.timer.stop()
